/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.control;

import java.util.List;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.value.WritableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.util.Duration;

public abstract class GraphComponent {
    private Opacity opacity = Opacity.CONSTANT;

    public Opacity getOpacity() {
        return this.opacity;
    }

    public void setOpacity(Opacity opacity) {
        this.opacity = opacity;
    }

    public abstract Node getNode();

    public void move() {
        this.getNode().setOpacity(1.0);
        this.doMove();
    }

    public void animate(Timeline timeline, Duration duration) {
        this.animate(timeline, duration, null);
    }

    public void animate(Timeline timeline, Duration duration, EventHandler<ActionEvent> eventHandler) {
        if (this.opacity != Opacity.CONSTANT) {
            double d = this.opacity == Opacity.INCREASING ? 0.0 : 1.0;
            Node node = this.getNode();
            node.setOpacity(d);
            this.addKeyFrame(timeline, duration, (WritableValue)node.opacityProperty(), 1.0 - d);
        }
        this.doAnimate(timeline, duration, eventHandler);
    }

    protected abstract void doMove();

    protected abstract void doAnimate(Timeline var1, Duration var2, EventHandler<ActionEvent> var3);

    protected <T> void addKeyFrame(Timeline timeline, Duration duration, WritableValue<T> writableValue, T t) {
        this.addKeyFrame(timeline, duration, null, writableValue, t);
    }

    protected <T> void addKeyFrame(Timeline timeline, Duration duration, EventHandler<ActionEvent> eventHandler, WritableValue<T> writableValue, T t) {
        KeyValue keyValue = new KeyValue(writableValue, t, Interpolator.EASE_BOTH);
        KeyFrame keyFrame = new KeyFrame(duration, eventHandler, new KeyValue[]{keyValue});
        timeline.getKeyFrames().add((Object)keyFrame);
    }

    void addNodeTo(List<Node> list) {
        list.add(this.getNode());
    }

    public static enum Opacity {
        CONSTANT,
        INCREASING,
        DECREASING;

    }
}

