/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.control;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableDoubleProperty;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableDoubleProperty;
import javafx.css.StyleableProperty;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.Spinner;
import javafx.scene.control.SpinnerValueFactory;
import javafx.scene.control.TextField;
import javafx.scene.layout.Region;
import javafx.util.StringConverter;
import oracle.dbtools.raptor.metrics.control.LayoutHelper;

public class NumberEditor
extends Region {
    private static final String[] prefixes = new String[]{"", "k", "M", "G", "T", "P"};
    private final StringProperty unitProperty = new SimpleStringProperty((Object)this, "unit"){

        protected void invalidated() {
            NumberEditor.this.setupChoiceBox();
        }
    };
    private final DoubleProperty valueProperty = new SimpleDoubleProperty(){

        protected void invalidated() {
            if (!NumberEditor.this.inUpdateValue) {
                NumberEditor.this.setupControlValues();
            }
        }
    };
    private boolean inUpdateValue = false;
    private final Spinner<Double> spinner;
    private final ChoiceBox<String> choiceBox;
    private final StyleableDoubleProperty gapProperty = new SimpleStyleableDoubleProperty(cssGap, (Object)this, "gap", 1.0){

        protected void invalidated() {
            NumberEditor.this.requestLayout();
        }
    };
    private static final CssMetaData<NumberEditor, Number> cssGap = new CssMetaData<NumberEditor, Number>("-sd-gap", StyleConverter.getSizeConverter()){

        public boolean isSettable(NumberEditor numberEditor) {
            return true;
        }

        public StyleableProperty<Number> getStyleableProperty(NumberEditor numberEditor) {
            return numberEditor.gapProperty;
        }
    };
    private static final List<CssMetaData<? extends Styleable, ?>> cssMetaDataList;

    public NumberEditor() {
        this.spinner = new Spinner(0.0, Double.MAX_VALUE, 0.0);
        this.choiceBox = new ChoiceBox();
        this.spinner.getStyleClass().add((Object)"arrows-on-left-vertical");
        this.spinner.setEditable(true);
        this.spinner.getValueFactory().setConverter((StringConverter)new StringConverter<Double>(){
            private final DecimalFormat format = new DecimalFormat(".########################");

            public String toString(Double d) {
                return this.format.format(d);
            }

            public Double fromString(String string) {
                return Double.parseDouble(string);
            }
        });
        TextField textField = this.spinner.getEditor();
        textField.focusedProperty().addListener(observable -> {
            if (!textField.isFocused()) {
                this.onEditSpinner(textField);
            }
        });
        textField.setOnAction(actionEvent -> this.onEditSpinner(textField));
        this.setupChoiceBox();
        this.spinner.valueProperty().addListener((observableValue, d, d2) -> this.updateValueProperty());
        this.choiceBox.valueProperty().addListener((observableValue, string, string2) -> this.updateValueProperty());
        this.getStyleClass().add((Object)"suffix-number-editor");
        this.getChildren().addAll((Object[])new Node[]{this.spinner, this.choiceBox});
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return cssMetaDataList;
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return NumberEditor.getClassCssMetaData();
    }

    public String getUnit() {
        return (String)this.unitProperty.get();
    }

    public void setUnit(String string) {
        this.unitProperty.set((Object)string);
    }

    public StringProperty unitProperty() {
        return this.unitProperty;
    }

    public void setGap(double d) {
        this.gapProperty.setValue((Number)d);
    }

    public double getGap() {
        return this.gapProperty.getValue();
    }

    public DoubleProperty gapProperty() {
        return this.gapProperty;
    }

    public double getValue() {
        return this.valueProperty.get();
    }

    public void setValue(double d) {
        this.valueProperty.set(d);
    }

    public DoubleProperty valueProperty() {
        return this.valueProperty;
    }

    protected double computePrefWidth(double d) {
        Insets insets = this.getPadding();
        double d2 = (insets != null ? insets.getLeft() + insets.getRight() : 0.0) + this.getGap();
        return this.spinner.prefWidth(-1.0) + this.choiceBox.prefWidth(-1.0) + d2;
    }

    protected double computeMinWidth(double d) {
        Insets insets = this.getPadding();
        double d2 = (insets != null ? insets.getLeft() + insets.getRight() : 0.0) + this.getGap();
        return this.spinner.minWidth(-1.0) + this.choiceBox.prefWidth(-1.0) + d2;
    }

    protected double computePrefHeight(double d) {
        Insets insets = this.getPadding();
        double d2 = insets != null ? insets.getTop() + insets.getBottom() : 0.0;
        return Math.max(this.spinner.prefHeight(-1.0), this.choiceBox.prefHeight(-1.0)) + d2;
    }

    protected double computeMinHeight(double d) {
        Insets insets = this.getPadding();
        double d2 = insets != null ? insets.getTop() + insets.getBottom() : 0.0;
        return Math.max(this.spinner.minHeight(-1.0), this.choiceBox.minHeight(-1.0)) + d2;
    }

    protected void layoutChildren() {
        LayoutHelper layoutHelper = new LayoutHelper(this);
        double d = this.getGap();
        double d2 = layoutHelper.height();
        double d3 = this.choiceBox.prefWidth(-1.0);
        double d4 = layoutHelper.width() - d - d3;
        double d5 = this.spinner.maxWidth(-1.0);
        if (d5 < d4) {
            d4 = d5;
        }
        this.layoutInArea((Node)this.spinner, layoutHelper.x(0.0), layoutHelper.y(0.0), d4, d2, 0.0, HPos.LEFT, VPos.TOP);
        this.layoutInArea((Node)this.choiceBox, layoutHelper.x(d4 + d), layoutHelper.y(0.0), d3, d2, 0.0, HPos.LEFT, VPos.TOP);
    }

    private void setupChoiceBox() {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = this.getUnit();
        for (String string2 : prefixes) {
            if (string != null) {
                arrayList.add(string2 + string);
                continue;
            }
            arrayList.add(string2);
        }
        this.choiceBox.getItems().setAll(arrayList);
        this.choiceBox.getSelectionModel().select(0);
    }

    private void setupControlValues() {
        double d = this.getValue();
        int n = 0;
        while (d >= 1024.0) {
            d /= 1024.0;
            ++n;
        }
        this.spinner.getValueFactory().setValue((Object)d);
        this.choiceBox.getSelectionModel().select(n);
    }

    private void onEditSpinner(TextField textField) {
        String string = textField.getText();
        SpinnerValueFactory spinnerValueFactory = this.spinner.getValueFactory();
        if (spinnerValueFactory != null) {
            try {
                Double d = Math.rint(Math.abs((Double)spinnerValueFactory.getConverter().fromString(string)));
                spinnerValueFactory.setValue((Object)d);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            textField.setText(((Double)spinnerValueFactory.getValue()).toString());
        }
    }

    private void updateValueProperty() {
        this.inUpdateValue = true;
        try {
            double d = (Double)this.spinner.getValue() * Math.pow(1024.0, this.choiceBox.getSelectionModel().getSelectedIndex());
            this.setValue(d);
        }
        finally {
            this.inUpdateValue = false;
        }
    }

    static {
        ArrayList<CssMetaData<NumberEditor, Number>> arrayList = new ArrayList<CssMetaData<NumberEditor, Number>>(Region.getClassCssMetaData());
        arrayList.add(cssGap);
        cssMetaDataList = Collections.unmodifiableList(arrayList);
    }
}

