/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.control;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import oracle.dbtools.raptor.metrics.control.Edge;
import oracle.dbtools.raptor.metrics.control.GraphObject;

public class Vertex<T, V extends Vertex<T, V, E>, E extends Edge<T, V, E>>
extends GraphObject<T, V, E> {
    private final Map<V, E> sourceToInEdgeMap = new HashMap<V, E>();
    private final Map<V, E> destToOutEdgeMap = new HashMap<V, E>();
    private int level;

    public int getLevel() {
        this.getGraph().verifyGlobal();
        return this.level;
    }

    public Collection<V> getNeighbors() {
        HashSet<V> hashSet = new HashSet<V>();
        hashSet.addAll(this.sourceToInEdgeMap.keySet());
        hashSet.addAll(this.destToOutEdgeMap.keySet());
        return Collections.unmodifiableCollection(hashSet);
    }

    public boolean isNeighbor(V v) {
        return this.sourceToInEdgeMap.containsKey(v) || this.destToOutEdgeMap.containsKey(v);
    }

    public Collection<E> getIncidentEdges() {
        HashSet<E> hashSet = new HashSet<E>();
        hashSet.addAll(this.sourceToInEdgeMap.values());
        hashSet.addAll(this.destToOutEdgeMap.values());
        return Collections.unmodifiableCollection(hashSet);
    }

    public int getDegree() {
        return this.sourceToInEdgeMap.size() + this.destToOutEdgeMap.size();
    }

    public Collection<E> getInEdges() {
        return Collections.unmodifiableCollection(this.sourceToInEdgeMap.values());
    }

    public Collection<E> getOutEdges() {
        return Collections.unmodifiableCollection(this.destToOutEdgeMap.values());
    }

    public int getInDegree() {
        return this.sourceToInEdgeMap.size();
    }

    public int getOutDegree() {
        return this.destToOutEdgeMap.size();
    }

    public Collection<V> getPredecessors() {
        return Collections.unmodifiableCollection(this.sourceToInEdgeMap.keySet());
    }

    public Collection<V> getSuccessors() {
        return Collections.unmodifiableCollection(this.destToOutEdgeMap.keySet());
    }

    public boolean isPredecessor(V v) {
        return this.sourceToInEdgeMap.containsKey(v);
    }

    public boolean isSuccessor(V v) {
        return this.destToOutEdgeMap.containsKey(v);
    }

    public int getPredecessorCount() {
        return this.sourceToInEdgeMap.size();
    }

    public int getSuccessorCount() {
        return this.destToOutEdgeMap.size();
    }

    public boolean isInternal() {
        return !this.isLeaf() && !this.isRoot();
    }

    public boolean isLeaf() {
        return this.getSuccessors().isEmpty();
    }

    public boolean isRoot() {
        return this.getPredecessors().isEmpty();
    }

    public V getFirstPredecessor() {
        if (this.getSourceToInEdgeMap().isEmpty()) {
            return null;
        }
        return (V)((Vertex)this.getSourceToInEdgeMap().keySet().iterator().next());
    }

    public E getFirstPredecessorEdge() {
        if (this.getSourceToInEdgeMap().isEmpty()) {
            return null;
        }
        return (E)((Edge)this.getSourceToInEdgeMap().values().iterator().next());
    }

    Map<V, E> getSourceToInEdgeMap() {
        return this.sourceToInEdgeMap;
    }

    Map<V, E> getDestToOutEdgeMap() {
        return this.destToOutEdgeMap;
    }

    void setRawLevel(int n) {
        this.level = n;
    }

    int getRawLevel() {
        return this.level;
    }
}

