/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.dataobject;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableMap;
import oracle.dbtools.raptor.metrics.engine.DXIds;
import oracle.dbtools.raptor.metrics.panel.BoundDataObject;
import oracle.dbtools.raptor.metrics.panel.DataObject;

public abstract class AbstractBoundDataObject<T>
implements BoundDataObject<T> {
    private final StringProperty connectionTypeNameProperty = new SimpleStringProperty((Object)this, "connectionTypeName", "sql");
    private final StringProperty pathProperty = new SimpleStringProperty((Object)this, "path");
    private final ObservableMap<String, Object> connectionParameters = FXCollections.observableHashMap();
    private final ObservableMap<String, Object> queryParameters = FXCollections.observableHashMap();

    @Override
    public boolean isConnected() {
        return this.connectedProperty().get();
    }

    @Override
    public boolean isAvailable() {
        return this.availableProperty().get();
    }

    @Override
    public String getConnectionTypeName() {
        return (String)this.connectionTypeNameProperty.get();
    }

    @Override
    public void setConnectionTypeName(String string) {
        this.connectionTypeNameProperty.set((Object)string);
    }

    @Override
    public StringProperty connectionTypeNameProperty() {
        return this.connectionTypeNameProperty;
    }

    @Override
    public String getPath() {
        return (String)this.pathProperty.get();
    }

    @Override
    public void setPath(String string) {
        this.pathProperty.set((Object)string);
    }

    @Override
    public StringProperty pathProperty() {
        return this.pathProperty;
    }

    @Override
    public ObservableMap<String, Object> getConnectionParameters() {
        return this.connectionParameters;
    }

    @Override
    public ObservableMap<String, Object> getQueryParameters() {
        return this.queryParameters;
    }

    protected URI createItemId(String string) {
        Map<String, String> map = this.createParametersRep((Map<String, Object>)this.connectionParameters);
        Map<String, String> map2 = this.createParametersRep((Map<String, Object>)this.queryParameters);
        return DXIds.newId(this.getConnectionTypeName(), string, this.getPath(), map, map2);
    }

    private Map<String, String> createParametersRep(Map<String, Object> map) {
        HashMap<String, String> hashMap = null;
        Set<String> set = map.keySet();
        if (!set.isEmpty()) {
            hashMap = new HashMap<String, String>();
            for (String string : set) {
                hashMap.put(string, this.toStringRep(map.get(string)));
            }
        }
        return hashMap;
    }

    private String toStringRep(Object object) {
        Object object2 = null;
        if (object instanceof DataObject) {
            ObservableValue observableValue = ((DataObject)object).valueProperty();
            if (observableValue != null) {
                object2 = observableValue.getValue();
            }
        } else {
            object2 = object;
        }
        if (object2 != null) {
            return object2.toString();
        }
        return "";
    }
}

