/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.dataobject;

import javafx.beans.DefaultProperty;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.binding.StringBinding;
import javafx.beans.binding.StringExpression;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import oracle.dbtools.raptor.metrics.dataobject.AbstractCalcDataObject;
import oracle.dbtools.raptor.metrics.panel.DataObject;
import oracle.dbtools.raptor.metrics.panel.Formatter;
import oracle.dbtools.raptor.metrics.panel.StringDataObject;

@DefaultProperty(value="items")
public class FormattedString
extends AbstractCalcDataObject<String>
implements StringDataObject {
    private StringExpression observable;
    private BooleanExpression available;
    private BooleanExpression connected;
    private final StringProperty formatProperty = new SimpleStringProperty((Object)this, "format", "%s");
    private final ObservableList<DataObject<?>> items = FXCollections.observableArrayList();

    public FormattedString() {
        this.init();
    }

    public String getFormat() {
        return (String)this.formatProperty.get();
    }

    public void setFormat(String string) {
        this.formatProperty.set((Object)string);
    }

    public StringProperty formatProperty() {
        return this.formatProperty;
    }

    public ObservableList<DataObject<?>> getItems() {
        return this.items;
    }

    @Override
    public StringExpression valueProperty() {
        if (this.observable == null) {
            String string = this.getFormat();
            ObservableValue[] observableValueArray = new ObservableValue[this.items.size()];
            int n = 0;
            for (DataObject dataObject : this.items) {
                observableValueArray[n++] = dataObject.valueProperty();
            }
            if (string != null) {
                this.observable = this.createBinding(string, observableValueArray);
            }
        }
        return this.observable;
    }

    @Override
    public BooleanExpression connectedProperty() {
        if (this.connected == null) {
            for (DataObject dataObject : this.items) {
                if (this.connected == null) {
                    this.connected = dataObject.connectedProperty();
                    continue;
                }
                this.connected = Bindings.and((ObservableBooleanValue)this.connected, (ObservableBooleanValue)dataObject.connectedProperty());
            }
        }
        return this.connected;
    }

    @Override
    public BooleanExpression availableProperty() {
        if (this.available == null) {
            for (DataObject dataObject : this.items) {
                if (this.available == null) {
                    this.available = dataObject.availableProperty();
                    continue;
                }
                this.available = Bindings.and((ObservableBooleanValue)this.available, (ObservableBooleanValue)dataObject.availableProperty());
            }
        }
        return this.available;
    }

    private StringBinding createBinding(final String string, final ObservableValue<?>[] observableValueArray) {
        return new StringBinding(){
            {
                super.bind((Observable[])observableValueArray);
            }

            public void dispose() {
                super.unbind((Observable[])observableValueArray);
            }

            protected String computeValue() {
                Object[] objectArray = new Object[observableValueArray.length];
                for (int i = 0; i < objectArray.length; ++i) {
                    objectArray[i] = observableValueArray[i].getValue();
                }
                return Formatter.format(string, objectArray);
            }

            public ObservableList<Observable> getDependencies() {
                return FXCollections.unmodifiableObservableList((ObservableList)FXCollections.observableArrayList((Object[])observableValueArray));
            }
        };
    }
}

