/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.engine;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import oracle.dbtools.raptor.metrics.engine.Command;
import oracle.dbtools.raptor.metrics.engine.Context;
import oracle.dbtools.raptor.metrics.engine.InputEvent;
import oracle.dbtools.raptor.metrics.engine.Notification;
import oracle.dbtools.raptor.metrics.engine.ObjectManager;
import oracle.dbtools.raptor.metrics.engine.Task;
import oracle.dbtools.raptor.metrics.engine.TracingService;
import oracle.dbtools.raptor.metrics.engine.Worker;
import oracle.dbtools.raptor.metrics.engine.WorkerService;

class ExecutionService {
    private Context context;
    private final ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor(this.createThreadFactory());
    private final List<InputEvent> events;
    private final List<Notification> notifications;
    private final WorkerService workerService = new WorkerService();
    private volatile Thread metricsThread;
    private boolean inCallNotifications;

    ExecutionService() {
        this.events = new ArrayList<InputEvent>();
        this.notifications = new ArrayList<Notification>();
    }

    void setContext(Context context) {
        this.context = context;
    }

    void enqueueCommand(Command command) {
        this.executorService.execute(() -> this.executeCommand(command));
    }

    Future<?> scheduleCommand(long l, Command command) {
        return this.executorService.schedule(() -> this.executeCommand(command), l, TimeUnit.MILLISECONDS);
    }

    private void executeCommand(Command command) {
        TracingService tracingService = this.context.getTracingService();
        ObjectManager objectManager = this.context.getObjectManager();
        if (tracingService.isTracingEnabled()) {
            tracingService.traceCommand(command.getId(), command.getName());
        }
        try {
            boolean bl = objectManager.isEngineActive();
            command.execute();
            this.callEvents();
            objectManager.purgeRemovedObjects();
            if (bl && !objectManager.isEngineActive() && tracingService.isTracingEnabled()) {
                tracingService.traceEngineEvent("onEngineDeactivated");
            }
            this.callNotifications();
        }
        catch (RuntimeException runtimeException) {
            this.context.getLogger().log(Level.WARNING, runtimeException.getStackTrace()[0].toString(), runtimeException);
        }
        catch (Error error) {
            this.context.getLogger().log(Level.SEVERE, error.getStackTrace()[0].toString(), error);
            throw error;
        }
    }

    void submitTask(final Task task) {
        this.workerService.submit(new Worker(){

            @Override
            public void call() {
                TracingService tracingService = ExecutionService.this.context.getTracingService();
                if (tracingService.isTracingEnabled()) {
                    tracingService.traceTask(task.getId(), task.getName());
                }
                try {
                    task.execute();
                }
                catch (RuntimeException runtimeException) {
                    ExecutionService.this.context.getLogger().log(Level.WARNING, runtimeException.getStackTrace()[0].toString(), runtimeException);
                }
                catch (Error error) {
                    ExecutionService.this.context.getLogger().log(Level.SEVERE, error.getStackTrace()[0].toString(), error);
                    throw error;
                }
            }

            @Override
            public boolean cancelCall() {
                boolean bl = false;
                try {
                    bl = task.cancel();
                }
                catch (RuntimeException runtimeException) {
                    ExecutionService.this.context.getLogger().log(Level.WARNING, runtimeException.getStackTrace()[0].toString(), runtimeException);
                }
                catch (Error error) {
                    ExecutionService.this.context.getLogger().log(Level.SEVERE, error.getStackTrace()[0].toString(), error);
                    throw error;
                }
                return bl;
            }

            @Override
            public String getDisplayName() {
                return task.getLabel();
            }
        });
    }

    void addEvent(InputEvent inputEvent) {
        this.events.add(inputEvent);
    }

    void callEvents() {
        for (int i = 0; i < this.events.size(); ++i) {
            this.events.get(i).dispatch();
        }
        this.events.clear();
    }

    void addNotification(Notification notification) {
        if (this.inCallNotifications) {
            this.context.getLogger().log(Level.SEVERE, "a notification must not add a notification", new IllegalStateException());
        }
        this.notifications.add(notification);
    }

    void callNotifications() {
        this.inCallNotifications = true;
        try {
            for (Notification notification : this.notifications) {
                notification.execute();
            }
            this.notifications.clear();
        }
        finally {
            this.inCallNotifications = false;
        }
    }

    private ThreadFactory createThreadFactory() {
        return runnable -> {
            this.metricsThread = new Thread(runnable);
            this.metricsThread.setName("Raptor Metrics Engine Thread");
            this.metricsThread.setDaemon(true);
            this.metricsThread.setPriority(5);
            return this.metricsThread;
        };
    }
}

