/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.engine;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.fxml.FXMLLoader;
import oracle.dbtools.raptor.metrics.engine.AbstractSource;
import oracle.dbtools.raptor.metrics.engine.SourceType;

class MergeSet {
    private final URL url;
    private SourceType sourceType;
    private int usageCount;
    private int runnableCount;

    MergeSet(ClassLoader classLoader, URL uRL) {
        this.url = uRL;
        try (InputStream inputStream = uRL.openStream();){
            FXMLLoader fXMLLoader = new FXMLLoader();
            fXMLLoader.setClassLoader(classLoader);
            AbstractSource abstractSource = (AbstractSource)fXMLLoader.load(inputStream);
            this.sourceType = abstractSource.createTypeObject(classLoader);
            if (this.sourceType == null) {
                Logger.getLogger(MergeSet.class.getPackage().getName()).log(Level.WARNING, "no loadable metrics definitions were found in ''{0}''", uRL.toString());
            }
        }
        catch (IOException | RuntimeException exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "fxml load error: {0}: {1}", new Object[]{uRL.toString(), exception});
            throw new IllegalArgumentException("metrics definition load failure");
        }
        if (this.sourceType == null) {
            throw new IllegalArgumentException("metrics definition load failure");
        }
        this.usageCount = 1;
        this.runnableCount = 0;
    }

    URL getURL() {
        return this.url;
    }

    SourceType getSourceType() {
        return this.sourceType;
    }

    void addUse() {
        ++this.usageCount;
    }

    void releaseUse(Runnable runnable) {
        --this.usageCount;
        this.check(runnable);
    }

    void addRunnable() {
        ++this.runnableCount;
    }

    void releaseRunnable(Runnable runnable) {
        --this.runnableCount;
        this.check(runnable);
    }

    private void check(Runnable runnable) {
        if (this.usageCount == 0 && this.runnableCount == 0) {
            runnable.run();
        }
    }
}

