/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.engine;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.metrics.engine.PropertyStoreImpl;

class PropertyStore {
    private final Map<String, String> transientValues = new HashMap<String, String>();
    private final PropertyStoreImpl storeImpl = new PropertyStoreImpl();
    private static final Map<String, Function<String, Object>> converterMap = new HashMap<String, Function<String, Object>>();

    PropertyStore() {
    }

    <T> T get(Class<T> clazz, URI uRI, String string, T t) {
        T t2;
        String string2 = this.getKey(uRI, string);
        String string3 = this.transientValues.get(string2);
        if (string3 == null) {
            string3 = this.storeImpl.get(this.flattenKey(string2));
        }
        try {
            T t3;
            Object object = t3 = string3 != null ? converterMap.get(clazz.getName()).apply(string3) : t;
            t2 = t3 != null && clazz.isAssignableFrom(t3.getClass()) ? t3 : t;
        }
        catch (RuntimeException runtimeException) {
            t2 = t;
            Logger.getLogger(PropertyStore.class.getName()).log(Level.WARNING, "error reading property with key '" + string2 + "'", runtimeException);
        }
        return t2;
    }

    <T> void set(URI uRI, String string, T t, boolean bl) {
        String string2;
        String string3 = this.getKey(uRI, string);
        String string4 = string2 = t != null ? t.toString() : null;
        if (bl) {
            this.storeImpl.set(this.flattenKey(string3), string2);
            this.transientValues.remove(string3);
        } else {
            this.transientValues.put(string3, string2);
        }
    }

    void remove(URI uRI, String string, boolean bl) {
        String string2 = this.getKey(uRI, string);
        this.transientValues.remove(string2);
        this.storeImpl.remove(this.flattenKey(string2));
    }

    private String getKey(URI uRI, String string) {
        return uRI.toString() + "#" + string;
    }

    private String flattenKey(String string) {
        return string.replace('/', '+');
    }

    static {
        converterMap.put(Long.class.getName(), string -> Long.parseLong(string));
        converterMap.put(Integer.class.getName(), string -> Integer.parseInt(string));
        converterMap.put(Double.class.getName(), string -> Double.parseDouble(string));
        converterMap.put(Float.class.getName(), string -> Float.valueOf(Float.parseFloat(string)));
        converterMap.put(Boolean.class.getName(), string -> Boolean.parseBoolean(string));
        converterMap.put(String.class.getName(), string -> string);
    }
}

