/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.engine;

import java.net.URI;
import java.util.Deque;
import java.util.LinkedList;
import java.util.concurrent.Future;
import java.util.logging.Level;
import oracle.dbtools.raptor.metrics.MetricsResources;
import oracle.dbtools.raptor.metrics.engine.Automaton;
import oracle.dbtools.raptor.metrics.engine.Command;
import oracle.dbtools.raptor.metrics.engine.DXException;
import oracle.dbtools.raptor.metrics.engine.ExecutionService;
import oracle.dbtools.raptor.metrics.engine.InputEvent;
import oracle.dbtools.raptor.metrics.engine.ItemInstance;
import oracle.dbtools.raptor.metrics.engine.JobInstance;
import oracle.dbtools.raptor.metrics.engine.JobPartition;
import oracle.dbtools.raptor.metrics.engine.Notification;
import oracle.dbtools.raptor.metrics.engine.OperationInstance;
import oracle.dbtools.raptor.metrics.engine.RunnableInstance;
import oracle.dbtools.raptor.metrics.engine.SourceAutomatonActions;
import oracle.dbtools.raptor.metrics.engine.SourceInstance;
import oracle.dbtools.raptor.metrics.engine.Task;
import oracle.dbtools.raptor.metrics.listener.ChangeType;

class SourceAutomaton
extends Automaton<SourceAutomatonActions> {
    private final SourceInstance source;
    private ExecutionService executionService;
    private int pinnedCount;
    private int activeCount;
    private int runningCount;
    private final Deque<RunnableInstance> runnableQueue;
    private Future<?> connectKeepAliveFuture;
    private volatile boolean taskCanceled;
    private Integer connectionCountPendingAdjustment;
    private final SourceActions NO_RUNNABLES_PINNED = new NoRunnablesPinnedActions();
    private final SourceActions RUNNABLES_PINNED = new RunnablesPinnedActions();
    private final SourceActions CONNECTED = new ConnectedActions();
    private final SourceActions UNCONNECTED = new UnconnectedActions();
    private final SourceActions RUNNING = new RunningActions();
    private final SourceActions RUNNING_NO_RUNNABLES_ACTIVE = new RunningNoRunnablesActiveActions();
    private final SourceActions RUNNING_NO_RUNNABLES_PINNED = new RunningNoRunnablesPinnedActions();
    private final SourceActions CONNECTING = new ConnectingActions();
    private final SourceActions CONNECTING_NO_RUNNABLES_ACTIVE = new ConnectingNoRunnablesActiveActions();
    private final SourceActions CONNECTING_NO_RUNNABLES_PINNED = new ConnectingNoRunnablesPinnedActions();
    private final SourceActions ADJUSTING = new AdjustingActions();
    private final SourceActions ADJUSTING_NO_RUNNABLES_ACTIVE = new AdjustingNoRunnablesActiveActions();
    private final SourceActions ADJUSTING_NO_RUNNABLES_PINNED = new AdjustingNoRunnablesPinnedActions();
    private final SourceActions CHECKING = new CheckingActions();
    private final SourceActions CHECKING_NO_RUNNABLES_ACTIVE = new CheckingNoRunnablesActiveActions();
    private final SourceActions CHECKING_NO_RUNNABLES_PINNED = new CheckingNoRunnablesPinnedActions();
    private final SourceActions DISCONNECTING = new DisconnectingActions();
    private final SourceActions DISCONNECTING_NO_RUNNABLES_ACTIVE = new DisconnectingNoRunnablesActiveActions();
    private final SourceActions DISCONNECTING_NO_RUNNABLES_PINNED = new DisconnectingNoRunnablesPinnedActions();
    private final SourceActions REMOVED = null;

    SourceAutomaton(SourceInstance sourceInstance) {
        this.source = sourceInstance;
        this.runnableQueue = new LinkedList<RunnableInstance>();
    }

    @Override
    void start() {
        super.start();
        this.executionService = this.getContext().getExecutionService();
    }

    @Override
    SourceAutomatonActions getInitialState() {
        return this.NO_RUNNABLES_PINNED;
    }

    @Override
    SourceInstance getFocusObject() {
        return this.source;
    }

    boolean isTaskCanceled() {
        return this.taskCanceled;
    }

    InputEvent createRunnablePinned() {
        return new Automaton.AutomatonInputEvent(){

            @Override
            SourceAutomatonActions callResponse(SourceAutomatonActions sourceAutomatonActions) {
                return sourceAutomatonActions.runnablePinned();
            }

            @Override
            String getName() {
                return "runnablePinned";
            }
        };
    }

    InputEvent createRunnableUnpinned() {
        return new Automaton.AutomatonInputEvent(){

            @Override
            SourceAutomatonActions callResponse(SourceAutomatonActions sourceAutomatonActions) {
                return sourceAutomatonActions.runnableUnpinned();
            }

            @Override
            String getName() {
                return "runnableUnpinned";
            }
        };
    }

    InputEvent createRunnableActivated() {
        return new Automaton.AutomatonInputEvent(){

            @Override
            SourceAutomatonActions callResponse(SourceAutomatonActions sourceAutomatonActions) {
                return sourceAutomatonActions.runnableActivated();
            }

            @Override
            String getName() {
                return "runnableActivated";
            }
        };
    }

    InputEvent createRunnableInactivated() {
        return new Automaton.AutomatonInputEvent(){

            @Override
            SourceAutomatonActions callResponse(SourceAutomatonActions sourceAutomatonActions) {
                return sourceAutomatonActions.runnableInactivated();
            }

            @Override
            String getName() {
                return "runnableInactivated";
            }
        };
    }

    InputEvent createQueueRunnable(final RunnableInstance runnableInstance) {
        return new Automaton.AutomatonInputEvent(){

            @Override
            SourceAutomatonActions callResponse(SourceAutomatonActions sourceAutomatonActions) {
                return sourceAutomatonActions.queueRunnable(runnableInstance);
            }

            @Override
            String getName() {
                return "queueRunnable";
            }
        };
    }

    InputEvent createCancelQueueRunnable(final RunnableInstance runnableInstance) {
        return new Automaton.AutomatonInputEvent(){

            @Override
            SourceAutomatonActions callResponse(SourceAutomatonActions sourceAutomatonActions) {
                return sourceAutomatonActions.cancelQueueRunnable(runnableInstance);
            }

            @Override
            String getName() {
                return "cancelQueueRunnable";
            }
        };
    }

    InputEvent createRunCompleted(final DXException dXException) {
        return new Automaton.AutomatonInputEvent(){

            @Override
            SourceAutomatonActions callResponse(SourceAutomatonActions sourceAutomatonActions) {
                return sourceAutomatonActions.runCompleted(dXException);
            }

            @Override
            String getName() {
                return "runCompleted";
            }
        };
    }

    InputEvent createRequestKeepAlive() {
        return new Automaton.AutomatonInputEvent(){

            @Override
            SourceAutomatonActions callResponse(SourceAutomatonActions sourceAutomatonActions) {
                return sourceAutomatonActions.requestKeepAlive();
            }

            @Override
            String getName() {
                return "requestKeepAlive";
            }
        };
    }

    InputEvent createAdjust(final int n) {
        return new Automaton.AutomatonInputEvent(){

            @Override
            SourceAutomatonActions callResponse(SourceAutomatonActions sourceAutomatonActions) {
                return sourceAutomatonActions.requestAdjust(n);
            }

            @Override
            String getName() {
                return "adjust";
            }
        };
    }

    InputEvent createConnectCompleted(final DXException dXException) {
        return new Automaton.AutomatonInputEvent(){

            @Override
            SourceAutomatonActions callResponse(SourceAutomatonActions sourceAutomatonActions) {
                if (dXException == null) {
                    SourceAutomaton.this.notifyConnect(true);
                }
                return sourceAutomatonActions.connectCompleted(dXException);
            }

            @Override
            String getName() {
                return "connectCompleted";
            }
        };
    }

    InputEvent createAdjustCompleted(final DXException dXException) {
        return new Automaton.AutomatonInputEvent(){

            @Override
            SourceAutomatonActions callResponse(SourceAutomatonActions sourceAutomatonActions) {
                if (dXException != null) {
                    SourceAutomaton.this.notifyConnect(false);
                }
                return sourceAutomatonActions.adjustCompleted(dXException);
            }

            @Override
            String getName() {
                return "adjustCompleted";
            }
        };
    }

    InputEvent createCheckCompleted(final DXException dXException) {
        return new Automaton.AutomatonInputEvent(){

            @Override
            SourceAutomatonActions callResponse(SourceAutomatonActions sourceAutomatonActions) {
                if (dXException != null) {
                    SourceAutomaton.this.notifyConnect(false);
                }
                return sourceAutomatonActions.checkCompleted(dXException);
            }

            @Override
            String getName() {
                return "checkCompleted";
            }
        };
    }

    InputEvent createDisconnectCompleted() {
        return new Automaton.AutomatonInputEvent(){

            @Override
            SourceAutomatonActions callResponse(SourceAutomatonActions sourceAutomatonActions) {
                SourceAutomaton.this.notifyConnect(false);
                return sourceAutomatonActions.disconnectCompleted();
            }

            @Override
            String getName() {
                return "disconnectCompleted";
            }
        };
    }

    void notifyConnect(final boolean bl) {
        this.getContext().getActivityListenerService().addEngineObjectChange(this.getFocusObject(), ChangeType.UPDATE);
        this.executionService.addNotification(new Notification(){

            @Override
            void execute() {
                for (JobInstance jobInstance : SourceAutomaton.this.source.getFaultedJobs()) {
                    for (JobPartition jobPartition : jobInstance.getPartitions()) {
                        for (ItemInstance itemInstance : jobPartition.getItems()) {
                            itemInstance.notifyConnectEvent(bl);
                        }
                    }
                }
            }
        });
    }

    private class DisconnectingNoRunnablesPinnedActions
    extends AbstractNoRunnablesPinnedActions {
        DisconnectingNoRunnablesPinnedActions() {
            super("DISCONNECTING_NO_RUNNABLES_PINNED");
        }

        @Override
        boolean isConnected() {
            return false;
        }

        @Override
        SourceActions onPinnedRunnables() {
            return SourceAutomaton.this.DISCONNECTING_NO_RUNNABLES_ACTIVE;
        }

        @Override
        SourceActions disconnectCompleted() {
            return this.removeSource();
        }
    }

    private class DisconnectingNoRunnablesActiveActions
    extends AbstractNoRunnablesActiveActions {
        DisconnectingNoRunnablesActiveActions() {
            super("DISCONNECTING_NO_RUNNABLES_ACTIVE");
        }

        @Override
        boolean isConnected() {
            return false;
        }

        @Override
        SourceActions onNoPinnedRunnables() {
            return SourceAutomaton.this.DISCONNECTING_NO_RUNNABLES_PINNED;
        }

        @Override
        SourceActions onActiveRunnables() {
            return SourceAutomaton.this.DISCONNECTING;
        }

        @Override
        SourceActions disconnectCompleted() {
            return SourceAutomaton.this.RUNNABLES_PINNED;
        }
    }

    private class DisconnectingActions
    extends AbstractRunnablesActiveActions {
        DisconnectingActions() {
            super("DISCONNECTING");
        }

        @Override
        boolean isConnected() {
            return false;
        }

        @Override
        SourceActions onNoActiveRunnables() {
            return SourceAutomaton.this.DISCONNECTING_NO_RUNNABLES_ACTIVE;
        }

        @Override
        SourceActions disconnectCompleted() {
            this.submitConnectTask((Integer)SourceAutomaton.this.source.getConnectionCount().get());
            return SourceAutomaton.this.CONNECTING;
        }
    }

    private class CheckingNoRunnablesPinnedActions
    extends AbstractNoRunnablesPinnedActions {
        CheckingNoRunnablesPinnedActions() {
            super("CHECKING_NO_RUNNABLES_PINNED");
        }

        @Override
        boolean isConnected() {
            return true;
        }

        @Override
        SourceActions onPinnedRunnables() {
            return SourceAutomaton.this.CHECKING_NO_RUNNABLES_ACTIVE;
        }

        @Override
        SourceActions checkCompleted(DXException dXException) {
            SourceActions sourceActions;
            SourceAutomaton.this.connectionCountPendingAdjustment = null;
            if (dXException == null) {
                this.submitDisconnectTask();
                sourceActions = SourceAutomaton.this.DISCONNECTING_NO_RUNNABLES_PINNED;
            } else {
                sourceActions = this.removeSource();
            }
            return sourceActions;
        }

        @Override
        SourceActions requestAdjust(int n) {
            SourceAutomaton.this.connectionCountPendingAdjustment = n;
            return this;
        }
    }

    private class CheckingNoRunnablesActiveActions
    extends AbstractNoRunnablesActiveActions {
        CheckingNoRunnablesActiveActions() {
            super("CHECKING_NO_RUNNABLES_ACTIVE");
        }

        @Override
        boolean isConnected() {
            return true;
        }

        @Override
        SourceActions onNoPinnedRunnables() {
            return SourceAutomaton.this.CHECKING_NO_RUNNABLES_PINNED;
        }

        @Override
        SourceActions onActiveRunnables() {
            return SourceAutomaton.this.CHECKING;
        }

        @Override
        SourceActions checkCompleted(DXException dXException) {
            SourceActions sourceActions;
            SourceAutomaton.this.connectionCountPendingAdjustment = null;
            if (dXException == null) {
                this.submitDisconnectTask();
                sourceActions = SourceAutomaton.this.DISCONNECTING_NO_RUNNABLES_ACTIVE;
            } else {
                sourceActions = SourceAutomaton.this.RUNNABLES_PINNED;
            }
            return sourceActions;
        }

        @Override
        SourceActions requestAdjust(int n) {
            SourceAutomaton.this.connectionCountPendingAdjustment = n;
            return this;
        }
    }

    private class CheckingActions
    extends AbstractRunnablesActiveActions {
        CheckingActions() {
            super("CHECKING");
        }

        @Override
        boolean isConnected() {
            return true;
        }

        @Override
        SourceActions onNoActiveRunnables() {
            return SourceAutomaton.this.CHECKING_NO_RUNNABLES_ACTIVE;
        }

        @Override
        SourceActions checkCompleted(DXException dXException) {
            return this.onConnectionTaskCompleted(dXException);
        }

        @Override
        SourceActions requestAdjust(int n) {
            SourceAutomaton.this.connectionCountPendingAdjustment = n;
            return this;
        }
    }

    private class AdjustingNoRunnablesPinnedActions
    extends AbstractNoRunnablesPinnedActions {
        AdjustingNoRunnablesPinnedActions() {
            super("ADJUSTING_NO_RUNNABLES_PINNED");
        }

        @Override
        boolean isConnected() {
            return true;
        }

        @Override
        SourceActions onPinnedRunnables() {
            return SourceAutomaton.this.ADJUSTING_NO_RUNNABLES_ACTIVE;
        }

        @Override
        SourceActions checkCompleted(DXException dXException) {
            SourceActions sourceActions;
            SourceAutomaton.this.connectionCountPendingAdjustment = null;
            if (dXException == null) {
                this.submitDisconnectTask();
                sourceActions = SourceAutomaton.this.DISCONNECTING_NO_RUNNABLES_PINNED;
            } else {
                sourceActions = this.removeSource();
            }
            return sourceActions;
        }

        @Override
        SourceActions requestAdjust(int n) {
            SourceAutomaton.this.connectionCountPendingAdjustment = n;
            return this;
        }
    }

    private class AdjustingNoRunnablesActiveActions
    extends AbstractNoRunnablesActiveActions {
        AdjustingNoRunnablesActiveActions() {
            super("ADJUSTING_NO_RUNNABLES_ACTIVE");
        }

        @Override
        boolean isConnected() {
            return true;
        }

        @Override
        SourceActions onNoPinnedRunnables() {
            return SourceAutomaton.this.ADJUSTING_NO_RUNNABLES_PINNED;
        }

        @Override
        SourceActions onActiveRunnables() {
            return SourceAutomaton.this.ADJUSTING;
        }

        @Override
        SourceActions adjustCompleted(DXException dXException) {
            SourceActions sourceActions;
            SourceAutomaton.this.connectionCountPendingAdjustment = null;
            if (dXException == null) {
                this.submitDisconnectTask();
                sourceActions = SourceAutomaton.this.DISCONNECTING_NO_RUNNABLES_ACTIVE;
            } else {
                sourceActions = SourceAutomaton.this.RUNNABLES_PINNED;
            }
            return sourceActions;
        }

        @Override
        SourceActions requestAdjust(int n) {
            SourceAutomaton.this.connectionCountPendingAdjustment = n;
            return this;
        }
    }

    private class AdjustingActions
    extends AbstractRunnablesActiveActions {
        AdjustingActions() {
            super("ADJUSTING");
        }

        @Override
        boolean isConnected() {
            return true;
        }

        @Override
        SourceActions onNoActiveRunnables() {
            return SourceAutomaton.this.ADJUSTING_NO_RUNNABLES_ACTIVE;
        }

        @Override
        SourceActions adjustCompleted(DXException dXException) {
            return this.onConnectionTaskCompleted(dXException);
        }

        @Override
        SourceActions requestAdjust(int n) {
            SourceAutomaton.this.connectionCountPendingAdjustment = n;
            return this;
        }
    }

    private class ConnectingNoRunnablesPinnedActions
    extends AbstractNoRunnablesPinnedActions {
        ConnectingNoRunnablesPinnedActions() {
            super("CONNECTING_NO_RUNNABLES_PINNED");
        }

        @Override
        boolean isConnected() {
            return false;
        }

        @Override
        SourceActions onPinnedRunnables() {
            return SourceAutomaton.this.CONNECTING_NO_RUNNABLES_ACTIVE;
        }

        @Override
        SourceActions connectCompleted(DXException dXException) {
            SourceActions sourceActions;
            SourceAutomaton.this.connectionCountPendingAdjustment = null;
            if (dXException == null) {
                this.submitDisconnectTask();
                sourceActions = SourceAutomaton.this.DISCONNECTING_NO_RUNNABLES_PINNED;
            } else {
                sourceActions = this.removeSource();
            }
            return sourceActions;
        }

        @Override
        SourceActions requestAdjust(int n) {
            SourceAutomaton.this.connectionCountPendingAdjustment = n;
            return this;
        }
    }

    private class ConnectingNoRunnablesActiveActions
    extends AbstractNoRunnablesActiveActions {
        ConnectingNoRunnablesActiveActions() {
            super("CONNECTING_NO_RUNNABLES_ACTIVE");
        }

        @Override
        boolean isConnected() {
            return false;
        }

        @Override
        SourceActions onNoPinnedRunnables() {
            return SourceAutomaton.this.CONNECTING_NO_RUNNABLES_PINNED;
        }

        @Override
        SourceActions onActiveRunnables() {
            return SourceAutomaton.this.CONNECTING;
        }

        @Override
        SourceActions connectCompleted(DXException dXException) {
            SourceActions sourceActions;
            SourceAutomaton.this.connectionCountPendingAdjustment = null;
            if (dXException == null) {
                this.submitDisconnectTask();
                sourceActions = SourceAutomaton.this.DISCONNECTING_NO_RUNNABLES_ACTIVE;
            } else {
                sourceActions = SourceAutomaton.this.RUNNABLES_PINNED;
            }
            return sourceActions;
        }

        @Override
        SourceActions requestAdjust(int n) {
            SourceAutomaton.this.connectionCountPendingAdjustment = n;
            return this;
        }
    }

    private class ConnectingActions
    extends AbstractRunnablesActiveActions {
        ConnectingActions() {
            super("CONNECTING");
        }

        @Override
        boolean isConnected() {
            return false;
        }

        @Override
        SourceActions onNoActiveRunnables() {
            return SourceAutomaton.this.CONNECTING_NO_RUNNABLES_ACTIVE;
        }

        @Override
        SourceActions connectCompleted(DXException dXException) {
            return this.onConnectionTaskCompleted(dXException);
        }

        @Override
        SourceActions requestAdjust(int n) {
            SourceAutomaton.this.connectionCountPendingAdjustment = n;
            return this;
        }
    }

    private class RunningNoRunnablesPinnedActions
    extends AbstractNoRunnablesPinnedActions {
        RunningNoRunnablesPinnedActions() {
            super("RUNNING_NO_RUNNABLES_PINNED");
        }

        @Override
        boolean isConnected() {
            return true;
        }

        @Override
        SourceActions onPinnedRunnables() {
            return SourceAutomaton.this.RUNNING_NO_RUNNABLES_ACTIVE;
        }

        @Override
        SourceActions runCompleted(DXException dXException) {
            SourceActions sourceActions;
            SourceAutomaton.this.runningCount = SourceAutomaton.this.runningCount - 1;
            if (SourceAutomaton.this.runningCount == 0) {
                SourceAutomaton.this.connectionCountPendingAdjustment = null;
                this.submitDisconnectTask();
                sourceActions = SourceAutomaton.this.DISCONNECTING_NO_RUNNABLES_PINNED;
            } else {
                sourceActions = this;
            }
            return sourceActions;
        }

        @Override
        SourceActions requestAdjust(int n) {
            SourceAutomaton.this.connectionCountPendingAdjustment = n;
            return this;
        }
    }

    private class RunningNoRunnablesActiveActions
    extends AbstractNoRunnablesActiveActions {
        RunningNoRunnablesActiveActions() {
            super("RUNNING_NO_RUNNABLES_ACTIVE");
        }

        @Override
        boolean isConnected() {
            return true;
        }

        @Override
        SourceActions onNoPinnedRunnables() {
            return SourceAutomaton.this.RUNNING_NO_RUNNABLES_PINNED;
        }

        @Override
        SourceActions onActiveRunnables() {
            return SourceAutomaton.this.RUNNING;
        }

        @Override
        SourceActions runCompleted(DXException dXException) {
            SourceActions sourceActions;
            SourceAutomaton.this.runningCount = SourceAutomaton.this.runningCount - 1;
            if (SourceAutomaton.this.runningCount == 0) {
                SourceAutomaton.this.connectionCountPendingAdjustment = null;
                this.submitDisconnectTask();
                sourceActions = SourceAutomaton.this.DISCONNECTING_NO_RUNNABLES_ACTIVE;
            } else {
                sourceActions = this;
            }
            return sourceActions;
        }

        @Override
        SourceActions requestAdjust(int n) {
            SourceAutomaton.this.connectionCountPendingAdjustment = n;
            return this;
        }
    }

    private class RunningActions
    extends AbstractRunnablesActiveActions {
        RunningActions() {
            super("RUNNING");
        }

        @Override
        boolean isConnected() {
            return true;
        }

        @Override
        SourceActions onNoActiveRunnables() {
            return SourceAutomaton.this.RUNNING_NO_RUNNABLES_ACTIVE;
        }

        @Override
        SourceActions queueRunnable(RunnableInstance runnableInstance) {
            if (SourceAutomaton.this.connectionCountPendingAdjustment == null) {
                if (SourceAutomaton.this.runningCount < (Integer)SourceAutomaton.this.source.getConnectionCount().get()) {
                    SourceAutomaton.this.runningCount = SourceAutomaton.this.runningCount + 1;
                    SourceAutomaton.this.executionService.addEvent(runnableInstance.getAutomaton().createStartRun());
                } else {
                    SourceAutomaton.this.runnableQueue.addLast(runnableInstance);
                }
            } else {
                SourceAutomaton.this.runnableQueue.addLast(runnableInstance);
            }
            return this;
        }

        @Override
        SourceActions runCompleted(DXException dXException) {
            SourceActions sourceActions;
            if (dXException == null) {
                if (SourceAutomaton.this.connectionCountPendingAdjustment != null) {
                    SourceAutomaton.this.runningCount = SourceAutomaton.this.runningCount - 1;
                    if (SourceAutomaton.this.runningCount == 0) {
                        this.submitAdjustTask(SourceAutomaton.this.connectionCountPendingAdjustment, (Integer)SourceAutomaton.this.source.getConnectionCount().get());
                        SourceAutomaton.this.connectionCountPendingAdjustment = null;
                        sourceActions = SourceAutomaton.this.ADJUSTING;
                    } else {
                        sourceActions = SourceAutomaton.this.RUNNING;
                    }
                } else {
                    RunnableInstance runnableInstance = this.removeFirstQueuedRunnable();
                    if (runnableInstance != null) {
                        SourceAutomaton.this.executionService.addEvent(runnableInstance.getAutomaton().createStartRun());
                        sourceActions = SourceAutomaton.this.RUNNING;
                    } else {
                        SourceAutomaton.this.runningCount = SourceAutomaton.this.runningCount - 1;
                        if (SourceAutomaton.this.runningCount == 0) {
                            sourceActions = SourceAutomaton.this.CONNECTED;
                            this.scheduleKeepAlive();
                        } else {
                            sourceActions = SourceAutomaton.this.RUNNING;
                        }
                    }
                }
            } else {
                SourceAutomaton.this.runningCount = SourceAutomaton.this.runningCount - 1;
                if (SourceAutomaton.this.runningCount == 0) {
                    this.submitCheckTask();
                    sourceActions = SourceAutomaton.this.CHECKING;
                } else {
                    sourceActions = SourceAutomaton.this.RUNNING;
                }
            }
            return sourceActions;
        }

        @Override
        SourceActions requestAdjust(int n) {
            SourceAutomaton.this.connectionCountPendingAdjustment = n;
            return this;
        }
    }

    private class UnconnectedActions
    extends AbstractRunnablesActiveActions {
        UnconnectedActions() {
            super("UNCONNECTED");
        }

        @Override
        boolean isConnected() {
            return false;
        }

        @Override
        SourceActions onNoActiveRunnables() {
            this.cancelKeepAlive();
            return SourceAutomaton.this.RUNNABLES_PINNED;
        }

        @Override
        SourceActions requestKeepAlive() {
            this.cancelKeepAlive();
            this.submitConnectTask((Integer)SourceAutomaton.this.source.getConnectionCount().get());
            return SourceAutomaton.this.CONNECTING;
        }
    }

    private class ConnectedActions
    extends AbstractRunnablesActiveActions {
        ConnectedActions() {
            super("CONNECTED");
        }

        @Override
        boolean isConnected() {
            return true;
        }

        @Override
        SourceActions onNoActiveRunnables() {
            this.cancelKeepAlive();
            this.submitDisconnectTask();
            return SourceAutomaton.this.DISCONNECTING_NO_RUNNABLES_ACTIVE;
        }

        @Override
        SourceActions queueRunnable(RunnableInstance runnableInstance) {
            this.cancelKeepAlive();
            SourceAutomaton.this.executionService.addEvent(runnableInstance.getAutomaton().createStartRun());
            SourceAutomaton.this.runningCount = SourceAutomaton.this.runningCount + 1;
            return SourceAutomaton.this.RUNNING;
        }

        @Override
        SourceActions requestAdjust(int n) {
            this.cancelKeepAlive();
            this.submitAdjustTask(n, (Integer)SourceAutomaton.this.source.getConnectionCount().get());
            return SourceAutomaton.this.ADJUSTING;
        }

        @Override
        SourceActions requestKeepAlive() {
            this.cancelKeepAlive();
            this.submitCheckTask();
            return SourceAutomaton.this.CHECKING;
        }
    }

    private class RunnablesPinnedActions
    extends AbstractNoRunnablesActiveActions {
        RunnablesPinnedActions() {
            super("RUNNABLES_PINNED");
        }

        @Override
        boolean isConnected() {
            return false;
        }

        @Override
        SourceActions onNoPinnedRunnables() {
            return this.removeSource();
        }

        @Override
        SourceActions onActiveRunnables() {
            this.submitConnectTask((Integer)SourceAutomaton.this.source.getConnectionCount().get());
            return SourceAutomaton.this.CONNECTING;
        }
    }

    private class NoRunnablesPinnedActions
    extends AbstractNoRunnablesPinnedActions {
        NoRunnablesPinnedActions() {
            super("NO_RUNNABLES_PINNED");
        }

        @Override
        boolean isConnected() {
            return false;
        }

        @Override
        SourceActions onPinnedRunnables() {
            return SourceAutomaton.this.RUNNABLES_PINNED;
        }

        @Override
        SourceActions remove() {
            SourceAutomaton.this.source.remove();
            SourceAutomaton.this.getContext().getLogger().log(Level.INFO, "source ''{0}'' closed", new Object[]{SourceAutomaton.this.source.getId()});
            return SourceAutomaton.this.REMOVED;
        }
    }

    private abstract class AbstractRunnablesActiveActions
    extends SourceActions {
        AbstractRunnablesActiveActions(String string) {
            super(string);
        }

        @Override
        SourceActions runnablePinned() {
            SourceAutomaton.this.pinnedCount = SourceAutomaton.this.pinnedCount + 1;
            return this;
        }

        @Override
        SourceActions runnableUnpinned() {
            if (SourceAutomaton.this.pinnedCount > 1) {
                SourceAutomaton.this.pinnedCount = SourceAutomaton.this.pinnedCount - 1;
            } else {
                SourceAutomaton.this.getContext().getLogger().log(Level.SEVERE, "unexpected state machine event whilst in state '" + ((SourceAutomatonActions)SourceAutomaton.this.getState()).getName() + "' for source '" + SourceAutomaton.this.source.getId() + "'", new IllegalStateException());
            }
            return this;
        }

        @Override
        SourceActions runnableActivated() {
            SourceAutomaton.this.activeCount = SourceAutomaton.this.activeCount + 1;
            return this;
        }

        @Override
        SourceActions runnableInactivated() {
            SourceAutomaton.this.activeCount = SourceAutomaton.this.activeCount - 1;
            SourceActions sourceActions = SourceAutomaton.this.activeCount == 0 ? this.onNoActiveRunnables() : this;
            return sourceActions;
        }

        @Override
        SourceActions queueRunnable(RunnableInstance runnableInstance) {
            if (SourceAutomaton.this.runnableQueue.contains(runnableInstance)) {
                SourceAutomaton.this.getContext().getLogger().log(Level.SEVERE, "unexpected state machine event whilst in state '" + ((SourceAutomatonActions)SourceAutomaton.this.getState()).getName() + "' for source '" + SourceAutomaton.this.source.getId() + "'", new IllegalStateException());
            }
            SourceAutomaton.this.runnableQueue.addLast(runnableInstance);
            return this;
        }

        @Override
        SourceActions cancelQueueRunnable(RunnableInstance runnableInstance) {
            if (!SourceAutomaton.this.runnableQueue.remove(runnableInstance)) {
                SourceAutomaton.this.getContext().getLogger().log(Level.SEVERE, "unexpected state machine event whilst in state '" + ((SourceAutomatonActions)SourceAutomaton.this.getState()).getName() + "' for source '" + SourceAutomaton.this.source.getId() + "'", new IllegalStateException());
            }
            return this;
        }

        SourceActions onConnectionTaskCompleted(DXException dXException) {
            SourceActions sourceActions;
            if (SourceAutomaton.this.runningCount != 0) {
                SourceAutomaton.this.getContext().getLogger().log(Level.SEVERE, "unexpected condition in state ''{0}'' for source ''{1}'' = running count > 0", new Object[]{((SourceAutomatonActions)SourceAutomaton.this.getState()).getName(), SourceAutomaton.this.source.getId()});
                return this;
            }
            if (dXException == null) {
                if (this.self() == SourceAutomaton.this.CONNECTING) {
                    for (JobInstance jobInstance : SourceAutomaton.this.source.getFaultedJobs()) {
                        SourceAutomaton.this.executionService.addEvent(jobInstance.getAutomaton().createRequestRun());
                    }
                }
                if (SourceAutomaton.this.connectionCountPendingAdjustment != null) {
                    this.submitAdjustTask(SourceAutomaton.this.connectionCountPendingAdjustment, (Integer)SourceAutomaton.this.source.getConnectionCount().get());
                    SourceAutomaton.this.connectionCountPendingAdjustment = null;
                    sourceActions = SourceAutomaton.this.ADJUSTING;
                } else {
                    Object object = this.removeFirstQueuedRunnable();
                    if (object != null) {
                        SourceAutomaton.this.runningCount = 1;
                        SourceAutomaton.this.executionService.addEvent(((RunnableInstance)object).getAutomaton().createStartRun());
                        while (SourceAutomaton.this.runningCount < (Integer)SourceAutomaton.this.source.getConnectionCount().get() && (object = this.removeFirstQueuedRunnable()) != null) {
                            SourceAutomaton.this.runningCount = SourceAutomaton.this.runningCount + 1;
                            SourceAutomaton.this.executionService.addEvent(((RunnableInstance)object).getAutomaton().createStartRun());
                        }
                        sourceActions = SourceAutomaton.this.RUNNING;
                    } else {
                        this.setupKeepAlive(this.self() == SourceAutomaton.this.CHECKING, dXException);
                        sourceActions = SourceAutomaton.this.CONNECTED;
                    }
                }
            } else {
                SourceAutomaton.this.getContext().getLogger().log(Level.WARNING, "connection failure for source '" + SourceAutomaton.this.source.getId() + "'", dXException);
                this.setupKeepAlive(this.self() == SourceAutomaton.this.CHECKING, dXException);
                sourceActions = SourceAutomaton.this.UNCONNECTED;
            }
            return sourceActions;
        }

        void setupKeepAlive(boolean bl, DXException dXException) {
            if (bl && dXException != null) {
                SourceAutomaton.this.executionService.addEvent(SourceAutomaton.this.createRequestKeepAlive());
            } else {
                this.scheduleKeepAlive();
            }
        }

        void scheduleKeepAlive() {
            SourceAutomaton.this.connectKeepAliveFuture = SourceAutomaton.this.executionService.scheduleCommand((long)(1000.0 * (Double)SourceAutomaton.this.source.getMinimumInterval().get()), new Command(){

                @Override
                void execute() {
                    SourceAutomaton.this.executionService.addEvent(SourceAutomaton.this.createRequestKeepAlive());
                }

                @Override
                URI getId() {
                    return SourceAutomaton.this.source.getId();
                }

                @Override
                String getName() {
                    return "requestKeepAlive";
                }
            });
        }

        RunnableInstance removeFirstQueuedRunnable() {
            RunnableInstance runnableInstance = null;
            if (SourceAutomaton.this.runnableQueue.size() > 0) {
                runnableInstance = (RunnableInstance)SourceAutomaton.this.runnableQueue.removeFirst();
            }
            return runnableInstance;
        }

        abstract SourceActions onNoActiveRunnables();
    }

    private abstract class AbstractNoRunnablesActiveActions
    extends SourceActions {
        AbstractNoRunnablesActiveActions(String string) {
            super(string);
        }

        @Override
        SourceActions runnablePinned() {
            SourceAutomaton.this.pinnedCount = SourceAutomaton.this.pinnedCount + 1;
            return this;
        }

        @Override
        SourceActions runnableUnpinned() {
            SourceAutomaton.this.pinnedCount = SourceAutomaton.this.pinnedCount - 1;
            SourceActions sourceActions = SourceAutomaton.this.pinnedCount == 0 ? this.onNoPinnedRunnables() : this;
            return sourceActions;
        }

        @Override
        SourceActions runnableActivated() {
            SourceAutomaton.this.activeCount = SourceAutomaton.this.activeCount + 1;
            return this.onActiveRunnables();
        }

        @Override
        SourceActions runnableInactivated() {
            SourceAutomaton.this.getContext().getLogger().log(Level.SEVERE, "unexpected state machine event whilst in state '" + ((SourceAutomatonActions)SourceAutomaton.this.getState()).getName() + "' for source '" + SourceAutomaton.this.source.getId() + "'", new IllegalStateException());
            return this;
        }

        abstract SourceActions onNoPinnedRunnables();

        abstract SourceActions onActiveRunnables();
    }

    private abstract class AbstractNoRunnablesPinnedActions
    extends SourceActions {
        AbstractNoRunnablesPinnedActions(String string) {
            super(string);
        }

        @Override
        SourceActions runnablePinned() {
            SourceAutomaton.this.pinnedCount = SourceAutomaton.this.pinnedCount + 1;
            return this.onPinnedRunnables();
        }

        @Override
        SourceActions runnableUnpinned() {
            SourceAutomaton.this.getContext().getLogger().log(Level.SEVERE, "unexpected state machine event whilst in state '" + ((SourceAutomatonActions)SourceAutomaton.this.getState()).getName() + "' for source '" + SourceAutomaton.this.source.getId() + "'", new IllegalStateException());
            return this;
        }

        @Override
        SourceActions runnableActivated() {
            SourceAutomaton.this.getContext().getLogger().log(Level.SEVERE, "unexpected state machine event whilst in state '" + ((SourceAutomatonActions)SourceAutomaton.this.getState()).getName() + "' for source '" + SourceAutomaton.this.source.getId() + "'", new IllegalStateException());
            return this;
        }

        @Override
        SourceActions runnableInactivated() {
            SourceAutomaton.this.getContext().getLogger().log(Level.SEVERE, "unexpected state machine event whilst in state '" + ((SourceAutomatonActions)SourceAutomaton.this.getState()).getName() + "' for source '" + SourceAutomaton.this.source.getId() + "'", new IllegalStateException());
            return this;
        }

        abstract SourceActions onPinnedRunnables();
    }

    private abstract class SourceActions
    extends SourceAutomatonActions {
        SourceActions(String string) {
            super(string);
        }

        @Override
        void logStateEventError() {
            SourceAutomaton.this.getContext().getLogger().log(Level.SEVERE, "unexpected state machine event whilst in state '" + ((SourceAutomatonActions)SourceAutomaton.this.getState()).getName() + "' for source '" + SourceAutomaton.this.source.getId() + "'", new IllegalStateException());
        }

        SourceActions removeSource() {
            for (JobInstance runnableInstance : SourceAutomaton.this.source.getFaultedJobs()) {
                SourceAutomaton.this.executionService.addEvent(runnableInstance.getAutomaton().createRemove());
            }
            for (OperationInstance operationInstance : SourceAutomaton.this.source.getFaultedOperations()) {
                SourceAutomaton.this.executionService.addEvent(operationInstance.getAutomaton().createRemove());
            }
            SourceAutomaton.this.executionService.addEvent(SourceAutomaton.this.createRemove());
            return SourceAutomaton.this.NO_RUNNABLES_PINNED;
        }

        void submitConnectTask(final int n) {
            SourceAutomaton.this.executionService.submitTask(new Task(){

                @Override
                void execute() {
                    SourceActions.this.callConnect(n);
                }

                @Override
                boolean cancel() {
                    SourceAutomaton.this.taskCanceled = SourceAutomaton.this.source.cancelConnect();
                    return SourceAutomaton.this.taskCanceled;
                }

                @Override
                String getLabel() {
                    return MetricsResources.format("METRICS_LABEL_CONNECTING_SOURCE", SourceAutomaton.this.source.getConnectionDisplayName());
                }

                @Override
                URI getId() {
                    return SourceAutomaton.this.source.getId();
                }

                @Override
                String getName() {
                    return "connect";
                }
            });
        }

        void submitAdjustTask(final int n, final int n2) {
            SourceAutomaton.this.executionService.submitTask(new Task(){

                @Override
                void execute() {
                    SourceActions.this.callAdjust(n, n2);
                }

                @Override
                boolean cancel() {
                    SourceAutomaton.this.taskCanceled = SourceAutomaton.this.source.cancelAdjustConnectionCount();
                    return SourceAutomaton.this.taskCanceled;
                }

                @Override
                String getLabel() {
                    return MetricsResources.format("METRICS_LABEL_ADJUSTING_SOURCE", SourceAutomaton.this.source.getConnectionDisplayName());
                }

                @Override
                URI getId() {
                    return SourceAutomaton.this.source.getId();
                }

                @Override
                String getName() {
                    return "adjustConnectionCount";
                }
            });
        }

        void submitCheckTask() {
            SourceAutomaton.this.executionService.submitTask(new Task(){

                @Override
                void execute() {
                    SourceActions.this.callCheck();
                }

                @Override
                boolean cancel() {
                    SourceAutomaton.this.taskCanceled = SourceAutomaton.this.source.cancelCheck();
                    return SourceAutomaton.this.taskCanceled;
                }

                @Override
                String getLabel() {
                    return MetricsResources.format("METRICS_LABEL_CHECKING_SOURCE", SourceAutomaton.this.source.getConnectionDisplayName());
                }

                @Override
                URI getId() {
                    return SourceAutomaton.this.source.getId();
                }

                @Override
                String getName() {
                    return "check";
                }
            });
        }

        void submitDisconnectTask() {
            SourceAutomaton.this.executionService.submitTask(new Task(){

                @Override
                void execute() {
                    SourceActions.this.callDisconnect();
                }

                @Override
                boolean cancel() {
                    SourceAutomaton.this.taskCanceled = SourceAutomaton.this.source.cancelDisconnect();
                    return SourceAutomaton.this.taskCanceled;
                }

                @Override
                String getLabel() {
                    return MetricsResources.format("METRICS_LABEL_DISCONNECTING_SOURCE", SourceAutomaton.this.source.getConnectionDisplayName());
                }

                @Override
                URI getId() {
                    return SourceAutomaton.this.source.getId();
                }

                @Override
                String getName() {
                    return "disconnect";
                }
            });
        }

        void callConnect(int n) {
            DXException dXException = null;
            try {
                SourceAutomaton.this.source.connect(n);
            }
            catch (DXException dXException2) {
                dXException = dXException2;
            }
            catch (RuntimeException runtimeException) {
                dXException = new DXException(runtimeException);
            }
            final DXException dXException3 = dXException;
            SourceAutomaton.this.executionService.enqueueCommand(new Command(){

                @Override
                void execute() {
                    SourceAutomaton.this.executionService.addEvent(SourceAutomaton.this.createConnectCompleted(dXException3));
                }

                @Override
                URI getId() {
                    return SourceAutomaton.this.source.getId();
                }

                @Override
                String getName() {
                    return "connectCompleted";
                }
            });
        }

        void callAdjust(int n, int n2) {
            DXException dXException = null;
            try {
                SourceAutomaton.this.source.adjust(n, n2);
            }
            catch (DXException dXException2) {
                dXException = dXException2;
            }
            catch (RuntimeException runtimeException) {
                dXException = new DXException(runtimeException);
            }
            final DXException dXException3 = dXException;
            SourceAutomaton.this.executionService.enqueueCommand(new Command(){

                @Override
                void execute() {
                    SourceAutomaton.this.executionService.addEvent(SourceAutomaton.this.createAdjustCompleted(dXException3));
                }

                @Override
                URI getId() {
                    return SourceAutomaton.this.source.getId();
                }

                @Override
                String getName() {
                    return "adjustCompleted";
                }
            });
        }

        void callCheck() {
            DXException dXException = null;
            try {
                SourceAutomaton.this.source.check();
            }
            catch (DXException dXException2) {
                dXException = dXException2;
            }
            catch (RuntimeException runtimeException) {
                dXException = new DXException(runtimeException);
            }
            final DXException dXException3 = dXException;
            SourceAutomaton.this.executionService.enqueueCommand(new Command(){

                @Override
                void execute() {
                    SourceAutomaton.this.executionService.addEvent(SourceAutomaton.this.createCheckCompleted(dXException3));
                }

                @Override
                URI getId() {
                    return SourceAutomaton.this.source.getId();
                }

                @Override
                String getName() {
                    return "checkCompleted";
                }
            });
        }

        void callDisconnect() {
            DXException dXException = null;
            try {
                SourceAutomaton.this.source.disconnect();
            }
            catch (RuntimeException runtimeException) {
                dXException = new DXException(runtimeException);
            }
            if (dXException != null) {
                SourceAutomaton.this.getContext().getLogger().log(Level.WARNING, "Error attempting to close metrics source connection", dXException);
            }
            SourceAutomaton.this.executionService.enqueueCommand(new Command(){

                @Override
                void execute() {
                    SourceAutomaton.this.executionService.addEvent(SourceAutomaton.this.createDisconnectCompleted());
                }

                @Override
                URI getId() {
                    return SourceAutomaton.this.source.getId();
                }

                @Override
                String getName() {
                    return "disconnectCompleted";
                }
            });
        }

        void cancelKeepAlive() {
            if (SourceAutomaton.this.connectKeepAliveFuture != null) {
                SourceAutomaton.this.connectKeepAliveFuture.cancel(false);
                SourceAutomaton.this.connectKeepAliveFuture = null;
            }
        }
    }
}

