/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.facet;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.application.Platform;
import javafx.beans.DefaultProperty;
import javafx.beans.binding.ListExpression;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.scene.layout.Region;
import oracle.dbtools.raptor.metrics.control.AbstractGraphControl;
import oracle.dbtools.raptor.metrics.control.BezierComponent;
import oracle.dbtools.raptor.metrics.control.Graph;
import oracle.dbtools.raptor.metrics.control.GraphObject;
import oracle.dbtools.raptor.metrics.control.LocatedEdge;
import oracle.dbtools.raptor.metrics.control.LocatedVertex;
import oracle.dbtools.raptor.metrics.facet.Monitor;
import oracle.dbtools.raptor.metrics.observable.DXRow;
import oracle.dbtools.raptor.metrics.panel.BoundListDataObject;
import oracle.dbtools.raptor.metrics.panel.Context;
import oracle.dbtools.raptor.metrics.panel.DataObject;
import oracle.dbtools.raptor.metrics.panel.InstanceListener;
import oracle.dbtools.raptor.metrics.panel.PanelTemplate;
import oracle.dbtools.raptor.metrics.panel.TemplateInstance;

@DefaultProperty(value="item")
public abstract class AbstractGraphMonitor<G extends Graph<DXRow, V, E>, V extends LocatedVertex<DXRow, V, E>, E extends LocatedEdge<DXRow, V, E>, ER extends BezierComponent>
implements Monitor {
    private ChangeListener<Boolean> listener;
    private boolean modelResetAtLeastOnce = false;
    private final ObjectProperty<BoundListDataObject> itemProperty = new SimpleObjectProperty((Object)this, "item");
    private final StringProperty vertexIDColumnProperty = new SimpleStringProperty((Object)this, "vertexIDColumn");
    private final StringProperty vertexLabelColumnProperty = new SimpleStringProperty((Object)this, "vertexLabelColumn");
    private final StringProperty destVertexIDColumnProperty = new SimpleStringProperty((Object)this, "destVertexIDColumn");
    private final StringProperty styleClassColumnProperty = new SimpleStringProperty((Object)this, "styleClassColumn");
    private final ObjectProperty<PanelTemplate<Region>> vertexRepresentationPanelTemplateProperty = new SimpleObjectProperty((Object)this, "vertexRepresentationPanelTemplate");
    private final ObjectProperty<PanelTemplate<Region>> vertexDisplayPanelTemplateProperty = new SimpleObjectProperty((Object)this, "vertexDisplayPanelTemplate");
    private final ObjectProperty<PanelTemplate<Region>> edgeDisplayPanelTemplateProperty = new SimpleObjectProperty((Object)this, "edgeDisplayPanelTemplate");
    private final BooleanProperty controlLoadedProperty = new SimpleBooleanProperty((Object)this, "controlLoaded");

    public BoundListDataObject getItem() {
        return (BoundListDataObject)this.itemProperty.get();
    }

    public void setItem(BoundListDataObject boundListDataObject) {
        this.itemProperty.set((Object)boundListDataObject);
    }

    public ObjectProperty<BoundListDataObject> itemProperty() {
        return this.itemProperty;
    }

    public String getVertexIDColumn() {
        return (String)this.vertexIDColumnProperty.get();
    }

    public void setVertexIDColumn(String string) {
        this.vertexIDColumnProperty.set((Object)string);
    }

    public StringProperty vertexIDColumnProperty() {
        return this.vertexIDColumnProperty;
    }

    public String getVertexLabelColumn() {
        return (String)this.vertexLabelColumnProperty.get();
    }

    public void setVertexLabelColumn(String string) {
        this.vertexLabelColumnProperty.set((Object)string);
    }

    public StringProperty vertexLabelColumnProperty() {
        return this.vertexLabelColumnProperty;
    }

    public String getDestVertexIDColumn() {
        return (String)this.destVertexIDColumnProperty.get();
    }

    public void setDestVertexIDColumn(String string) {
        this.destVertexIDColumnProperty.set((Object)string);
    }

    public StringProperty destVertexIDColumnProperty() {
        return this.destVertexIDColumnProperty;
    }

    public String getStyleClassColumn() {
        return (String)this.styleClassColumnProperty.get();
    }

    public void setStyleClassColumn(String string) {
        this.styleClassColumnProperty.set((Object)string);
    }

    public StringProperty styleClassColumnProperty() {
        return this.styleClassColumnProperty;
    }

    public PanelTemplate<Region> getVertexRepresentationPanelTemplate() {
        return (PanelTemplate)this.vertexRepresentationPanelTemplateProperty.get();
    }

    public void setVertexRepresentationPanelTemplate(PanelTemplate<Region> panelTemplate) {
        this.vertexRepresentationPanelTemplateProperty.set(panelTemplate);
    }

    public ObjectProperty<PanelTemplate<Region>> vertexRepresentationPanelTemplateProperty() {
        return this.vertexRepresentationPanelTemplateProperty;
    }

    public PanelTemplate<Region> getVertexDisplayPanelTemplate() {
        return (PanelTemplate)this.vertexDisplayPanelTemplateProperty.get();
    }

    public void setVertexDisplayPanelTemplate(PanelTemplate<Region> panelTemplate) {
        this.vertexDisplayPanelTemplateProperty.set(panelTemplate);
    }

    public ObjectProperty<PanelTemplate<Region>> vertexDisplayPanelTemplateProperty() {
        return this.vertexDisplayPanelTemplateProperty;
    }

    public PanelTemplate<Region> getEdgeDisplayPanelTemplate() {
        return (PanelTemplate)this.edgeDisplayPanelTemplateProperty.get();
    }

    public void setEdgeDisplayPanelTemplate(PanelTemplate<Region> panelTemplate) {
        this.edgeDisplayPanelTemplateProperty.set(panelTemplate);
    }

    public ObjectProperty<PanelTemplate<Region>> edgeDisplayPanelTemplateProperty() {
        return this.edgeDisplayPanelTemplateProperty;
    }

    public boolean isControlLoaded() {
        return this.controlLoadedProperty.get();
    }

    public ReadOnlyBooleanProperty controlLoadedProperty() {
        return this.controlLoadedProperty;
    }

    @Override
    public List<DataObject<?>> getDataObjects(Context context) {
        return Collections.singletonList(this.itemProperty.get());
    }

    protected abstract V createVertex(DXRow var1);

    protected abstract E createEdge(V var1, V var2, DXRow var3);

    protected void resetModel(final AbstractGraphControl<DXRow, G, V, E, ER> abstractGraphControl) {
        Object object;
        HashMap hashMap;
        Object object22;
        Object object3;
        Object object42;
        ListExpression listExpression;
        Object object52;
        String string = this.getVertexIDColumn();
        String string2 = this.getVertexLabelColumn();
        if (string2 == null) {
            string2 = string;
        }
        String string3 = this.getDestVertexIDColumn();
        ObservableList observableList = ((Graph)abstractGraphControl.getGraph()).getVertices();
        HashMap<Object, Object> hashMap2 = new HashMap<Object, Object>();
        for (Object object52 : observableList) {
            listExpression = (DXRow)((GraphObject)object52).getValue();
            object42 = (String)listExpression.get(string, String.class).get();
            hashMap2.put(object42, object52);
        }
        ObservableList observableList2 = ((Graph)abstractGraphControl.getGraph()).getEdges();
        object52 = new HashMap();
        for (Object object42 : observableList2) {
            Object object6 = (DXRow)((GraphObject)object42).getValue();
            object3 = (String)object6.get(string, String.class).get();
            object22 = (String)object6.get(string3, String.class).get();
            hashMap = (HashMap)object52.get(object3);
            if (hashMap == null) {
                hashMap = new HashMap();
                object52.put(object3, hashMap);
            }
            hashMap.put((String)object22, object42);
        }
        listExpression = this.getItem().valueProperty();
        for (Object object6 : listExpression) {
            object3 = (String)object6.get("Type", String.class).get();
            if (!((String)object3).equals("VERTEX") || (hashMap = (LocatedVertex)hashMap2.get(object22 = (String)object6.get(string, String.class).get())) != null) continue;
            hashMap = this.createVertex((DXRow)object6);
            ((GraphObject)((Object)hashMap)).setValue(object6);
            ((LocatedVertex)((Object)hashMap)).setLabel((String)object6.get(string2, String.class).get());
            object = this.getStyleClass((DXRow)object6);
            if (object != null) {
                ((LocatedVertex)((Object)hashMap)).setStyleClass((String)object);
            }
            hashMap2.put(object22, hashMap);
        }
        for (Object object6 : listExpression) {
            object3 = (String)object6.get("Type", String.class).get();
            if (!((String)object3).equals("EDGE")) continue;
            object22 = (String)object6.get(string, String.class).get();
            hashMap = (String)object6.get(string3, String.class).get();
            object = null;
            Map map = (Map)object52.get(object22);
            if (map != null) {
                object = (LocatedEdge)map.remove(hashMap);
            }
            if (object != null) continue;
            LocatedVertex locatedVertex = (LocatedVertex)hashMap2.get(object22);
            LocatedVertex locatedVertex2 = (LocatedVertex)hashMap2.get(hashMap);
            object = this.createEdge(locatedVertex, locatedVertex2, (DXRow)object6);
            ((GraphObject)object).setValue(object6);
            String string4 = this.getStyleClass((DXRow)object6);
            if (string4 != null) {
                ((LocatedEdge)object).setStyleClass(string4);
            }
            observableList2.add(object);
        }
        for (Object object6 : object52.values()) {
            for (Object object22 : object6.values()) {
                observableList2.remove(object22);
            }
        }
        if (!this.modelResetAtLeastOnce) {
            object42 = new ChangeListener<Boolean>(){

                public void changed(ObservableValue<? extends Boolean> observableValue, Boolean bl, Boolean bl2) {
                    if (bl.booleanValue()) {
                        AbstractGraphMonitor.this.controlLoadedProperty.set(true);
                        abstractGraphControl.needsLayoutProperty().removeListener((ChangeListener)this);
                    }
                }
            };
            abstractGraphControl.needsLayoutProperty().addListener((ChangeListener)object42);
            this.modelResetAtLeastOnce = true;
        }
    }

    private Region createPanel(Context context, PanelTemplate<Region> panelTemplate, DXRow dXRow, String string) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (String string2 : dXRow.getNames()) {
            hashMap.put(string2, dXRow.get(string2).get());
        }
        TemplateInstance<Region> templateInstance = panelTemplate.newPanel(hashMap);
        if (templateInstance != null) {
            if (string != null) {
                ((Region)templateInstance.getRootObject()).getStyleClass().add((Object)string);
            }
            templateInstance.getContext().setDataStreamEnabled(context.isRunning());
            return (Region)templateInstance.getRootObject();
        }
        return null;
    }

    private String getStyleClass(DXRow dXRow) {
        ObjectProperty<String> objectProperty;
        String string = null;
        String string2 = this.getStyleClassColumn();
        if (string2 != null && (objectProperty = dXRow.get(string2, String.class)) != null) {
            string = (String)objectProperty.get();
        }
        return string;
    }

    protected abstract class Listener
    implements InstanceListener {
        protected Listener() {
        }

        @Override
        public void onOpen(Context context) {
            if (AbstractGraphMonitor.this.listener == null) {
                PanelTemplate<Region> panelTemplate;
                PanelTemplate<Region> panelTemplate2;
                AbstractGraphControl abstractGraphControl = context.getLinkedTarget(AbstractGraphControl.class, AbstractGraphMonitor.this);
                PanelTemplate<Region> panelTemplate3 = AbstractGraphMonitor.this.getVertexRepresentationPanelTemplate();
                if (panelTemplate3 != null) {
                    abstractGraphControl.setVertexRepresentationFactory(locatedVertex -> AbstractGraphMonitor.this.createPanel(context, panelTemplate3, (DXRow)locatedVertex.getValue(), locatedVertex.getStyleClass()));
                }
                if ((panelTemplate2 = AbstractGraphMonitor.this.getVertexDisplayPanelTemplate()) != null) {
                    abstractGraphControl.setVertexDisplayFactory(locatedVertex -> AbstractGraphMonitor.this.createPanel(context, panelTemplate2, (DXRow)locatedVertex.getValue(), locatedVertex.getStyleClass()));
                }
                if ((panelTemplate = AbstractGraphMonitor.this.getEdgeDisplayPanelTemplate()) != null) {
                    abstractGraphControl.setEdgeDisplayFactory(locatedEdge -> AbstractGraphMonitor.this.createPanel(context, panelTemplate, (DXRow)locatedEdge.getValue(), locatedEdge.getStyleClass()));
                }
                AbstractGraphMonitor.this.listener = (observableValue, bl, bl2) -> {
                    if (!bl2.booleanValue()) {
                        Platform.runLater(() -> AbstractGraphMonitor.this.resetModel(abstractGraphControl));
                    }
                };
                AbstractGraphMonitor.this.getItem().updatingProperty().addListener(AbstractGraphMonitor.this.listener);
            }
        }

        @Override
        public void onClose(Context context) {
            if (AbstractGraphMonitor.this.listener != null) {
                AbstractGraphMonitor.this.getItem().updatingProperty().removeListener(AbstractGraphMonitor.this.listener);
                AbstractGraphMonitor.this.listener = null;
            }
        }
    }
}

