/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.facet;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.collections.ObservableSet;
import oracle.dbtools.raptor.metrics.facet.Decorator;
import oracle.dbtools.raptor.metrics.panel.Facet;
import oracle.dbtools.raptor.metrics.panel.VarDataObject;

public abstract class AbstractPropertyReflectionObject
implements Decorator {
    private final ObjectProperty<Object> objectProperty = new SimpleObjectProperty();
    private final StringProperty propertyProperty = new SimpleStringProperty();

    public Object getObject() {
        return this.objectProperty.get();
    }

    public void setObject(Object object) {
        this.objectProperty.set(object);
    }

    public ObjectProperty<Object> objectProperty() {
        return this.objectProperty;
    }

    public String getProperty() {
        return (String)this.propertyProperty.get();
    }

    public void setProperty(String string) {
        this.propertyProperty.set((Object)string);
    }

    public StringProperty propertyProperty() {
        return this.propertyProperty;
    }

    @Override
    public Class<?> getBindToClass() {
        return Object.class;
    }

    @Override
    public Class<? extends Facet> getBindAsClass() {
        return AbstractPropertyReflectionObject.class;
    }

    protected <T extends Observable> T resolveObservable(Object object, String string) {
        Observable observable = null;
        if (object != null) {
            if (string == null) {
                if (object instanceof VarDataObject) {
                    VarDataObject varDataObject = (VarDataObject)object;
                    observable = varDataObject.valueProperty();
                }
            } else {
                try {
                    String string2 = string + "Property";
                    Method method = object.getClass().getMethod(string2, new Class[0]);
                    observable = (Observable)method.invoke(object, new Object[0]);
                }
                catch (IllegalAccessException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "unable to resolve property '" + string + "' on '" + object.getClass().getSimpleName() + "'", exception);
                }
            }
        }
        return (T)observable;
    }

    protected <T extends Observable> T resolveObservableCollection(Object object, String string) {
        Observable observable = null;
        if (string == null) {
            VarDataObject varDataObject;
            Property property;
            if (object instanceof VarDataObject && (property = (varDataObject = (VarDataObject)object).valueProperty()) != null) {
                observable = (Observable)property.getValue();
            }
        } else {
            try {
                String string2 = "get" + Character.toUpperCase(string.charAt(0)) + string.substring(1);
                Method method = object.getClass().getMethod(string2, new Class[0]);
                observable = (Observable)method.invoke(object, new Object[0]);
            }
            catch (IllegalAccessException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "unable to resolve property '" + string + ",", exception);
            }
        }
        return (T)observable;
    }

    protected boolean compatibleCollections(Observable observable, Observable observable2) {
        if (observable == null || observable2 == null) {
            return false;
        }
        if (observable instanceof List && observable2 instanceof List) {
            return true;
        }
        if (observable instanceof Set && observable2 instanceof Set) {
            return true;
        }
        return observable instanceof Map && observable2 instanceof Map;
    }

    protected void bindCompatibleCollections(boolean bl, Observable observable, Observable observable2) {
        if (observable instanceof List) {
            if (bl) {
                Bindings.bindContentBidirectional((ObservableList)((ObservableList)observable), (ObservableList)((ObservableList)observable2));
            } else {
                Bindings.bindContent((List)((List)observable), (ObservableList)((ObservableList)observable2));
            }
        }
        if (observable instanceof Set) {
            if (bl) {
                Bindings.bindContentBidirectional((ObservableSet)((ObservableSet)observable), (ObservableSet)((ObservableSet)observable2));
            } else {
                Bindings.bindContent((Set)((Set)observable), (ObservableSet)((ObservableSet)observable2));
            }
        }
        if (observable instanceof Map) {
            if (bl) {
                Bindings.bindContentBidirectional((ObservableMap)((ObservableMap)observable), (ObservableMap)((ObservableMap)observable2));
            } else {
                Bindings.bindContent((Map)((Map)observable), (ObservableMap)((ObservableMap)observable2));
            }
        }
    }
}

