/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.facet;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javafx.beans.DefaultProperty;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.HPos;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Label;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.RowConstraints;
import javafx.scene.layout.StackPane;
import oracle.dbtools.raptor.metrics.facet.Monitor;
import oracle.dbtools.raptor.metrics.facet.Selection;
import oracle.dbtools.raptor.metrics.panel.Context;
import oracle.dbtools.raptor.metrics.panel.InstanceListener;
import oracle.dbtools.raptor.metrics.panel.PanelTemplate;
import oracle.dbtools.raptor.metrics.panel.TemplateInstance;

@DefaultProperty(value="selections")
public abstract class AbstractSelectionMonitor
implements Monitor {
    private final Map<String, TemplateInstance<Parent>> panelInstanceMap = new HashMap<String, TemplateInstance<Parent>>();
    private Node unselectedPane;
    private Context context;
    private final ObservableList<Selection> selections = FXCollections.observableArrayList();
    private final BooleanProperty stopOnDeselectProperty = new SimpleBooleanProperty((Object)this, "stopOnDeselect", false);
    private final ObjectProperty<Node> unselectedGraphicProperty = new SimpleObjectProperty((Object)this, "unselectedGraphic");
    private final StringProperty unselectedTextProperty = new SimpleStringProperty((Object)this, "unselectedText", "");

    public ObservableList<Selection> getSelections() {
        return this.selections;
    }

    public boolean isStopOnDeselect() {
        return this.stopOnDeselectProperty.get();
    }

    public void setStopOnDeselect(boolean bl) {
        this.stopOnDeselectProperty.set(bl);
    }

    public BooleanProperty stopOnDeselectProperty() {
        return this.stopOnDeselectProperty;
    }

    public Node getUnselectedGraphic() {
        return (Node)this.unselectedGraphicProperty.get();
    }

    public void setUnselectedGraphic(Node node) {
        this.unselectedGraphicProperty.set((Object)node);
    }

    public ObjectProperty<Node> unselectedGraphicProperty() {
        return this.unselectedGraphicProperty;
    }

    public String getUnselectedText() {
        return (String)this.unselectedTextProperty.get();
    }

    public void setUnselectedText(String string) {
        this.unselectedTextProperty.set((Object)string);
    }

    public StringProperty unselectedTextProperty() {
        return this.unselectedTextProperty;
    }

    @Override
    public Class<?> getBindToClass() {
        return StackPane.class;
    }

    protected void start(String string) {
        TemplateInstance<Parent> templateInstance;
        boolean bl = false;
        if (string != null && (templateInstance = this.getInstance(string)) != null) {
            bl = true;
            templateInstance.getRootObject().setVisible(true);
            templateInstance.getContext().setDataStreamEnabled(true);
        }
        this.unselectedPane.setVisible(!bl);
    }

    protected void stop(String string) {
        TemplateInstance<Parent> templateInstance;
        if (string != null && (templateInstance = this.panelInstanceMap.get(string)) != null) {
            templateInstance.getRootObject().setVisible(false);
            if (this.isStopOnDeselect()) {
                templateInstance.getContext().setDataStreamEnabled(false);
            }
        }
        this.unselectedPane.setVisible(true);
    }

    private Node createUnselectedPanel() {
        Object object;
        int n;
        GridPane gridPane = new GridPane();
        gridPane.setVgap(5.0);
        for (n = 0; n < 3; ++n) {
            object = new ColumnConstraints();
            object.setPercentWidth(33.333333333333336);
            gridPane.getColumnConstraints().add(object);
        }
        for (n = 0; n < 2; ++n) {
            object = new RowConstraints();
            object.setPercentHeight(50.0);
            gridPane.getRowConstraints().add(object);
        }
        Node node = this.getUnselectedGraphic();
        if (node != null) {
            GridPane.setValignment((Node)node, (VPos)VPos.BOTTOM);
            GridPane.setHalignment((Node)node, (HPos)HPos.CENTER);
            gridPane.add(node, 1, 0);
        }
        if ((object = this.getUnselectedText()) != null) {
            Label label = new Label((String)object);
            label.getStyleClass().add((Object)"unselected-label");
            label.setMaxWidth(Double.MAX_VALUE);
            label.setAlignment(Pos.TOP_CENTER);
            GridPane.setValignment((Node)label, (VPos)VPos.TOP);
            GridPane.setHalignment((Node)label, (HPos)HPos.CENTER);
            gridPane.add((Node)label, 1, 1);
        }
        return gridPane;
    }

    private TemplateInstance<Parent> getInstance(String string) {
        TemplateInstance<Object> templateInstance = null;
        if (this.panelInstanceMap.containsKey(string) && (templateInstance = this.panelInstanceMap.get(string)) == null) {
            PanelTemplate<Parent> panelTemplate = null;
            for (Selection selection : this.selections) {
                if (!selection.getSelector().equals(string)) continue;
                panelTemplate = selection.getPanelTemplate();
                break;
            }
            if (panelTemplate != null && (templateInstance = panelTemplate.newPanel()) != null) {
                Selection selection;
                Iterator iterator = (Node)templateInstance.getRootObject();
                iterator.setVisible(false);
                selection = this.context.getLinkedTarget(StackPane.class, this);
                selection.getChildren().add((Object)iterator);
                this.panelInstanceMap.put(string, templateInstance);
            }
        }
        return templateInstance;
    }

    protected abstract class Listener
    implements InstanceListener {
        protected Listener() {
        }

        @Override
        public void onLoad(Context context) {
            AbstractSelectionMonitor.this.context = context;
        }

        @Override
        public void onOpen(Context context) {
            StackPane stackPane = context.getLinkedTarget(StackPane.class, AbstractSelectionMonitor.this);
            for (Selection selection : AbstractSelectionMonitor.this.selections) {
                String string = selection.getSelector();
                AbstractSelectionMonitor.this.panelInstanceMap.put(string, null);
            }
            AbstractSelectionMonitor.this.unselectedPane = AbstractSelectionMonitor.this.createUnselectedPanel();
            stackPane.getChildren().add((Object)AbstractSelectionMonitor.this.unselectedPane);
        }
    }
}

