/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.facet;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.control.IndexedCell;
import javafx.scene.control.TableColumnBase;
import oracle.dbtools.raptor.metrics.control.MultiBar;
import oracle.dbtools.raptor.metrics.control.MultiBarElement;
import oracle.dbtools.raptor.metrics.observable.DXRow;

class BarCellHelper<C extends TableColumnBase<?, Object>, L extends IndexedCell<?>> {
    private final StringProperty barValueColumnProperty = new SimpleStringProperty((Object)this, "barValueColumn");
    private final StringProperty elementColumnProperty = new SimpleStringProperty((Object)this, "elementColumn");
    private final DoubleProperty barHeightProperty = new SimpleDoubleProperty((Object)this, "barHeight", 10.0);
    private final DoubleProperty maxBarWidthProperty = new SimpleDoubleProperty((Object)this, "maxBarWidth", 50.0);
    private final StringProperty valueColumnProperty;
    private List<String> cachedElementColumns;

    BarCellHelper(StringProperty stringProperty) {
        this.valueColumnProperty = stringProperty;
    }

    DoubleProperty barHeightProperty() {
        return this.barHeightProperty;
    }

    DoubleProperty maxBarWidthProperty() {
        return this.maxBarWidthProperty;
    }

    StringProperty barValueColumnProperty() {
        return this.barValueColumnProperty;
    }

    StringProperty elementColumnProperty() {
        return this.elementColumnProperty;
    }

    List<String> getSecondaryChangeColumns() {
        this.ensureCacheInitialized();
        return this.cachedElementColumns;
    }

    void initializeBar(MultiBar multiBar) {
        this.ensureCacheInitialized();
        ArrayList<MultiBarElement> arrayList = new ArrayList<MultiBarElement>(this.cachedElementColumns.size());
        for (String string : this.cachedElementColumns) {
            MultiBarElement multiBarElement = new MultiBarElement();
            multiBarElement.setStyleClass("element-" + string);
            arrayList.add(multiBarElement);
        }
        multiBar.getElements().setAll(arrayList);
    }

    MultiBar updateBar(MultiBar multiBar, DXRow dXRow) {
        Object object;
        boolean bl = false;
        double d = 0.0;
        double d2 = 0.0;
        Double d3 = this.getValue(dXRow, (String)this.barValueColumnProperty.get());
        if (d3 == null) {
            bl = true;
        } else {
            d = d3;
            for (String string : this.cachedElementColumns) {
                object = this.getValue(dXRow, string);
                if (object == null) {
                    bl = true;
                    break;
                }
                d2 += ((Double)object).doubleValue();
            }
        }
        if (!bl) {
            double d4;
            double d5 = 1.0 / d2;
            object = multiBar.getElements();
            for (int i = 0; i < object.size(); ++i) {
                MultiBarElement multiBarElement = (MultiBarElement)object.get(i);
                d4 = this.getValue(dXRow, this.cachedElementColumns.get(i));
                multiBarElement.setValue(d4 * d5);
            }
            double d6 = this.barHeightProperty.get();
            d4 = d * this.maxBarWidthProperty.get();
            if (d4 < 2.0) {
                d4 = 2.0;
            }
            multiBar.setMinHeight(d6);
            multiBar.setPrefHeight(d6);
            multiBar.setMaxHeight(d6);
            multiBar.setMinWidth(d4);
            multiBar.setPrefWidth(d4);
            multiBar.setMaxWidth(d4);
        }
        return bl ? null : multiBar;
    }

    private Double getValue(DXRow dXRow, String string) {
        ObjectProperty<Double> objectProperty = dXRow.get(string, Double.class);
        return objectProperty != null ? (Double)objectProperty.get() : null;
    }

    private void ensureCacheInitialized() {
        if (this.cachedElementColumns == null) {
            this.cachedElementColumns = new ArrayList<String>();
            String string = (String)this.elementColumnProperty.get();
            if (string == null || string.isEmpty()) {
                string = (String)this.valueColumnProperty.get();
            }
            this.cachedElementColumns = Arrays.asList(string.trim().split("\\s*,\\s*"));
        }
    }
}

