/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.facet;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javafx.animation.Animation;
import javafx.animation.FadeTransition;
import javafx.application.Platform;
import javafx.beans.binding.ListExpression;
import javafx.scene.control.Control;
import javafx.scene.control.IndexedCell;
import javafx.scene.control.TableColumnBase;
import javafx.scene.effect.Effect;
import javafx.scene.effect.MotionBlur;
import javafx.util.Duration;
import oracle.dbtools.raptor.metrics.facet.AbstractChangeIndicatorObject;
import oracle.dbtools.raptor.metrics.facet.AbstractTableMonitor;
import oracle.dbtools.raptor.metrics.observable.DXKey;
import oracle.dbtools.raptor.metrics.observable.DXRow;
import oracle.dbtools.raptor.metrics.panel.BoundListDataObject;
import oracle.dbtools.raptor.metrics.panel.Context;
import oracle.dbtools.raptor.metrics.panel.Facet;
import oracle.dbtools.raptor.metrics.panel.SnapshotAttribute;

public class CellChangeIndicator
extends AbstractChangeIndicatorObject {
    private final Set<DXKey> changedRowKeys = new HashSet<DXKey>();
    private final List<IndexedCell<?>> updatedCells = new ArrayList();
    private final Map<IndexedCell<?>, Object> cellItemMap = new HashMap();
    private final Map<IndexedCell<?>, ChangeEffect> changeEffectMap = new HashMap();

    public CellChangeIndicator() {
        this.init(new Listener());
    }

    @Override
    public Class<? extends Facet> getBindAsClass() {
        return CellChangeIndicator.class;
    }

    void onCellUpdate(IndexedCell<?> indexedCell) {
        this.updatedCells.add(indexedCell);
        if (indexedCell.getIndex() < 0) {
            this.cellItemMap.remove(indexedCell);
        } else {
            this.cellItemMap.put(indexedCell, indexedCell.getItem());
        }
    }

    private void populateInitialRowItemMap(AbstractTableMonitor abstractTableMonitor, Map<DXKey, Map<TableColumnBase<?, Object>, Object>> map) {
        for (IndexedCell<?> indexedCell : this.cellItemMap.keySet()) {
            DXRow dXRow = abstractTableMonitor.getRow(indexedCell);
            if (dXRow == null) continue;
            DXKey dXKey = dXRow.getKey();
            Object c = abstractTableMonitor.getColumn(indexedCell);
            Map<TableColumnBase<?, Object>, Object> map2 = map.get(dXKey);
            if (map2 == null) {
                map2 = new HashMap();
                map.put(dXKey, map2);
            }
            map2.put((TableColumnBase<?, Object>)c, this.cellItemMap.get(indexedCell));
        }
    }

    private void processUpdatedCells(AbstractTableMonitor abstractTableMonitor, Map<DXKey, Map<TableColumnBase<?, Object>, Object>> map) {
        Object object;
        HashMap hashMap = new HashMap();
        for (Object object2 : this.updatedCells) {
            Object object3;
            object = abstractTableMonitor.getRow(object2);
            if (object == null || !this.changedRowKeys.contains(object3 = object.getKey())) continue;
            HashMap hashMap2 = (HashMap)hashMap.get(object3);
            if (hashMap2 == null) {
                hashMap2 = new HashMap();
                hashMap.put(object3, hashMap2);
            }
            hashMap2.put(abstractTableMonitor.getColumn(object2), (IndexedCell<?>)object2);
        }
        for (Object object2 : hashMap.keySet()) {
            object = (Map)hashMap.get(object2);
            for (HashMap hashMap2 : object.keySet()) {
                Object object4;
                IndexedCell indexedCell = (IndexedCell)object.get(hashMap2);
                Object object5 = null;
                Map<TableColumnBase<?, Object>, Object> map2 = map.get(object2);
                if (map2 != null) {
                    object5 = map2.get(hashMap2);
                }
                if (Objects.equals(object5, object4 = indexedCell.getItem())) continue;
                ChangeEffect changeEffect = this.changeEffectMap.remove(indexedCell);
                if (changeEffect != null) {
                    changeEffect.cancel(indexedCell);
                }
                changeEffect = new ChangeEffect(indexedCell);
                this.changeEffectMap.put(indexedCell, changeEffect);
            }
        }
        this.updatedCells.clear();
    }

    private class ChangeEffect {
        private final FadeTransition fadeTransition;

        private ChangeEffect(IndexedCell<?> indexedCell) {
            this.fadeTransition = new FadeTransition(Duration.seconds((double)0.25), indexedCell);
            this.fadeTransition.setFromValue(1.0);
            this.fadeTransition.setToValue(0.9);
            this.fadeTransition.setCycleCount(2);
            this.fadeTransition.setAutoReverse(true);
            this.fadeTransition.setOnFinished(actionEvent -> this.cancel(indexedCell));
            indexedCell.setEffect((Effect)new MotionBlur(0.0, 10.0));
            this.fadeTransition.play();
        }

        private void cancel(IndexedCell<?> indexedCell) {
            if (this.fadeTransition.getStatus() == Animation.Status.RUNNING) {
                this.fadeTransition.stop();
            }
            indexedCell.setEffect(null);
            CellChangeIndicator.this.changeEffectMap.remove(indexedCell);
        }
    }

    protected class Listener
    extends AbstractChangeIndicatorObject.Listener {
        protected Listener() {
        }

        @Override
        public void onOpen(Context context) {
            Control control;
            super.onOpen(context);
            if (!SnapshotAttribute.get(context) && (control = context.getLinkedTarget(Control.class, CellChangeIndicator.this)) != null) {
                AbstractTableMonitor abstractTableMonitor = context.getLinkedSource(AbstractTableMonitor.class, control);
                BoundListDataObject boundListDataObject = abstractTableMonitor.getItem();
                ListExpression listExpression = boundListDataObject.valueProperty();
                HashMap hashMap = new HashMap();
                listExpression.addListener(change -> {
                    boolean bl = CellChangeIndicator.this.changedRowKeys.isEmpty();
                    if (bl) {
                        CellChangeIndicator.this.populateInitialRowItemMap(abstractTableMonitor, hashMap);
                    }
                    while (change.next()) {
                        if (change.wasUpdated()) {
                            for (DXRow dXRow : change.getList().subList(change.getFrom(), change.getTo())) {
                                CellChangeIndicator.this.changedRowKeys.add(dXRow.getKey());
                            }
                            continue;
                        }
                        if (!change.wasAdded()) continue;
                        for (DXRow dXRow : change.getAddedSubList()) {
                            DXKey dXKey = dXRow.getKey();
                            CellChangeIndicator.this.changedRowKeys.add(dXKey);
                        }
                    }
                    if (bl && !CellChangeIndicator.this.changedRowKeys.isEmpty()) {
                        Platform.runLater(() -> {
                            control.layout();
                            CellChangeIndicator.this.processUpdatedCells(abstractTableMonitor, hashMap);
                            CellChangeIndicator.this.changedRowKeys.clear();
                            hashMap.clear();
                        });
                    }
                });
            }
        }
    }
}

