/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.facet;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Parent;
import javafx.scene.control.IndexedCell;
import javafx.scene.control.TableColumnBase;
import oracle.dbtools.raptor.metrics.facet.EnumItem;
import oracle.dbtools.raptor.metrics.panel.PanelTemplate;
import oracle.dbtools.raptor.metrics.panel.TemplateInstance;

class EnumCellHelper<C extends TableColumnBase<?, Object>, L extends IndexedCell<?>> {
    private final ObservableList<EnumItem> enumItems = FXCollections.observableArrayList();
    private final List<TemplateInstance<Parent>> panelInstances = new ArrayList<TemplateInstance<Parent>>();

    EnumCellHelper() {
    }

    ObservableList<EnumItem> getEnumItems() {
        return this.enumItems;
    }

    Map<String, TemplateInstance<Parent>> createPanelMap() {
        HashMap<String, TemplateInstance<Parent>> hashMap = new HashMap<String, TemplateInstance<Parent>>();
        for (EnumItem enumItem : this.enumItems) {
            TemplateInstance<Parent> templateInstance;
            String string = enumItem.getValue();
            PanelTemplate<Parent> panelTemplate = enumItem.getPanelTemplate();
            if (panelTemplate == null || (templateInstance = panelTemplate.newPanel()) == null) continue;
            templateInstance.getContext().setDataStreamEnabled(true);
            hashMap.put(string, templateInstance);
        }
        this.panelInstances.addAll(hashMap.values());
        return hashMap;
    }

    void startPanelMaps() {
        for (TemplateInstance<Parent> templateInstance : this.panelInstances) {
            templateInstance.getContext().setDataStreamEnabled(true);
        }
    }

    void stopPanelMaps() {
        for (TemplateInstance<Parent> templateInstance : this.panelInstances) {
            templateInstance.getContext().setDataStreamEnabled(false);
        }
    }
}

