/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.facet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.DefaultProperty;
import javafx.beans.binding.MapExpression;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.chart.XYChart;
import oracle.dbtools.raptor.metrics.facet.ChartMonitor;
import oracle.dbtools.raptor.metrics.facet.SeriesColumn;
import oracle.dbtools.raptor.metrics.observable.DXRow;
import oracle.dbtools.raptor.metrics.panel.BoundMapDataObject;
import oracle.dbtools.raptor.metrics.panel.Context;
import oracle.dbtools.raptor.metrics.panel.DataObject;
import oracle.dbtools.raptor.metrics.panel.InstanceListener;

@DefaultProperty(value="item")
public abstract class GraphicalChartMonitor<XA, YA, X extends Comparable<X>, Y extends Comparable<Y>>
extends ChartMonitor {
    private final Map<X, Map<Integer, XListener>> listenersMap = new HashMap<X, Map<Integer, XListener>>();
    private final List<ObservableList<XYChart.Data<XA, YA>>> dataPointsList = new ArrayList<ObservableList<XYChart.Data<XA, YA>>>();
    private final ObjectProperty<BoundMapDataObject> itemProperty = new SimpleObjectProperty((Object)this, "item");
    private final StringProperty xColumnProperty = new SimpleStringProperty();
    private final ObservableList<SeriesColumn> yColumns = FXCollections.observableArrayList();
    private final ObjectProperty<ObservableList<XYChart.Series<XA, YA>>> seriesList = new SimpleObjectProperty((Object)FXCollections.observableArrayList());

    public BoundMapDataObject getItem() {
        return (BoundMapDataObject)this.itemProperty.get();
    }

    public void setItem(BoundMapDataObject boundMapDataObject) {
        this.itemProperty.set((Object)boundMapDataObject);
    }

    public ObjectProperty<BoundMapDataObject> itemProperty() {
        return this.itemProperty;
    }

    public String getXColumn() {
        return (String)this.xColumnProperty.get();
    }

    public void setXColumn(String string) {
        this.xColumnProperty.set((Object)string);
    }

    public StringProperty xColumnProperty() {
        return this.xColumnProperty;
    }

    public ObservableList<SeriesColumn> getYColumns() {
        return this.yColumns;
    }

    @Override
    public List<DataObject<?>> getDataObjects(Context context) {
        return Collections.singletonList(this.getItem());
    }

    protected abstract void initializeAxes(Context var1, XYChart<XA, YA> var2);

    protected abstract X getXValue(ObservableValue<?> var1);

    protected abstract X getXValue(XA var1);

    protected abstract Y getYValue(ObservableValue<?> var1);

    protected abstract void updateBounds(List<ObservableList<XYChart.Data<XA, YA>>> var1);

    protected int findInsertionIndex(X x, DXRow dXRow) {
        XYChart.Data data;
        X x2;
        int n = 0;
        List list = (List)this.dataPointsList.get(0);
        Iterator iterator = list.iterator();
        while (iterator.hasNext() && (x2 = this.getXValue((data = (XYChart.Data)iterator.next()).getXValue())).compareTo(x) < 0) {
            ++n;
        }
        return n;
    }

    protected void onRemoveInsertionIndex(int n) {
    }

    private void onPointAdded(X x, int n, ObservableValue<?> observableValue, DXRow dXRow) {
        Y y = this.getYValue(observableValue);
        XYChart.Data data = new XYChart.Data(x, y);
        this.listenForSequence(x, n, observableValue);
        int n2 = this.findInsertionIndex(x, dXRow);
        List list = (List)this.dataPointsList.get(n);
        if (n2 < list.size() && ((XYChart.Data)list.get(n2)).getXValue().equals(x)) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "duplicate map entry detected for {0}", x);
        } else {
            list.add(n2, data);
        }
    }

    private void onPointRemoved(X x, int n) {
        int n2 = this.findIndex(x);
        if (n2 >= 0) {
            List list = (List)this.dataPointsList.get(n);
            list.remove(n2);
            this.onRemoveInsertionIndex(n2);
            this.unlistenForSequence(x, n);
        }
    }

    private void onValueChanged(X x, int n, ObservableValue<?> observableValue) {
        int n2 = this.findIndex(x);
        if (n2 >= 0) {
            XYChart.Data data = (XYChart.Data)this.dataPointsList.get(n).get(n2);
            Y y = this.getYValue(observableValue);
            data.setYValue(y);
        } else {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "data point with value {0} in series {1} not found", new String[]{x.toString(), Integer.toString(n)});
        }
    }

    private int findIndex(X x) {
        int n = -1;
        int n2 = 0;
        List list = (List)this.dataPointsList.get(0);
        for (XYChart.Data data : list) {
            if (data.getXValue().equals(x)) {
                n = n2;
                break;
            }
            ++n2;
        }
        return n;
    }

    private void listenForSequence(X x, int n, ObservableValue<?> observableValue) {
        XListener xListener = new XListener(this, x, n, observableValue);
        Map<Integer, XListener> map = this.listenersMap.get(x);
        if (map == null) {
            map = new HashMap<Integer, XListener>();
            this.listenersMap.put(x, map);
        }
        map.put(n, xListener);
        xListener.listen();
    }

    private void unlistenForSequence(X x, int n) {
        Map<Integer, XListener> map = this.listenersMap.get(x);
        if (map != null) {
            XListener xListener = map.remove(n);
            if (xListener != null) {
                xListener.unlisten();
            }
            if (map.isEmpty()) {
                this.listenersMap.remove(x);
            }
        }
    }

    private static class XListener
    implements ChangeListener<Object> {
        private final X x;
        private final int series;
        private final ObservableValue<?> yValue;
        final /* synthetic */ GraphicalChartMonitor this$0;

        XListener(X x, int n, ObservableValue<?> observableValue) {
            this.this$0 = var1_1;
            this.x = x;
            this.series = n;
            this.yValue = observableValue;
        }

        void listen() {
            this.yValue.addListener((ChangeListener)this);
        }

        void unlisten() {
            this.yValue.removeListener((ChangeListener)this);
        }

        public void changed(ObservableValue<?> observableValue, Object object, Object object2) {
            this.this$0.onValueChanged(this.x, this.series, this.yValue);
        }
    }

    protected class Listener
    implements InstanceListener {
        protected Listener() {
        }

        @Override
        public void onLoad(Context context) {
            XYChart xYChart = context.getLinkedTarget(XYChart.class, GraphicalChartMonitor.this);
            if (xYChart != null) {
                GraphicalChartMonitor.this.initializeAxes(context, xYChart);
            }
        }

        @Override
        public void onOpen(Context context) {
            XYChart xYChart = context.getLinkedTarget(XYChart.class, GraphicalChartMonitor.this);
            if (xYChart != null) {
                String string = GraphicalChartMonitor.this.getXColumn();
                for (SeriesColumn seriesColumn : GraphicalChartMonitor.this.yColumns) {
                    XYChart.Series series = new XYChart.Series();
                    String string2 = seriesColumn.getSeries();
                    if (string2 != null && !string2.isEmpty()) {
                        series.setName(seriesColumn.getSeries());
                    } else {
                        series.setName(seriesColumn.getName());
                    }
                    ((ObservableList)GraphicalChartMonitor.this.seriesList.get()).add((Object)series);
                    GraphicalChartMonitor.this.dataPointsList.add(series.getData());
                }
                MapExpression mapExpression = GraphicalChartMonitor.this.getItem().valueProperty();
                mapExpression.addListener(change -> {
                    block3: {
                        block2: {
                            if (!change.wasAdded()) break block2;
                            DXRow dXRow = (DXRow)change.getValueAdded();
                            Object x = GraphicalChartMonitor.this.getXValue(dXRow.get(string));
                            for (int i = 0; i < GraphicalChartMonitor.this.yColumns.size(); ++i) {
                                GraphicalChartMonitor.this.onPointAdded(x, i, dXRow.get(((SeriesColumn)GraphicalChartMonitor.this.yColumns.get(i)).getName()), dXRow);
                            }
                            break block3;
                        }
                        if (!change.wasRemoved()) break block3;
                        DXRow dXRow = (DXRow)change.getValueRemoved();
                        Object x = GraphicalChartMonitor.this.getXValue(dXRow.get(string));
                        for (int i = 0; i < GraphicalChartMonitor.this.yColumns.size(); ++i) {
                            GraphicalChartMonitor.this.onPointRemoved(x, i);
                        }
                    }
                });
                GraphicalChartMonitor.this.getItem().updatingProperty().addListener((observableValue, bl, bl2) -> {
                    if (!bl2.booleanValue()) {
                        GraphicalChartMonitor.this.updateBounds(GraphicalChartMonitor.this.dataPointsList);
                    }
                });
                xYChart.dataProperty().bind((ObservableValue)GraphicalChartMonitor.this.seriesList);
            }
        }

        @Override
        public void onClose(Context context) {
            XYChart xYChart = context.getLinkedTarget(XYChart.class, GraphicalChartMonitor.this);
            if (xYChart != null) {
                xYChart.dataProperty().unbind();
            }
        }
    }
}

