/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.facet;

import java.util.Collections;
import java.util.List;
import javafx.beans.DefaultProperty;
import javafx.beans.InvalidationListener;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.Labeled;
import oracle.dbtools.raptor.metrics.facet.Monitor;
import oracle.dbtools.raptor.metrics.panel.Context;
import oracle.dbtools.raptor.metrics.panel.DataObject;
import oracle.dbtools.raptor.metrics.panel.InstanceListener;
import oracle.dbtools.raptor.metrics.panel.StringDataObject;

@DefaultProperty(value="item")
public class TextMonitor
implements Monitor {
    private InvalidationListener listener;
    private final ObjectProperty<StringDataObject> itemProperty = new SimpleObjectProperty((Object)this, "item");

    public TextMonitor() {
        this.init(new Listener());
    }

    @Override
    public Class<?> getBindToClass() {
        return Labeled.class;
    }

    public StringDataObject getItem() {
        return (StringDataObject)this.itemProperty.get();
    }

    public void setItem(StringDataObject stringDataObject) {
        this.itemProperty.set((Object)stringDataObject);
    }

    public ObjectProperty<StringDataObject> itemProperty() {
        return this.itemProperty;
    }

    @Override
    public List<DataObject<?>> getDataObjects(Context context) {
        return Collections.singletonList(this.getItem());
    }

    protected class Listener
    implements InstanceListener {
        protected Listener() {
        }

        @Override
        public void onOpen(Context context) {
            Labeled labeled = context.getLinkedTarget(Labeled.class, TextMonitor.this);
            if (labeled != null) {
                StringProperty stringProperty = labeled.textProperty();
                BooleanExpression booleanExpression = TextMonitor.this.getItem().availableProperty();
                if (booleanExpression.get()) {
                    stringProperty.bind((ObservableValue)TextMonitor.this.getItem().valueProperty());
                } else {
                    if (stringProperty.get() == null || ((String)stringProperty.get()).isEmpty()) {
                        stringProperty.set((Object)"***");
                    }
                    TextMonitor.this.listener = observable -> stringProperty.bind((ObservableValue)TextMonitor.this.getItem().valueProperty());
                    booleanExpression.addListener(TextMonitor.this.listener);
                }
            }
        }

        @Override
        public void onClose(Context context) {
            Labeled labeled = context.getLinkedTarget(Labeled.class, TextMonitor.this);
            if (labeled != null) {
                StringProperty stringProperty;
                BooleanExpression booleanExpression = TextMonitor.this.getItem().availableProperty();
                if (TextMonitor.this.listener != null) {
                    booleanExpression.removeListener(TextMonitor.this.listener);
                }
                if ((stringProperty = labeled.textProperty()).isBound()) {
                    stringProperty.unbind();
                }
            }
        }
    }
}

