/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.panel;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import oracle.dbtools.raptor.metrics.engine.DXListenerList;
import oracle.dbtools.raptor.metrics.engine.DXService;
import oracle.dbtools.raptor.metrics.panel.AbstractNamespaceObject;
import oracle.dbtools.raptor.metrics.panel.AbstractTemplate;
import oracle.dbtools.raptor.metrics.panel.AttributesService;
import oracle.dbtools.raptor.metrics.panel.BoundDataObject;
import oracle.dbtools.raptor.metrics.panel.Context;
import oracle.dbtools.raptor.metrics.panel.DataObject;
import oracle.dbtools.raptor.metrics.panel.GlobalsService;
import oracle.dbtools.raptor.metrics.panel.InstanceController;
import oracle.dbtools.raptor.metrics.panel.InstanceInitFeatures;
import oracle.dbtools.raptor.metrics.panel.InstanceListener;
import oracle.dbtools.raptor.metrics.panel.InstanceService;
import oracle.dbtools.raptor.metrics.panel.LocalsService;
import oracle.dbtools.raptor.metrics.panel.PageTemplateFactory;
import oracle.dbtools.raptor.metrics.panel.PanelTemplate;
import oracle.dbtools.raptor.metrics.panel.ParametersService;
import oracle.dbtools.raptor.metrics.panel.Service;
import oracle.dbtools.raptor.metrics.panel.ServiceFactory;
import oracle.dbtools.raptor.metrics.panel.ServiceListener;
import oracle.dbtools.raptor.metrics.panel.TemplateInstance;
import oracle.dbtools.raptor.metrics.panel.TemplateObject;
import oracle.dbtools.raptor.metrics.panel.TemplateObjectVisitor;
import oracle.dbtools.raptor.metrics.sysjob.StandardMetricsResources;

public abstract class PageTemplateFactory<P extends Parent> {
    private final List<ServiceFactory<?>> serviceFactories = new ArrayList();
    private final List<TemplateObjectVisitor<?>> templateObjectVisitors = new ArrayList();
    private final List<String> stylesheets = new ArrayList<String>();
    private final List<String> metricsModels = new ArrayList<String>();
    private final String templateFxml;
    private final List<String> templateStylesheets = new ArrayList<String>();
    private String templateBundle;

    protected PageTemplateFactory(String string) {
        this(string, false);
    }

    protected PageTemplateFactory(String string, boolean bl) {
        this.serviceFactories.add(this.createAttributesServiceFactory());
        this.serviceFactories.add(this.createParametersServiceFactory());
        this.serviceFactories.add(this.createGlobalsServiceFactory());
        this.serviceFactories.add(this.createLocalsServiceFactory());
        if (!bl) {
            this.metricsModels.addAll(StandardMetricsResources.get());
        }
        this.templateFxml = string;
    }

    protected void addServiceFactories(ServiceFactory<?> ... serviceFactoryArray) {
        this.serviceFactories.addAll(Arrays.asList(serviceFactoryArray));
    }

    protected void addServiceFactories(Collection<ServiceFactory<?>> collection) {
        this.serviceFactories.addAll(collection);
    }

    protected void addVisitors(TemplateObjectVisitor<?> ... templateObjectVisitorArray) {
        this.templateObjectVisitors.addAll(Arrays.asList(templateObjectVisitorArray));
    }

    protected void addVisitors(Collection<TemplateObjectVisitor<?>> collection) {
        this.templateObjectVisitors.addAll(collection);
    }

    protected void addStylesheets(String ... stringArray) {
        this.stylesheets.addAll(Arrays.asList(stringArray));
    }

    protected void addStylesheets(Collection<String> collection) {
        this.stylesheets.addAll(collection);
    }

    protected void addMetricsModels(String ... stringArray) {
        this.metricsModels.addAll(Arrays.asList(stringArray));
    }

    protected void addMetricsModels(Collection<String> collection) {
        this.metricsModels.addAll(collection);
    }

    protected void setTemplateBundle(String string) {
        this.templateBundle = string;
    }

    protected void addTemplateStylesheets(String ... stringArray) {
        this.templateStylesheets.addAll(Arrays.asList(stringArray));
    }

    protected void addTemplateStylesheets(Collection<String> collection) {
        this.templateStylesheets.addAll(collection);
    }

    public PanelTemplate<P> newPageTemplate() {
        return this.newPageTemplate(Collections.emptyMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PanelTemplate<P> newPageTemplate(Map<String, Object> map) {
        PanelTemplate panelTemplate;
        ContextObject contextObject = new ContextObject();
        contextObject.init(this.getClass().getClassLoader(), map);
        InstanceInitFeatures.setCurrent(contextObject.createInstanceInitFeatures());
        try {
            panelTemplate = new PanelTemplate();
        }
        finally {
            InstanceInitFeatures.setCurrent(null);
        }
        panelTemplate.setFxml(this.templateFxml);
        if (this.templateBundle != null) {
            panelTemplate.setBundle(this.templateBundle);
        }
        if (!this.templateStylesheets.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            for (String string : this.templateStylesheets) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(string);
            }
            panelTemplate.setStylesheet(stringBuilder.toString());
        }
        for (Object object : contextObject.instanceListeners) {
            object.onLoad(contextObject);
        }
        return panelTemplate;
    }

    private ServiceFactory<AttributesService> createAttributesServiceFactory() {
        return () -> new AttributesServiceObject();
    }

    private ServiceFactory<ParametersService> createParametersServiceFactory() {
        return () -> new ParametersServiceObject();
    }

    private ServiceFactory<GlobalsService> createGlobalsServiceFactory() {
        return () -> new GlobalsServiceObject();
    }

    private ServiceFactory<LocalsService> createLocalsServiceFactory() {
        return () -> new LocalsServiceObject();
    }

    private <T> Collection<T> getObjectsOfType(Class<T> clazz, Collection<?> collection) {
        return collection.stream().filter(object -> clazz.isAssignableFrom(object.getClass())).collect(Collectors.toList());
    }

    private BooleanExpression getPanelConnectedProperty(Context context) {
        SimpleBooleanProperty simpleBooleanProperty = new SimpleBooleanProperty(true);
        List<DataObject<?>> list = this.getDataObjects(context);
        for (DataObject<?> dataObject : list) {
            simpleBooleanProperty = Bindings.and((ObservableBooleanValue)simpleBooleanProperty, (ObservableBooleanValue)dataObject.connectedProperty());
        }
        return simpleBooleanProperty;
    }

    private BooleanExpression getPanelAvailableProperty(Context context) {
        SimpleBooleanProperty simpleBooleanProperty = new SimpleBooleanProperty(true);
        List<DataObject<?>> list = this.getDataObjects(context);
        for (DataObject<?> dataObject : list) {
            simpleBooleanProperty = Bindings.and((ObservableBooleanValue)simpleBooleanProperty, (ObservableBooleanValue)dataObject.availableProperty());
        }
        return simpleBooleanProperty;
    }

    private List<DataObject<?>> getDataObjects(Context context) {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(context.getTemplateObjects(BoundDataObject.class));
        arrayList.addAll(context.getParameters().getObjects(DataObject.class));
        arrayList.addAll(context.getAttributes().getObjects(DataObject.class));
        arrayList.addAll(context.getGlobals().getObjects(DataObject.class));
        return arrayList;
    }

    private class Loader<T> {
        private T rootObject;
        private Map<String, Object> namespace;
        private Object controller;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Loader(ContextObject contextObject, String string, String string2) {
            URL uRL = contextObject.getResourceURL(string);
            if (uRL != null) {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                ClassLoader classLoader2 = contextObject.getClassLoader();
                Thread.currentThread().setContextClassLoader(classLoader2);
                try {
                    FXMLLoader fXMLLoader = new FXMLLoader(uRL);
                    fXMLLoader.setClassLoader(classLoader2);
                    if (string2 != null) {
                        try {
                            ResourceBundle resourceBundle = ResourceBundle.getBundle(string2.substring(1), Locale.getDefault(), classLoader2);
                            fXMLLoader.setResources(resourceBundle);
                        }
                        catch (MissingResourceException missingResourceException) {
                            Logger.getLogger(PageTemplateFactory.class.getName()).log(Level.SEVERE, "resource bundle not found: {0} \n {1}", new Object[]{string2, missingResourceException});
                        }
                    }
                    try {
                        this.rootObject = fXMLLoader.load();
                        this.controller = fXMLLoader.getController();
                        this.namespace = fXMLLoader.getNamespace().entrySet().stream().filter(entry -> {
                            String string = (String)entry.getKey();
                            return !string.equals("resources") && !string.equals("location");
                        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                    }
                    catch (IOException | RuntimeException exception) {
                        Logger.getLogger(PageTemplateFactory.class.getName()).log(Level.SEVERE, "fxml load error: " + string, exception);
                    }
                }
                finally {
                    Thread.currentThread().setContextClassLoader(classLoader);
                }
            } else {
                Logger.getLogger(PageTemplateFactory.class.getName()).log(Level.SEVERE, "fxml url not found: {0}", string);
            }
        }

        boolean isLoaded() {
            return this.rootObject != null;
        }

        T getRootObject() {
            return this.rootObject;
        }

        Map<String, Object> getNamespace() {
            return this.namespace;
        }

        Object getController() {
            return this.controller;
        }
    }

    private class LocalsServiceObject
    implements Service<LocalsService>,
    ServiceListener {
        private final oracle.dbtools.raptor.metrics.panel.PageTemplateFactory$LocalsServiceObject.ServiceObject serviceObject = new ServiceObject();

        private LocalsServiceObject() {
        }

        @Override
        public void onLoad(Context context, Map<String, Object> map) {
            ((ServiceObject)this.serviceObject).initialize(map);
        }

        @Override
        public Class<LocalsService> getType() {
            return LocalsService.class;
        }

        @Override
        public LocalsService getServiceObject() {
            return this.serviceObject;
        }

        @Override
        public ServiceListener getListener() {
            return this;
        }

        private class ServiceObject
        extends NamespaceServicesObject
        implements LocalsService {
            private ServiceObject() {
            }

            private void initialize(Map<String, Object> map) {
                this.namedObjectMap.putAll(map);
            }
        }
    }

    private class GlobalsServiceObject
    implements Service<GlobalsService>,
    ServiceListener {
        private final oracle.dbtools.raptor.metrics.panel.PageTemplateFactory$GlobalsServiceObject.ServiceObject serviceObject = new ServiceObject();

        private GlobalsServiceObject() {
        }

        @Override
        public void init(Context context, Map<String, Object> map) {
            ((ServiceObject)this.serviceObject).initialize((ContextObject)context);
        }

        @Override
        public Class<GlobalsService> getType() {
            return GlobalsService.class;
        }

        @Override
        public GlobalsService getServiceObject() {
            return this.serviceObject;
        }

        @Override
        public ServiceListener getListener() {
            return this;
        }

        private class ServiceObject
        extends NamespaceServicesObject
        implements GlobalsService {
            private ServiceObject() {
            }

            private void initialize(ContextObject contextObject) {
                Object object;
                Object object2;
                Object object3;
                AbstractTemplate abstractTemplate = contextObject.getTemplate();
                if (!abstractTemplate.isDisableInheritGlobals() && (object3 = contextObject.getParentContext()) != null && (object2 = (ServiceObject)object3.get(GlobalsService.class)) != null) {
                    this.namedObjectMap.putAll(((ServiceObject)object2).namedObjectMap);
                }
                object3 = contextObject.getAbsoluteResourcePath(abstractTemplate.getFxml());
                object2 = contextObject.getResourceFolderPath((String)object3);
                String string = contextObject.getResourceName((String)object3);
                String string2 = (String)object2 + string + ".globals.fxml";
                if (contextObject.getResourceURL(string2) != null && ((Loader)(object = new Loader(contextObject, string2, abstractTemplate.getBundle()))).isLoaded()) {
                    this.namedObjectMap.putAll(((Loader)object).getNamespace());
                }
                if ((object = abstractTemplate.getGlobals()) != null) {
                    String[] stringArray;
                    for (String string3 : stringArray = ((String)object).trim().split("\\s*,\\s*")) {
                        String string4 = contextObject.getAbsoluteResourcePath(string3);
                        Loader loader = new Loader(contextObject, string4, abstractTemplate.getBundle());
                        if (loader.isLoaded()) {
                            this.namedObjectMap.putAll(loader.getNamespace());
                            continue;
                        }
                        Logger.getLogger(PageTemplateFactory.class.getName()).log(Level.SEVERE, "resource not found: {0}", string4);
                    }
                }
            }
        }
    }

    private class ParametersServiceObject
    implements Service<ParametersService>,
    ServiceListener {
        private final oracle.dbtools.raptor.metrics.panel.PageTemplateFactory$ParametersServiceObject.ServiceObject serviceObject = new ServiceObject();

        private ParametersServiceObject() {
        }

        @Override
        public void init(Context context, Map<String, Object> map) {
            ((ServiceObject)this.serviceObject).initialize(context);
        }

        @Override
        public Class<ParametersService> getType() {
            return ParametersService.class;
        }

        @Override
        public ParametersService getServiceObject() {
            return this.serviceObject;
        }

        @Override
        public ServiceListener getListener() {
            return this;
        }

        private class ServiceObject
        extends NamespaceServicesObject
        implements ParametersService {
            private ServiceObject() {
            }

            private void initialize(Context context) {
                this.namedObjectMap.putAll(context.getTemplate().getParameters());
            }
        }
    }

    private class AttributesServiceObject
    implements Service<AttributesService>,
    ServiceListener {
        private final oracle.dbtools.raptor.metrics.panel.PageTemplateFactory$AttributesServiceObject.ServiceObject serviceObject = new ServiceObject();

        private AttributesServiceObject() {
        }

        @Override
        public void init(Context context, Map<String, Object> map) {
            ((ServiceObject)this.serviceObject).initialize(context, map);
        }

        @Override
        public Class<AttributesService> getType() {
            return AttributesService.class;
        }

        @Override
        public AttributesService getServiceObject() {
            return this.serviceObject;
        }

        @Override
        public ServiceListener getListener() {
            return this;
        }

        private class ServiceObject
        extends NamespaceServicesObject
        implements AttributesService {
            private ServiceObject() {
            }

            private void initialize(Context context, Map<String, Object> map) {
                this.namedObjectMap.putAll(context.getInheritedAttributes());
                this.namedObjectMap.putAll(map);
            }
        }
    }

    private abstract class NamespaceServicesObject
    extends AbstractNamespaceObject {
        final Map<String, Object> namedObjectMap = new HashMap<String, Object>();

        private NamespaceServicesObject() {
        }

        @Override
        protected Map<String, Object> getNamedObjectMap() {
            return this.namedObjectMap;
        }
    }

    private class TemplateInstanceObject<T>
    implements TemplateInstance<T> {
        private final ContextObject contextObject;
        private BooleanExpression connectedProperty;
        private BooleanExpression availableProperty;
        private T rootObject;

        TemplateInstanceObject(ContextObject contextObject) {
            this.contextObject = contextObject;
        }

        void setRootObject(T t) {
            this.rootObject = t;
        }

        @Override
        public ContextObject getContext() {
            return this.contextObject;
        }

        @Override
        public T getRootObject() {
            return this.rootObject;
        }

        @Override
        public boolean isConnected() {
            return this.getConnectedProperty().getValue();
        }

        @Override
        public BooleanExpression connectedProperty() {
            return this.getConnectedProperty();
        }

        @Override
        public boolean isAvailable() {
            return this.getAvailableProperty().getValue();
        }

        @Override
        public BooleanExpression availableProperty() {
            return this.getAvailableProperty();
        }

        private BooleanExpression getConnectedProperty() {
            if (this.connectedProperty == null) {
                this.connectedProperty = PageTemplateFactory.this.getPanelConnectedProperty(this.contextObject);
            }
            return this.connectedProperty;
        }

        private BooleanExpression getAvailableProperty() {
            if (this.availableProperty == null) {
                this.availableProperty = PageTemplateFactory.this.getPanelAvailableProperty(this.contextObject);
            }
            return this.availableProperty;
        }
    }

    private class ContextObject
    implements Context {
        private final Set<ContextObject> openChildContexts = new HashSet<ContextObject>();
        private final Set<TemplateObject> templateObjects = new HashSet<TemplateObject>();
        private final List<ServiceListener> serviceListeners = new ArrayList<ServiceListener>();
        private final List<InstanceListener> instanceListeners = new ArrayList<InstanceListener>();
        private final Map<Object, Set<Object>> sourceRefsMap = new HashMap<Object, Set<Object>>();
        private final Map<Object, Set<Object>> targetRefsMap = new HashMap<Object, Set<Object>>();
        private final Map<Class<?>, Object> servicesMap = new HashMap();
        private String name;
        private ContextObject parentContext;
        private String homePath;
        private ClassLoader classLoader;
        private String bundle;
        private Map<String, Object> inheritedAttributes;
        private AbstractTemplate<?> template;
        private TemplateInstanceObject<?> instance;
        private Object controller;
        private boolean dataStreamEnabled;
        private boolean open;
        private boolean running;

        private ContextObject() {
        }

        void init(ClassLoader classLoader, Map<String, Object> map) {
            this.classLoader = classLoader;
            this.inheritedAttributes = map;
            this.name = null;
            this.parentContext = null;
            this.template = null;
            this.homePath = "";
            this.bundle = null;
            this.servicesMap.put(InstanceService.class, this);
            this.instance = new TemplateInstanceObject(this);
            this.dataStreamEnabled = true;
            this.open = true;
            this.running = true;
        }

        void init(ContextObject contextObject, AbstractTemplate<?> abstractTemplate) {
            if (contextObject.template != null) {
                this.parentContext = contextObject;
            }
            this.template = abstractTemplate;
            String string = contextObject.getAbsoluteResourcePath(abstractTemplate.getFxml());
            int n = string.lastIndexOf(47);
            this.homePath = n < 0 ? "" : string.substring(0, n + 1);
            this.classLoader = contextObject.getClassLoader();
            this.inheritedAttributes = contextObject.getInheritedAttributes();
            this.bundle = this.findBundle(contextObject, abstractTemplate);
            this.name = this.getResourceName(this.getAbsoluteResourcePath(abstractTemplate.getFxml()));
            this.dataStreamEnabled = true;
            this.open = false;
            this.running = false;
            this.instance = new TemplateInstanceObject(this);
            this.servicesMap.put(InstanceService.class, this);
            this.serviceListeners.add(new ServiceListener(){

                @Override
                public void onClosing(Context context) {
                    ContextObject.this.open = false;
                }

                @Override
                public void onOpened(Context context) {
                    ContextObject.this.open = true;
                }
            });
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Context getParentContext() {
            return this.parentContext;
        }

        @Override
        public Collection<? extends Context> getOpenChildContexts() {
            return this.openChildContexts;
        }

        @Override
        public Collection<Class<?>> getServiceTypes() {
            return this.servicesMap.keySet();
        }

        @Override
        public <T> T get(Class<T> clazz) {
            return (T)this.servicesMap.get(clazz);
        }

        @Override
        public <T> AbstractTemplate<T> getTemplate() {
            return this.template;
        }

        @Override
        public String getAbsoluteResourcePath(String string) {
            if (string != null) {
                if ((string = string.trim()).startsWith("/")) {
                    return string;
                }
                return this.homePath + string;
            }
            return this.homePath;
        }

        @Override
        public String getResourceFolderPath(String string) {
            int n = string.lastIndexOf(47);
            return string.substring(0, n + 1);
        }

        @Override
        public String getResourceName(String string) {
            int n = string.lastIndexOf(47);
            int n2 = string.lastIndexOf(46);
            return string.substring(n + 1, n2);
        }

        @Override
        public URL getResourceURL(String string) {
            return this.classLoader.getResource(string.substring(1));
        }

        @Override
        public ClassLoader getClassLoader() {
            return this.classLoader;
        }

        @Override
        public Map<String, Object> getInheritedAttributes() {
            return this.inheritedAttributes;
        }

        @Override
        public List<String> getPageStylesheets() {
            return this.resolvePageResourcePaths(PageTemplateFactory.this.stylesheets);
        }

        @Override
        public List<String> getMetricsModels() {
            return this.resolvePageResourcePaths(PageTemplateFactory.this.metricsModels);
        }

        @Override
        public String getFxml() {
            return this.getAbsoluteResourcePath(this.template.getFxml());
        }

        @Override
        public String getBundle() {
            return this.bundle;
        }

        @Override
        public <T> InstanceController<T> newChildInstance(AbstractTemplate<T> abstractTemplate, Map<String, Object> map) {
            ContextObject contextObject = new ContextObject();
            contextObject.init(this, abstractTemplate);
            return contextObject.createInstanceController(map);
        }

        public <T> TemplateInstanceObject<T> getTemplateInstance() {
            return this.instance;
        }

        @Override
        public <T extends TemplateObject> Collection<T> getTemplateObjects(Class<T> clazz) {
            return PageTemplateFactory.this.getObjectsOfType(clazz, this.templateObjects);
        }

        @Override
        public <T> T getRootObject() {
            Object obj = this.instance.getRootObject();
            return (T)obj;
        }

        @Override
        public <T> T getRootObject(Class<T> clazz) {
            Object obj = this.instance.getRootObject();
            if (obj != null && clazz.isAssignableFrom(obj.getClass())) {
                return (T)obj;
            }
            return null;
        }

        @Override
        public <T> T getController() {
            return (T)this.controller;
        }

        @Override
        public <T> T getController(Class<T> clazz) {
            if (this.controller != null && clazz.isAssignableFrom(this.controller.getClass())) {
                return (T)this.controller;
            }
            return null;
        }

        @Override
        public <T> T getLinkedTarget(Class<T> clazz, Object object) {
            Iterator<T> iterator;
            Collection<T> collection = this.getLinkedTargets(clazz, object);
            if (collection.size() > 1) {
                Logger.getLogger(PageTemplateFactory.class.getName()).log(Level.WARNING, "found multiple linked objects with type ''{0}'' when at most one expected", clazz.getName());
            }
            if ((iterator = collection.iterator()).hasNext()) {
                T t = iterator.next();
                return t;
            }
            return null;
        }

        @Override
        public <T> Collection<T> getLinkedTargets(Class<T> clazz, Object object) {
            Set<Object> set = this.sourceRefsMap.get(object);
            if (set == null) {
                return Collections.emptySet();
            }
            return PageTemplateFactory.this.getObjectsOfType(clazz, set);
        }

        @Override
        public <S> S getLinkedSource(Class<S> clazz, Object object) {
            Iterator<S> iterator;
            Collection<S> collection = this.getLinkedSources(clazz, object);
            if (collection.size() > 1) {
                Logger.getLogger(PageTemplateFactory.class.getName()).log(Level.WARNING, "found multiple linked objects with type ''{0}'' when at most one expected", clazz.getName());
            }
            if ((iterator = collection.iterator()).hasNext()) {
                S s = iterator.next();
                return s;
            }
            return null;
        }

        @Override
        public <S> Collection<S> getLinkedSources(Class<S> clazz, Object object) {
            Set<Object> set = this.targetRefsMap.get(object);
            if (set == null) {
                return Collections.emptySet();
            }
            return PageTemplateFactory.this.getObjectsOfType(clazz, set);
        }

        @Override
        public void setDataStreamEnabled(boolean bl) {
            this.dataStreamEnabled = bl;
            this.evaluateDataStreaming(this.isParentRunning());
        }

        @Override
        public boolean isPage() {
            return this.parentContext == null;
        }

        @Override
        public boolean isDataStreamEnabled() {
            return this.dataStreamEnabled;
        }

        @Override
        public boolean isRunning() {
            return this.running;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private <T> InstanceController<T> createInstanceController(Map<String, Object> map) {
            Loader loader;
            InstanceController instanceController = null;
            for (ServiceFactory iterator : PageTemplateFactory.this.serviceFactories) {
                Service service = iterator.createService();
                this.servicesMap.put(service.getType(), service.getServiceObject());
                this.serviceListeners.add(service.getListener());
            }
            InstanceInitFeatures.setCurrent(this.createInstanceInitFeatures());
            for (ServiceListener serviceListener : this.serviceListeners) {
                serviceListener.init(this, map);
            }
            try {
                loader = new Loader(this, this.getFxml(), this.getBundle());
            }
            finally {
                InstanceInitFeatures.setCurrent(null);
            }
            if (loader.isLoaded()) {
                ((TemplateInstanceObject)this.getTemplateInstance()).setRootObject(loader.getRootObject());
                this.controller = loader.getController();
                for (ServiceListener serviceListener : this.serviceListeners) {
                    serviceListener.onLoad(this, loader.getNamespace());
                }
                for (InstanceListener instanceListener : this.instanceListeners) {
                    instanceListener.onLoad(this);
                }
                for (ServiceListener serviceListener : this.serviceListeners) {
                    serviceListener.onInitComplete(this);
                }
                if (!PageTemplateFactory.this.templateObjectVisitors.isEmpty()) {
                    for (TemplateObject templateObject : this.templateObjects) {
                        for (TemplateObjectVisitor templateObjectVisitor : PageTemplateFactory.this.templateObjectVisitors) {
                            templateObjectVisitor.visit(this, templateObject);
                        }
                    }
                }
                instanceController = new InstanceController<T>(){

                    @Override
                    public TemplateInstance<T> getInstance() {
                        return ContextObject.this.getTemplateInstance();
                    }

                    @Override
                    public void openInstance() {
                        ContextObject.this.open();
                    }

                    @Override
                    public void closeInstance() {
                        ContextObject.this.close();
                    }
                };
            }
            return instanceController;
        }

        private List<String> resolvePageResourcePaths(List<String> list) {
            ArrayList<String> arrayList = new ArrayList<String>();
            Context context = this;
            while (context != null) {
                Context context2 = context.getParentContext();
                if (context2 == null) {
                    for (String string : list) {
                        arrayList.add(context.getAbsoluteResourcePath(string));
                    }
                }
                context = context2;
            }
            return arrayList;
        }

        private String findBundle(InstanceService instanceService, AbstractTemplate<?> abstractTemplate) {
            String string = abstractTemplate.getBundle();
            if (string != null) {
                string = this.getAbsoluteResourcePath(string);
            } else {
                string = this.getAbsoluteResourcePath(this.getResourceName(abstractTemplate.getFxml()));
                URL uRL = this.getResourceURL(string + ".properties");
                if (uRL == null) {
                    string = instanceService.getBundle();
                }
            }
            return string;
        }

        private InstanceInitFeatures.FeaturesObject createInstanceInitFeatures() {
            return new InstanceInitFeatures.FeaturesObject(){

                @Override
                void addTemplateObject(TemplateObject templateObject) {
                    if (!ContextObject.this.templateObjects.add(templateObject)) {
                        throw new IllegalStateException("template object of type '" + templateObject.getClass().getName() + "' already registered");
                    }
                }

                @Override
                void addTemplateObject(TemplateObject templateObject, InstanceListener instanceListener) {
                    this.addTemplateObject(templateObject);
                    ContextObject.this.instanceListeners.add(instanceListener);
                }

                @Override
                void addLink(Object object, Object object2) {
                    ContextObject.this.addRef(ContextObject.this.sourceRefsMap, object, object2);
                    ContextObject.this.addRef(ContextObject.this.targetRefsMap, object2, object);
                }

                @Override
                ParametersService getParameters() {
                    return ContextObject.this.getParameters();
                }

                @Override
                AttributesService getAttributes() {
                    return ContextObject.this.getAttributes();
                }

                @Override
                GlobalsService getGlobals() {
                    return ContextObject.this.getGlobals();
                }
            };
        }

        private void addRef(Map<Object, Set<Object>> map, Object object, Object object2) {
            Set<Object> set = map.get(object);
            if (set == null) {
                set = new HashSet<Object>();
                map.put(object, set);
            }
            set.add(object2);
        }

        private void open() {
            for (ServiceListener object : this.serviceListeners) {
                object.onOpening(this);
            }
            for (InstanceListener instanceListener : this.instanceListeners) {
                instanceListener.onOpen(this);
            }
            if (this.parentContext != null) {
                this.parentContext.openChildContexts.add(this);
            }
            for (ServiceListener serviceListener : this.serviceListeners) {
                serviceListener.onOpened(this);
            }
            this.evaluateDataStreaming(this.isParentRunning());
        }

        private void start() {
            for (ServiceListener iterator : this.serviceListeners) {
                iterator.onStarting(this);
            }
            DXListenerList dXListenerList = new DXListenerList();
            for (InstanceListener instanceListener : this.instanceListeners) {
                instanceListener.onStart(this, dXListenerList);
            }
            DXService.registerListeners(dXListenerList);
            for (ServiceListener serviceListener : this.serviceListeners) {
                serviceListener.onStarted(this);
            }
            for (ContextObject contextObject : this.openChildContexts) {
                contextObject.evaluateDataStreaming(true);
            }
        }

        private void stop() {
            for (ContextObject iterator : this.openChildContexts) {
                iterator.evaluateDataStreaming(false);
            }
            for (ServiceListener serviceListener : this.serviceListeners) {
                serviceListener.onStopping(this);
            }
            DXListenerList dXListenerList = new DXListenerList();
            for (InstanceListener instanceListener : this.instanceListeners) {
                instanceListener.onStop(this, dXListenerList);
            }
            DXService.unregisterListeners(dXListenerList);
            for (ServiceListener serviceListener : this.serviceListeners) {
                serviceListener.onStopped(this);
            }
        }

        private void close() {
            for (ServiceListener object : this.serviceListeners) {
                object.onClosing(this);
            }
            this.evaluateDataStreaming(this.isParentRunning());
            for (InstanceListener instanceListener : this.instanceListeners) {
                instanceListener.onClose(this);
            }
            for (ServiceListener serviceListener : this.serviceListeners) {
                serviceListener.onClosed(this);
            }
            if (this.parentContext != null) {
                this.parentContext.openChildContexts.remove(this);
            }
        }

        private void evaluateDataStreaming(boolean bl) {
            if (!this.running) {
                if (this.dataStreamEnabled && this.open && bl) {
                    this.start();
                    this.running = true;
                }
            } else if (!(this.dataStreamEnabled && this.open && bl)) {
                this.stop();
                this.running = false;
            }
        }

        private boolean isParentRunning() {
            return this.parentContext != null ? this.parentContext.isRunning() : true;
        }
    }
}

