/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.panel;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.Parent;
import javafx.scene.Scene;
import oracle.dbtools.raptor.metrics.engine.DXService;
import oracle.dbtools.raptor.metrics.panel.AbstractTemplate;
import oracle.dbtools.raptor.metrics.panel.Context;
import oracle.dbtools.raptor.metrics.panel.Facet;
import oracle.dbtools.raptor.metrics.panel.InstanceController;
import oracle.dbtools.raptor.metrics.panel.InstanceService;
import oracle.dbtools.raptor.metrics.panel.TemplateInstance;

public class PanelTemplate<P extends Parent>
extends AbstractTemplate<P> {
    private final StringProperty stylesheetProperty = new SimpleStringProperty((Object)this, "stylesheet");

    public PanelTemplate() {
        this.init(new Listener());
    }

    public String getStylesheet() {
        return (String)this.stylesheetProperty.get();
    }

    public void setStylesheet(String string) {
        this.stylesheetProperty.set((Object)string);
    }

    public StringProperty stylesheetProperty() {
        return this.stylesheetProperty;
    }

    public TemplateInstance<P> newPanel() {
        return this.newPanel(Collections.emptyMap());
    }

    public TemplateInstance<P> newPanel(Map<String, Object> map) {
        return this.initializePanel(this.newInstance(map));
    }

    private TemplateInstance<P> initializePanel(InstanceController<P> instanceController) {
        TemplateInstance<P> templateInstance = null;
        if (instanceController != null) {
            templateInstance = instanceController.getInstance();
            this.checkFacetObjects(templateInstance.getContext());
            Parent parent = (Parent)templateInstance.getRootObject();
            parent.sceneProperty().addListener((observableValue, scene, scene2) -> {
                if (scene == null && scene2 != null) {
                    this.mergeMetricsModels(instanceController);
                    this.attachStylesheets((Scene)scene2, instanceController);
                    instanceController.openInstance();
                } else if (scene != null && scene2 == null) {
                    instanceController.closeInstance();
                    this.detachStylesheets((Scene)scene, instanceController);
                    this.releaseMetricsModels(instanceController);
                }
            });
        }
        return templateInstance;
    }

    private void mergeMetricsModels(InstanceController<P> instanceController) {
        TemplateInstance<P> templateInstance = instanceController.getInstance();
        Context context = templateInstance.getContext();
        if (context.isPage()) {
            ClassLoader classLoader = context.getClassLoader();
            for (String string : this.findMetricsModels(context)) {
                DXService.useMergeSet(classLoader, string, null);
            }
        }
    }

    private void releaseMetricsModels(InstanceController<P> instanceController) {
        TemplateInstance<P> templateInstance = instanceController.getInstance();
        Context context = templateInstance.getContext();
        if (context.isPage()) {
            ClassLoader classLoader = context.getClassLoader();
            for (String string : this.findMetricsModels(context)) {
                DXService.releaseMergeSet(classLoader, string, null);
            }
        }
    }

    private void attachStylesheets(Scene scene, InstanceController<P> instanceController) {
        TemplateInstance<P> templateInstance = instanceController.getInstance();
        Context context = templateInstance.getContext();
        if (context.isPage()) {
            scene.getStylesheets().addAll(this.findSceneStylesheets(context));
        }
        ((Parent)templateInstance.getRootObject()).getStylesheets().addAll(this.findRootObjectStylesheets(context));
    }

    private List<String> findMetricsModels(InstanceService instanceService) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String object2 : instanceService.getMetricsModels()) {
            URL uRL = this.getResourceURL(instanceService, object2);
            if (uRL != null) {
                arrayList.add(object2);
                continue;
            }
            Logger.getLogger(PanelTemplate.class.getName()).log(Level.WARNING, "metrics model ''{0}'' not found", object2);
        }
        String string = this.getDefaultResourceBase(instanceService) + ".metrics.fxml";
        URL uRL = this.getResourceURL(instanceService, string);
        if (uRL != null) {
            arrayList.add(string);
        }
        return arrayList;
    }

    private List<String> findSceneStylesheets(InstanceService instanceService) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String object2 : instanceService.getPageStylesheets()) {
            URL uRL = this.getResourceURL(instanceService, object2);
            if (uRL != null) {
                arrayList.add(uRL.toExternalForm());
                continue;
            }
            Logger.getLogger(PanelTemplate.class.getName()).log(Level.WARNING, "stylesheet ''{0}'' not found", object2);
        }
        String string = this.getDefaultResourceBase(instanceService) + ".css";
        URL uRL = this.getResourceURL(instanceService, string);
        if (uRL != null) {
            arrayList.add(uRL.toExternalForm());
        }
        return arrayList;
    }

    private List<String> findRootObjectStylesheets(InstanceService instanceService) {
        URL uRL;
        Object object;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = this.getStylesheet();
        if (string != null) {
            object = string.trim().split("\\s*,\\s*");
            int n = ((String[])object).length;
            for (int i = 0; i < n; ++i) {
                String string2 = object[i];
                URL uRL2 = this.getResourceURL(instanceService, string2);
                if (uRL2 != null) {
                    arrayList.add(uRL2.toExternalForm());
                    continue;
                }
                Logger.getLogger(PanelTemplate.class.getName()).log(Level.WARNING, "stylesheet ''{0}'' not found", arrayList);
            }
        }
        if ((uRL = this.getResourceURL(instanceService, (String)(object = this.getDefaultResourceBase(instanceService) + ".branch.css"))) != null) {
            arrayList.add(uRL.toExternalForm());
        }
        return arrayList;
    }

    private void detachStylesheets(Scene scene, InstanceController<P> instanceController) {
        TemplateInstance<P> templateInstance = instanceController.getInstance();
        Context context = templateInstance.getContext();
        if (context.isPage()) {
            scene.getStylesheets().clear();
        }
        ((Parent)templateInstance.getRootObject()).getStylesheets().clear();
    }

    private URL getResourceURL(InstanceService instanceService, String string) {
        return instanceService.getResourceURL(instanceService.getAbsoluteResourcePath(string));
    }

    private String getDefaultResourceBase(InstanceService instanceService) {
        return instanceService.getAbsoluteResourcePath(instanceService.getResourceName(instanceService.getFxml()));
    }

    private void checkFacetObjects(Context context) {
        Collection<Facet> collection = context.getTemplateObjects(Facet.class);
        HashMap hashMap = new HashMap();
        for (Facet facet : collection) {
            Integer n;
            int n2;
            Object object = context.getLinkedTarget(Object.class, facet);
            HashMap<Class<? extends Facet>, Integer> hashMap2 = (HashMap<Class<? extends Facet>, Integer>)hashMap.get(object);
            if (hashMap2 == null) {
                hashMap2 = new HashMap<Class<? extends Facet>, Integer>();
                hashMap.put(object, hashMap2);
            }
            Class<? extends Facet> clazz = facet.getBindAsClass();
            int n3 = facet.getBindCardinality();
            boolean bl = false;
            Class<?> clazz2 = facet.getBindToClass();
            if (clazz2.isAssignableFrom(object.getClass()) && (n2 = (n = (Integer)hashMap2.get(clazz)) != null ? n + 1 : 1) <= n3) {
                hashMap2.put(clazz, n2);
                bl = true;
            }
            if (bl) continue;
            throw new IllegalArgumentException("invalid binding of '" + facet.getClass().getSimpleName() + "' to '" + object.getClass().getSimpleName() + "'");
        }
    }

    private class Listener
    extends AbstractTemplate.Listener {
        private Listener() {
        }
    }
}

