/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.sqlsource;

import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.raptor.metrics.engine.AbstractSource;
import oracle.dbtools.raptor.metrics.sqlsource.Query;
import oracle.dbtools.raptor.metrics.sqlsource.SQLJob;
import oracle.dbtools.raptor.metrics.sqlsource.SQLJobType;
import oracle.dbtools.raptor.metrics.sqlsource.SQLLibrary;
import oracle.dbtools.raptor.metrics.sqlsource.SQLOperation;
import oracle.dbtools.raptor.metrics.sqlsource.SQLOperationType;
import oracle.dbtools.raptor.metrics.sqlsource.SQLSourceType;
import oracle.dbtools.raptor.query.ObjectQueries;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SQLSource
extends AbstractSource<SQLSourceType, SQLJobType, SQLOperationType, SQLLibrary> {
    private final SortedSet<Version> libRangeBoundaries = new TreeSet<Version>();
    private static final Version MIN_VERSION = new Version(new int[]{0});
    private static final Version MAX_VERSION = new Version(new int[]{Integer.MAX_VALUE});

    @Override
    public SQLSourceType createTypeObject(ClassLoader classLoader) {
        this.initLibraries();
        SQLSourceType sQLSourceType = new SQLSourceType();
        this.initializeTypeObject(classLoader, sQLSourceType);
        return sQLSourceType;
    }

    @Override
    protected void initializeTypeObject(ClassLoader classLoader, SQLSourceType sQLSourceType) {
        super.initializeTypeObject(classLoader, sQLSourceType);
        sQLSourceType.setJobTypes(this.createTypeObjects(SQLJob.class, classLoader, sQLSourceType));
        sQLSourceType.setOperationTypes(this.createTypeObjects(SQLOperation.class, classLoader, sQLSourceType));
    }

    ObjectQueries createObjectQueries(List<Query> list) {
        XMLDocument xMLDocument = new XMLDocument();
        Element element = xMLDocument.createElement("queries");
        xMLDocument.appendChild((Node)element);
        block0: for (Query query : list) {
            Version version = this.getVersionFromLabel(query.getMinVersion(), MIN_VERSION);
            Version version2 = this.getVersionFromLabel(query.getMaxVersion(), MAX_VERSION);
            for (Version version3 : this.libRangeBoundaries) {
                if (version3.compareTo(version) <= 0) continue;
                boolean bl = version3.compareTo(version2) >= 0;
                Version version4 = version;
                Version version5 = bl ? version2 : version3;
                Element element2 = xMLDocument.createElement("query");
                if (!version4.equals((Object)MIN_VERSION)) {
                    element2.setAttribute("minversion", version4.toCanonicalString());
                }
                if (!version5.equals((Object)MAX_VERSION)) {
                    element2.setAttribute("maxversion", version5.toCanonicalString());
                }
                Element element3 = xMLDocument.createElement("sql");
                element3.setTextContent(this.resolveLibraryRefs(query.getSql(), sQLLibrary -> this.getLibraryText((SQLLibrary)sQLLibrary, version4, version5)));
                element2.appendChild(element3);
                element.appendChild(element2);
                if (bl) continue block0;
                version = version5;
            }
        }
        return new ObjectQueries((XMLNode)element);
    }

    private String getLibraryText(SQLLibrary sQLLibrary, Version version, Version version2) {
        for (Query query : sQLLibrary.getQueries()) {
            Version version3 = this.getVersionFromLabel(query.getMinVersion(), MIN_VERSION);
            Version version4 = this.getVersionFromLabel(query.getMaxVersion(), MAX_VERSION);
            if (version3.compareTo(version) > 0 || version4.compareTo(version2) < 0) continue;
            return query.getSql();
        }
        return "";
    }

    private void initLibraries() {
        this.libRangeBoundaries.add(MIN_VERSION);
        this.libRangeBoundaries.add(MAX_VERSION);
        for (SQLLibrary sQLLibrary : this.getLibraries()) {
            for (Query query : sQLLibrary.getQueries()) {
                if (query.getMinVersion() != null) {
                    this.libRangeBoundaries.add(new Version(query.getMinVersion()));
                }
                if (query.getMaxVersion() == null) continue;
                this.libRangeBoundaries.add(new Version(query.getMaxVersion()));
            }
        }
    }

    private Version getVersionFromLabel(String string, Version version) {
        return string != null ? new Version(string) : version;
    }
}

