/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.viewer;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.scene.Scene;
import javafx.scene.layout.Region;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.controls.display.DisplayAdapter;
import oracle.dbtools.raptor.controls.display.IDisplay;
import oracle.dbtools.raptor.controls.sqldialog.ObjectAction;
import oracle.dbtools.raptor.metrics.panel.PageTemplateFactory;
import oracle.dbtools.raptor.metrics.viewer.MetricsPanelAdapter;
import oracle.dbtools.raptor.metrics.viewer.MetricsPanelCommand;
import oracle.dbtools.raptor.metrics.viewer.MetricsToolbar;
import oracle.dbtools.raptor.metrics.viewer.MetricsToolbarAdapter;
import oracle.dbtools.raptor.oviewer.base.ViewerNode;
import oracle.ide.controls.Toolbar;
import oracle.ide.model.Node;
import oracle.ide.view.View;

public class MetricsDisplay
extends DisplayAdapter
implements IDisplay {
    private volatile MetricsPanelAdapter metricsPanel;
    private volatile MetricsToolbarAdapter toolbarAdapter;
    private String toolbarAcceleratorsResource;
    private final Map<String, MetricsPanelCommand> commandMap = new HashMap<String, MetricsPanelCommand>();

    public boolean isDisabled(String string) {
        MetricsPanelCommand metricsPanelCommand = this.commandMap.get(string);
        if (metricsPanelCommand != null) {
            return metricsPanelCommand.isDisabled();
        }
        return true;
    }

    public void invoke(String string) {
        MetricsPanelCommand metricsPanelCommand = this.commandMap.get(string);
        if (metricsPanelCommand != null) {
            metricsPanelCommand.invoke();
        }
    }

    public JComponent getUI() {
        if (this.metricsPanel == null) {
            Object object;
            Object object22;
            Object object3;
            PageTemplateFactory pageTemplateFactory = null;
            try {
                object3 = (String)this.getExtValues().get("FactoryClass");
                object22 = this.getDisplayModel().getCl().loadClass((String)object3);
                pageTemplateFactory = (PageTemplateFactory)((Class)object22).newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException reflectiveOperationException) {
                throw new TypeNotPresentException((String)this.getExtValues().get("FactoryClass"), reflectiveOperationException);
            }
            for (Object object22 : this.getDisplayModel().getActions()) {
                object = new MetricsPanelCommand((ObjectAction)object22){

                    @Override
                    protected void onUpdateDisabled() {
                        MetricsDisplay.this.getView().updateVisibleActions();
                    }
                };
                this.commandMap.put(((MetricsPanelCommand)object).getCommandName(), (MetricsPanelCommand)object);
            }
            this.metricsPanel = new MetricsPanelAdapter(pageTemplateFactory, this.getConnName(), this.commandMap.values());
            object3 = null;
            try {
                object22 = (String)this.getExtValues().get("ToolbarFactoryClass");
                if (object22 != null && !((String)object22).isEmpty()) {
                    object = this.getDisplayModel().getCl().loadClass((String)object22);
                    object3 = (PageTemplateFactory)((Class)object).newInstance();
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException reflectiveOperationException) {
                throw new TypeNotPresentException((String)this.getExtValues().get("ToolbarFactoryClass"), reflectiveOperationException);
            }
            if (object3 != null) {
                this.toolbarAdapter = new MetricsToolbarAdapter((PageTemplateFactory<Region>)object3, this.getConnName());
                MetricsToolbar.setAdapter(this.toolbarAdapter);
                this.getExtValues().put("ToolbarExtra", MetricsToolbar.class.getName());
            }
            this.toolbarAcceleratorsResource = (String)this.getExtValues().get("ToolbarAcceleratorsResource");
            if (this.toolbarAcceleratorsResource != null && this.toolbarAcceleratorsResource.isEmpty()) {
                this.toolbarAcceleratorsResource = null;
            }
        }
        return this.metricsPanel;
    }

    public void close() {
        this.metricsPanel.close();
        if (this.toolbarAdapter != null) {
            this.toolbarAdapter.closeToolbarUI();
        }
        super.close();
    }

    public void refresh(boolean bl) {
        Object v;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (String string : this.getExtValues().keySet()) {
            v = this.getExtValues().get(string);
            if (v == null) continue;
            hashMap.put(string, v);
        }
        for (String string : this.getBindMap().keySet()) {
            v = this.getBindMap().get(string);
            if (v == null) continue;
            hashMap.put(string, v);
        }
        this.metricsPanel.open(hashMap);
    }

    public void setView(View view) {
        Node node;
        super.setView(view);
        if (view != null && (node = view.getContext().getNode()) instanceof ViewerNode) {
            ViewerNode viewerNode = (ViewerNode)node;
            viewerNode.setPinned(true);
        }
    }

    public void clear() {
    }

    public void addActions(List<ObjectAction> list) {
    }

    public boolean isUseEditorScrollPane() {
        return false;
    }

    public boolean isUseScrollableUI() {
        return false;
    }

    public Scene getScene() {
        return this.metricsPanel.getScene();
    }

    public double getDisplayWidth() {
        return this.metricsPanel.getWidth();
    }

    public double getDisplayHeight() {
        return this.metricsPanel.getWidth();
    }

    public void setupAccelerators() {
        if (this.toolbarAcceleratorsResource != null) {
            try {
                JComponent jComponent = this.getUI();
                Toolbar toolbar = this.getToolbar();
                InputMap inputMap = jComponent.getInputMap(1);
                KeyStroke keyStroke = KeyStroke.getKeyStroke(80, 192, false);
                Object object = inputMap.get(keyStroke);
                InputMap inputMap2 = new InputMap();
                inputMap2.put(keyStroke, object);
                UIUtils.addIdeKeyBindings((JComponent)jComponent, (int)1, (String)this.toolbarAcceleratorsResource, (InputMap)inputMap2);
                UIUtils.setupAccelerators((Toolbar)toolbar, (String)this.toolbarAcceleratorsResource);
            }
            catch (Exception exception) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, "exception setting up accelerators", exception);
            }
            this.toolbarAcceleratorsResource = null;
        }
    }
}

