/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.onsd.connection;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.naming.Referenceable;
import javax.swing.SwingUtilities;
import oracle.dbtools.connections.ConnectionFactory;
import oracle.dbtools.connections.NameExistsException;
import oracle.dbtools.connections.Storage;
import oracle.dbtools.connections.StorageException;
import oracle.dbtools.raptor.onsd.connection.ConnectionCreator;
import oracle.dbtools.raptor.onsd.connection.NSConnection;
import oracle.dbtools.raptor.onsd.connection.NSConnectionEvent;
import oracle.dbtools.raptor.onsd.connection.NSConnectionException;
import oracle.dbtools.raptor.onsd.connection.NSConnectionInfo;
import oracle.dbtools.raptor.onsd.connection.NSConnectionInfoFactory2;
import oracle.dbtools.raptor.onsd.connection.NSConnectionType;
import oracle.dbtools.raptor.onsd.connection.NSConnectionsListener;
import oracle.dbtools.raptor.onsd.connection.OnsdConnectionType;
import oracle.dbtools.util.Logger;
import oracle.jdevimpl.db.adapter.StorageWrapper;

public class NSConnections {
    private static Map<NSConnectionType, NSConnections> s_connTypes = new HashMap<NSConnectionType, NSConnections>();
    private NSConnectionType m_type;
    private Map<String, C> m_conns = new HashMap<String, C>();
    private List<NSConnectionsListener> m_listeners = new CopyOnWriteArrayList<NSConnectionsListener>();

    public static synchronized NSConnections getInstance() {
        return NSConnections.getInstance(OnsdConnectionType.getInstance());
    }

    public static synchronized NSConnections getInstance(NSConnectionType nSConnectionType) {
        NSConnections nSConnections = s_connTypes.get(nSConnectionType);
        if (nSConnections == null) {
            nSConnections = new NSConnections(nSConnectionType);
            s_connTypes.put(nSConnectionType, nSConnections);
        }
        return nSConnections;
    }

    private NSConnections(NSConnectionType nSConnectionType) {
        this.m_type = nSConnectionType;
    }

    static Storage<NSConnectionInfo> getStorage() {
        StorageWrapper storageWrapper = StorageWrapper.getDefaultWrapper();
        NSConnectionInfoFactory2 nSConnectionInfoFactory2 = new NSConnectionInfoFactory2();
        return storageWrapper.getStorage(nSConnectionInfoFactory2.getConnectionType());
    }

    public String[] listConnections() {
        return NSConnections.getStorage().listConnections();
    }

    public NSConnectionInfo getConnectionInfo(String string) {
        NSConnectionInfo nSConnectionInfo = null;
        try {
            nSConnectionInfo = (NSConnectionInfo)NSConnections.getStorage().getConnection(string, (ConnectionFactory)new NSConnectionInfoFactory2());
        }
        catch (StorageException storageException) {
            Logger.severe(NSConnections.class, (Throwable)storageException);
        }
        return nSConnectionInfo;
    }

    public void addConnection(String string, NSConnectionInfo nSConnectionInfo) throws NSConnectionException {
        try {
            NSConnections.getStorage().addConnection(string, (Referenceable)((Object)nSConnectionInfo));
            this.fireConnectionsEvent(new NSConnectionEvent(2, string), true);
        }
        catch (NameExistsException nameExistsException) {
            throw new NSConnectionException(new IllegalArgumentException("Duplicate name: " + string));
        }
        catch (StorageException storageException) {
            throw new NSConnectionException(storageException);
        }
    }

    public void modifyConnection(String string, NSConnectionInfo nSConnectionInfo) throws NSConnectionException {
        boolean bl;
        C c = this.m_conns.get(string);
        boolean bl2 = bl = c != null;
        if (bl) {
            this.closeConnection(c);
            this.m_conns.remove(string);
        }
        try {
            NSConnections.getStorage().updateConnection(string, (Referenceable)((Object)nSConnectionInfo));
            this.fireConnectionsEvent(new NSConnectionEvent(4, string), true);
        }
        catch (StorageException storageException) {
            Logger.severe(NSConnections.class, (Throwable)storageException);
        }
    }

    public void removeConnection(String string) {
        C c = this.m_conns.get(string);
        if (c != null) {
            this.closeConnection(c);
            this.m_conns.remove(string);
        }
        try {
            NSConnections.getStorage().removeConnection(string);
            this.fireConnectionsEvent(new NSConnectionEvent(3, string), true);
        }
        catch (StorageException storageException) {
            Logger.severe(NSConnections.class, (Throwable)storageException);
        }
    }

    private boolean closeConnection(C c) {
        if (c.close()) {
            this.fireConnectionsEvent(new NSConnectionEvent(1, c.getName()), false);
            return true;
        }
        return false;
    }

    public NSConnection getConnection(String string, boolean bl) throws NSConnectionException {
        NSConnectionInfo nSConnectionInfo;
        C c = this.m_conns.get(string);
        if (c == null && (nSConnectionInfo = this.getConnectionInfo(string)) != null) {
            c = new C(this.m_type, nSConnectionInfo);
            this.m_conns.put(string, c);
        }
        if (c != null) {
            boolean bl2;
            boolean bl3 = c.m_conn == null;
            NSConnection nSConnection = c.getConnection(bl);
            boolean bl4 = bl2 = c.m_conn != null;
            if (bl3 && bl2) {
                this.fireConnectionsEvent(new NSConnectionEvent(0, c.getName()), false);
            }
            return nSConnection;
        }
        return null;
    }

    public boolean closeConnection(String string) {
        boolean bl = false;
        C c = this.m_conns.get(string);
        if (c != null) {
            bl = this.closeConnection(c);
            this.m_conns.remove(string);
        } else {
            bl = true;
        }
        return bl;
    }

    public void addListener(NSConnectionsListener nSConnectionsListener) {
        this.m_listeners.add(nSConnectionsListener);
    }

    public void removeListener(NSConnectionsListener nSConnectionsListener) {
        this.m_listeners.remove(nSConnectionsListener);
    }

    static void migrateConnections(Map<String, NSConnectionInfo> map) {
        if (map.size() > 0) {
            Storage<NSConnectionInfo> storage = NSConnections.getStorage();
            for (Map.Entry<String, NSConnectionInfo> entry : map.entrySet()) {
                try {
                    storage.addConnection(entry.getKey(), (Referenceable)((Object)entry.getValue()));
                }
                catch (StorageException storageException) {
                    Logger.severe(NSConnections.class, (Throwable)storageException);
                }
            }
        }
    }

    private void fireConnectionsEvent(final NSConnectionEvent nSConnectionEvent, boolean bl) {
        final Iterator<NSConnectionsListener> iterator = this.m_listeners.iterator();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                switch (nSConnectionEvent.getID()) {
                    case 2: {
                        while (iterator.hasNext()) {
                            ((NSConnectionsListener)iterator.next()).connectionAdded(nSConnectionEvent);
                        }
                        break;
                    }
                    case 3: {
                        while (iterator.hasNext()) {
                            ((NSConnectionsListener)iterator.next()).connectionRemoved(nSConnectionEvent);
                        }
                        break;
                    }
                    case 4: {
                        while (iterator.hasNext()) {
                            ((NSConnectionsListener)iterator.next()).connectionModified(nSConnectionEvent);
                        }
                        break;
                    }
                    case 1: {
                        while (iterator.hasNext()) {
                            ((NSConnectionsListener)iterator.next()).connectionClosed(nSConnectionEvent);
                        }
                        break;
                    }
                    case 0: {
                        while (iterator.hasNext()) {
                            ((NSConnectionsListener)iterator.next()).connectionOpened(nSConnectionEvent);
                        }
                        break;
                    }
                }
            }
        };
        if (bl) {
            SwingUtilities.invokeLater(runnable);
        } else {
            runnable.run();
        }
    }

    private static class C {
        private NSConnectionType m_type;
        private NSConnectionInfo m_info;
        private NSConnection m_conn;

        C(NSConnectionType nSConnectionType, NSConnectionInfo nSConnectionInfo) {
            this.m_type = nSConnectionType;
            this.m_info = nSConnectionInfo;
        }

        String getName() {
            return this.m_info.getName();
        }

        NSConnectionInfo getInfo() {
            return this.m_info;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        NSConnection getConnection(boolean bl) throws NSConnectionException {
            C c = this;
            synchronized (c) {
                if (this.m_conn == null && bl) {
                    ConnectionCreator connectionCreator = new ConnectionCreator(this.m_type);
                    this.m_conn = connectionCreator.createConnection(this.m_info);
                }
            }
            return this.m_conn;
        }

        boolean close() {
            if (this.m_conn != null) {
                this.m_conn.close();
                this.m_conn = null;
            }
            return true;
        }
    }
}

