/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.onsd.connection.ui;

import java.awt.Component;
import javax.swing.JPanel;
import oracle.dbtools.raptor.onsd.connection.NSConnection;
import oracle.dbtools.raptor.onsd.connection.NSConnectionException;
import oracle.dbtools.raptor.onsd.connection.NSConnectionInfo;
import oracle.dbtools.raptor.onsd.connection.NSConnectionType;
import oracle.dbtools.raptor.onsd.connection.NSConnections;
import oracle.dbtools.raptor.onsd.connection.ui.BaseConnectionPanel;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dbtools.util.Logger;
import oracle.ide.Ide;
import oracle.ide.panels.TDialogLauncher;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;
import oracle.javatools.util.ModelUtil;

public final class ConnectionEditor {
    private static ConnectionEditor INSTANCE;

    public static synchronized ConnectionEditor getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ConnectionEditor();
        }
        return INSTANCE;
    }

    public String createConnection(NSConnectionType nSConnectionType) {
        String string = null;
        BaseConnectionPanel baseConnectionPanel = this.createPanel(nSConnectionType);
        if (baseConnectionPanel != null) {
            NSConnections nSConnections = NSConnections.getInstance(nSConnectionType);
            Namespace namespace = baseConnectionPanel.createNamespace(null, nSConnections.listConnections());
            NSConnectionInfo nSConnectionInfo = this.runDialog(baseConnectionPanel.getCreateTitle(), namespace, baseConnectionPanel);
            if (nSConnectionInfo != null) {
                try {
                    nSConnections.addConnection(nSConnectionInfo.getName(), nSConnectionInfo);
                    string = nSConnectionInfo.getName();
                }
                catch (NSConnectionException nSConnectionException) {
                    ExceptionHandler.handleException((Throwable)nSConnectionException);
                }
            }
        }
        return string;
    }

    public String editConnection(String string, NSConnectionType nSConnectionType) {
        String string2 = null;
        BaseConnectionPanel baseConnectionPanel = this.createPanel(nSConnectionType);
        if (baseConnectionPanel != null) {
            NSConnections nSConnections = NSConnections.getInstance(nSConnectionType);
            NSConnectionInfo nSConnectionInfo = nSConnections.getConnectionInfo(string);
            Namespace namespace = baseConnectionPanel.createNamespace(nSConnectionInfo, nSConnections.listConnections());
            NSConnectionInfo nSConnectionInfo2 = this.runDialog(baseConnectionPanel.getEditTitle(), namespace, baseConnectionPanel);
            if (nSConnectionInfo2 != null && ModelUtil.areDifferent((Object)nSConnectionInfo, (Object)nSConnectionInfo2)) {
                try {
                    string2 = nSConnectionInfo2.getName();
                    if (ModelUtil.areDifferent((Object)string, (Object)string2)) {
                        nSConnections.removeConnection(string);
                        nSConnections.addConnection(string2, nSConnectionInfo2);
                    } else {
                        nSConnections.modifyConnection(string, nSConnectionInfo2);
                    }
                }
                catch (NSConnectionException nSConnectionException) {
                    ExceptionHandler.handleException((Throwable)nSConnectionException);
                    string2 = null;
                }
            }
        }
        return string2;
    }

    private boolean isConnectionOpen(NSConnections nSConnections, String string) {
        try {
            NSConnection nSConnection = nSConnections.getConnection(string, false);
            return nSConnection != null && nSConnection.isOpen();
        }
        catch (NSConnectionException nSConnectionException) {
            Logger.warn(ConnectionEditor.class, (Throwable)nSConnectionException);
            return false;
        }
    }

    private BaseConnectionPanel createPanel(NSConnectionType nSConnectionType) {
        try {
            return nSConnectionType.getConnectionEditorClass().newInstance();
        }
        catch (InstantiationException instantiationException) {
            Logger.severe(ConnectionEditor.class, (Throwable)instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            Logger.severe(ConnectionEditor.class, (Throwable)illegalAccessException);
        }
        return null;
    }

    private NSConnectionInfo runDialog(String string, Namespace namespace, BaseConnectionPanel baseConnectionPanel) {
        TDialogLauncher tDialogLauncher = new TDialogLauncher((Component)Ide.getMainWindow(), string, (Traversable)new TP(baseConnectionPanel), namespace);
        tDialogLauncher.setPackDialog(true);
        tDialogLauncher.initDialog().setInitialFocus(baseConnectionPanel.getInitialFocusComponent());
        tDialogLauncher.initDialog().getAccessibleContext().setAccessibleName(string);
        NSConnectionInfo nSConnectionInfo = null;
        if (tDialogLauncher.showDialog()) {
            nSConnectionInfo = baseConnectionPanel.createConnectionInfo(namespace);
        }
        return nSConnectionInfo;
    }

    private static final class TP
    implements Traversable {
        private JPanel m_panel;
        private Traversable m_wrapped;

        TP(Traversable traversable) {
            this.m_wrapped = traversable;
        }

        public void onEntry(TraversableContext traversableContext) {
            this.m_wrapped.onEntry(traversableContext);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Component getComponent() {
            TP tP = this;
            synchronized (tP) {
                if (this.m_panel == null) {
                    this.m_panel = LayoutControl.GBC.createDialogMainPanel((Component)this.m_wrapped.getComponent());
                }
            }
            return this.m_panel;
        }

        public void onExit(TraversableContext traversableContext) throws TraversalException {
            this.m_wrapped.onExit(traversableContext);
        }

        public Object getExitTransition() {
            return this.m_wrapped.getExitTransition();
        }

        public String getHelpID() {
            return this.m_wrapped.getHelpID();
        }
    }
}

