/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.onsd.connection.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.dbtools.raptor.onsd.OnsdBrowserResources;
import oracle.dbtools.raptor.onsd.connection.NSConnectionInfo;
import oracle.dbtools.raptor.onsd.connection.ui.BaseConnectionPanel;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.ide.Ide;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLTextField;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.util.ModelUtil;

public final class OnsdConnectionPanel
extends BaseConnectionPanel {
    private static final String DEFAULT_HOST_NAME = "localhost";
    private static final int DEFAULT_DB_PORT = 5000;
    private static final String DEFAULT_STORE_NAME = "kvstore";
    public static final String TRANSPORT_SSL_KEY = "Onsd.Transport.SSL";
    public static final String TRANSPORT_KEYFILE_KEY = "Onsd.Transport.KeyFile";
    private static final String SSH_SETTINGS_DIR = ".ssh";
    public static final String SECURITY_PROPFILE_KEY = "Onsd.Security.PropFile";
    public static final String SECURITY_WALLETDIR_KEY = "Onsd.Security.WalletDir";
    public static final String SECURITY_PWDFILE_KEY = "Onsd.Security.PWDFile";
    private static URL sDefaultDir;
    private HintTextField m_dbUser = new HintTextField();
    private JPasswordField m_dbPwd = new JPasswordField();
    private HintTextField m_dbHost = new HintTextField();
    private HintTextField m_dbStore = new HintTextField();
    private JCheckBox m_dbSSL = new JCheckBox();
    private HintURLTextField m_dbKeyFile = new HintURLTextField();
    private JButton m_dbKeyChooser = new JButton();
    private HintURLTextField m_dbWalletDir = new HintURLTextField();
    private JButton m_dbWalletChooser = new JButton();
    private HintURLTextField m_dbPWDFile = new HintURLTextField();
    private JButton m_dbPWDChooser = new JButton();
    private HintURLTextField m_dbPropFile = new HintURLTextField();
    private JButton m_dbPropChooser = new JButton();
    private URL savedKeyURL = this.initKeyURL = this.m_dbKeyFile.getURL();
    private URL initKeyURL;
    private URL savedPropURL = this.initPropURL = this.m_dbPropFile.getURL();
    private URL initPropURL;
    private URL savedWalletURL = this.initWalletURL = this.m_dbWalletDir.getURL();
    private URL initWalletURL;
    private URL savedPWDURL = this.initPWDURL = this.m_dbPWDFile.getURL();
    private URL initPWDURL;
    private Boolean userSSLSetting = null;
    private boolean doingImplicitChange = false;

    public OnsdConnectionPanel() {
        this.m_dbKeyFile.setEnabled(this.m_dbSSL.isSelected());
        this.m_dbKeyChooser.setEnabled(this.m_dbSSL.isSelected());
        this.m_dbSSL.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (!OnsdConnectionPanel.this.doingImplicitChange) {
                    OnsdConnectionPanel.this.userSSLSetting = OnsdConnectionPanel.this.m_dbSSL.isSelected();
                }
                if (OnsdConnectionPanel.this.m_dbSSL.isSelected()) {
                    OnsdConnectionPanel.this.m_dbKeyFile.setEnabled(true);
                    OnsdConnectionPanel.this.m_dbKeyFile.setURL(OnsdConnectionPanel.this.savedKeyURL);
                    OnsdConnectionPanel.this.m_dbKeyChooser.setEnabled(true);
                } else {
                    OnsdConnectionPanel.this.savedKeyURL = OnsdConnectionPanel.this.m_dbKeyFile.getURL();
                    OnsdConnectionPanel.this.m_dbKeyFile.setURL(OnsdConnectionPanel.this.initKeyURL);
                    OnsdConnectionPanel.this.m_dbKeyFile.setEnabled(false);
                    OnsdConnectionPanel.this.m_dbKeyChooser.setEnabled(false);
                }
            }
        });
        this.m_dbUser.getDocument().addDocumentListener(new DocumentListener(){

            private void setSSL() {
                try {
                    OnsdConnectionPanel.this.doingImplicitChange = true;
                    OnsdConnectionPanel.this.m_dbSSL.setSelected(OnsdConnectionPanel.this.SSLrequired());
                }
                finally {
                    OnsdConnectionPanel.this.doingImplicitChange = false;
                }
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.setSSL();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.setSSL();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
            }
        });
        this.m_dbPwd.getDocument().addDocumentListener(new DocumentListener(){

            private void setSSL() {
                try {
                    OnsdConnectionPanel.this.doingImplicitChange = true;
                    OnsdConnectionPanel.this.m_dbSSL.setSelected(OnsdConnectionPanel.this.SSLrequired());
                }
                finally {
                    OnsdConnectionPanel.this.doingImplicitChange = false;
                }
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.setSSL();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.setSSL();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
            }
        });
    }

    private boolean SSLrequired() {
        if (this.userSSLSetting != null) {
            return this.userSSLSetting;
        }
        return ModelUtil.hasLength((String)this.m_dbUser.getText()) || this.m_dbPwd.getPassword() != null && this.m_dbPwd.getPassword().length > 0;
    }

    @Override
    public String getCreateTitle() {
        return OnsdBrowserResources.getString("NEW_CONN_TITLE");
    }

    @Override
    public String getEditTitle() {
        return OnsdBrowserResources.getString("EDIT_CONN_TITLE");
    }

    public String getHelpID() {
        return "f1_onsdconnection_html";
    }

    @Override
    protected NSConnectionInfo createConnectionInfo(Namespace namespace) {
        String string = (String)namespace.get("Onsd.ConnectionName");
        String string2 = (String)namespace.get("Onsd.Hosts");
        String string3 = (String)namespace.get("Onsd.StoreName");
        String string4 = (String)namespace.get("Onsd.Username");
        char[] cArray = (char[])namespace.get("Onsd.Password");
        Boolean bl = (Boolean)namespace.get(TRANSPORT_SSL_KEY);
        URL uRL = (URL)namespace.get(TRANSPORT_KEYFILE_KEY);
        NSConnectionInfo.TransportInfo transportInfo = new NSConnectionInfo.TransportInfo(bl, uRL);
        URL uRL2 = (URL)namespace.get(SECURITY_PROPFILE_KEY);
        URL uRL3 = (URL)namespace.get(SECURITY_WALLETDIR_KEY);
        URL uRL4 = (URL)namespace.get(SECURITY_PWDFILE_KEY);
        NSConnectionInfo.SecurityInfo securityInfo = new NSConnectionInfo.SecurityInfo(uRL2, uRL3, uRL4);
        return new NSConnectionInfo(string, string2, string3, string4, cArray, transportInfo, securityInfo);
    }

    @Override
    protected Namespace createNamespace(NSConnectionInfo nSConnectionInfo, String[] stringArray) {
        Namespace namespace = super.createNamespace(nSConnectionInfo, stringArray);
        if (nSConnectionInfo != null) {
            NSConnectionInfo.SecurityInfo securityInfo;
            NSConnectionInfo.TransportInfo transportInfo = nSConnectionInfo.getTransportInfo();
            if (transportInfo != null) {
                namespace.put(TRANSPORT_SSL_KEY, (Object)transportInfo.getUseSSL());
                namespace.put(TRANSPORT_KEYFILE_KEY, (Object)transportInfo.getKeyFile());
            }
            if ((securityInfo = nSConnectionInfo.getSecurityInfo()) != null) {
                namespace.put(SECURITY_PROPFILE_KEY, (Object)securityInfo.getPropertyFile());
                namespace.put(SECURITY_WALLETDIR_KEY, (Object)securityInfo.getWalletDir());
                namespace.put(SECURITY_PWDFILE_KEY, (Object)securityInfo.getPWDFile());
            }
        }
        return namespace;
    }

    @Override
    public void onEntry(TraversableContext traversableContext) {
        String string;
        URL uRL;
        URL uRL2;
        URL uRL3;
        URL uRL4;
        Boolean bl;
        char[] cArray;
        super.onEntry(traversableContext);
        String string2 = (String)traversableContext.get("Onsd.Username");
        if (string2 != null) {
            this.m_dbUser.setText(string2);
        }
        if ((cArray = (char[])traversableContext.get("Onsd.Password")) != null && cArray.length > 0) {
            this.m_dbPwd.setText(new String(cArray));
        }
        if ((bl = (Boolean)traversableContext.get(TRANSPORT_SSL_KEY)) != null) {
            this.userSSLSetting = bl;
            this.m_dbSSL.setSelected(this.userSSLSetting);
        }
        if ((uRL4 = (URL)traversableContext.get(TRANSPORT_KEYFILE_KEY)) != null) {
            if (bl.booleanValue()) {
                this.m_dbKeyFile.setURL(uRL4);
            } else {
                this.savedKeyURL = uRL4;
            }
        }
        if ((uRL3 = (URL)traversableContext.get(SECURITY_PROPFILE_KEY)) != null) {
            this.m_dbPropFile.setURL(uRL3);
        }
        if ((uRL2 = (URL)traversableContext.get(SECURITY_WALLETDIR_KEY)) != null) {
            this.m_dbWalletDir.setURL(uRL2);
        }
        if ((uRL = (URL)traversableContext.get(SECURITY_PWDFILE_KEY)) != null) {
            this.m_dbPWDFile.setURL(uRL);
        }
        if ((string = (String)traversableContext.get("Onsd.Hosts")) != null) {
            this.m_dbHost.setText(string);
        } else {
            this.m_dbHost.setText("localhost:5000");
        }
        String string3 = (String)traversableContext.get("Onsd.StoreName");
        if (string3 != null) {
            this.m_dbStore.setText(string3);
        } else {
            this.m_dbStore.setText(DEFAULT_STORE_NAME);
        }
    }

    @Override
    public void onExit(TraversableContext traversableContext) throws TraversalException {
        char[] cArray = this.m_dbPwd.getPassword();
        String string = this.m_dbUser.getText().trim();
        if (cArray != null && cArray.length > 0 && !ModelUtil.hasLength((String)string)) {
            throw new TraversalException(OnsdBrowserResources.getString("NEW_CONN_MISSING_USERNAME"));
        }
        String string2 = this.m_dbHost.getText().trim();
        if (!ModelUtil.hasLength((String)string2)) {
            throw new TraversalException(OnsdBrowserResources.getString("NEW_CONN_MISSING_HOST_NAME"));
        }
        String string3 = this.m_dbStore.getText();
        if (!ModelUtil.hasLength((String)string3)) {
            throw new TraversalException(OnsdBrowserResources.getString("NEW_CONN_MISSING_STORE_NAME"));
        }
        Boolean bl = this.m_dbSSL.isSelected();
        if (!bl.booleanValue() && this.SSLrequired()) {
            throw new TraversalException(OnsdBrowserResources.getString("NEW_CONN_SSL_REQUIRED"));
        }
        URL uRL = this.m_dbKeyFile.getURL();
        URL uRL2 = this.m_dbPropFile.getURL();
        URL uRL3 = this.m_dbWalletDir.getURL();
        URL uRL4 = this.m_dbPWDFile.getURL();
        traversableContext.put("Onsd.Username", (Object)string);
        traversableContext.put("Onsd.Password", (Object)cArray);
        traversableContext.put("Onsd.Hosts", (Object)string2);
        traversableContext.put("Onsd.StoreName", (Object)string3);
        traversableContext.put(TRANSPORT_SSL_KEY, (Object)bl);
        traversableContext.put(TRANSPORT_KEYFILE_KEY, (Object)uRL);
        traversableContext.put(SECURITY_PROPFILE_KEY, (Object)uRL2);
        traversableContext.put(SECURITY_WALLETDIR_KEY, (Object)uRL3);
        traversableContext.put(SECURITY_PWDFILE_KEY, (Object)uRL4);
        super.onExit(traversableContext);
    }

    @Override
    protected final Component createComponent() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.m_name, (String)OnsdBrowserResources.getString("NEW_CONN_NAME"));
        jPanel.add((Component)jLabel, LayoutControl.GBC.gbc((int)0, (int)0, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP));
        jPanel.add((Component)this.m_name, LayoutControl.GBC.gbc((int)1, (int)0, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        int n = 0;
        jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.m_dbUser, (String)OnsdBrowserResources.getString("NEW_CONN_USERNAME"));
        jPanel2.add((Component)jLabel, LayoutControl.GBC.gbc((int)0, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP));
        jPanel2.add((Component)this.m_dbUser, LayoutControl.GBC.gbc((int)1, (int)n, (int)3, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.m_dbPwd, (String)OnsdBrowserResources.getString("NEW_CONN_PASSWORD"));
        this.m_dbPwd.setToolTipText(OnsdBrowserResources.getString("AUTHENTICATION_PWD_TOOLTIP"));
        jPanel2.add((Component)jLabel, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP));
        jPanel2.add((Component)this.m_dbPwd, LayoutControl.GBC.gbc((int)1, (int)n, (int)3, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.m_dbHost, (String)OnsdBrowserResources.getString("NEW_CONN_HOST_NAME"));
        this.m_dbHost.setHint("host:port{,host:port}*");
        jPanel2.add((Component)jLabel, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP));
        jPanel2.add((Component)this.m_dbHost, LayoutControl.GBC.gbc((int)1, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.m_dbStore, (String)OnsdBrowserResources.getString("NEW_CONN_STORE_NAME"));
        jPanel2.add((Component)jLabel, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP));
        jPanel2.add((Component)this.m_dbStore, LayoutControl.GBC.gbc((int)1, (int)n, (int)3, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        Serializable serializable = LayoutControl.GBC.createTitledSubPanel((String)OnsdBrowserResources.getString("NEW_PUBLIC_DB_LABEL"), (Component)jPanel2);
        jPanel.add((Component)serializable, LayoutControl.GBC.gbc((int)0, (int)2, (int)2, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.NONE, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.XY, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X, (LayoutControl.GBC.Anchor)LayoutControl.GBC.Anchor.CENTER));
        jPanel2 = new JPanel(new GridBagLayout());
        n = 0;
        jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.m_dbSSL, (String)OnsdBrowserResources.getString("NEW_CONN_SSL_LABEL"));
        jPanel2.add((Component)jLabel, LayoutControl.GBC.gbc((int)0, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP));
        jPanel2.add((Component)this.m_dbSSL, LayoutControl.GBC.gbc((int)1, (int)n, (int)3, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        ++n;
        jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)((Object)this.m_dbKeyFile), (String)OnsdBrowserResources.getString("NEW_CONN_KEYFILE_LABEL"));
        ResourceUtils.resButton((AbstractButton)this.m_dbKeyChooser, (String)OnsdBrowserResources.getString("NEW_CONN_BROWSE_BTN"));
        this.m_dbKeyChooser.addActionListener((ActionListener)((Object)this.m_dbKeyFile));
        this.m_dbKeyFile.setDialogTitle(OnsdBrowserResources.getString("NEW_CONN_TITLE_KEY_FILE"));
        this.m_dbKeyFile.setDialogType(0);
        this.m_dbKeyFile.setDirectoryOnly(false);
        if (sDefaultDir == null) {
            serializable = URLFactory.newFileURL((String)Ide.getTrueUserHomeDirectory());
            URL uRL = URLFactory.newDirURL((URL)serializable, (String)SSH_SETTINGS_DIR);
            sDefaultDir = URLFileSystem.exists((URL)uRL) ? uRL : serializable;
        }
        this.m_dbKeyFile.setDefaultChooserURL(sDefaultDir);
        jPanel2.add((Component)jLabel, LayoutControl.GBC.gbc((int)0, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP));
        jPanel2.add((Component)((Object)this.m_dbKeyFile), LayoutControl.GBC.gbc((int)1, (int)n, (int)2, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        jPanel2.add((Component)this.m_dbKeyChooser, LayoutControl.GBC.gbc((int)3, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_CONTROL2CONTROL_COMP));
        ++n;
        jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)((Object)this.m_dbWalletDir), (String)OnsdBrowserResources.getString("NEW_CONN_WALLETDIR_LABEL"));
        ResourceUtils.resButton((AbstractButton)this.m_dbWalletChooser, (String)OnsdBrowserResources.getString("NEW_CONN_BROWSE_BTN"));
        this.m_dbWalletChooser.addActionListener((ActionListener)((Object)this.m_dbWalletDir));
        this.m_dbWalletDir.setDialogType(0);
        this.m_dbWalletDir.setDirectoryOnly(true);
        this.m_dbWalletDir.setDialogTitle(OnsdBrowserResources.getString("NEW_CONN_TITLE_WALLET_DIR"));
        jPanel2.add((Component)jLabel, LayoutControl.GBC.gbc((int)0, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP));
        jPanel2.add((Component)((Object)this.m_dbWalletDir), LayoutControl.GBC.gbc((int)1, (int)n, (int)2, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        jPanel2.add((Component)this.m_dbWalletChooser, LayoutControl.GBC.gbc((int)3, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_CONTROL2CONTROL_COMP));
        ++n;
        jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)((Object)this.m_dbPropFile), (String)OnsdBrowserResources.getString("NEW_CONN_PROPFILE_LABEL"));
        ResourceUtils.resButton((AbstractButton)this.m_dbPropChooser, (String)OnsdBrowserResources.getString("NEW_CONN_BROWSE_BTN"));
        this.m_dbPropChooser.addActionListener((ActionListener)((Object)this.m_dbPropFile));
        this.m_dbPropFile.setDialogType(0);
        this.m_dbPropFile.setDirectoryOnly(false);
        this.m_dbPropFile.setDialogTitle(OnsdBrowserResources.getString("NEW_CONN_TITLE_PROP_FILE"));
        jPanel2.add((Component)jLabel, LayoutControl.GBC.gbc((int)0, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP));
        jPanel2.add((Component)((Object)this.m_dbPropFile), LayoutControl.GBC.gbc((int)1, (int)n, (int)2, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        jPanel2.add((Component)this.m_dbPropChooser, LayoutControl.GBC.gbc((int)3, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_CONTROL2CONTROL_COMP));
        serializable = LayoutControl.GBC.createTitledSubPanel((String)OnsdBrowserResources.getString("NEW_PUBLIC_SECURITY_LABEL"), (Component)jPanel2);
        jPanel.add((Component)serializable, LayoutControl.GBC.gbc((int)0, (int)4, (int)4, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.NONE, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.XY, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X, (LayoutControl.GBC.Anchor)LayoutControl.GBC.Anchor.CENTER));
        LayoutControl.GBC.addVSpring((JPanel)jPanel, (int)1);
        LayoutControl.GBC.addVSpring((JPanel)jPanel, (int)3);
        return jPanel;
    }

    public static class HintURLTextField
    extends URLTextField {
        private String _ghostDefault = null;
        private String _hint = null;

        public void paint(Graphics graphics) {
            super.paint(graphics);
            if (this.isEnabled() && this.getText().length() == 0 && (this._hint != null && this._hint.length() > 0 || this._ghostDefault != null && this._ghostDefault.length() > 0)) {
                int n = this.getHeight();
                ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                Insets insets = this.getInsets();
                int n2 = this.getBackground().getRGB();
                int n3 = this.getForeground().getRGB();
                int n4 = -16843010;
                int n5 = ((n2 & n4) >>> 1) + ((n3 & n4) >>> 1);
                graphics.setColor(new Color(n5, true));
                if (this._ghostDefault != null && this._ghostDefault.length() > 0) {
                    graphics.drawString(this._ghostDefault, insets.left, n / 2 + graphics.getFontMetrics().getAscent() / 2 - 2);
                } else {
                    Font font = this.getFont();
                    Font font2 = new Font(font.getName(), font.getStyle() | 2, font.getSize());
                    graphics.setFont(font2);
                    graphics.drawString(this._hint, insets.left, n / 2 + graphics.getFontMetrics().getAscent() / 2 - 2);
                }
            }
        }

        public void setHint(String string) {
            this._hint = string;
            this.repaint();
        }

        public String getHint() {
            return this._hint;
        }

        public void setGhostDefault(String string) {
            this._ghostDefault = string;
            this.repaint();
        }

        public String getGhostDefault() {
            return this._ghostDefault;
        }
    }

    public static class HintTextField
    extends JTextField {
        private String _ghostDefault = null;
        private String _hint = null;

        @Override
        public void paint(Graphics graphics) {
            super.paint(graphics);
            if (this.isEnabled() && this.getText().length() == 0 && (this._hint != null && this._hint.length() > 0 || this._ghostDefault != null && this._ghostDefault.length() > 0)) {
                int n = this.getHeight();
                ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                Insets insets = this.getInsets();
                int n2 = this.getBackground().getRGB();
                int n3 = this.getForeground().getRGB();
                int n4 = -16843010;
                int n5 = ((n2 & n4) >>> 1) + ((n3 & n4) >>> 1);
                graphics.setColor(new Color(n5, true));
                if (this._ghostDefault != null && this._ghostDefault.length() > 0) {
                    graphics.drawString(this._ghostDefault, insets.left, n / 2 + graphics.getFontMetrics().getAscent() / 2 - 2);
                } else {
                    Font font = this.getFont();
                    Font font2 = new Font(font.getName(), font.getStyle() | 2, font.getSize());
                    graphics.setFont(font2);
                    graphics.drawString(this._hint, insets.left, n / 2 + graphics.getFontMetrics().getAscent() / 2 - 2);
                }
            }
        }

        public void setHint(String string) {
            this._hint = string;
            this.repaint();
        }

        public String getHint() {
            return this._hint;
        }

        public void setGhostDefault(String string) {
            this._ghostDefault = string;
            this.repaint();
        }

        public String getGhostDefault() {
            return this._ghostDefault;
        }
    }
}

