/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.metadata.persistence;

import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.dbtools.metadata.persistence.CloseableResultSet;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.Field;
import oracle.dbtools.metadata.persistence.NoSuchObjectException;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;

public class MdApplicationFile
extends PersistableObject {
    public static final String TABLE_NAME = "MD_APPLICATIONFILES";
    public static final String COLNAME_APPLICATIONS_ID_FK = "APPLICATIONS_ID_FK";
    public static final String COLNAME_NAME = "NAME";
    public static final String COLNAME_URI = "URI";
    public static final String COLNAME_TYPE = "TYPE";
    public static final String COLNAME_STATE = "STATE";
    public static final String COLNAME_LANGUAGE = "LANGUAGE";
    public static final String COLNAME_SECURITY_GROUP_ID = "SECURITY_GROUP_ID";
    public static final String COLNAME_CREATED_ON = "CREATED_ON";
    public static final String COLNAME_CREATED_BY = "CREATED_BY";
    public static final String COLNAME_UPDATED_ON = "UPDATED_ON";
    public static final String COLNAME_UPDATED_BY = "UPDATED_BY";

    public MdApplicationFile(DBObjectId dBObjectId, String string, String string2, String string3, String string4) {
        this.setApplicationsId(dBObjectId);
        this.setName(string);
        this.setUri(string2);
        this.setType(string3);
        this.setState(string4);
    }

    public static MdApplicationFile getExistingInstance(DBObjectId dBObjectId) {
        MdApplicationFile mdApplicationFile = new MdApplicationFile();
        mdApplicationFile.setKey(dBObjectId);
        return mdApplicationFile;
    }

    private MdApplicationFile() {
    }

    public static MdApplicationFile retrieveExistingInstance(PersistenceManager persistenceManager, DBObjectId dBObjectId) throws PersistenceException, NoSuchObjectException {
        MdApplicationFile mdApplicationFile = MdApplicationFile.getExistingInstance(dBObjectId);
        mdApplicationFile.retrieve(persistenceManager);
        return mdApplicationFile;
    }

    protected void setApplicationsId(DBObjectId dBObjectId) {
        Field field = new Field(COLNAME_APPLICATIONS_ID_FK, "DBOBJECTID", false);
        field.setValue(dBObjectId);
        this.setField(field);
    }

    protected void setName(String string) {
        Field field = new Field(COLNAME_NAME, "STRING", false);
        field.setValue(string);
        this.setField(field);
    }

    protected void setUri(String string) {
        Field field = new Field(COLNAME_URI, "STRING", false);
        field.setValue(string);
        this.setField(field);
    }

    protected void setType(String string) {
        Field field = new Field(COLNAME_TYPE, "STRING", false);
        field.setValue(string);
        this.setField(field);
    }

    protected void setState(String string) {
        Field field = new Field(COLNAME_STATE, "STRING", false);
        field.setValue(string);
        this.setField(field);
    }

    public void setLanguage(String string) {
        Field field = new Field(COLNAME_LANGUAGE, "STRING");
        field.setValue(string);
        this.setField(field);
    }

    public void setSecurityGroupId(DBObjectId dBObjectId) {
        Field field = new Field(COLNAME_SECURITY_GROUP_ID, "DBOBJECTID");
        field.setValue(dBObjectId);
        this.setField(field);
    }

    public void setCreatedOn(Date date) {
        Field field = new Field(COLNAME_CREATED_ON, "DATE");
        field.setValue(date);
        this.setField(field);
    }

    public void setCreatedBy(String string) {
        Field field = new Field(COLNAME_CREATED_BY, "STRING");
        field.setValue(string);
        this.setField(field);
    }

    public void setUpdatedOn(Date date) {
        Field field = new Field(COLNAME_UPDATED_ON, "DATE");
        field.setValue(date);
        this.setField(field);
    }

    public void setUpdatedBy(String string) {
        Field field = new Field(COLNAME_UPDATED_BY, "STRING");
        field.setValue(string);
        this.setField(field);
    }

    public DBObjectId getApplicationsId() {
        Field field = this.getField(COLNAME_APPLICATIONS_ID_FK);
        if (field == null) {
            return null;
        }
        return field.getDBObjectId();
    }

    public String getName() {
        Field field = this.getField(COLNAME_NAME);
        if (field == null) {
            return null;
        }
        return field.getString();
    }

    public String getUri() {
        Field field = this.getField(COLNAME_URI);
        if (field == null) {
            return null;
        }
        return field.getString();
    }

    public String getType() {
        Field field = this.getField(COLNAME_TYPE);
        if (field == null) {
            return null;
        }
        return field.getString();
    }

    public String getState() {
        Field field = this.getField(COLNAME_STATE);
        if (field == null) {
            return null;
        }
        return field.getString();
    }

    public String getLanguage() {
        Field field = this.getField(COLNAME_LANGUAGE);
        if (field == null) {
            return null;
        }
        return field.getString();
    }

    public DBObjectId getSecurityGroupId() {
        Field field = this.getField(COLNAME_SECURITY_GROUP_ID);
        if (field == null) {
            return null;
        }
        return field.getDBObjectId();
    }

    public Date getCreatedOn() {
        Field field = this.getField(COLNAME_CREATED_ON);
        if (field == null) {
            return null;
        }
        return field.getDate();
    }

    public String getCreatedBy() {
        Field field = this.getField(COLNAME_CREATED_BY);
        if (field == null) {
            return null;
        }
        return field.getString();
    }

    public Date getUpdatedOn() {
        Field field = this.getField(COLNAME_UPDATED_ON);
        if (field == null) {
            return null;
        }
        return field.getDate();
    }

    public String getUpdatedBy() {
        Field field = this.getField(COLNAME_UPDATED_BY);
        if (field == null) {
            return null;
        }
        return field.getString();
    }

    public void retrieve(PersistenceManager persistenceManager) throws PersistenceException, NoSuchObjectException {
        CloseableResultSet closeableResultSet = this.issueRetrieveQuery(persistenceManager);
        ResultSet resultSet = closeableResultSet.getResultSet();
        try {
            this.setApplicationsId(new DBObjectId(resultSet.getLong(COLNAME_APPLICATIONS_ID_FK)));
            this.setName(resultSet.getString(COLNAME_NAME));
            this.setUri(resultSet.getString(COLNAME_URI));
            this.setType(resultSet.getString(COLNAME_TYPE));
            this.setState(resultSet.getString(COLNAME_STATE));
            Object object = resultSet.getString(COLNAME_LANGUAGE);
            if (resultSet.wasNull()) {
                this.setLanguage(null);
            } else {
                this.setLanguage((String)object);
            }
            object = new DBObjectId(resultSet.getLong(COLNAME_SECURITY_GROUP_ID));
            if (resultSet.wasNull()) {
                this.setSecurityGroupId(null);
            } else {
                this.setSecurityGroupId((DBObjectId)object);
            }
            object = resultSet.getDate(COLNAME_CREATED_ON);
            if (resultSet.wasNull()) {
                this.setCreatedOn(null);
            } else {
                this.setCreatedOn((Date)object);
            }
            object = resultSet.getString(COLNAME_CREATED_BY);
            if (resultSet.wasNull()) {
                this.setCreatedBy(null);
            } else {
                this.setCreatedBy((String)object);
            }
            object = resultSet.getDate(COLNAME_UPDATED_ON);
            if (resultSet.wasNull()) {
                this.setUpdatedOn(null);
            } else {
                this.setUpdatedOn((Date)object);
            }
            object = resultSet.getString(COLNAME_UPDATED_BY);
            if (resultSet.wasNull()) {
                this.setUpdatedBy(null);
            } else {
                this.setUpdatedBy((String)object);
            }
        }
        catch (SQLException sQLException) {
            throw new PersistenceException(sQLException);
        }
        finally {
            closeableResultSet.close();
        }
        this.retrieveAdditionalProperties(persistenceManager);
        this.clearUpdatedFields();
    }

    @Override
    public String getObjectName() {
        return this.getName();
    }

    @Override
    public String getObjectNameFieldName() {
        return COLNAME_NAME;
    }

    public void rename(String string) {
        this.setName(string);
    }

    @Override
    protected String getStorageTableName() {
        return TABLE_NAME;
    }
}

