/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.metadata.persistence;

import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.dbtools.metadata.persistence.ClobHelper;
import oracle.dbtools.metadata.persistence.CloseableResultSet;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.Field;
import oracle.dbtools.metadata.persistence.NoSuchObjectException;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;

public class MdColumn
extends PersistableObject {
    public static final String TABLE_NAME = "MD_COLUMNS";
    public static final String COLNAME_TABLE_ID_FK = "TABLE_ID_FK";
    public static final String COLNAME_COLUMN_NAME = "COLUMN_NAME";
    public static final String COLNAME_COLUMN_ORDER = "COLUMN_ORDER";
    public static final String COLNAME_COLUMN_TYPE = "COLUMN_TYPE";
    public static final String COLNAME_PRECISION = "PRECISION";
    public static final String COLNAME_SCALE = "SCALE";
    public static final String COLNAME_NULLABLE = "NULLABLE";
    public static final String COLNAME_DEFAULT_VALUE = "DEFAULT_VALUE";
    public static final String COLNAME_NATIVE_SQL = "NATIVE_SQL";
    public static final String COLNAME_NATIVE_KEY = "NATIVE_KEY";
    public static final String COLNAME_DATATYPE_TRANSFORMED_FLAG = "DATATYPE_TRANSFORMED_FLAG";
    public static final String COLNAME_SECURITY_GROUP_ID = "SECURITY_GROUP_ID";
    public static final String COLNAME_CREATED_BY = "CREATED_BY";
    public static final String COLNAME_CREATED_ON = "CREATED_ON";
    public static final String COLNAME_LAST_UPDATED_BY = "LAST_UPDATED_BY";
    public static final String COLNAME_LAST_UPDATED_ON = "LAST_UPDATED_ON";
    public static final String COLNAME_COMMENTS = "COMMENTS";

    public MdColumn(DBObjectId dBObjectId, String string, Integer n) {
        this.setTableId(dBObjectId);
        this.setColumnName(string);
        this.setColumnOrder(n);
    }

    public static MdColumn getExistingInstance(DBObjectId dBObjectId) {
        MdColumn mdColumn = new MdColumn();
        mdColumn.setKey(dBObjectId);
        return mdColumn;
    }

    private MdColumn() {
    }

    public static MdColumn retrieveExistingInstance(PersistenceManager persistenceManager, DBObjectId dBObjectId) throws PersistenceException, NoSuchObjectException {
        MdColumn mdColumn = MdColumn.getExistingInstance(dBObjectId);
        mdColumn.retrieve(persistenceManager);
        return mdColumn;
    }

    protected void setTableId(DBObjectId dBObjectId) {
        Field field = new Field(COLNAME_TABLE_ID_FK, "DBOBJECTID", false);
        field.setValue(dBObjectId);
        this.setField(field);
    }

    protected void setColumnName(String string) {
        Field field = new Field(COLNAME_COLUMN_NAME, "STRING", false);
        field.setValue(string);
        this.setField(field);
    }

    protected void setColumnOrder(Integer n) {
        Field field = new Field(COLNAME_COLUMN_ORDER, "INTEGER", false);
        field.setValue(n);
        this.setField(field);
    }

    public void setColumnType(String string) {
        Field field = new Field(COLNAME_COLUMN_TYPE, "STRING");
        field.setValue(string);
        this.setField(field);
    }

    public void setPrecision(Integer n) {
        Field field = new Field(COLNAME_PRECISION, "INTEGER");
        field.setValue(n);
        this.setField(field);
    }

    public void setScale(Integer n) {
        Field field = new Field(COLNAME_SCALE, "INTEGER");
        field.setValue(n);
        this.setField(field);
    }

    public void setNullable(String string) {
        Field field = new Field(COLNAME_NULLABLE, "STRING");
        field.setValue(string);
        this.setField(field);
    }

    public void setDefaultValue(String string) {
        Field field = new Field(COLNAME_DEFAULT_VALUE, "STRING");
        field.setValue(string);
        this.setField(field);
    }

    public void setNativeSql(String string) {
        Field field = new Field(COLNAME_NATIVE_SQL, "CLOBHELPER");
        ClobHelper clobHelper = new ClobHelper(string);
        field.setValue(clobHelper);
        this.setField(field);
    }

    public void setNativeSql(ClobHelper clobHelper) {
        Field field = new Field(COLNAME_NATIVE_SQL, "CLOBHELPER");
        field.setValue(clobHelper);
        this.setField(field);
    }

    public void setNativeKey(String string) {
        Field field = new Field(COLNAME_NATIVE_KEY, "STRING");
        field.setValue(string);
        this.setField(field);
    }

    public void setDatatypeTransformedFlag(String string) {
        Field field = new Field(COLNAME_DATATYPE_TRANSFORMED_FLAG, "STRING");
        field.setValue(string);
        this.setField(field);
    }

    public void setSecurityGroupId(DBObjectId dBObjectId) {
        Field field = new Field(COLNAME_SECURITY_GROUP_ID, "DBOBJECTID");
        field.setValue(dBObjectId);
        this.setField(field);
    }

    public void setCreatedBy(String string) {
        Field field = new Field(COLNAME_CREATED_BY, "STRING");
        field.setValue(string);
        this.setField(field);
    }

    public void setCreatedOn(Date date) {
        Field field = new Field(COLNAME_CREATED_ON, "DATE");
        field.setValue(date);
        this.setField(field);
    }

    public void setLastUpdatedBy(String string) {
        Field field = new Field(COLNAME_LAST_UPDATED_BY, "STRING");
        field.setValue(string);
        this.setField(field);
    }

    public void setLastUpdatedOn(Date date) {
        Field field = new Field(COLNAME_LAST_UPDATED_ON, "DATE");
        field.setValue(date);
        this.setField(field);
    }

    public void setComments(String string) {
        Field field = new Field(COLNAME_COMMENTS, "STRING");
        field.setValue(string);
        this.setField(field);
    }

    public DBObjectId getTableId() {
        Field field = this.getField(COLNAME_TABLE_ID_FK);
        if (field == null) {
            return null;
        }
        return field.getDBObjectId();
    }

    public String getColumnName() {
        Field field = this.getField(COLNAME_COLUMN_NAME);
        if (field == null) {
            return null;
        }
        return field.getString();
    }

    public Integer getColumnOrder() {
        Field field = this.getField(COLNAME_COLUMN_ORDER);
        if (field == null) {
            return null;
        }
        return field.getInteger();
    }

    public String getColumnType() {
        Field field = this.getField(COLNAME_COLUMN_TYPE);
        if (field == null) {
            return null;
        }
        return field.getString();
    }

    public Integer getPrecision() {
        Field field = this.getField(COLNAME_PRECISION);
        if (field == null) {
            return null;
        }
        return field.getInteger();
    }

    public Integer getScale() {
        Field field = this.getField(COLNAME_SCALE);
        if (field == null) {
            return null;
        }
        return field.getInteger();
    }

    public String getNullable() {
        Field field = this.getField(COLNAME_NULLABLE);
        if (field == null) {
            return null;
        }
        return field.getString();
    }

    public String getDefaultValue() {
        Field field = this.getField(COLNAME_DEFAULT_VALUE);
        if (field == null) {
            return null;
        }
        return field.getString();
    }

    public ClobHelper getNativeSql() {
        Field field = this.getField(COLNAME_NATIVE_SQL);
        if (field == null) {
            return null;
        }
        return field.getClobHelper();
    }

    public String getNativeKey() {
        Field field = this.getField(COLNAME_NATIVE_KEY);
        if (field == null) {
            return null;
        }
        return field.getString();
    }

    public String getDatatypeTransformedFlag() {
        Field field = this.getField(COLNAME_DATATYPE_TRANSFORMED_FLAG);
        if (field == null) {
            return null;
        }
        return field.getString();
    }

    public DBObjectId getSecurityGroupId() {
        Field field = this.getField(COLNAME_SECURITY_GROUP_ID);
        if (field == null) {
            return null;
        }
        return field.getDBObjectId();
    }

    public String getCreatedBy() {
        Field field = this.getField(COLNAME_CREATED_BY);
        if (field == null) {
            return null;
        }
        return field.getString();
    }

    public Date getCreatedOn() {
        Field field = this.getField(COLNAME_CREATED_ON);
        if (field == null) {
            return null;
        }
        return field.getDate();
    }

    public String getLastUpdatedBy() {
        Field field = this.getField(COLNAME_LAST_UPDATED_BY);
        if (field == null) {
            return null;
        }
        return field.getString();
    }

    public Date getLastUpdatedOn() {
        Field field = this.getField(COLNAME_LAST_UPDATED_ON);
        if (field == null) {
            return null;
        }
        return field.getDate();
    }

    public String getComments() {
        Field field = this.getField(COLNAME_COMMENTS);
        if (field == null) {
            return null;
        }
        return field.getString();
    }

    public void retrieve(PersistenceManager persistenceManager) throws PersistenceException, NoSuchObjectException {
        CloseableResultSet closeableResultSet = this.issueRetrieveQuery(persistenceManager);
        ResultSet resultSet = closeableResultSet.getResultSet();
        try {
            this.setTableId(new DBObjectId(resultSet.getLong(COLNAME_TABLE_ID_FK)));
            this.setColumnName(resultSet.getString(COLNAME_COLUMN_NAME));
            this.setColumnOrder(resultSet.getInt(COLNAME_COLUMN_ORDER));
            Object object = resultSet.getString(COLNAME_COLUMN_TYPE);
            if (resultSet.wasNull()) {
                this.setColumnType(null);
            } else {
                this.setColumnType((String)object);
            }
            object = resultSet.getInt(COLNAME_PRECISION);
            if (resultSet.wasNull()) {
                this.setPrecision(null);
            } else {
                this.setPrecision((Integer)object);
            }
            object = resultSet.getInt(COLNAME_SCALE);
            if (resultSet.wasNull()) {
                this.setScale(null);
            } else {
                this.setScale((Integer)object);
            }
            object = resultSet.getString(COLNAME_NULLABLE);
            if (resultSet.wasNull()) {
                this.setNullable(null);
            } else {
                this.setNullable((String)object);
            }
            object = resultSet.getString(COLNAME_DEFAULT_VALUE);
            if (resultSet.wasNull()) {
                this.setDefaultValue(null);
            } else {
                this.setDefaultValue((String)object);
            }
            object = new ClobHelper(resultSet.getClob(COLNAME_NATIVE_SQL));
            if (resultSet.wasNull()) {
                this.setNativeSql((ClobHelper)null);
            } else {
                this.setNativeSql((ClobHelper)object);
            }
            object = resultSet.getString(COLNAME_NATIVE_KEY);
            if (resultSet.wasNull()) {
                this.setNativeKey(null);
            } else {
                this.setNativeKey((String)object);
            }
            object = resultSet.getString(COLNAME_DATATYPE_TRANSFORMED_FLAG);
            if (resultSet.wasNull()) {
                this.setDatatypeTransformedFlag(null);
            } else {
                this.setDatatypeTransformedFlag((String)object);
            }
            object = new DBObjectId(resultSet.getLong(COLNAME_SECURITY_GROUP_ID));
            if (resultSet.wasNull()) {
                this.setSecurityGroupId(null);
            } else {
                this.setSecurityGroupId((DBObjectId)object);
            }
            object = resultSet.getString(COLNAME_CREATED_BY);
            if (resultSet.wasNull()) {
                this.setCreatedBy(null);
            } else {
                this.setCreatedBy((String)object);
            }
            object = resultSet.getDate(COLNAME_CREATED_ON);
            if (resultSet.wasNull()) {
                this.setCreatedOn(null);
            } else {
                this.setCreatedOn((Date)object);
            }
            object = resultSet.getString(COLNAME_LAST_UPDATED_BY);
            if (resultSet.wasNull()) {
                this.setLastUpdatedBy(null);
            } else {
                this.setLastUpdatedBy((String)object);
            }
            object = resultSet.getDate(COLNAME_LAST_UPDATED_ON);
            if (resultSet.wasNull()) {
                this.setLastUpdatedOn(null);
            } else {
                this.setLastUpdatedOn((Date)object);
            }
            object = resultSet.getString(COLNAME_COMMENTS);
            if (resultSet.wasNull()) {
                this.setComments(null);
            } else {
                this.setComments((String)object);
            }
        }
        catch (SQLException sQLException) {
            throw new PersistenceException(sQLException);
        }
        finally {
            closeableResultSet.close();
        }
        this.retrieveAdditionalProperties(persistenceManager);
        this.clearUpdatedFields();
    }

    @Override
    public String getObjectName() {
        return this.getColumnName();
    }

    @Override
    public String getObjectNameFieldName() {
        return COLNAME_COLUMN_NAME;
    }

    public void rename(String string) {
        this.setColumnName(string);
    }

    @Override
    public String getContainerFieldName() {
        return COLNAME_TABLE_ID_FK;
    }

    @Override
    public DBObjectId getContainerId() {
        return this.getTableId();
    }

    public boolean getNullableFlag() {
        return this.getNullable().equalsIgnoreCase("Y");
    }

    public String getUnit() {
        if (this.getColumnType().equals("VARCHAR2") || this.getColumnType().equals("CHAR")) {
            return "CHAR";
        }
        return null;
    }

    @Override
    protected String getStorageTableName() {
        return TABLE_NAME;
    }

    public String getIdentityClause() {
        String string = this.getProperty("REALIDENTITY");
        Object var2_2 = null;
        if (string != null) {
            return " " + string + " ";
        }
        return null;
    }
}

