/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.metadata.persistence;

import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.dbtools.metadata.persistence.ClobHelper;
import oracle.dbtools.metadata.persistence.CloseableResultSet;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.Field;
import oracle.dbtools.metadata.persistence.NoSuchObjectException;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;

public class MdIndexe
extends PersistableObject {
    public static final String TABLE_NAME = "MD_INDEXES";
    public static final String COLNAME_INDEX_TYPE = "INDEX_TYPE";
    public static final String COLNAME_TABLE_ID_FK = "TABLE_ID_FK";
    public static final String COLNAME_INDEX_NAME = "INDEX_NAME";
    public static final String COLNAME_NATIVE_SQL = "NATIVE_SQL";
    public static final String COLNAME_NATIVE_KEY = "NATIVE_KEY";
    public static final String COLNAME_SECURITY_GROUP_ID = "SECURITY_GROUP_ID";
    public static final String COLNAME_CREATED_ON = "CREATED_ON";
    public static final String COLNAME_CREATED_BY = "CREATED_BY";
    public static final String COLNAME_LAST_UPDATED_ON = "LAST_UPDATED_ON";
    public static final String COLNAME_LAST_UPDATED_BY = "LAST_UPDATED_BY";
    public static final String COLNAME_COMMENTS = "COMMENTS";

    public MdIndexe(DBObjectId dBObjectId) {
        this.setTableId(dBObjectId);
    }

    public static MdIndexe getExistingInstance(DBObjectId dBObjectId) {
        MdIndexe mdIndexe = new MdIndexe();
        mdIndexe.setKey(dBObjectId);
        return mdIndexe;
    }

    private MdIndexe() {
    }

    public static MdIndexe retrieveExistingInstance(PersistenceManager persistenceManager, DBObjectId dBObjectId) throws PersistenceException, NoSuchObjectException {
        MdIndexe mdIndexe = MdIndexe.getExistingInstance(dBObjectId);
        mdIndexe.retrieve(persistenceManager);
        return mdIndexe;
    }

    public void setIndexType(String string) {
        Field field = new Field(COLNAME_INDEX_TYPE, "STRING");
        field.setValue(string);
        this.setField(field);
    }

    protected void setTableId(DBObjectId dBObjectId) {
        Field field = new Field(COLNAME_TABLE_ID_FK, "DBOBJECTID", false);
        field.setValue(dBObjectId);
        this.setField(field);
    }

    public void setIndexName(String string) {
        Field field = new Field(COLNAME_INDEX_NAME, "STRING");
        field.setValue(string);
        this.setField(field);
    }

    public void setNativeSql(String string) {
        Field field = new Field(COLNAME_NATIVE_SQL, "CLOBHELPER");
        ClobHelper clobHelper = new ClobHelper(string);
        field.setValue(clobHelper);
        this.setField(field);
    }

    public void setNativeSql(ClobHelper clobHelper) {
        Field field = new Field(COLNAME_NATIVE_SQL, "CLOBHELPER");
        field.setValue(clobHelper);
        this.setField(field);
    }

    public void setNativeKey(String string) {
        Field field = new Field(COLNAME_NATIVE_KEY, "STRING");
        field.setValue(string);
        this.setField(field);
    }

    public void setSecurityGroupId(DBObjectId dBObjectId) {
        Field field = new Field(COLNAME_SECURITY_GROUP_ID, "DBOBJECTID");
        field.setValue(dBObjectId);
        this.setField(field);
    }

    public void setCreatedOn(Date date) {
        Field field = new Field(COLNAME_CREATED_ON, "DATE");
        field.setValue(date);
        this.setField(field);
    }

    public void setCreatedBy(String string) {
        Field field = new Field(COLNAME_CREATED_BY, "STRING");
        field.setValue(string);
        this.setField(field);
    }

    public void setLastUpdatedOn(Date date) {
        Field field = new Field(COLNAME_LAST_UPDATED_ON, "DATE");
        field.setValue(date);
        this.setField(field);
    }

    public void setLastUpdatedBy(String string) {
        Field field = new Field(COLNAME_LAST_UPDATED_BY, "STRING");
        field.setValue(string);
        this.setField(field);
    }

    public void setComments(String string) {
        Field field = new Field(COLNAME_COMMENTS, "STRING");
        field.setValue(string);
        this.setField(field);
    }

    public String getIndexType() {
        Field field = this.getField(COLNAME_INDEX_TYPE);
        if (field == null) {
            return null;
        }
        return field.getString();
    }

    public DBObjectId getTableId() {
        Field field = this.getField(COLNAME_TABLE_ID_FK);
        if (field == null) {
            return null;
        }
        return field.getDBObjectId();
    }

    public String getIndexName() {
        Field field = this.getField(COLNAME_INDEX_NAME);
        if (field == null) {
            return null;
        }
        return field.getString();
    }

    public ClobHelper getNativeSql() {
        Field field = this.getField(COLNAME_NATIVE_SQL);
        if (field == null) {
            return null;
        }
        return field.getClobHelper();
    }

    public String getNativeKey() {
        Field field = this.getField(COLNAME_NATIVE_KEY);
        if (field == null) {
            return null;
        }
        return field.getString();
    }

    public DBObjectId getSecurityGroupId() {
        Field field = this.getField(COLNAME_SECURITY_GROUP_ID);
        if (field == null) {
            return null;
        }
        return field.getDBObjectId();
    }

    public Date getCreatedOn() {
        Field field = this.getField(COLNAME_CREATED_ON);
        if (field == null) {
            return null;
        }
        return field.getDate();
    }

    public String getCreatedBy() {
        Field field = this.getField(COLNAME_CREATED_BY);
        if (field == null) {
            return null;
        }
        return field.getString();
    }

    public Date getLastUpdatedOn() {
        Field field = this.getField(COLNAME_LAST_UPDATED_ON);
        if (field == null) {
            return null;
        }
        return field.getDate();
    }

    public String getLastUpdatedBy() {
        Field field = this.getField(COLNAME_LAST_UPDATED_BY);
        if (field == null) {
            return null;
        }
        return field.getString();
    }

    public String getComments() {
        Field field = this.getField(COLNAME_COMMENTS);
        if (field == null) {
            return null;
        }
        return field.getString();
    }

    public void retrieve(PersistenceManager persistenceManager) throws PersistenceException, NoSuchObjectException {
        CloseableResultSet closeableResultSet = this.issueRetrieveQuery(persistenceManager);
        ResultSet resultSet = closeableResultSet.getResultSet();
        try {
            Object object = resultSet.getString(COLNAME_INDEX_TYPE);
            if (resultSet.wasNull()) {
                this.setIndexType(null);
            } else {
                this.setIndexType((String)object);
            }
            this.setTableId(new DBObjectId(resultSet.getLong(COLNAME_TABLE_ID_FK)));
            object = resultSet.getString(COLNAME_INDEX_NAME);
            if (resultSet.wasNull()) {
                this.setIndexName(null);
            } else {
                this.setIndexName((String)object);
            }
            object = new ClobHelper(resultSet.getClob(COLNAME_NATIVE_SQL));
            if (resultSet.wasNull()) {
                this.setNativeSql((ClobHelper)null);
            } else {
                this.setNativeSql((ClobHelper)object);
            }
            object = resultSet.getString(COLNAME_NATIVE_KEY);
            if (resultSet.wasNull()) {
                this.setNativeKey(null);
            } else {
                this.setNativeKey((String)object);
            }
            object = new DBObjectId(resultSet.getLong(COLNAME_SECURITY_GROUP_ID));
            if (resultSet.wasNull()) {
                this.setSecurityGroupId(null);
            } else {
                this.setSecurityGroupId((DBObjectId)object);
            }
            object = resultSet.getDate(COLNAME_CREATED_ON);
            if (resultSet.wasNull()) {
                this.setCreatedOn(null);
            } else {
                this.setCreatedOn((Date)object);
            }
            object = resultSet.getString(COLNAME_CREATED_BY);
            if (resultSet.wasNull()) {
                this.setCreatedBy(null);
            } else {
                this.setCreatedBy((String)object);
            }
            object = resultSet.getDate(COLNAME_LAST_UPDATED_ON);
            if (resultSet.wasNull()) {
                this.setLastUpdatedOn(null);
            } else {
                this.setLastUpdatedOn((Date)object);
            }
            object = resultSet.getString(COLNAME_LAST_UPDATED_BY);
            if (resultSet.wasNull()) {
                this.setLastUpdatedBy(null);
            } else {
                this.setLastUpdatedBy((String)object);
            }
            object = resultSet.getString(COLNAME_COMMENTS);
            if (resultSet.wasNull()) {
                this.setComments(null);
            } else {
                this.setComments((String)object);
            }
        }
        catch (SQLException sQLException) {
            throw new PersistenceException(sQLException);
        }
        finally {
            closeableResultSet.close();
        }
        this.retrieveAdditionalProperties(persistenceManager);
        this.clearUpdatedFields();
    }

    @Override
    public String getObjectName() {
        return this.getIndexName();
    }

    @Override
    public String getObjectNameFieldName() {
        return COLNAME_INDEX_NAME;
    }

    public void rename(String string) {
        this.setIndexName(string);
    }

    @Override
    public String getContainerFieldName() {
        return COLNAME_TABLE_ID_FK;
    }

    @Override
    public DBObjectId getContainerId() {
        return this.getTableId();
    }

    @Override
    protected String getStorageTableName() {
        return TABLE_NAME;
    }
}

