/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.capture;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.metadata.persistence.MdConnection;
import oracle.dbtools.metadata.persistence.MdProject;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.metadata.persistence.PersistenceUtility;
import oracle.dbtools.migration.capture.CaptureException;
import oracle.dbtools.migration.capture.CaptureWorker;
import oracle.dbtools.migration.capture.EMDataMover;
import oracle.dbtools.migration.capture.EMManager;
import oracle.dbtools.migration.capture.EMSQL;
import oracle.dbtools.migration.capture.Messages;
import oracle.dbtools.migration.capture.OfflineCaptureWorker;
import oracle.dbtools.migration.capture.offline.OfflineCaptureException;
import oracle.dbtools.migration.capture.offline.OfflineCapturer;
import oracle.dbtools.migration.command_line.CMDLineError;
import oracle.dbtools.migration.command_line.CMDOut;
import oracle.dbtools.migration.command_line.CMDUtil;
import oracle.dbtools.migration.command_line.MigrationCmd;
import oracle.dbtools.migration.command_line.MigrationCmdRunner;
import oracle.dbtools.migration.command_line.MigrationDetails;
import oracle.dbtools.migration.core.util.MigrationUtils;
import oracle.dbtools.migration.parser.internalapi.ITranslationAll;
import oracle.dbtools.migration.parser.internalapi.TranslateResultWithASTs;
import oracle.dbtools.migration.workbench.core.BasicMigrationStorer;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.MigrationPlugin;
import oracle.dbtools.migration.workbench.core.MigrationStorer;
import oracle.dbtools.migration.workbench.core.logging.MigrationLogUtil;
import oracle.dbtools.migration.workbench.core.ui.quickmigrate.QMWizard;
import oracle.dbtools.raptor.proxy.driver.oracle.RaptorProxyOJDBCConnection;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.JDBCProxyUtil;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.OraclePreparedStatement;
import oracle.sql.CLOB;

public class CaptureCmd
extends MigrationCmd {
    public static final String CMDNAME = "capture";
    public static final String STAGE_PULL = "stage pull";
    private boolean _remoteDebugging;
    private CountDownLatch _latch = new CountDownLatch(1);
    private InlineSQLTranslator m_inlineSQLTranslator = null;
    private EMManager m_emManager = null;
    private HashMap<String, Integer> m_tableToNumberOfRows = new HashMap();
    private HashMap<String, Integer> m_databaseMap = null;
    private HashMap<Integer, Long> m_sourceToRepoDBID = new HashMap();
    private CaptureDetails m_captureDetails = null;
    private long m_currentDBID = 0L;
    private long m_currentServerID = 0L;
    private long m_currentSchemaID = 0L;
    private long m_currentProjectID = 0L;
    private String m_serverName = null;
    private String m_projectName = null;
    private String m_dbFilter = null;
    private String[] excludeDBArray = new String[]{"model", "master", "sybsystemprocs", "sybsystemdb", "tempdb", "sybsecurity", "dbccdb", "sybmgmtdb", "sybmigratedb", "mtpdb$1$1"};
    private static Logger s_logger = Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle");
    private ArrayList<CLOB> downloadUploadList = new ArrayList();
    private PersistenceUtility _persistenceUtility;
    private Statement _stmt = null;
    private Statement _stmtTp = null;

    public CaptureCmd() {
        super(CMDNAME, null, null, true);
        this.m_captureDetails = new CaptureDetails(new MigrationDetails());
    }

    public CaptureCmd(MigrationDetails migrationDetails, CMDOut cMDOut, boolean bl) {
        super(CMDNAME, migrationDetails, cMDOut, bl);
        this.m_captureDetails = new CaptureDetails(migrationDetails);
    }

    private void captureDatabaseMetadata(String string, CaptureDetails captureDetails, String string2) {
        this.reportStartingDatabase(string);
        for (EMDataMover eMDataMover : this.getPerDatabaseDataMovers()) {
            try {
                this.captureTable(eMDataMover, captureDetails, CMDUtil.getRepositoryConnectionName(), string);
            }
            catch (CMDLineError cMDLineError) {
                this.getCmdout().printError(cMDLineError);
                this.logToStage(this.getCurrentServerID(), this.getCurrentDBID(), 0L, null, 1000, "captureDatabaseMetadata method: " + string + ":" + cMDLineError.getMessage(), STAGE_PULL);
            }
        }
    }

    private void captureIntoStagingTables(CaptureDetails captureDetails) throws CMDLineError {
        this.m_databaseMap = this.getListOfSourceDatabasesOnServer(captureDetails);
        this.captureOneOffs(captureDetails, CMDUtil.getRepositoryConnectionName());
        for (String string : this.m_databaseMap.keySet()) {
            this.setCurrentDatabaseID(this.m_databaseMap.get(string));
            this.captureDatabaseMetadata(string, captureDetails, CMDUtil.getRepositoryConnectionName());
        }
        this.printSummaryInfo();
    }

    private void captureOneOffs(CaptureDetails captureDetails, String string) throws CMDLineError {
        this.printCapturingServerDetails();
        for (EMDataMover eMDataMover : this.getOneOffs()) {
            try {
                this.captureTable(eMDataMover, captureDetails, CMDUtil.getRepositoryConnectionName(), null);
            }
            catch (CMDLineError cMDLineError) {
                throw new CMDLineError(CMDNAME, "Problem capturing table " + eMDataMover.getSourceQuery().getProperty("source"), cMDLineError);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void captureTable(EMDataMover eMDataMover, CaptureDetails captureDetails, String string, String string2) throws CMDLineError {
        String string3 = null;
        ResultSet resultSet = null;
        Connection connection = null;
        ArrayList<KeyValue> arrayList = new ArrayList<KeyValue>();
        if (string2 != null) {
            arrayList.add(new KeyValue("/*DBNAME*/", string2));
        }
        arrayList.add(new KeyValue("/*DB_WHERE_CLAUSE*/", this.getDBFilter(captureDetails)));
        try {
            string3 = eMDataMover.getSourceQuery().getSQL(arrayList);
            if (string3 != null) {
                connection = CMDUtil.getConnectionFromSimpleName(captureDetails.getSourceName());
                this._stmtTp = connection.prepareStatement(string3);
                resultSet = ((PreparedStatement)this._stmtTp).executeQuery();
            }
            String string4 = eMDataMover.getSourceQuery().getProperty("source");
            int n = this.insertResultSet(resultSet, eMDataMover, captureDetails);
            if (string4 == null) {
                string4 = eMDataMover.getStageInsert().getProperty("source");
            }
            this.logInsertInformation(n, captureDetails, string2, string4, eMDataMover.getStageInsert().getProperty("target"));
        }
        catch (Exception exception) {
            this.getCmdout().printError(exception.getLocalizedMessage());
            this.logToStage(this.getCurrentServerID(), this.getCurrentDBID(), 0L, null, 1000, "captureTable method: " + string2 + ":" + string3 + ":" + exception.getMessage(), STAGE_PULL);
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (this._stmtTp != null) {
                    this._stmtTp.close();
                }
            }
            catch (Exception exception) {
                this.getCmdout().printError(exception);
                this.logToStage(this.getCurrentServerID(), this.getCurrentDBID(), 0L, null, 1000, "captureTable method: rs/stmt close issue : " + exception.getMessage(), STAGE_PULL);
            }
        }
    }

    private void checkAndUpdateProjectDetail(CaptureDetails captureDetails) {
        String string = captureDetails.get("PROJECT_ID");
        String string2 = captureDetails.get("project");
        String string3 = "UPDATE STAGE_SERVERDETAIL SET PROJECT_ID=" + string + ", PROJECT_NAME= '" + string2 + "' WHERE PROJECT_ID=" + this.m_currentProjectID;
        if (string != null) {
            DBUtil dBUtil = null;
            try {
                dBUtil = DBUtil.getInstance((String)CMDUtil.getRepositoryConnectionName());
                dBUtil.execute(string3);
            }
            catch (Exception exception) {
                this.getCmdout().printError(exception);
                this.logToStage(this.getCurrentServerID(), this.getCurrentDBID(), 0L, null, 1000, this.m_serverName + ":checkAndUpdateProjectDetail method : " + exception.getMessage(), STAGE_PULL);
            }
        }
    }

    private void createStagingTables(MigrationPlugin migrationPlugin) throws CMDLineError {
        String string = CMDUtil.getRepositoryConnectionName();
        for (EMSQL eMSQL : this.getEMManager().getStageDDL()) {
            if (eMSQL.getSQL().trim().equalsIgnoreCase("NULL")) continue;
            this.executeSQL(eMSQL.getSQL(), string, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void dbg_plsql(Connection connection) {
        OracleCallableStatement oracleCallableStatement = null;
        if (connection != null && !this._remoteDebugging) {
            try {
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("{call DBMS_DEBUG_JDWP.CONNECT_TCP( ?, ? )}");
                oracleCallableStatement.setString(1, "localhost");
                oracleCallableStatement.setInt(2, 4000);
                oracleCallableStatement.execute();
                this._remoteDebugging = true;
            }
            catch (SQLException sQLException) {
                this.getCmdout().printError("Debug Exception : " + sQLException.getMessage());
            }
            finally {
                try {
                    if (oracleCallableStatement != null) {
                        oracleCallableStatement.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    private CLOB downloadUpload(Clob clob, Connection connection) throws IOException, SQLException {
        JDBCProxyUtil jDBCProxyUtil;
        if (connection instanceof RaptorProxyOJDBCConnection) {
            jDBCProxyUtil = JDBCProxyUtil.getInstance((ClassLoader)this.getClass().getClassLoader());
            connection = (Connection)jDBCProxyUtil.unwrap((Object)connection);
        }
        if (clob == null) {
            return null;
        }
        jDBCProxyUtil = CLOB.createTemporary((Connection)connection, (boolean)true, (int)10);
        this.downloadUploadList.add((CLOB)jDBCProxyUtil);
        jDBCProxyUtil.open(1);
        Reader reader = clob.getCharacterStream();
        Writer writer = jDBCProxyUtil.setCharacterStream(1L);
        int n = jDBCProxyUtil.getChunkSize();
        char[] cArray = new char[n];
        int n2 = 0;
        while ((n2 = reader.read(cArray, 0, n)) != -1) {
            writer.write(cArray, 0, n2);
        }
        reader.close();
        writer.flush();
        writer.close();
        return jDBCProxyUtil;
    }

    private void dropStagingTables(MigrationPlugin migrationPlugin) throws CMDLineError {
        String string = CMDUtil.getRepositoryConnectionName();
        this.m_captureDetails.m_details.getOut().printMessage(Messages.getString("StageInitiated"));
        for (String string2 : this.getDropStageSQL()) {
            try {
                this.executeSQL(string2, string, false);
            }
            catch (CMDLineError cMDLineError) {}
        }
    }

    @Override
    protected void executeImpl() throws CMDLineError {
        Thread.currentThread().setContextClassLoader(CaptureCmd.class.getClassLoader());
        MigrationCmdRunner.setupSQLDeveloper();
        this.verifyRepository();
        this.runCapture(this.getCaptureDetails());
    }

    private void executeSQL(String string, String string2, boolean bl) throws CMDLineError {
        try {
            Connection connection = Connections.getInstance().getConnection(string2);
            boolean bl2 = Connections.getInstance().isOracle(string2);
            if (bl2) {
                this._stmt = connection.createStatement();
                this._stmt.execute(string);
            } else {
                this._stmtTp = connection.createStatement();
                this._stmtTp.execute(string);
            }
        }
        catch (Exception exception) {
            throw new CMDLineError(CMDNAME, "Problem executing SQL : " + string, exception);
        }
        finally {
            try {
                if (this._stmt != null) {
                    this._stmt.close();
                    this._stmt = null;
                }
            }
            catch (Exception exception) {
                throw new CMDLineError(CMDNAME, "Problem closing statement", exception);
            }
            try {
                if (this._stmtTp != null) {
                    this._stmtTp.close();
                    this._stmtTp = null;
                }
            }
            catch (Exception exception) {
                throw new CMDLineError(CMDNAME, "Problem closing statement", exception);
            }
        }
    }

    private void freeClob() {
        while (this.downloadUploadList.size() != 0) {
            CLOB cLOB = this.downloadUploadList.remove(0);
            try {
                cLOB.freeTemporary();
            }
            catch (SQLException sQLException) {
                this.getCmdout().printError(sQLException);
                this.logToStage(this.getCurrentServerID(), this.getCurrentDBID(), 0L, null, 1000, this.m_serverName + ":freeClob method : " + sQLException.getMessage(), STAGE_PULL);
            }
        }
    }

    private String getBindList(ResultSetMetaData resultSetMetaData, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = this.getColumnCount(resultSetMetaData);
        for (int i = 1; i <= n2 + n; ++i) {
            stringBuffer.append(":x" + i + ",");
        }
        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        return stringBuffer.toString();
    }

    private CaptureDetails getCaptureDetails() {
        return this.m_captureDetails;
    }

    private int getColumnCount(ResultSetMetaData resultSetMetaData) {
        int n = 0;
        int n2 = 0;
        try {
            n2 = n = resultSetMetaData.getColumnCount();
            for (int i = 1; i <= n; ++i) {
                if (!resultSetMetaData.getColumnName(i).equalsIgnoreCase("translate_flag")) continue;
                --n2;
            }
        }
        catch (SQLException sQLException) {
            this.getCmdout().printError(sQLException);
            this.logToStage(this.getCurrentServerID(), this.getCurrentDBID(), 0L, null, 1000, this.m_serverName + ":getColumnCount method : " + sQLException.getMessage(), STAGE_PULL);
        }
        return n2;
    }

    private String getConditions(String string, String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" (");
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i].toUpperCase();
            if (i != 0) {
                stringBuffer.append(" OR " + string + "'" + string2 + "'");
                continue;
            }
            stringBuffer.append(string + "'" + string2 + "'");
        }
        stringBuffer.append(") ");
        return stringBuffer.toString();
    }

    private long getCurrentDBID() {
        return this.m_currentDBID;
    }

    public long getCurrentProjectID() {
        if (0L == this.m_currentProjectID) {
            MdProject mdProject = null;
            try {
                mdProject = this.getPersistenceUtility().getNamedProject(this.getProjectName());
            }
            catch (PersistenceException persistenceException) {
                throw new IllegalStateException(persistenceException);
            }
            if (mdProject != null) {
                this.m_currentProjectID = mdProject.getKey().getId();
            }
        }
        return this.m_currentProjectID;
    }

    private long getCurrentServerID() {
        return this.m_currentServerID;
    }

    private String getDatabaseListQuery() throws CMDLineError {
        ArrayList<KeyValue> arrayList = new ArrayList<KeyValue>();
        arrayList.add(new KeyValue("/*DB_WHERE_CLAUSE*/", this.getDBFilter(this.getCaptureDetails())));
        return this.getEMManager().getDatabaseListQuery().getSQL(arrayList);
    }

    private String getDB_name() throws CaptureException {
        if (this.getModelName() != null) {
            return this.getModelName();
        }
        if (this.m_serverName == null) {
            this.m_serverName = CaptureWorker.getModelConnectionName();
        }
        return this.m_serverName;
    }

    private String getDBFilter(CaptureDetails captureDetails) throws CMDLineError {
        if (this.m_dbFilter == null) {
            if (captureDetails.isDatabaseCapture()) {
                Connection connection = CMDUtil.getConnectionFromSimpleName(captureDetails.getSourceName());
                Properties properties = Connections.getInstance().getConnectionInfo(Connections.getInstance().getConnectionName(connection));
                String string = (String)properties.get("customUrl");
                string = string.substring(string.lastIndexOf(47) + 1);
                this.m_dbFilter = "WHERE UPPER(name) = '" + string.toUpperCase() + "' ";
            } else if (captureDetails.isDBListSpecified()) {
                String[] stringArray = captureDetails.getDBList();
                if (stringArray != null) {
                    String string = " WHERE " + this.getConditions("UPPER(name) =", stringArray);
                    this.m_dbFilter = string + " ";
                }
            } else {
                this.m_dbFilter = " WHERE " + this.getConditions("LOWER(name) <>", this.excludeDBArray);
            }
        }
        return this.m_dbFilter;
    }

    private ArrayList<String> getDropStageSQL() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (EMSQL eMSQL : this.getEMManager().getStageDDL()) {
            if (eMSQL.getProperty("tablename") != null) {
                arrayList.add("DROP TABLE " + eMSQL.getProperty("tablename"));
                continue;
            }
            if (eMSQL.getProperty("deleteme") == null) continue;
            arrayList.add("truncate table " + eMSQL.getProperty("deleteme"));
        }
        return arrayList;
    }

    private EMManager getEMManager() {
        return this.m_emManager;
    }

    private InputStream getEnterpriseCaptureDefinition(MigrationPlugin migrationPlugin) {
        String string = migrationPlugin.getOfflineCapturer().getEnterpriseCaptureFileName();
        InputStream inputStream = this.getClass().getResourceAsStream(string);
        return inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<String> getListOfOnlineSourceDatabases(String string) {
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(this.excludeDBArray));
        ArrayList<String> arrayList2 = new ArrayList<String>();
        Connection connection = null;
        ResultSet resultSet = null;
        EMManager eMManager = null;
        ArrayList<KeyValue> arrayList3 = new ArrayList<KeyValue>();
        try {
            arrayList3.add(new KeyValue("/*DB_WHERE_CLAUSE*/", this.getDBFilter(this.getCaptureDetails())));
            connection = Connections.getInstance().getConnection(string);
            MigrationPlugin migrationPlugin = MigrationAddin.getPluginForConnection(connection);
            InputStream inputStream = this.getEnterpriseCaptureDefinition(migrationPlugin);
            eMManager = new EMManager(inputStream);
            this._stmtTp = connection.createStatement();
            resultSet = this._stmtTp.executeQuery(eMManager.getDatabaseListQuery().getSQL(arrayList3));
            while (resultSet.next()) {
                String string2 = resultSet.getString("CATALOG_NAME");
                if (arrayList.contains(string2.toLowerCase())) continue;
                arrayList2.add(string2);
            }
        }
        catch (Exception exception) {
            this.getCmdout().printError(exception);
            this.logToStage(this.getCurrentServerID(), this.getCurrentDBID(), 0L, null, 1000, "getListOfOnlineSourceDatabases method : " + exception.getMessage(), STAGE_PULL);
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (this._stmtTp != null) {
                    this._stmtTp.close();
                }
            }
            catch (Exception exception) {
                this.getCmdout().printError(exception);
                this.logToStage(this.getCurrentServerID(), this.getCurrentDBID(), 0L, null, 1000, "getListOfOnlineSourceDatabases method : stmt/rs close issue : " + exception.getMessage(), STAGE_PULL);
            }
        }
        return arrayList2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap<String, Integer> getListOfSourceDatabasesOnServer(CaptureDetails captureDetails) {
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(this.excludeDBArray));
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        Connection connection = null;
        ResultSet resultSet = null;
        try {
            connection = CMDUtil.getConnectionFromSimpleName(captureDetails.getSourceName());
            this._stmtTp = connection.createStatement();
            resultSet = this._stmtTp.executeQuery(this.getDatabaseListQuery());
            while (resultSet.next()) {
                String string = resultSet.getString("CATALOG_NAME");
                int n = resultSet.getInt("DBID");
                if (arrayList.contains(string.toLowerCase())) continue;
                hashMap.put(string, n);
            }
        }
        catch (Exception exception) {
            this.getCmdout().printError(exception);
            this.logToStage(this.getCurrentServerID(), this.getCurrentDBID(), 0L, null, 1000, "getListOfSourceDatabasesOnServer method : " + exception.getMessage(), STAGE_PULL);
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (this._stmtTp != null) {
                    this._stmtTp.close();
                    this._stmtTp = null;
                }
            }
            catch (Exception exception) {
                this.getCmdout().printError(exception);
                this.logToStage(this.getCurrentServerID(), this.getCurrentDBID(), 0L, null, 1000, "getListOfSourceDatabasesOnServer method : rs/stmt close issue : " + exception.getMessage(), STAGE_PULL);
            }
        }
        return hashMap;
    }

    private String getModelName() {
        String string = null;
        CaptureDetails captureDetails = this.getCaptureDetails();
        string = captureDetails.getModelName();
        return string;
    }

    private ArrayList<EMDataMover> getOneOffs() {
        ArrayList<EMDataMover> arrayList = new ArrayList<EMDataMover>();
        ArrayList<EMDataMover> arrayList2 = this.getEMManager().getStageTableCapture();
        for (EMDataMover eMDataMover : arrayList2) {
            if (eMDataMover.isPerDatabaseRequired()) continue;
            arrayList.add(eMDataMover);
        }
        return arrayList;
    }

    private String getOracleTableName(String string) {
        for (EMDataMover eMDataMover : this.getEMManager().getStageTableCapture()) {
            if (!string.equals(eMDataMover.getSourceQuery().getProperty("source"))) continue;
            return eMDataMover.getStageInsert().getProperty("target");
        }
        return null;
    }

    private ArrayList<EMDataMover> getPerDatabaseDataMovers() {
        ArrayList<EMDataMover> arrayList = new ArrayList<EMDataMover>();
        ArrayList<EMDataMover> arrayList2 = this.getEMManager().getStageTableCapture();
        for (EMDataMover eMDataMover : arrayList2) {
            if (!eMDataMover.isPerDatabaseRequired()) continue;
            arrayList.add(eMDataMover);
        }
        return arrayList;
    }

    private PersistenceUtility getPersistenceUtility() {
        if (null == this._persistenceUtility) {
            PersistenceManager persistenceManager = this.getPersistenceManager();
            this._persistenceUtility = PersistenceUtility.getInstance(persistenceManager);
        }
        return this._persistenceUtility;
    }

    private String getProjectName() {
        Object object;
        if (this.m_projectName == null) {
            object = this.getCaptureDetails();
            this.m_projectName = ((CaptureDetails)object).getProjectName();
            if (this.m_projectName != null && !((CaptureDetails)object).isAppend()) {
                try {
                    if (this.getPersistenceUtility().getNamedProject(this.m_projectName) != null) {
                        this.getCmdout().printError("That project name is already in use. Please enter a unique name, include the -append to add to an existing project, or do not specify a -project to have the system create the name.");
                        this.logToStage(this.getCurrentServerID(), this.getCurrentDBID(), 0L, null, 1000, "getProjectName method : " + this.m_serverName + ":" + this.getPersistenceUtility().getNamedProject(this.m_projectName) + " already in use & non unique ", STAGE_PULL);
                        System.exit(1);
                    }
                }
                catch (PersistenceException persistenceException) {
                    throw new IllegalStateException(persistenceException);
                }
            }
        }
        if (this.m_projectName == null) {
            object = Connections.getInstance().getConnectionInfo(CMDUtil.getQualifiedName(this.getCaptureDetails().getSourceName()));
            this.m_projectName = ((Properties)object).getProperty("RaptorConnectionType");
        }
        return this.m_projectName;
    }

    private long getRepoDBID(int n) {
        if (this.m_sourceToRepoDBID.get(n) == null) {
            return 0L;
        }
        return this.m_sourceToRepoDBID.get(n);
    }

    private File getReportFile() throws CMDLineError, FileNotFoundException {
        String string = this.getCaptureDetails().getReportDestination();
        File file = null;
        if (string != null && !string.trim().equals("")) {
            if (!string.endsWith("/") && !string.endsWith("\\")) {
                string = string + File.separator;
            }
        } else if (string == null) {
            string = "";
        }
        boolean bl = false;
        try {
            file = new File(string);
            bl = !file.exists() ? new File(string).mkdirs() : true;
        }
        catch (Exception exception) {
            throw new CMDLineError(CMDNAME, "failed to create or find directory:" + string, exception);
        }
        if (!bl) {
            throw new FileNotFoundException(string);
        }
        File file2 = null;
        try {
            file2 = new File(file, "MigrationEstimation_" + this.getDB_name() + ".xls");
        }
        catch (CaptureException captureException) {
            captureException.printStackTrace();
        }
        return file2;
    }

    private String getServerURL() {
        String string = null;
        try {
            Connection connection = CMDUtil.getConnectionFromSimpleName(this.getCaptureDetails().getSourceName());
            string = connection.getMetaData().getURL();
        }
        catch (Exception exception) {
            this.getCmdout().printError(exception.getLocalizedMessage());
            this.logToStage(this.getCurrentServerID(), this.getCurrentDBID(), 0L, null, 1000, "getServerURL method : " + this.m_serverName + ":" + exception.getMessage(), STAGE_PULL);
        }
        return string;
    }

    private ArrayList<String> getSourceTableNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (EMDataMover eMDataMover : this.getEMManager().getStageTableCapture()) {
            EMSQL eMSQL = eMDataMover.getSourceQuery();
            String string = eMSQL.getProperty("source");
            if (string == null) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int insertResultSet(ResultSet resultSet, EMDataMover eMDataMover, CaptureDetails captureDetails) throws CMDLineError {
        String string = CMDUtil.getRepositoryConnectionName();
        int n = 0;
        Connection connection = null;
        String string2 = null;
        String string3 = null;
        boolean bl = true;
        try {
            Object object;
            Object object2;
            connection = Connections.getInstance().getConnection(string);
            if (connection instanceof RaptorProxyOJDBCConnection) {
                object2 = JDBCProxyUtil.getInstance((ClassLoader)this.getClass().getClassLoader());
                connection = (Connection)object2.unwrap((Object)connection);
            }
            bl = connection.getAutoCommit();
            connection.setAutoCommit(true);
            object2 = new ArrayList();
            if (resultSet != null) {
                ((ArrayList)object2).add(new KeyValue("/*ALLSOURCEBINDS*/", this.getBindList(resultSet.getMetaData(), 0)));
            }
            ((ArrayList)object2).add(new KeyValue("/*DB_ID*/", "" + this.getCurrentDBID()));
            ((ArrayList)object2).add(new KeyValue("/*SERVER_ID*/", "" + this.getCurrentServerID()));
            ((ArrayList)object2).add(new KeyValue("/*SERVERURL*/", this.getServerURL()));
            string3 = this.getDB_name();
            ((ArrayList)object2).add(new KeyValue("/*DB_NAME*/", string3));
            String string4 = this.getCurrentProjectID() == 0L ? "NULL" : "" + this.getCurrentProjectID();
            ((ArrayList)object2).add(new KeyValue("/*PROJECT_ID*/", string4));
            ((ArrayList)object2).add(new KeyValue("/*PROJECTNAME*/", this.getProjectName()));
            string2 = eMDataMover.getStageInsert().getSQL((ArrayList<KeyValue>)object2);
            string2 = string2.trim();
            if (eMDataMover.hasOUT()) {
                object = eMDataMover.getOUT();
                this._stmt = connection.prepareStatement(string2, (String[])object);
            } else {
                this._stmt = connection.prepareStatement(string2);
            }
            object = null;
            if (eMDataMover.hasOUT()) {
                connection.setAutoCommit(true);
            } else {
                connection.setAutoCommit(false);
                ((OraclePreparedStatement)this._stmt).setExecuteBatch(5);
            }
            if (resultSet != null) {
                while (resultSet.next()) {
                    try {
                        for (int i = 1; i <= this.getColumnCount(resultSet.getMetaData()); ++i) {
                            Object object3 = resultSet.getObject(i);
                            if (object3 instanceof Clob) {
                                ((OraclePreparedStatement)this._stmt).setObject(i, (Object)this.downloadUpload((Clob)object3, connection));
                            } else {
                                ((OraclePreparedStatement)this._stmt).setObject(i, resultSet.getObject(i));
                            }
                            if (!this.getCaptureDetails().isAnalysisRequired() || !this.requiresTranslation(eMDataMover, resultSet.getMetaData().getColumnName(i))) continue;
                            this.m_inlineSQLTranslator.setTranslationDataMover(eMDataMover);
                            this.m_inlineSQLTranslator.processSQLObject(resultSet);
                        }
                        if (Connections.getInstance().isConnectionOpen(string)) {
                            ((OraclePreparedStatement)this._stmt).executeUpdate();
                            if (eMDataMover.hasOUT()) {
                                object = ((OraclePreparedStatement)this._stmt).getGeneratedKeys();
                                this.processOutResult((ResultSet)object, eMDataMover, resultSet, captureDetails);
                            }
                            ++n;
                            continue;
                        }
                        this.getCmdout().printError("The connection is closed");
                    }
                    catch (Exception exception) {
                        this.getCmdout().printError(exception.getMessage());
                        this.logToStage(this.getCurrentServerID(), this.getCurrentDBID(), 0L, null, 1000, "insertResultSet method : " + string3 + ":" + string2 + " : " + exception.getMessage(), STAGE_PULL);
                    }
                }
            } else if (Connections.getInstance().isConnectionOpen(string)) {
                ((OraclePreparedStatement)this._stmt).executeUpdate();
                if (eMDataMover.hasOUT()) {
                    object = ((OraclePreparedStatement)this._stmt).getGeneratedKeys();
                    this.processOutResult((ResultSet)object, eMDataMover, resultSet, captureDetails);
                }
                ++n;
            } else {
                this.getCmdout().printError("The connection is closed");
            }
        }
        catch (Exception exception) {
            this.getCmdout().printError(exception.getLocalizedMessage());
            this.logToStage(this.getCurrentServerID(), this.getCurrentDBID(), 0L, null, 1000, "insertResultSet method : " + this.m_serverName + ":" + string2 + " : " + exception.getMessage(), STAGE_PULL);
        }
        finally {
            try {
                if (connection != null) {
                    connection.setAutoCommit(bl);
                }
            }
            catch (Exception exception) {}
            if (eMDataMover.isTranslationRequired()) {
                this.m_inlineSQLTranslator.finished();
            }
            try {
                if (!eMDataMover.hasOUT()) {
                    ((OraclePreparedStatement)this._stmt).sendBatch();
                    connection.commit();
                }
                this.freeClob();
            }
            catch (SQLException sQLException) {
                this.getCmdout().printError(sQLException.getLocalizedMessage());
                this.logToStage(this.getCurrentServerID(), this.getCurrentDBID(), 0L, null, 1000, "insertResultSet method : sendBatch/commit/freeClob failed : " + sQLException.getMessage(), STAGE_PULL);
            }
            try {
                if (this._stmt != null) {
                    this._stmt.close();
                    this._stmt = null;
                }
            }
            catch (Exception exception) {}
        }
        return n;
    }

    private long[] kickOffRepositoryCapture() throws CMDLineError {
        String string = this.getCaptureDetails().isAnalysisRequired() ? "TRUE" : "FALSE";
        String string2 = this.getCaptureDetails().get("PROJECT_ID") != null ? "TRUE" : "FALSE";
        String string3 = "SYB12ALLPLATFORM";
        Connection connection = CMDUtil.getConnectionFromSimpleName(this.m_captureDetails.getSourceName());
        MigrationPlugin migrationPlugin = MigrationAddin.getPluginForConnection(connection);
        if (migrationPlugin.getClass().getName().indexOf("SQLServer2005Plugin") != -1 || migrationPlugin.getClass().getName().indexOf("SQLServer2008Plugin") != -1) {
            string3 = "SS2K5ALLPLATFORM";
        }
        if (migrationPlugin.getClass().getName().indexOf("Teradata12Plugin") != -1 || migrationPlugin.getClass().getName().indexOf("Teradata13Plugin") != -1 || migrationPlugin.getClass().getName().indexOf("Teradata14Plugin") != -1) {
            string3 = "TDALLPLATFORM";
        }
        long[] lArray = this.performCapture("{call ? := " + string3 + ".STAGECAPTURE(" + this.getCurrentProjectID() + ",'" + migrationPlugin.getClass().getName() + "'," + string2 + "," + string + ")}", CMDUtil.getRepositoryConnectionName());
        return lArray;
    }

    private void logInsertInformation(int n, CaptureDetails captureDetails, String string, String string2, String string3) {
        String string4 = string != null ? string + ".." + string2 : string2;
        this.getCmdout().printMessage(" " + Messages.getString("Inserted") + " " + n + " " + Messages.getString("RowsFrom") + " " + string4 + " " + Messages.getString("Into") + " " + string3);
        this.logInsertInformationHistory(n, captureDetails, string2, string3);
    }

    private void logInsertInformationHistory(int n, CaptureDetails captureDetails, String string, String string2) {
        String string3 = string;
        if (this.m_tableToNumberOfRows.containsKey(string3)) {
            Integer n2 = this.m_tableToNumberOfRows.get(string3);
            this.m_tableToNumberOfRows.remove(string3);
            n = n2 + n;
        }
        this.m_tableToNumberOfRows.put(string3, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logToStage(long l, long l2, long l3, String string, int n, String string2, String string3) {
        String string4 = "INSERT INTO STAGE_MIGRLOG(svrid_fk, dbid_gen_fk, ref_object_id, ref_object_type, severity, logtext, phase) VALUES(?,?,?,?,?,?, ?)";
        try {
            String string5 = CMDUtil.getRepositoryConnectionName();
            Connection connection = Connections.getInstance().getConnection(string5);
            this._stmt = connection.prepareStatement(string4);
            ((PreparedStatement)this._stmt).setLong(1, l);
            ((PreparedStatement)this._stmt).setLong(2, l2);
            ((PreparedStatement)this._stmt).setLong(3, l3);
            ((PreparedStatement)this._stmt).setString(4, string);
            ((PreparedStatement)this._stmt).setInt(5, n);
            ((PreparedStatement)this._stmt).setString(6, string2);
            ((PreparedStatement)this._stmt).setString(7, string3);
            ((PreparedStatement)this._stmt).executeUpdate();
            connection.commit();
        }
        catch (Exception exception) {
            this.getCmdout().printError(exception);
        }
        finally {
            try {
                if (this._stmt != null) {
                    ((PreparedStatement)this._stmt).close();
                }
            }
            catch (SQLException sQLException) {
                this.getCmdout().printError(sQLException);
            }
        }
    }

    private long[] offlineCapture(CaptureDetails captureDetails) throws CMDLineError {
        if (!captureDetails.isOffline()) {
            return null;
        }
        long[] lArray = new long[2];
        String string = captureDetails.getOCP();
        File file = new File(string);
        String string2 = file.getAbsolutePath();
        String string3 = null;
        File file2 = null;
        Properties properties = new Properties();
        String[] stringArray = captureDetails.getDBList();
        String string4 = null;
        if (file != null) {
            Object object;
            Object object2;
            file2 = file;
            if (string2.toUpperCase().endsWith("XML")) {
                string3 = "oracle.dbtools.migration.workbench.plugin.MSAccessPlugin";
                string4 = string2;
            } else if (file2 != null && file2.canRead()) {
                try {
                    object2 = new FileInputStream(file2);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    String string5 = MigrationAddinArb.format("ERR_FILE_MISSING", file2.getName());
                    return null;
                }
                try {
                    string4 = file2.getParent();
                    properties.load((InputStream)object2);
                    string3 = properties.getProperty("OfflinePluginIdentifier");
                }
                catch (IOException iOException) {
                    String string6 = MigrationAddinArb.format("READ_OFFLINE_OUTPUT_FAILED", file2.getName(), iOException.getMessage());
                    throw new CMDLineError(CMDNAME, string6, null);
                }
                finally {
                    try {
                        ((FileInputStream)object2).close();
                    }
                    catch (IOException iOException) {}
                }
            }
            if (string3 == null || string3.trim().length() == 0) {
                object2 = MigrationAddinArb.format("ERR_FILE_INVALID_FORMAT", file2.getName());
                throw new CMDLineError(CMDNAME, (String)object2, null);
            }
            object2 = MigrationAddin.findPlugin(string3);
            if (object2 == null) {
                String string7 = MigrationAddinArb.getString("MSG_PLUGIN_NO_LONGER_AVAILABLE");
                throw new CMDLineError(CMDNAME, string7, null);
            }
            OfflineCapturer offlineCapturer = object2.getOfflineCapturer();
            ArrayList<String> arrayList = null;
            if (stringArray != null) {
                arrayList = new ArrayList<String>(Arrays.asList(stringArray));
            } else {
                object = object2 != null ? object2.getPlatformName() : "MSAccess";
                arrayList = new ArrayList<String>(QMWizard.ContextHelper.getAvailableDBListOffline((String)object, string));
            }
            offlineCapturer.setSelectedDatabaseList(arrayList);
            if (offlineCapturer == null) {
                object = MigrationAddinArb.getString("ERR_OFFLINE_NOT_SUPPORTED");
                throw new CMDLineError(CMDNAME, (String)object, null);
            }
            try {
                OfflineCaptureWorker offlineCaptureWorker;
                object = new BasicMigrationStorer(this.getPersistenceManager());
                String string8 = offlineCapturer.captureInitialize(string4, properties, (MigrationStorer)object);
                if (string8 == null) {
                    throw new OfflineCaptureException(new NullPointerException());
                }
                if (captureDetails.getProjectName() != null) {
                    string8 = captureDetails.getProjectName();
                }
                if ((offlineCaptureWorker = object2.getOfflineCaptureWorker(offlineCapturer, string8, string3)) == null) {
                    offlineCaptureWorker = new OfflineCaptureWorker(offlineCapturer, string8, string3);
                }
                offlineCaptureWorker.runCapture();
                MdConnection mdConnection = offlineCaptureWorker.getCapturedConnection();
                lArray[0] = mdConnection.getKey().getId();
            }
            catch (Exception exception) {
                MigrationLogUtil.logThrowable(exception.getMessage(), Messages.getString("CaptureInitiator.2"), (Throwable)exception);
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                throw new CMDLineError(CMDNAME, exception.getLocalizedMessage(), exception);
            }
        }
        return lArray;
    }

    private long[] onlineCapture(CaptureDetails captureDetails) throws CMDLineError {
        Connection connection = CMDUtil.getConnectionFromSimpleName(captureDetails.getSourceName());
        MigrationPlugin migrationPlugin = MigrationAddin.getPluginForConnection(connection);
        InputStream inputStream = this.getEnterpriseCaptureDefinition(migrationPlugin);
        try {
            this.m_emManager = new EMManager(inputStream);
        }
        catch (Exception exception) {
            throw new CMDLineError(CMDNAME, "Problem reading xmlfiles", exception);
        }
        this.m_inlineSQLTranslator = new InlineSQLTranslator(migrationPlugin, this.m_emManager);
        this.dropStagingTables(migrationPlugin);
        this.createStagingTables(migrationPlugin);
        this.captureIntoStagingTables(captureDetails);
        this._latch.countDown();
        long[] lArray = this.kickOffRepositoryCapture();
        return lArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long[] performCapture(String string, String string2) {
        Object object;
        String string3 = null;
        long l = 0L;
        long l2 = 0L;
        try {
            object = Connections.getInstance().getConnection(string2);
            MigrationUtils.setOracleDatabaseLongIdentifier((Connection)object, this.getClass().getName());
            this._stmt = object.prepareCall(string);
            ((OracleCallableStatement)this._stmt).registerOutParameter(1, 12);
            this.m_captureDetails.m_details.getOut().printMessage(Messages.getString("InitiatingCapture"));
            ((OracleCallableStatement)this._stmt).execute();
            string3 = ((OracleCallableStatement)this._stmt).getString(1);
            String string4 = string3.substring(0, string3.indexOf("/"));
            String string5 = string3.substring(string3.indexOf("/") + 1);
            l2 = Long.parseLong(string4);
            l = Long.parseLong(string5);
            this.m_captureDetails.m_details.setCurrentCaptureModel(string4);
        }
        catch (Exception exception) {
            this.getCmdout().printError(exception);
        }
        finally {
            try {
                if (this._stmt != null) {
                    ((OracleCallableStatement)this._stmt).close();
                }
            }
            catch (Exception exception) {
                this.getCmdout().printError(exception);
            }
        }
        object = new long[]{l2, l};
        return object;
    }

    private void printCapturingServerDetails() {
        this.getCmdout().printResult("*** Server Information ***");
    }

    /*
     * WARNING - void declaration
     */
    private void printSummaryInfo() {
        void var2_5;
        Integer n;
        this.getCmdout().printResult("********************");
        this.getCmdout().printResult("*SUMMARY************");
        this.getCmdout().printResult("********************");
        this.getCmdout().printResult(this.m_databaseMap.size() + " source databases metadata captured");
        for (String object2 : this.getSourceTableNames()) {
            this.getCmdout().printResult(this.m_tableToNumberOfRows.get(object2) + " rows inserted from " + object2 + " to " + this.getOracleTableName(object2));
        }
        Object object3 = this.m_tableToNumberOfRows.get("FAILED TO TRANSLATE");
        if (object3 == null) {
            object3 = 0;
        }
        if ((n = this.m_tableToNumberOfRows.get("STAGE_TRANSLATEDSQL")) == null) {
            Integer n2 = 0;
        }
        this.getCmdout().printResult(object3 + " SQL Objects failed to translate");
        this.getCmdout().printResult(var2_5 + " SQL Objects successfully translated and inserted into STAGE_TRANSLATEDSQL");
    }

    private void processOutDatabases(Long l, ResultSet resultSet) {
        try {
            int n = resultSet.getInt("dbid");
            this.m_sourceToRepoDBID.put(n, l);
        }
        catch (SQLException sQLException) {
            this.getCmdout().printError(sQLException);
            this.logToStage(this.getCurrentServerID(), this.getCurrentDBID(), 0L, null, 1000, this.m_serverName + ":processOutDatabases method : " + sQLException.getMessage(), STAGE_PULL);
        }
    }

    private void processOutResult(ArrayList<Long> arrayList, EMDataMover eMDataMover, ResultSet resultSet, CaptureDetails captureDetails) {
        String string = eMDataMover.getStageInsert().getProperty("target");
        if (string.equals("STAGE_SYB12_SYSDATABASES")) {
            this.processOutDatabases(arrayList.get(0), resultSet);
        } else if (string.equals("STAGE_SS2K5_DATABASES")) {
            this.processOutDatabases(arrayList.get(0), resultSet);
        } else if (string.equals("STAGE_TERADATA12_DBASE")) {
            this.processOutDatabases(arrayList.get(0), resultSet);
        } else if (string.equals("STAGE_TERADATA12_TVM")) {
            this.processOutDatabases(arrayList.get(0), resultSet);
        } else if (string.equals("STAGE_SERVERDETAIL")) {
            this.setCurrentServerID(arrayList);
            this.checkAndUpdateProjectDetail(captureDetails);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processOutResult(ResultSet resultSet, EMDataMover eMDataMover, ResultSet resultSet2, CaptureDetails captureDetails) {
        try {
            ArrayList<Long> arrayList = new ArrayList<Long>();
            int n = eMDataMover.getOUT().length;
            while (resultSet.next()) {
                for (int i = 1; i <= n; ++i) {
                    Long l = resultSet.getLong(i);
                    arrayList.add(l);
                }
            }
            this.processOutResult(arrayList, eMDataMover, resultSet2, captureDetails);
        }
        catch (Exception exception) {
            this.getCmdout().printError(exception);
            this.logToStage(this.getCurrentServerID(), this.getCurrentDBID(), 0L, null, 1000, "processOutResult method : " + this.m_serverName + ":" + exception.getMessage(), STAGE_PULL);
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {
                this.getCmdout().printError(sQLException);
                this.logToStage(this.getCurrentServerID(), this.getCurrentDBID(), 0L, null, 1000, "processOutResult method : close resultset failed " + this.m_serverName + ":" + sQLException.getMessage(), STAGE_PULL);
            }
        }
    }

    private void reportStartingDatabase(String string) {
        this.getCmdout().printMessage("*** " + string + " ***");
    }

    private boolean requiresTranslation(EMDataMover eMDataMover, String string) {
        return eMDataMover.isTranslationRequired() && string.equalsIgnoreCase(eMDataMover.getSourceQuery().getProperty("columnToTranslate"));
    }

    private void runCapture(CaptureDetails captureDetails) throws CMDLineError {
        this.verifyRepository();
        long[] lArray = null;
        lArray = captureDetails.isOnline() ? this.onlineCapture(captureDetails) : this.offlineCapture(captureDetails);
    }

    private void setCurrentDatabaseID(int n) {
        this.m_currentDBID = this.getRepoDBID(n);
    }

    private void setCurrentServerID(ArrayList<Long> arrayList) {
        this.m_currentServerID = arrayList.get(0);
        this.m_currentProjectID = arrayList.get(1);
    }

    @Override
    public void signalCancel() {
        try {
            if (this._stmt != null && !this._stmt.isClosed()) {
                this._stmt.cancel();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this._stmtTp != null && !this._stmtTp.isClosed()) {
                this._stmtTp.cancel();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void waitForPackageCreation() throws InterruptedException {
        this._latch.await();
    }

    public class KeyValue {
        String m_key = null;
        String m_value = null;

        public KeyValue(String string, String string2) {
            this.m_key = string;
            this.m_value = string2;
        }

        public String getKey() {
            return this.m_key;
        }

        public String getValue() {
            return this.m_value;
        }

        public void setKey(String string) {
            this.m_key = string;
        }

        public void setValue(String string) {
            this.m_value = string;
        }
    }

    private class InlineSQLTranslator {
        int m_currentObjectID = 0;
        int m_currentChunkNum = 0;
        StringBuffer m_textSoFar = new StringBuffer();
        MigrationPlugin m_plugin = null;
        EMManager m_emManager = null;
        EMDataMover m_translationDataMover = null;

        public InlineSQLTranslator(MigrationPlugin migrationPlugin, EMManager eMManager) {
            this.m_plugin = migrationPlugin;
            this.m_emManager = eMManager;
        }

        public void finished() {
            if (this.m_textSoFar.length() > 1) {
                this.processLastObject();
            }
        }

        private long getCurrentObjectID() {
            return 0L;
        }

        private String getCurrentObjectType() {
            return null;
        }

        private long getCurrentSchemaID() {
            return 0L;
        }

        private int getObjectChunkNum(ResultSet resultSet) {
            try {
                return resultSet.getInt(this.getTranslationDataMover().getSourceQuery().getProperty("columnToSpecifyTextOrder"));
            }
            catch (SQLException sQLException) {
                CaptureCmd.this.getCmdout().printError(sQLException);
                CaptureCmd.this.logToStage(CaptureCmd.this.getCurrentServerID(), CaptureCmd.this.getCurrentDBID(), 0L, null, 1000, "getObjectChunkNum method : " + sQLException.getMessage(), CaptureCmd.STAGE_PULL);
                return 0;
            }
        }

        private int getObjectID(ResultSet resultSet) {
            try {
                return resultSet.getInt(this.getTranslationDataMover().getSourceQuery().getProperty("columnToSpecifyObject"));
            }
            catch (SQLException sQLException) {
                CaptureCmd.this.getCmdout().printError(sQLException);
                CaptureCmd.this.logToStage(CaptureCmd.this.getCurrentServerID(), CaptureCmd.this.getCurrentDBID(), 0L, null, 1000, "getObjectID method : " + sQLException.getMessage(), CaptureCmd.STAGE_PULL);
                return 0;
            }
        }

        private String getObjectTextChunk(ResultSet resultSet) {
            try {
                return resultSet.getString(this.getTranslationDataMover().getSourceQuery().getProperty("columnToTranslate"));
            }
            catch (SQLException sQLException) {
                CaptureCmd.this.getCmdout().printError(sQLException);
                CaptureCmd.this.logToStage(CaptureCmd.this.getCurrentServerID(), CaptureCmd.this.getCurrentDBID(), 0L, null, 1000, "getObjectTextChunk method : " + sQLException.getMessage(), CaptureCmd.STAGE_PULL);
                return null;
            }
        }

        private String getTranslatedSQL() {
            ITranslationAll iTranslationAll = (ITranslationAll)this.m_plugin.getConverter().getPlaformTranslator();
            TranslateResultWithASTs translateResultWithASTs = null;
            try {
                translateResultWithASTs = iTranslationAll.translateAndGetASTS(this.m_textSoFar.toString());
            }
            catch (Exception exception) {
                CaptureCmd.this.logToStage(CaptureCmd.this.getCurrentServerID(), CaptureCmd.this.getCurrentDBID(), 0L, null, 1000, "getTranslatedSQL method : source sql : " + this.m_textSoFar.toString() + " : " + exception.getMessage(), CaptureCmd.STAGE_PULL);
                return null;
            }
            return translateResultWithASTs.getTargetString();
        }

        public EMDataMover getTranslationDataMover() {
            return this.m_translationDataMover;
        }

        private void logFailedToTranslate() {
            CaptureCmd.this.logInsertInformationHistory(1, null, "", "FAILED TO TRANSLATE");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processLastObject() {
            String string = this.getTranslatedSQL();
            String string2 = "INSERT INTO STAGE_TRANSLATEDSQL VALUES(?,?,?,?,?,?)";
            try {
                String string3 = CMDUtil.getRepositoryConnectionName();
                Connection connection = Connections.getInstance().getConnection(string3);
                CaptureCmd.this._stmt = connection.prepareStatement(string2);
                ((PreparedStatement)CaptureCmd.this._stmt).setLong(1, CaptureCmd.this.getCurrentServerID());
                ((PreparedStatement)CaptureCmd.this._stmt).setLong(2, CaptureCmd.this.getCurrentDBID());
                ((PreparedStatement)CaptureCmd.this._stmt).setLong(3, this.getCurrentSchemaID());
                ((PreparedStatement)CaptureCmd.this._stmt).setInt(4, this.m_currentObjectID);
                ((PreparedStatement)CaptureCmd.this._stmt).setString(5, this.m_textSoFar.toString());
                ((PreparedStatement)CaptureCmd.this._stmt).setString(6, string);
                ((PreparedStatement)CaptureCmd.this._stmt).executeUpdate();
                connection.commit();
                CaptureCmd.this.logInsertInformationHistory(1, null, "", "STAGE_TRANSLATEDSQL");
            }
            catch (Exception exception) {
                CaptureCmd.this.getCmdout().printError(exception);
            }
            finally {
                try {
                    if (CaptureCmd.this._stmt != null) {
                        ((PreparedStatement)CaptureCmd.this._stmt).close();
                    }
                }
                catch (SQLException sQLException) {
                    CaptureCmd.this.getCmdout().printError(sQLException);
                }
            }
            if (string == null) {
                this.logFailedToTranslate();
            }
        }

        public void processSQLObject(ResultSet resultSet) {
            if (this.sqlTypeRequiresTranslation(resultSet)) {
                int n = this.getObjectID(resultSet);
                int n2 = this.getObjectChunkNum(resultSet);
                String string = this.getObjectTextChunk(resultSet);
                if (n == this.m_currentObjectID) {
                    this.m_textSoFar.append(string);
                } else {
                    if (this.m_currentObjectID != 0) {
                        this.processLastObject();
                    }
                    this.startNewObject(n, n2, string);
                }
            }
        }

        public void setTranslationDataMover(EMDataMover eMDataMover) {
            this.m_translationDataMover = eMDataMover;
        }

        private boolean sqlTypeRequiresTranslation(ResultSet resultSet) {
            int n = 0;
            try {
                n = resultSet.getInt("translate_flag");
            }
            catch (SQLException sQLException) {
                CaptureCmd.this.getCmdout().printError(sQLException);
                CaptureCmd.this.logToStage(CaptureCmd.this.getCurrentServerID(), CaptureCmd.this.getCurrentDBID(), 0L, null, 1000, "sqlTypeRequiresTranslation method : " + sQLException.getMessage(), CaptureCmd.STAGE_PULL);
            }
            return n == 1;
        }

        private void startNewObject(int n, int n2, String string) {
            this.m_textSoFar.setLength(0);
            this.m_textSoFar.append(string);
            this.m_currentObjectID = n;
            this.m_currentChunkNum = n2;
        }
    }

    class CaptureDetails {
        MigrationDetails m_details = null;

        CaptureDetails(MigrationDetails migrationDetails) {
            this.m_details = migrationDetails;
        }

        public String get(String string) {
            return this.m_details.get(string);
        }

        public String[] getDBList() {
            String string = this.m_details.get("dblist");
            if (string != null) {
                return string.split(",");
            }
            return null;
        }

        public String getLog() {
            return this.m_details.get("log");
        }

        public String getModelName() {
            return this.m_details.get("model");
        }

        private String[] getNameAndPassword(String string) {
            int n = string.indexOf("/");
            if (n == -1) {
                return new String[]{string, null};
            }
            return new String[]{string.substring(0, n), string.substring(n + 1)};
        }

        public String getOCP() {
            return this.m_details.get("ocp");
        }

        public String getProjectName() {
            return this.m_details.get("project");
        }

        public String getReportDestination() {
            String string = this.m_details.get("report");
            if (string == null) {
                string = "";
            } else if (string.startsWith("[")) {
                string = string.substring(string.indexOf(93) + 1);
            }
            return string;
        }

        public String getReportType() {
            String string = this.m_details.get("report");
            if (string != null && string.startsWith("[")) {
                string = string.substring(1, string.indexOf(93));
                if ((string = string.toLowerCase()).equals("xml") || string.equals("html")) {
                    return string;
                }
                CaptureCmd.this.getCmdout().printError("Warning:-reportType:xml or -reportType:html are only supported");
                CaptureCmd.this.getCmdout().printError("Warning: the default -reportType:html will be used");
                return "html";
            }
            return "html";
        }

        public String getRepositoryPassword() {
            return this.getNameAndPassword(this.m_details.get("repo"))[1];
        }

        public String getRepositorySpecified() {
            return this.getNameAndPassword(this.m_details.get("repo"))[0];
        }

        private String getSourceConnection(String[] stringArray) {
            if (stringArray.length == 1) {
                return stringArray[0];
            }
            for (String string : stringArray) {
                if (!string.toLowerCase().startsWith("source")) continue;
                return string;
            }
            return null;
        }

        public String getSourceName() {
            String[] stringArray = this.m_details.get("conn").split(",");
            String string = this.getSourceConnection(stringArray);
            if (string != null) {
                return this.getNameAndPassword(string)[0];
            }
            return null;
        }

        public String getSourcePassword() {
            String[] stringArray = this.m_details.get("conn").split(",");
            String string = this.getSourceConnection(stringArray);
            return this.getNameAndPassword(string)[1];
        }

        public boolean isAnalysisRequired() {
            return this.m_details.contains("analysis");
        }

        public boolean isAppend() {
            return this.m_details.contains("append");
        }

        public boolean isDatabaseCapture() {
            return this.m_details.contains("db");
        }

        public boolean isDBListSpecified() {
            return this.m_details.contains("dblist");
        }

        public boolean isLogSpecified() {
            return this.m_details.contains("log");
        }

        public boolean isOffline() {
            return this.m_details.contains("ocp");
        }

        public boolean isOnline() {
            return this.m_details.contains("conn");
        }

        private boolean isPasswordSpecified(String string) {
            return string.indexOf("/") != -1;
        }

        public boolean isReportRequired() {
            return this.m_details.contains("report");
        }

        public boolean isRepositoryPasswordSpecified() {
            return this.isPasswordSpecified(this.m_details.get("repo"));
        }

        public boolean isRepositorySpecified() {
            return this.m_details.contains("repo");
        }

        public boolean isServerCapture() {
            boolean bl = this.m_details.contains("server");
            boolean bl2 = this.m_details.contains("database");
            return bl || !bl2;
        }

        public boolean isSourcePasswordSpecified() {
            String[] stringArray = this.m_details.get("conn").split(",");
            String string = this.getSourceConnection(stringArray);
            return this.isPasswordSpecified(string);
        }

        public boolean isValid() {
            if (this.getSourceName() == null) {
                return false;
            }
            if (this.isRepositorySpecified() && this.getRepositorySpecified() == null) {
                return false;
            }
            if (this.isDBListSpecified() && this.getDBList() == null) {
                return false;
            }
            return !this.isLogSpecified() || this.getLog() != null;
        }
    }
}

