/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.datamove.offline.streams;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.metadata.persistence.MdConnection;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.migration.core.util.MigrationUtils;
import oracle.dbtools.migration.datamove.DataMoveDescriptor;
import oracle.dbtools.migration.datamove.offline.streams.OfflineDBStructure;
import oracle.dbtools.migration.datamove.offline.streams.OfflineDMSInterface;
import oracle.dbtools.migration.datamove.offline.streams.ScriptFilesContentGenerator;
import oracle.dbtools.migration.datamove.online.DataMoveAudience;
import oracle.dbtools.migration.workbench.core.MigrationPlugin;
import oracle.dbtools.migration.workbench.core.MigrationPluginException;

public abstract class OfflineDMSAbstract
implements OfflineDMSInterface,
OfflineDBStructure {
    protected static final String DOT = ".";
    public static final String NIX = "sh";
    protected static final String UNDERSCORE = "_";
    public static final String WINDOWS = "bat";
    private String basedir = null;
    private String catalogdir = null;
    private String fileType = null;
    public final Logger LOGGER = Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle");
    protected DataMoveAudience m_audience;
    protected DataMoveDescriptor m_descriptor;
    protected PersistenceManager m_persistenceManager;
    protected MigrationPlugin m_plugin;
    protected String m_projectName;
    protected String m_timeStamp;
    protected MdConnection mdConnection;
    private String offlinebase = null;
    private String prevCatalog = null;
    protected String schemadir = null;
    protected ScriptFilesContentGenerator scriptGenerator;
    protected PrintWriter topLevelwindows;
    protected PrintWriter topLevelnix;
    protected PrintWriter catalogWriterWindows;
    protected PrintWriter catalogWriterNix;
    protected PrintWriter schemaWriterWindows;
    protected PrintWriter schemaWriterNix;
    protected PrintWriter tableWriter;
    protected PrintWriter truncWriter;
    protected PrintWriter preWriter;
    protected PrintWriter postWriter;
    protected boolean truncatable;
    String unix = null;
    String window = null;

    public static final void setWriteDir(String string) {
        if (string == null || string.trim().length() == 0) {
            return;
        }
        File file = new File(string);
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    public OfflineDMSAbstract(String string, String string2) {
        this.setBaseDir(string);
        this.fileType = string2;
        this.setGenerator(new ScriptFilesContentGenerator(string2));
    }

    @Override
    public void endDatabase() {
        this.println(this.catalogWriterWindows, this.scriptGenerator.getTailScript(this.window, true), true);
        this.println(this.catalogWriterNix, this.scriptGenerator.getTailScript(this.unix, false), false);
        this.flushnclose(this.catalogWriterNix, this.catalogWriterWindows);
    }

    @Override
    public void endSchema() {
        this.println(this.schemaWriterWindows, this.scriptGenerator.getStreamBodyFooter(true), true);
        this.println(this.schemaWriterNix, this.scriptGenerator.getStreamBodyFooter(false), false);
        this.flushnclose(this.schemaWriterNix, this.schemaWriterWindows);
    }

    @Override
    public void endTable() {
    }

    @Override
    public void finished() {
        this.flushnclose(this.topLevelnix, this.topLevelwindows);
    }

    protected void flushnclose(PrintWriter printWriter, PrintWriter printWriter2) {
        if (printWriter2 != null) {
            printWriter2.flush();
            printWriter2.close();
        }
        if (printWriter != null) {
            printWriter.flush();
            printWriter.close();
        }
    }

    @Override
    public String getBaseDir() {
        return this.basedir;
    }

    public abstract String getBaseFileName();

    @Override
    public String getCatalogDir() {
        String string = this.getOfflineBaseDir() + File.separator + this.catalogdir;
        OfflineDMSAbstract.setWriteDir(string);
        return string;
    }

    @Override
    public abstract String getExtension();

    @Override
    public abstract String getFileName();

    @Override
    public String getGenType() {
        return this.fileType;
    }

    @Override
    public String getOfflineBaseDir() {
        return this.offlinebase;
    }

    private PrintWriter getPrintWiter(String string, boolean bl) {
        this.window = MessageFormat.format(this.getBaseFileName(), this.getGenType(), WINDOWS);
        this.unix = MessageFormat.format(this.getBaseFileName(), this.getGenType(), NIX);
        String string2 = string + File.separator + this.window;
        String string3 = string + File.separator + this.unix;
        PrintWriter printWriter = null;
        try {
            if (bl) {
                File file = new File(string2);
                if (file.exists()) {
                    System.out.println(string2 + " exists already, overwriting");
                }
                printWriter = new PrintWriter(file);
            } else {
                File file = new File(string3);
                if (file.exists()) {
                    System.out.println(string2 + " exists already, overwriting");
                }
                printWriter = new PrintWriter(file);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        return printWriter;
    }

    protected PrintWriter getPrintWriter(String string, String string2) {
        String string3 = string2 + File.separator + string;
        PrintWriter printWriter = null;
        OfflineDMSAbstract.setWriteDir(string2);
        File file = new File(string3);
        if (file.exists()) {
            System.out.println(string3 + " exists already, overwriting");
        }
        try {
            printWriter = new PrintWriter(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        return printWriter;
    }

    @Override
    public String getSchemaDir() {
        String string = this.getCatalogDir() + File.separator + this.schemadir;
        OfflineDMSAbstract.setWriteDir(string);
        return string;
    }

    public ScriptFilesContentGenerator getScriptGenerator() {
        return this.scriptGenerator;
    }

    @Override
    public void println(PrintWriter printWriter, String string, boolean bl) {
        try {
            printWriter.print(bl ? OfflineDMSAbstract.makeWindows(string) : OfflineDMSAbstract.makeUnix(string));
            printWriter.print(bl ? "\r\n" : "\n");
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
        }
    }

    @Override
    public void setAudience(DataMoveAudience dataMoveAudience, String string, String string2) {
        this.m_audience = dataMoveAudience;
        this.m_projectName = string.replaceAll(" ", UNDERSCORE).replaceAll(File.separator + File.separator, UNDERSCORE);
        this.m_timeStamp = string2;
    }

    @Override
    public void setBaseDir(String string) {
        this.basedir = string;
    }

    @Override
    public void setCatalogDir(String string) {
        this.catalogdir = string;
    }

    @Override
    public void setDescriptor(DataMoveDescriptor dataMoveDescriptor) {
        this.m_descriptor = dataMoveDescriptor;
    }

    public void setGenerator(ScriptFilesContentGenerator scriptFilesContentGenerator) {
        this.scriptGenerator = scriptFilesContentGenerator;
    }

    @Override
    public void setSchemaDir(String string) {
        this.schemadir = string;
    }

    @Override
    public void start(MdConnection mdConnection, PersistenceManager persistenceManager) {
        try {
            this.m_plugin = MigrationUtils.getPluginForConnection(mdConnection);
        }
        catch (MigrationPluginException migrationPluginException) {
            this.LOGGER.log(Level.SEVERE, "Migration Plugin cannot be found");
        }
        this.mdConnection = mdConnection;
        this.m_persistenceManager = persistenceManager;
        this.offlinebase = this.getBaseDir();
        OfflineDMSAbstract.setWriteDir(this.offlinebase);
        this.topLevelwindows = this.getPrintWiter(this.getOfflineBaseDir(), true);
        this.topLevelnix = this.getPrintWiter(this.getOfflineBaseDir(), false);
        this.scriptGenerator.start(mdConnection, persistenceManager);
    }

    @Override
    public void startDatabase(String string, String string2) {
        this.setCatalogDir(string);
        this.setSchemaDir(string2);
        OfflineDMSAbstract.setWriteDir(this.getCatalogDir());
        if (this.prevCatalog == null && string != null) {
            this.catalogWriterWindows = this.getPrintWiter(this.getCatalogDir(), true);
            this.catalogWriterNix = this.getPrintWiter(this.getCatalogDir(), false);
        }
        if (string != null && !string.equals(this.prevCatalog)) {
            this.println(this.topLevelwindows, this.scriptGenerator.getHeadScript(this.window, true), true);
            this.println(this.topLevelnix, this.scriptGenerator.getHeadScript(this.unix, false), false);
            this.println(this.topLevelwindows, this.scriptGenerator.getBody(string, this.window, true), true);
            this.println(this.topLevelnix, this.scriptGenerator.getBody(string, this.unix, false), false);
            this.println(this.topLevelwindows, this.scriptGenerator.getTailScript(this.window, true), true);
            this.println(this.topLevelnix, this.scriptGenerator.getTailScript(this.unix, false), false);
            this.flushnclose(this.topLevelnix, this.topLevelwindows);
        }
        this.println(this.catalogWriterWindows, this.scriptGenerator.getHeadScript(this.window, true), true);
        this.println(this.catalogWriterNix, this.scriptGenerator.getHeadScript(this.unix, false), false);
    }

    @Override
    public void startSchema(String string, String string2) {
        this.setCatalogDir(string);
        this.setSchemaDir(string2);
        OfflineDMSAbstract.setWriteDir(this.getSchemaDir());
        this.schemaWriterWindows = this.getPrintWiter(this.getSchemaDir(), true);
        this.schemaWriterNix = this.getPrintWiter(this.getSchemaDir(), false);
        if (this.scriptGenerator != null) {
            this.println(this.schemaWriterWindows, OfflineDMSAbstract.makeWindows(this.scriptGenerator.getStreamBodyHeader(true)), true);
            this.println(this.schemaWriterNix, OfflineDMSAbstract.makeUnix(this.scriptGenerator.getStreamBodyHeader(false)), false);
        }
        this.println(this.catalogWriterWindows, OfflineDMSAbstract.makeWindows(this.scriptGenerator.getBody(string2, this.window, true)), true);
        this.println(this.catalogWriterNix, OfflineDMSAbstract.makeUnix(this.scriptGenerator.getBody(string2, this.unix, false)), false);
        this.scriptGenerator.setSchema(string, string2);
    }

    public static String makeWindows(CharSequence charSequence) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        for (int i = 0; i < charSequence.length(); ++i) {
            char c = charSequence.charAt(i);
            if (c == '\r') {
                if (bl) {
                    stringBuffer.append("\r\n");
                }
                bl = true;
                continue;
            }
            if (c == '\n') {
                stringBuffer.append("\r\n");
                bl = false;
                continue;
            }
            if (bl) {
                stringBuffer.append("\r\n");
                bl = false;
            }
            stringBuffer.append(c);
        }
        if (bl) {
            stringBuffer.append("\r\n");
        }
        return stringBuffer.toString();
    }

    public static String makeUnix(CharSequence charSequence) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        for (int i = 0; i < charSequence.length(); ++i) {
            char c = charSequence.charAt(i);
            if (c == '\r') {
                if (bl) {
                    stringBuffer.append('\n');
                }
                bl = true;
                continue;
            }
            if (c == '\n') {
                stringBuffer.append('\n');
                bl = false;
                continue;
            }
            if (bl) {
                stringBuffer.append('\n');
                bl = false;
            }
            stringBuffer.append(c);
        }
        if (bl) {
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }

    @Override
    public abstract void startTable(String var1);
}

