/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.generate;

import java.io.File;
import java.util.ArrayList;
import oracle.dbtools.migration.generate.BaseGeneration;
import oracle.dbtools.migration.generate.GenerateException;
import oracle.dbtools.migration.generate.GenerateWorker;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.preferences.MigrationConfig;
import oracle.ide.config.Preferences;
import oracle.javatools.data.PropertyStorage;
import org.antlr.stringtemplate.StringTemplate;

public class SingleFileSqlGeneration
extends BaseGeneration {
    public SingleFileSqlGeneration(GenerateWorker generateWorker) {
        super(generateWorker);
    }

    @Override
    public boolean startGeneration() throws GenerateException {
        this.createSchemaDirectories();
        this.generatePasswordDefinitionSqlFile();
        this.generateDropAllSchemasFile();
        this.generateWrapperFile();
        if (MigrationAddin.getMigrationConfig().getCreateUser()) {
            this.generateUserFile();
        }
        this.generateReportAllStatusFile();
        return true;
    }

    @Override
    public void processFileWriting(String string, BaseGeneration.GenerationType generationType) {
        if (generationType == BaseGeneration.GenerationType.OBJECT || generationType == BaseGeneration.GenerationType.SINGLE) {
            this.getMainMasterOutputStream().println(string);
        }
    }

    @Override
    protected void createSchemaDirectories() {
        File file = new File(this.getBaseDirectory());
        file.mkdir();
    }

    @Override
    public String generateDisconnectSql(boolean bl) {
        if (bl) {
            return this.getTemplateGroup().getInstanceOf("disconnect").toString();
        }
        return null;
    }

    @Override
    public void generateUserFile() {
        try {
            ArrayList<String> arrayList = this.getAllSchemaNames();
            StringTemplate stringTemplate = null;
            for (int i = 0; i < arrayList.size(); ++i) {
                stringTemplate = MigrationConfig.getInstance((PropertyStorage)Preferences.getPreferences()).getTarget12c() ? this.getTemplateGroup().getInstanceOf("user12c") : this.getTemplateGroup().getInstanceOf("user");
                stringTemplate.setAttribute("schemaName", (Object)arrayList.get(i));
                stringTemplate.setAttribute("password", (Object)(arrayList.get(i) + "_password"));
                this.getMainMasterOutputStream().println(stringTemplate.toString());
                stringTemplate.reset();
                this.getMainMasterOutputStream().endObject();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void generateReportAllStatusFile() {
        try {
            ArrayList<String> arrayList = this.getAllSchemaNames();
            String string = this.getBaseDirectory();
            this.setOutputStream(this.createGenerationOutputStream(string, "reportallstatus", false));
            for (int i = 0; i < arrayList.size(); ++i) {
                StringTemplate stringTemplate = this.getTemplateGroup().getInstanceOf("reportAllStatus");
                stringTemplate.setAttribute("schemaName", (Object)arrayList.get(i).toUpperCase());
                stringTemplate.setAttribute("password", (Object)(arrayList.get(i) + "_password"));
                this.getOutputStream().println(stringTemplate.toString());
                stringTemplate.reset();
                this.getOutputStream().endObject();
            }
            this.getOutputStream().close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public boolean endGeneration() throws GenerateException {
        try {
            return true;
        }
        catch (Exception exception) {
            throw new GenerateException(exception);
        }
    }

    @Override
    public void generateUserEntryInMainMaster(String string) {
    }

    @Override
    public void generateMasterEntryInMainMaster(String string) {
    }

    public void generatePostEntryInMainMaster(String string) {
    }

    @Override
    public void endFileWriting(BaseGeneration.GenerationType generationType) {
    }

    @Override
    public void generateForignKeyEntryInMainMaster(String string) {
    }

    @Override
    public void generatePostEntryInMainMaster() {
    }

    @Override
    public void endFileWriting(BaseGeneration.GenerationType generationType, boolean bl) {
    }

    @Override
    protected void writeSchemaMasterFile() {
    }

    @Override
    protected void writeDropObjectsInSchemaFile() {
    }

    @Override
    public boolean setGenerationOutputStream(BaseGeneration.GenerationType generationType, String string) {
        return true;
    }

    @Override
    public boolean startFileWriting(String string, String string2, String string3, BaseGeneration.GenerationType generationType) {
        return true;
    }
}

