/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.translation;

import java.util.HashMap;
import oracle.dbtools.metadata.persistence.DBObjectHierarchy;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdSchema;
import oracle.dbtools.metadata.persistence.NoSuchObjectException;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.migration.convert.ConvertUtils;
import oracle.dbtools.migration.convert.TranslationContext;
import oracle.dbtools.migration.parser.ParserFactoryProvider;
import oracle.dbtools.migration.parser.internalapi.ITranslationAll;
import oracle.dbtools.migration.parser.internalapi.TranslateResultWithASTs;
import oracle.dbtools.migration.translation.SchemaDetails;
import oracle.dbtools.migration.translation.api.ITranslationContext;
import oracle.dbtools.migration.translation.api.TranslationAPI;
import oracle.dbtools.migration.translation.api.TranslationResult;
import oracle.dbtools.migration.translation.api.exceptions.TranslationException;
import oracle.dbtools.migration.translation.api.objects.TranslationDBObject;
import oracle.dbtools.migration.translation.api.objects.TranslationDBObjectReference;

public class RepoTranslationAPI
extends TranslationAPI {
    public static TranslateResultWithASTs translate(String string, SchemaDetails schemaDetails, PersistenceManager persistenceManager, String string2) throws TranslationException, PersistenceException, NoSuchObjectException {
        ITranslationAll iTranslationAll = (ITranslationAll)ParserFactoryProvider.getInstance().getParser(string2);
        return RepoTranslationAPI.translate(string, schemaDetails, persistenceManager, iTranslationAll);
    }

    public static TranslationDBObject getSourceObject(String string, SchemaDetails schemaDetails, PersistenceManager persistenceManager) throws PersistenceException, NoSuchObjectException {
        TranslationDBObject translationDBObject = new TranslationDBObject(RepoTranslationAPI.getReference(schemaDetails, persistenceManager), string);
        return translationDBObject;
    }

    public static DBObjectId getMapId(SchemaDetails schemaDetails, PersistenceManager persistenceManager) {
        PersistableObject persistableObject = null;
        try {
            persistableObject = ConvertUtils.getMapForProjectId(persistenceManager, new DBObjectId(schemaDetails.getProjectId()));
        }
        catch (PersistenceException persistenceException) {
            persistenceException.printStackTrace();
        }
        return persistableObject.getKey();
    }

    private static TranslationDBObjectReference getReference(SchemaDetails schemaDetails, PersistenceManager persistenceManager) throws PersistenceException, NoSuchObjectException {
        TranslationDBObjectReference translationDBObjectReference = null;
        MdSchema mdSchema = MdSchema.retrieveExistingInstance(persistenceManager, new DBObjectId(schemaDetails.getCapSchemaId()));
        DBObjectHierarchy dBObjectHierarchy = new DBObjectHierarchy(mdSchema, persistenceManager);
        translationDBObjectReference = new TranslationDBObjectReference(dBObjectHierarchy.getTranslationDBObjectReference());
        translationDBObjectReference.setOMWBObj((Object)mdSchema);
        return translationDBObjectReference;
    }

    public static TranslateResultWithASTs translate(String string, SchemaDetails schemaDetails, PersistenceManager persistenceManager, ITranslationAll iTranslationAll) throws TranslationException, PersistenceException, NoSuchObjectException {
        TranslateResultWithASTs translateResultWithASTs = null;
        TranslationContext translationContext = null;
        if (schemaDetails == null || !schemaDetails.hasMigrationContext() || persistenceManager == null || iTranslationAll == null) {
            throw new IllegalArgumentException("Invalid schemaDetails or PersistenceManager or ParserString");
        }
        try {
            translationContext = new TranslationContext(persistenceManager, new DBObjectId(schemaDetails.getConConnId()), 100, RepoTranslationAPI.getMapId(schemaDetails, persistenceManager));
        }
        catch (PersistenceException persistenceException) {
            persistenceException.printStackTrace();
        }
        translationContext.enablePreferences(true);
        TranslationResult translationResult = null;
        translationResult = iTranslationAll.translate(RepoTranslationAPI.getSourceObject(string, schemaDetails, persistenceManager), (ITranslationContext)translationContext, null, null, null);
        translateResultWithASTs = new TranslateResultWithASTs(translationResult.getFullDdlScript(), (HashMap)null);
        return translateResultWithASTs;
    }
}

