/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.ui;

import java.awt.Component;
import javax.swing.JPanel;
import oracle.dbtools.migration.workbench.core.ui.MigrationProgressBar;
import oracle.ide.Ide;

public abstract class AbstractMigrationProgressRunnable
implements Runnable {
    private Exception _ex;
    private MigrationProgressBar _progBar;
    private boolean _canceled;
    private Thread _runnerThread;
    private boolean _useThread = true;
    private boolean _useBuzyBar = true;
    private String _title;
    private String _msg;
    private Object _result;

    public final void setTitle(String string) {
        this._title = string;
    }

    public final String getTitle() {
        return this._title;
    }

    public final void setMessage(String string) {
        this._msg = string;
    }

    public final String getMessage() {
        return this._msg;
    }

    public void updateProgress(int n, Object object, Object object2) {
        if (this._progBar == null) {
            return;
        }
        this._progBar.updateProgress(n, object, object2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start(boolean bl) throws Exception {
        this._useThread = bl;
        if (bl) {
            this._progBar = new MigrationProgressBar((Component)Ide.getMainWindow(), this._title, this, this._useBuzyBar);
            JPanel jPanel = this.getTopPanel();
            JPanel jPanel2 = this.getDownPanel();
            this._progBar.setGUI(jPanel, jPanel2);
            this._progBar.start();
            AbstractMigrationProgressRunnable abstractMigrationProgressRunnable = this;
            synchronized (abstractMigrationProgressRunnable) {
                if (this._progBar.hasUserCancelled()) {
                    this._canceled = true;
                    this.doCancel();
                }
                this._progBar = null;
            }
        } else {
            this.run();
        }
        if (this._ex != null && !this._canceled) {
            throw new Exception(this._ex);
        }
        this.finish(this._result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        Object object = null;
        try {
            AbstractMigrationProgressRunnable abstractMigrationProgressRunnable = this;
            synchronized (abstractMigrationProgressRunnable) {
                if (this._progBar != null) {
                    this._progBar.sleepForUIToRepaint();
                    this._runnerThread = Thread.currentThread();
                }
            }
            object = this.doWork();
            if (this._progBar != null) {
                this._result = object;
            }
        }
        catch (Exception exception) {
            this._ex = exception;
        }
        finally {
            AbstractMigrationProgressRunnable abstractMigrationProgressRunnable = this;
            synchronized (abstractMigrationProgressRunnable) {
                if (this._useThread && this._progBar != null && this._progBar.isExitClicked()) {
                    this._runnerThread = null;
                    this._progBar.setDoneStatus();
                }
            }
        }
    }

    protected abstract Object doWork() throws Exception;

    protected void finish(Object object) {
    }

    protected void doCancel() {
        if (this._runnerThread != null) {
            this._runnerThread.interrupt();
            this._runnerThread = null;
            this._result = Boolean.FALSE;
        }
    }

    protected final Thread getRunnerThread() {
        return this._runnerThread;
    }

    public abstract void updateAbovePanel(Object var1);

    public abstract JPanel getTopPanel();

    public abstract JPanel getDownPanel();

    public abstract void updateBelowPanel(Object var1);

    public MigrationProgressBar getProgBar() {
        return this._progBar;
    }

    public boolean isUseBuzyBar() {
        return this._useBuzyBar;
    }

    public void setUseBuzyBar(boolean bl) {
        this._useBuzyBar = bl;
    }
}

