/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;
import oracle.dbtools.migration.datamove.online.DataMoveDrone;
import oracle.dbtools.migration.datamove.online.DataMoveEvent;
import oracle.dbtools.migration.datamove.online.DataMoveListener;
import oracle.dbtools.migration.datamove.online.DroneState;
import oracle.dbtools.migration.datamove.online.ProgressCellRenderer;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.ui.Messages;
import oracle.dbtools.migration.workbench.core.ui.MigrationTaskUI;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskDescriptor;

public class DataMoveDialogTaskUI
extends MigrationTaskUI
implements DataMoveListener {
    private static final String[] S_CURRENT_ACTIVITY_HEADINGS = new String[]{MigrationAddinArb.getString("DATAMOVE_PROG_THREAD"), MigrationAddinArb.getString("DATAMOVE_PROG_TABLE"), MigrationAddinArb.getString("DATAMOVE_PROG_STATE"), MigrationAddinArb.getString("DATAMOVE_PROG_ROWSDONE"), MigrationAddinArb.getString("DATAMOVE_PROG_TOTALROWS"), MigrationAddinArb.getString("DATAMOVE_PROG_CURRENT_ERRORS"), MigrationAddinArb.getString("DATAMOVE_PROG_TOTAL_ERRORS")};
    private static final String[] S_FINISHED_ACTIVITY_HEADINGS = new String[]{MigrationAddinArb.getString("DATAMOVE_PROG_TABLE"), MigrationAddinArb.getString("DATAMOVE_PROG_ROWSDONE"), MigrationAddinArb.getString("DATAMOVE_PROG_TOTALROWS"), MigrationAddinArb.getString("DATAMOVE_PROG_CURRENT_ERRORS"), MigrationAddinArb.getString("DATAMOVE_PROG_TOTAL_ERRORS")};
    private JPanel m_finishedActivityPanel;
    private JTable m_finishedActivityTable;
    private DefaultTableModel m_finishedActivityTableModel;

    public DataMoveDialogTaskUI(RaptorTaskDescriptor raptorTaskDescriptor) {
        super(raptorTaskDescriptor);
    }

    @Override
    public String[] getColumnNames() {
        return S_CURRENT_ACTIVITY_HEADINGS;
    }

    public String[] getBelowColumnNames() {
        return S_FINISHED_ACTIVITY_HEADINGS;
    }

    public int getPanelWidth() {
        return 500;
    }

    @Override
    public JTable getTopTable() {
        JTable jTable = new JTable(){

            @Override
            public String getToolTipText(MouseEvent mouseEvent) {
                return DataMoveDialogTaskUI.this.getTableToolTip(DataMoveDialogTaskUI.this._jTable, mouseEvent, 1);
            }
        };
        Object[] objectArray = this.getColumnNames();
        this._jTableModel = new DefaultTableModel(null, objectArray){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        jTable.setModel(this._jTableModel);
        ProgressCellRenderer progressCellRenderer = new ProgressCellRenderer();
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        tableColumnModel.getColumn(3).setCellRenderer(progressCellRenderer);
        return jTable;
    }

    private String getTableToolTip(JTable jTable, MouseEvent mouseEvent, int n) {
        Object object;
        String string = Messages.getString("DataMoveDialogTaskUI.0");
        Point point = mouseEvent.getPoint();
        int n2 = jTable.rowAtPoint(point);
        int n3 = jTable.columnAtPoint(point);
        int n4 = jTable.convertColumnIndexToModel(n3);
        if ((n4 >= 0 || n4 < jTable.getColumnCount()) && (object = jTable.getValueAt(n2, n)) != null) {
            string = object.toString();
        }
        return string;
    }

    @Override
    protected JPanel getBottomPanel() {
        if (this.m_finishedActivityPanel == null) {
            BorderLayout borderLayout = new BorderLayout();
            borderLayout.setVgap(5);
            this.m_finishedActivityPanel = new JPanel(borderLayout);
            this.m_finishedActivityPanel.setPreferredSize(new Dimension(this.getPanelWidth(), 125));
            JLabel jLabel = new JLabel();
            jLabel.setText(MigrationAddinArb.getString("DATAMOVE_COMPLETED_TABLES_LABEL"));
            this.m_finishedActivityPanel.add((Component)jLabel, "North");
            JScrollPane jScrollPane = new JScrollPane();
            this.m_finishedActivityPanel.add((Component)jScrollPane, "Center");
            jScrollPane.setHorizontalScrollBarPolicy(32);
            jScrollPane.setVerticalScrollBarPolicy(22);
            Object[] objectArray = this.getBelowColumnNames();
            this.m_finishedActivityTableModel = new DefaultTableModel(null, objectArray){

                @Override
                public boolean isCellEditable(int n, int n2) {
                    return false;
                }
            };
            this.m_finishedActivityTable = new JTable(){

                @Override
                public String getToolTipText(MouseEvent mouseEvent) {
                    return DataMoveDialogTaskUI.this.getTableToolTip(DataMoveDialogTaskUI.this.m_finishedActivityTable, mouseEvent, 0);
                }
            };
            jScrollPane.setViewportView(this.m_finishedActivityTable);
            this.m_finishedActivityTable.setModel(this.m_finishedActivityTableModel);
        }
        return this.m_finishedActivityPanel;
    }

    @Override
    public void raiseEvent(final DataMoveEvent dataMoveEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DataMoveDialogTaskUI.this.raiseSwingEvent(dataMoveEvent);
            }
        });
    }

    private void raiseSwingEvent(DataMoveEvent dataMoveEvent) {
        int n = 0;
        this.getTaskDescriptor().setMessage(this.getTaskDescriptor().getMessage());
        if (dataMoveEvent.getEventId() == 3) {
            DroneState droneState;
            DataMoveDrone dataMoveDrone = (DataMoveDrone)dataMoveEvent.getSupplementaryData();
            if (dataMoveDrone != null && (droneState = dataMoveDrone.getState()).getCurrentTable().length() != 0) {
                Vector<String> vector = new Vector<String>();
                vector.add(droneState.getCurrentTable());
                vector.add(new Long(droneState.getRowsMoved()).toString());
                String string = droneState.getTableRowCount() == -1L ? "unknown" : Long.valueOf(droneState.getTableRowCount());
                vector.add(string.toString());
                vector.add(new Long(droneState.getThisErrorCount()).toString());
                vector.add(new Long(droneState.getTotalErrorCount()).toString());
                this.m_finishedActivityTableModel.addRow(vector);
                this.m_finishedActivityTable.scrollRectToVisible(this.m_finishedActivityTable.getCellRect(this.m_finishedActivityTableModel.getRowCount() - 1, 0, true));
                this.m_finishedActivityTableModel.fireTableDataChanged();
            }
        } else {
            DroneState[] droneStateArray = (DroneState[])dataMoveEvent.getSupplementaryData();
            if (droneStateArray != null) {
                while (this._jTableModel.getRowCount() < droneStateArray.length) {
                    Object[] objectArray = new Object[this.getColumnNames().length];
                    this._jTableModel.addRow(objectArray);
                }
                this._jTableModel.fireTableDataChanged();
                for (int i = 0; i < droneStateArray.length; ++i) {
                    n += droneStateArray[i].getTotalTablesMoved();
                    this._jTableModel.setValueAt(droneStateArray[i].getId(), i, 0);
                    this._jTableModel.setValueAt(droneStateArray[i].getCurrentTable(), i, 1);
                    this._jTableModel.setValueAt(droneStateArray[i].getProcessState(), i, 2);
                    this._jTableModel.setValueAt(droneStateArray[i].getRowsMoved(), i, 3);
                    this._jTableModel.setValueAt(droneStateArray[i].getTableRowCount() == -1L ? "unknown" : Long.valueOf(droneStateArray[i].getTableRowCount()), i, 4);
                    this._jTableModel.setValueAt(droneStateArray[i].getThisErrorCount(), i, 5);
                    this._jTableModel.setValueAt(droneStateArray[i].getTotalErrorCount(), i, 6);
                }
                this._jTableModel.fireTableDataChanged();
            }
        }
    }

    @Override
    public String getEventString(Object object) {
        return Messages.getString("DataMoveDialogTaskUI.3");
    }
}

