/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.ui.treeTable;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.LogRecord;

public class MigrationTreeNode {
    private LogRecord _userObject;
    private List<MigrationTreeNode> _children;
    private String _displayString;

    public MigrationTreeNode(LogRecord logRecord) {
        this(logRecord.getMessage(), logRecord);
    }

    public MigrationTreeNode(String string, LogRecord logRecord) {
        this._userObject = logRecord;
        this._displayString = string;
        this._children = new ArrayList<MigrationTreeNode>();
    }

    public String toString() {
        return this._displayString;
    }

    public LogRecord getUserObject() {
        return this._userObject;
    }

    public List<MigrationTreeNode> getChildren() {
        return this._children;
    }

    public MigrationTreeNode addChild(String string, LogRecord logRecord) {
        MigrationTreeNode migrationTreeNode = new MigrationTreeNode(string, logRecord);
        this._children.add(migrationTreeNode);
        return migrationTreeNode;
    }

    public MigrationTreeNode getChildAt(int n) {
        return this._children.get(n);
    }

    public int getChildCount() {
        return this._children.size();
    }

    public MigrationTreeNode insertChildAt(int n, String string, LogRecord logRecord) {
        MigrationTreeNode migrationTreeNode = new MigrationTreeNode(string, logRecord);
        this._children.add(n, migrationTreeNode);
        return migrationTreeNode;
    }

    public void removeChildAt(int n) {
        this._children.remove(n);
    }

    public void removeAllChildren() {
        this._children.clear();
    }
}

