/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.latch;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.latch.LatchException;
import com.sleepycat.je.latch.LatchNotHeldException;
import com.sleepycat.je.latch.LatchSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class SharedLatch
extends ReentrantReadWriteLock {
    private String name;
    private boolean noteLatch;
    private List<Thread> readers;
    private boolean exclusiveOnly;

    public SharedLatch(String name) {
        super(EnvironmentImpl.getFairLatches());
        assert ((this.readers = Collections.synchronizedList(new ArrayList())) != null);
        this.exclusiveOnly = false;
        this.name = name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean setNoteLatch(boolean noteLatch) {
        this.noteLatch = noteLatch;
        return true;
    }

    public void setExclusiveOnly(boolean exclusiveOnly) {
        this.exclusiveOnly = exclusiveOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquireExclusive() throws DatabaseException {
        try {
            if (this.isWriteLockedByCurrentThread()) {
                throw new LatchException(this.name + " already held");
            }
            this.writeLock().lock();
            assert (!this.noteLatch || this.noteLatch());
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            assert (EnvironmentImpl.maybeForceYield());
            throw throwable;
        }
        assert (EnvironmentImpl.maybeForceYield());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean acquireExclusiveNoWait() throws DatabaseException {
        boolean bl;
        try {
            if (this.isWriteLockedByCurrentThread()) {
                throw new LatchException(this.name + " already held");
            }
            boolean ret = this.writeLock().tryLock();
            assert (!(this.noteLatch & ret) || this.noteLatch());
            bl = ret;
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            assert (EnvironmentImpl.maybeForceYield());
            throw throwable;
        }
        assert (EnvironmentImpl.maybeForceYield());
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquireShared() throws DatabaseException {
        if (this.exclusiveOnly) {
            this.acquireExclusive();
            return;
        }
        try {
            boolean assertionsEnabled = false;
            if (!$assertionsDisabled) {
                assertionsEnabled = true;
                if (!true) {
                    throw new AssertionError();
                }
            }
            if (assertionsEnabled) {
                if (this.readers.add(Thread.currentThread())) {
                    this.readLock().lock();
                }
            } else {
                this.readLock().lock();
            }
            assert (!this.noteLatch || this.noteLatch());
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            assert (EnvironmentImpl.maybeForceYield());
            throw throwable;
        }
        assert (EnvironmentImpl.maybeForceYield());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void release() throws LatchNotHeldException {
        try {
            if (this.isWriteLockedByCurrentThread()) {
                this.writeLock().unlock();
                assert (!this.noteLatch || this.unNoteLatch());
                return;
            }
            if (this.exclusiveOnly) {
                return;
            }
            boolean assertionsEnabled = false;
            if (!$assertionsDisabled) {
                assertionsEnabled = true;
                if (!true) {
                    throw new AssertionError();
                }
            }
            if (assertionsEnabled) {
                if (!this.readers.remove(Thread.currentThread())) throw new LatchNotHeldException(this.name + " not held");
                this.readLock().unlock();
            } else {
                this.readLock().unlock();
            }
            assert (!this.noteLatch || this.unNoteLatch());
            return;
        }
        catch (IllegalMonitorStateException IMSE) {
            IMSE.printStackTrace();
            return;
        }
    }

    public void releaseIfOwner() throws LatchNotHeldException {
        if (this.isWriteLockedByCurrentThread()) {
            this.writeLock().unlock();
            assert (!this.noteLatch || this.unNoteLatch());
            return;
        }
        if (this.exclusiveOnly) {
            return;
        }
        assert (this.getReadLockCount() > 0);
        boolean assertionsEnabled = false;
        if (!$assertionsDisabled) {
            assertionsEnabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (assertionsEnabled) {
            if (this.readers.contains(Thread.currentThread())) {
                this.readLock().unlock();
                this.readers.remove(Thread.currentThread());
                assert (!this.noteLatch || this.unNoteLatch());
            }
        } else {
            this.readLock().unlock();
        }
    }

    public boolean isOwner() {
        boolean assertionsEnabled = false;
        if (!$assertionsDisabled) {
            assertionsEnabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (assertionsEnabled && !this.exclusiveOnly) {
            return this.readers.contains(Thread.currentThread()) || this.isWriteLockedByCurrentThread();
        }
        return this.isWriteLockedByCurrentThread();
    }

    private boolean noteLatch() throws LatchException {
        return LatchSupport.latchTable.noteLatch(this);
    }

    private boolean unNoteLatch() {
        return LatchSupport.latchTable.unNoteLatch(this, this.name);
    }
}

