/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.compiler;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import oracle.aurora.compiler.OptionTable;

public class DictionaryOptionTable
extends OptionTable {
    Dictionary levels;

    DictionaryOptionTable(Dictionary levels) {
        if (levels == null) {
            levels = new Hashtable();
        }
        this.levels = levels;
    }

    protected Enumeration getValues(String level, String id) {
        return new LookupState(level, id);
    }

    protected void resetValues(String level, String id) {
        LookupState values = new LookupState(level, id);
        while (values.hasMoreElements()) {
            this.levels.remove(values.getKey());
            values.nextElement();
        }
    }

    protected void addValue(String level, String id, String value) {
        LookupState values = new LookupState(level, id);
        while (values.hasMoreElements()) {
            values.nextElement();
        }
        this.levels.put(values.getKey(), value);
    }

    class LookupState
    implements Enumeration {
        String level;
        String id;
        int n = 0;
        String value;

        LookupState(String level, String id) {
            this.level = level;
            this.id = id;
            this.n = 0;
            this.lookup();
        }

        String getKey() {
            String key = this.level + "/" + this.id;
            if (this.n > 0) {
                key = key + "/" + this.n;
            }
            return key;
        }

        void lookup() {
            this.value = (String)DictionaryOptionTable.this.levels.get(this.getKey());
        }

        public boolean hasMoreElements() {
            return this.value != null;
        }

        public Object nextElement() {
            String result = this.value;
            if (result != null) {
                ++this.n;
                this.lookup();
            }
            return result;
        }
    }
}

