/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.rdbms.security;

import java.security.AccessControlContext;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.ProtectionDomain;
import java.util.Hashtable;
import oracle.aurora.rdbms.Schema;
import oracle.aurora.rdbms.security.PolicyTable;
import oracle.aurora.rdbms.security.PolicyTableManager;
import oracle.aurora.rdbms.security.PolicyTableProxy;
import oracle.aurora.rdbms.security.SchemaCodeSource;
import oracle.aurora.rdbms.security.SchemaJServerPermission;
import oracle.aurora.rdbms.security.SysProtectionDomain;
import sun.reflect.Reflection;

public class SchemaProtectionDomain
extends ProtectionDomain {
    static final int SYSTEM_OWNER_NUMBER = 0;
    public static final Class theClass = Reflection.getCallerClass((int)1);
    private static SchemaProtectionDomain sysProtectionDomain;
    private static AccessControlContext sysAccessControlContext;
    private static Hashtable schemaToDomain;
    private static PolicyTableProxy.TableGetter getter;

    public SchemaProtectionDomain(Schema schema) {
        super(new SchemaCodeSource(schema), getter.table().getProxy(schema));
    }

    public SchemaProtectionDomain(Schema schema, Class clazz) {
        super(new SchemaCodeSource(schema, clazz), getter.table().getProxy(schema));
    }

    public Schema getSchema() {
        return ((SchemaCodeSource)this.getCodeSource()).getSchema();
    }

    public int hashCode() {
        return this.getSchema().hashCode();
    }

    public boolean equals(Object rhs) {
        boolean result = rhs instanceof SchemaProtectionDomain ? this.getSchema().equals(((SchemaProtectionDomain)rhs).getSchema()) : super.equals(rhs);
        return result;
    }

    public String toString() {
        return this.getSchema().toString();
    }

    public boolean implies(Permission p) {
        boolean result = super.implies(p);
        if (!result && p instanceof SchemaJServerPermission) {
            PermissionCollection tester = ((SchemaJServerPermission)((Object)p)).getPermissionFor(this.getSchema());
            result = tester.implies(p);
        }
        return result;
    }

    public static SchemaProtectionDomain getSysProtectionDomain() {
        if (sysProtectionDomain == null) {
            sysProtectionDomain = new SysProtectionDomain();
        }
        return sysProtectionDomain;
    }

    private static synchronized AccessControlContext getSysAccessControlContext() {
        if (sysAccessControlContext == null) {
            ProtectionDomain[] array = new ProtectionDomain[]{SchemaProtectionDomain.getSysProtectionDomain()};
            sysAccessControlContext = new AccessControlContext(array);
        }
        return sysAccessControlContext;
    }

    private static SchemaProtectionDomain getProtectionDomain(Schema s) {
        SchemaProtectionDomain result;
        if (s.ownerNumber() == 0) {
            result = SchemaProtectionDomain.getSysProtectionDomain();
        } else {
            result = (SchemaProtectionDomain)schemaToDomain.get(s);
            if (result == null) {
                result = new SchemaProtectionDomain(s);
                schemaToDomain.put(s, result);
            }
        }
        return result;
    }

    private static ProtectionDomain ownerProtectionDomain(int ownerNumber) {
        if (ownerNumber == 0) {
            return SchemaProtectionDomain.getSysProtectionDomain();
        }
        return new SchemaProtectionDomain(Schema.lookup(ownerNumber));
    }

    private static ProtectionDomain fabricateProtectionDomain(int owner) {
        return new SchemaProtectionDomain(Schema.lookup(owner));
    }

    private static ProtectionDomain fabricateProtectionDomain(int owner, Class clazz) {
        return new SchemaProtectionDomain(Schema.lookup(owner), clazz);
    }

    private static boolean debugFlag() {
        return PolicyTableManager.getDebugLevel() > 3;
    }

    static {
        schemaToDomain = new Hashtable();
        getter = new PolicyTableProxy.TableGetter(){

            public PolicyTable table() {
                return PolicyTableManager.getTable();
            }
        };
    }
}

