/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.server.tools.ojvmtc;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.UnknownHostException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import oracle.aurora.server.tools.loadjava.ByteCode;
import oracle.aurora.server.tools.loadjava.ByteCodeReader;
import oracle.aurora.server.tools.ojvmtc.OjvmTcOptions;
import oracle.aurora.util.classfile.Descriptor;
import oracle.aurora.util.classfile.Dig;
import oracle.aurora.util.classfile.Raw;
import oracle.aurora.util.classfile.RawFactory;
import oracle.aurora.util.tools.ToolException;
import oracle.jdbc.pool.OracleDataSource;

public class OjvmTcMain
implements Raw.JavaConstants {
    private OjvmTcOptions ops = null;
    private URLClassLoader bcp = null;
    private URLClassLoader cp = null;
    private Connection servcon = null;
    private ZipOutputStream zos = null;
    static final byte[] version = new byte[]{0};
    static String ojvmtcAttributeName = "aurora.ojvmtc";
    HashSet existsSet = new HashSet();
    HashSet missingSet = new HashSet();
    HashSet interfacesSet = new HashSet();
    HashMap methodsMap = new HashMap();

    OjvmTcMain() {
    }

    public static void main(String[] argv) {
        String[] allargs = null;
        String servstr = System.getenv("TCSERV");
        if (servstr != null) {
            allargs = new String[argv.length + 2];
            System.arraycopy(servstr.split(" "), 0, allargs, 0, 2);
            System.arraycopy(argv, 0, allargs, 2, argv.length);
        } else {
            allargs = argv;
        }
        OjvmTcMain tcm = new OjvmTcMain();
        int results = tcm.run(allargs);
        System.exit(results);
    }

    int run(String[] args) {
        String[] targets = this.parseArgs(args);
        int error = 0;
        ZipInputStream zip = null;
        ByteArrayInputStream bis = null;
        for (int i = 0; i < targets.length; ++i) {
            int idx = targets[i].lastIndexOf(".");
            if (idx == -1) {
                System.out.println("file is not a supported type = " + targets[i]);
                continue;
            }
            String post = targets[i].substring(idx);
            if (post.equals(".class")) {
                try {
                    bis = this.makeInputStream(new FileInputStream(targets[i]));
                    this.add(bis);
                    continue;
                }
                catch (IOException ioe) {
                    System.out.println("error opening: " + ioe.getMessage());
                    return -1;
                }
                catch (ToolException te) {
                    System.out.println("error while reading  " + bis.toString());
                    System.out.println("exception: " + te.getMessage());
                    return -1;
                }
            }
            if (post.equals(".jar") || post.equals(".zip")) {
                try {
                    zip = new ZipInputStream(new FileInputStream(targets[i]));
                    ZipEntry entry = zip.getNextEntry();
                    while (entry != null) {
                        if (entry.getName().endsWith(".class")) {
                            bis = this.makeInputStream(zip);
                            this.add(bis);
                        }
                        zip.closeEntry();
                        entry = zip.getNextEntry();
                    }
                    continue;
                }
                catch (IOException ioe) {
                    System.out.println("error while processing entry in " + targets[i]);
                    return -1;
                }
                catch (ToolException te) {
                    System.out.println("error while reading " + targets[i]);
                    return -1;
                }
            }
            System.out.println(targets[i] + " is not a class, zip, or jar file");
        }
        if (this.missingSet.size() > 0) {
            if (this.ops.getBoolean("-list")) {
                System.out.println("The following classes could not be found:");
                Iterator it = this.missingSet.iterator();
                while (it.hasNext()) {
                    System.out.println((String)it.next());
                }
            } else {
                System.out.println("The set is not closed");
                System.out.println(this.missingSet.size() + " classes are missing");
            }
            if (this.zos != null && this.missingSet.size() > 0) {
                System.out.println("generating stub classes");
                for (String name : this.missingSet) {
                    try {
                        ZipEntry entry = new ZipEntry(name + ".class");
                        this.zos.putNextEntry(entry);
                        this.generate(name, this.zos);
                        this.zos.closeEntry();
                        this.zos.flush();
                    }
                    catch (IOException ioe) {
                        System.out.println("error generating stub for class " + name);
                        error = -1;
                    }
                }
            }
        } else {
            System.out.println("The set is closed");
        }
        if (this.zos != null) {
            try {
                this.zos.flush();
                this.zos.close();
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        return error;
    }

    void add(InputStream in) throws IOException, ToolException {
        Dig dig = new Dig(new Raw.Class(in));
        Dig.Class digClass = dig.getClazz();
        in.reset();
        this.writeClass(in, digClass.getSlashName());
        this.noteExists(digClass.getSlashName());
        Dig.ConstantPool pool = digClass.getConstants();
        this.classReference(digClass.getSlashSuperClass());
        block5: for (int xConstant = 1; xConstant < pool.size(); ++xConstant) {
            switch (pool.getConstantType(xConstant)) {
                case 7: {
                    String className = pool.getClass(xConstant);
                    className = this.stripArray(className);
                    this.classReference(className);
                    continue block5;
                }
                case 10: {
                    String className = this.stripArray(pool.getDeclaringClass(xConstant));
                    this.classReference(className);
                    this.methodReference(digClass, pool.getDeclaringClass(xConstant), pool.getNameOfRef(xConstant), pool.getDescriptorOfRef(xConstant), xConstant);
                    continue block5;
                }
                case 11: {
                    this.interfaceReference(pool.getDeclaringClass(xConstant));
                    this.methodReference(digClass, pool.getDeclaringClass(xConstant), pool.getNameOfRef(xConstant), pool.getDescriptorOfRef(xConstant), 0);
                }
            }
        }
        for (int xInterface = 0; xInterface < digClass.getInterfaceCount(); ++xInterface) {
            String iName = digClass.getInterface(xInterface);
            this.interfaceReference(iName);
        }
        Dig.Methods methods = digClass.getMethods();
        for (int xMethod = 0; xMethod < methods.count(); ++xMethod) {
            this.noteDescriptor(methods.get(xMethod).getDescriptor());
        }
        Dig.Fields fields = digClass.getFields();
        for (int xFields = 0; xFields < fields.count(); ++xFields) {
            Descriptor d = new Descriptor(fields.get(xFields).getDescriptor());
            if (!d.getFieldType().isClass()) continue;
            String className = d.getFieldType().name();
            this.classReference(className);
        }
    }

    String[] parseArgs(String[] arg) {
        String envcp;
        String[] unused = null;
        this.ops = new OjvmTcOptions();
        unused = this.ops.parseArgs(arg);
        if (this.ops.getBoolean("-help")) {
            this.help();
            System.exit(0);
        }
        if (unused == null || unused.length == 0) {
            this.usage();
            System.exit(-1);
        }
        if (this.ops.getBoolean("-bootclasspath")) {
            String b = null;
            b = this.ops.getString("-bootclasspath");
            if (b != null) {
                String[] tmp = b.split(File.pathSeparator);
                URL[] tmpbcp = new URL[tmp.length];
                for (int i = 0; i < tmp.length; ++i) {
                    try {
                        tmpbcp[i] = new File(tmp[i]).toURL();
                        continue;
                    }
                    catch (MalformedURLException mue) {
                        // empty catch block
                    }
                }
                this.bcp = new URLClassLoader(tmpbcp, null);
            } else {
                System.out.println("-bootclasspath requires a path argument");
                this.usage();
                System.exit(-1);
            }
        }
        String clcp = this.ops.getString("-classpath");
        URL[] tmpcp = null;
        String[] tmp = null;
        tmp = clcp == null ? ((envcp = System.getenv("CLASSPATH")) != null ? envcp.split(File.pathSeparator) : new String[]{"."}) : clcp.split(File.pathSeparator);
        tmpcp = new URL[tmp.length];
        for (int i = 0; i < tmp.length; ++i) {
            try {
                tmpcp[i] = new File(tmp[i]).toURL();
                continue;
            }
            catch (MalformedURLException mue) {
                // empty catch block
            }
        }
        this.cp = new URLClassLoader(tmpcp, null);
        String jname = null;
        if (this.ops.getBoolean("-jar")) {
            jname = this.ops.getString("-jar");
            if (jname == null) {
                System.out.println("-jar requires a file name argument");
                this.usage();
                System.exit(-1);
            }
            try {
                BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(jname));
                this.zos = new ZipOutputStream(os);
            }
            catch (IOException ioe) {
                System.out.println("could not open jar file " + jname);
                System.out.println("closure set will not be written");
            }
        }
        if (this.ops.getBoolean("-server")) {
            String conninfo = this.ops.getString("-server");
            if (conninfo == null) {
                System.out.println("-server requires a connection string");
                this.usage();
                System.exit(-1);
            }
            this.servcon = this.getConnection(conninfo);
        }
        return unused;
    }

    Connection getConnection(String constr) {
        Connection conn = null;
        Properties prop = new Properties();
        int din = constr.indexOf(58);
        int pin = constr.indexOf(47);
        int hin = constr.indexOf(64);
        String driver = constr.substring(0, din);
        String user = constr.substring(din + 1, pin);
        String pass = null;
        String cstr = null;
        if (hin == -1) {
            pass = constr.substring(pin + 1);
            cstr = "";
        } else {
            pass = constr.substring(pin + 1, hin);
            cstr = constr.substring(hin + 1);
        }
        try {
            OracleDataSource ods = new OracleDataSource();
            if (driver.equals("oci")) {
                ods.setDriverType("oci");
                if (cstr != null) {
                    if (cstr.startsWith("(DESCRIPTION=")) {
                        prop.put("database", cstr);
                    } else if (cstr.indexOf(":") != -1) {
                        int port = Integer.parseInt(cstr.substring(cstr.indexOf(":") + 1, cstr.lastIndexOf(":")));
                        String server = cstr.substring(0, cstr.indexOf(":"));
                        String dbase = cstr.substring(cstr.lastIndexOf(":") + 1);
                        if (server.equals("localhost")) {
                            try {
                                server = InetAddress.getLocalHost().getHostName();
                            }
                            catch (UnknownHostException uhe) {
                                // empty catch block
                            }
                        }
                        ods.setServerName(server);
                        ods.setPortNumber(port);
                        ods.setDatabaseName(dbase);
                    } else {
                        ods.setTNSEntryName(cstr);
                    }
                }
            } else if (driver.equals("thin")) {
                ods.setDriverType("thin");
                String server = cstr.substring(0, cstr.indexOf(":"));
                int port = Integer.parseInt(cstr.substring(cstr.indexOf(":") + 1, cstr.lastIndexOf(":")));
                String dbase = cstr.substring(cstr.lastIndexOf(":") + 1);
                ods.setServerName(server);
                ods.setPortNumber(port);
                ods.setDatabaseName(dbase);
            } else {
                System.out.println(driver + " is not a valid Oracle JDBC driver type");
                System.exit(-1);
            }
            prop.put("user", user);
            prop.put("password", pass);
            if (user.toUpperCase().equals("SYS")) {
                prop.put("internal_logon", "sysdba");
            }
            ods.setConnectionProperties(prop);
            conn = ods.getConnection();
        }
        catch (SQLException e) {
            System.out.println("server connection error");
            System.out.println(e.getErrorCode() + ": " + e.getMessage());
            conn = null;
            System.exit(-1);
        }
        return conn;
    }

    void interfaceReference(String name) {
        if (name != null) {
            this.classReference(name);
            this.interfacesSet.add(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void classReference(String name) {
        while (name != null && name.length() > 0 && name.charAt(0) == '[') {
            if (!(name = name.substring(1)).equals("I") && !name.equals("B") && !name.equals("C") && !name.equals("D") && !name.equals("F") && !name.equals("J") && !name.equals("S") && !name.equals("Z")) continue;
            return;
        }
        if (name != null && !this.existsSet.contains(name) && !this.missingSet.contains(name)) {
            URL srch = null;
            if (this.bcp != null && (srch = this.bcp.findResource(name + ".class")) != null) {
                this.noteExists(name);
                return;
            }
            boolean found = false;
            if (this.servcon != null) {
                CallableStatement shortNameStmt = null;
                Statement selectStmt = null;
                try {
                    shortNameStmt = this.servcon.prepareCall("{? = call dbms_java.shortname(?) }");
                    shortNameStmt.setString(2, name);
                    shortNameStmt.registerOutParameter(1, 12);
                    shortNameStmt.execute();
                    String shortName = shortNameStmt.getString(1);
                    selectStmt = this.servcon.prepareStatement("SELECT object_name FROM all_objects WHERE  OBJECT_TYPE = 'JAVA CLASS' AND  OBJECT_NAME = ? ");
                    selectStmt.setString(1, shortName);
                    ResultSet r = selectStmt.executeQuery();
                    found = r.next();
                    r.close();
                }
                catch (SQLException sqlex) {
                    System.out.println("error during database lookup for " + name);
                }
                finally {
                    try {
                        if (shortNameStmt != null) {
                            shortNameStmt.close();
                        }
                        if (selectStmt != null) {
                            selectStmt.close();
                        }
                    }
                    catch (SQLException ignore) {}
                }
                if (found) {
                    this.noteExists(name);
                    return;
                }
            }
            if ((srch = this.cp.findResource(name + ".class")) != null) {
                ByteArrayInputStream bis = null;
                try {
                    InputStream in = srch.openStream();
                    bis = this.makeInputStream(in);
                    this.add(bis);
                }
                catch (IOException ioe) {
                    System.out.println("error while opening " + ioe.getMessage());
                }
                catch (ToolException te) {
                    System.out.println("error while reading  " + te.getMessage());
                }
            } else {
                this.noteMissing(name);
            }
        }
    }

    void typeReference(Descriptor.Type type) {
        if (type != null && type.isClass()) {
            this.classReference(type.name());
        }
    }

    void noteDescriptor(String descriptor) {
        Descriptor d = new Descriptor(descriptor);
        if (d.isMethod()) {
            Descriptor.Type[] args = d.getArgs();
            for (int xArg = 0; xArg < args.length; ++xArg) {
                this.typeReference(args[xArg]);
            }
            this.typeReference(d.getReturnType());
        }
    }

    void methodReference(Dig.Class dclass, String className, String methodName, String descriptor, int const_pool_offset) {
        if (!this.existsSet.contains(className)) {
            int is_static = 0;
            Raw.Class rclass = dclass.getRaw();
            int count = rclass.methodCount;
            HashSet<MethodInfo> classMethods = (HashSet<MethodInfo>)this.methodsMap.get(className);
            if (classMethods == null) {
                classMethods = new HashSet<MethodInfo>();
                this.methodsMap.put(className, classMethods);
            }
            for (int i = 0; i < count; ++i) {
                Raw.Member rmeth = rclass.methods[i];
                Dig.Methods meths = dclass.getMethods();
                Dig.Member digm = meths.get(i);
                Dig.Attribute attr = digm.getAttributes().get("Code");
                if (attr == null) continue;
                Dig.Code code = dclass.makeCode(attr);
                byte[] bcodes = code.getBytecodes();
                ByteCode currbc = new ByteCode();
                ByteCodeReader bcr = new ByteCodeReader(bcodes, 0);
                while (bcr.hasNext()) {
                    bcr.readNextByteCode(currbc);
                    int opcode = currbc.getOpcode();
                    switch (opcode) {
                        case 184: {
                            if (currbc.getArgsAsCPIndex() != const_pool_offset) break;
                            is_static = 8;
                        }
                    }
                }
            }
            MethodInfo m = new MethodInfo(methodName, descriptor, is_static);
            classMethods.add(m);
            this.noteDescriptor(descriptor);
        }
    }

    void addMethod(RawFactory factory, MethodInfo info) {
        Raw.Code codeAttribute;
        String name = info.name;
        String descriptor = info.descriptor;
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        DataOutputStream d = new DataOutputStream(b);
        Raw.Constant errorClass = factory.constant(7, "java/lang/NoClassDefFoundError");
        Raw.Constant objectClass = factory.constant(7, "java/lang/Object");
        Raw.Constant message = factory.constant(8, "!!!ERROR!!! generated by genmissing");
        Raw.Constant exceptionCtorType = factory.constant(1, "(Ljava/lang/String;)V");
        Raw.Constant objectCtorType = factory.constant(1, "()V");
        Raw.Constant ctorName = factory.constant(1, "<init>");
        Raw.Constant ctor = factory.constant(10, errorClass, factory.constant(12, ctorName, exceptionCtorType));
        Raw.Constant objectCtor = factory.constant(10, objectClass, factory.constant(12, ctorName, objectCtorType));
        if ((info.access & 0x400) != 0) {
            codeAttribute = null;
        } else {
            try {
                if (name.equals("<init>")) {
                    d.writeByte(42);
                    d.writeByte(183);
                    d.writeShort(factory.add(objectCtor));
                }
                d.writeByte(187);
                d.writeShort(factory.add(errorClass));
                d.writeByte(89);
                d.writeByte(19);
                d.writeShort(factory.add(message));
                d.writeByte(183);
                d.writeShort(factory.add(ctor));
                d.writeByte(191);
                d.flush();
            }
            catch (IOException ioex) {
                System.out.println("error adding " + name + " to class");
            }
            byte[] byteCodes = b.toByteArray();
            Descriptor xDescriptor = new Descriptor(descriptor);
            int argLen = 2 * xDescriptor.getArgs().length;
            codeAttribute = new Raw.Code(argLen + 4, argLen + 1, byteCodes, null, null);
        }
        factory.addMethod(info.access, name, descriptor, codeAttribute, null);
    }

    void addMethodInfos(Set infos, RawFactory factory, int access) {
        if (infos != null) {
            for (MethodInfo m : infos) {
                m.access |= access;
                this.addMethod(factory, m);
            }
        }
    }

    void addOjvmtcAttribute(RawFactory factory) {
        int xName = factory.addConstant(1, ojvmtcAttributeName);
        factory.add(new Raw.Attribute(xName, version));
    }

    void generate(String name, OutputStream out) {
        try {
            System.out.println("generating: " + name);
            RawFactory factory = new RawFactory();
            factory.setThis(name);
            factory.setSuper("java/lang/Object");
            int classAccess = 1;
            int methodAccess = 1;
            if (this.interfacesSet.contains(name)) {
                classAccess |= 0x600;
                methodAccess |= 0x400;
            }
            factory.setAccess(classAccess);
            this.addMethod(factory, new MethodInfo("<clinit>", "()V", 8));
            boolean access = true;
            this.addMethodInfos((Set)this.methodsMap.get(name), factory, methodAccess);
            this.addOjvmtcAttribute(factory);
            Raw.Class raw = factory.toRaw();
            DataOutputStream dOut = new DataOutputStream(out);
            raw.output(dOut);
        }
        catch (IOException ioex) {
            System.out.println("error generating " + name);
        }
    }

    void noteExists(String className) {
        this.existsSet.add(className);
        this.missingSet.remove(className);
        this.methodsMap.remove(className);
    }

    void noteMissing(String className) {
        this.missingSet.add(className);
    }

    String stripArray(String className) {
        String result;
        if (className == null) {
            result = className;
        } else if (className.length() == 0) {
            result = className;
        } else if (className.charAt(0) != '[') {
            result = className;
        } else {
            int x;
            for (x = 0; x < className.length() && className.charAt(x) == '['; ++x) {
            }
            result = x < className.length() && className.charAt(x) == 'L' ? className.substring(x + 1, className.length() - 1) : null;
        }
        return result;
    }

    void usage() {
        System.out.println("ojvmtc [-help ] [-bootclasspath] [-server connect_string] [-jar jar_name] [-list] -classpath jar1:path2:jar2  jars,...,classes");
    }

    void help() {
        this.usage();
        System.out.println("-bootclasspath          Classes used for closure but not included in the ");
        System.out.println("                        closure set");
        System.out.println();
        System.out.println("-server connect_string  Connect to the server and uses classes found there.");
        System.out.println("                        Classes are not included in the closure set");
        System.out.println("connect_string");
        System.out.println("    thin                thin:user/passwd@host:port:sid");
        System.out.println("    oci                 oci:user/passwd@host:port:sid");
        System.out.println("                        oci:user/passwd@tnsname");
        System.out.println("                        oci:user/passwd@(connect descriptor)");
        System.out.println();
        System.out.println("-jar jar_name           Write each class of the closure set to a jar");
        System.out.println("                        and generate stubs for missing classes");
        System.out.println();
        System.out.println("-list                   List the missing classes");
        System.out.println();
        System.out.println("-classpath              Use the specified jars and classes for the closure set");
    }

    void writeClass(InputStream in, String name) {
        if (this.zos != null && !this.existsSet.contains(name)) {
            try {
                ZipEntry entry = new ZipEntry(name + ".class");
                this.zos.putNextEntry(entry);
                int count = 0;
                byte[] buf = new byte[4096];
                while (count >= 0) {
                    try {
                        count = in.read(buf);
                    }
                    catch (EOFException ex) {
                        count = -1;
                    }
                    if (count <= 0) continue;
                    this.zos.write(buf, 0, count);
                }
                this.zos.closeEntry();
                this.zos.flush();
            }
            catch (IOException ioe) {
                System.out.println("error while writing " + name + " to jar file");
                System.out.println(ioe.getMessage());
            }
            try {
                in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    ByteArrayInputStream makeInputStream(InputStream in) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int count = 0;
        byte[] buf = new byte[4096];
        while (count >= 0) {
            try {
                count = in.read(buf);
            }
            catch (EOFException ex) {
                count = -1;
            }
            if (count <= 0) continue;
            baos.write(buf, 0, count);
        }
        return new ByteArrayInputStream(baos.toByteArray());
    }

    static class MethodInfo {
        int access;
        String name;
        String descriptor;

        MethodInfo(String name, String descriptor, int access) {
            this.name = name;
            this.descriptor = descriptor;
            this.access = access;
        }

        MethodInfo(String name, String descriptor) {
            this(name, descriptor, 1);
        }

        public int hashCode() {
            return this.name.hashCode() + this.descriptor.hashCode();
        }

        public boolean equals(Object other) {
            return other instanceof MethodInfo && this.name.equals(((MethodInfo)other).name) && this.descriptor.equals(((MethodInfo)other).descriptor) && this.access == ((MethodInfo)other).access;
        }

        public String toString() {
            return "<" + this.name + "," + this.descriptor + ", " + Integer.toHexString(this.access) + ">";
        }
    }
}

