/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.util.classfile;

import java.util.Vector;

public class Descriptor {
    String descriptor;
    boolean errorReported;
    int errorOffset;
    Type returnType;
    Type fieldType;
    Type[] argTypes;
    Vector argV;
    int paramLength;
    int paramCount;
    int offset;
    int end;

    public Descriptor(String descriptor) {
        this.descriptor = descriptor;
        this.offset = 0;
        this.errorReported = false;
        if (descriptor == null || descriptor.length() == 0) {
            this.vassert(false);
        } else {
            this.end = descriptor.length();
            if (this.isMethod()) {
                this.parseMethod();
            } else {
                this.fieldType = this.parseField(false);
            }
            this.checkAtEnd();
        }
    }

    public boolean parseError() {
        return this.errorReported;
    }

    public boolean isMethod() {
        return this.descriptor != null && this.descriptor.charAt(0) == '(';
    }

    public int getParamLength() {
        return this.paramLength;
    }

    public Type getReturnType() {
        return this.returnType;
    }

    public Type getFieldType() {
        return this.fieldType;
    }

    public Type[] getArgs() {
        if (this.argTypes == null && this.argV != null) {
            this.argTypes = new Type[this.argV.size()];
            this.argV.copyInto(this.argTypes);
        }
        return this.argTypes;
    }

    public int getSubscripts() {
        return this.fieldType == null ? 0 : this.fieldType.arrayCount;
    }

    public String toString() {
        return this.descriptor;
    }

    boolean vassert(boolean ok) {
        if (!ok && !this.errorReported) {
            this.errorOffset = this.offset;
            this.errorReported = true;
        }
        return ok;
    }

    boolean atEnd() {
        return this.offset == this.end || this.errorReported;
    }

    void checkAtEnd() {
        this.vassert(this.atEnd());
    }

    char next() {
        char c = ' ';
        if (this.vassert(!this.atEnd())) {
            c = this.descriptor.charAt(this.offset);
        }
        return c;
    }

    void toss() {
        if (this.vassert(!this.atEnd())) {
            ++this.offset;
        }
    }

    void skip(char c) {
        this.vassert(c == this.next());
        this.toss();
    }

    Type parseField(boolean allowVoid) {
        Type t;
        int start = this.offset;
        int arrayCount = this.skipArray();
        this.vassert(arrayCount < 256);
        char elementType = this.next();
        if (elementType == 'L') {
            this.toss();
            int begin = this.offset;
            int end = this.skipClassname();
            t = this.mkClass(arrayCount, begin, end);
        } else if ("BCFISZDJ".indexOf(elementType) >= 0) {
            t = this.mkPrimitive(arrayCount, this.offset);
            this.toss();
        } else if (elementType == 'V') {
            this.vassert(arrayCount == 0);
            this.vassert(allowVoid);
            t = this.mkPrimitive(0, this.offset);
            this.toss();
        } else {
            this.vassert(false);
            t = this.mkPrimitive(arrayCount, this.offset);
        }
        return t;
    }

    int skipArray() {
        int start = this.offset;
        while (this.next() == '[' && !this.atEnd()) {
            this.toss();
        }
        return this.offset - start;
    }

    int skipClassname() {
        int start = this.offset;
        while (this.next() != ';' && !this.atEnd()) {
            this.toss();
        }
        int end = this.offset;
        this.skip(';');
        return end;
    }

    void parseMethod() {
        this.argV = new Vector(8);
        this.skip('(');
        boolean done = false;
        this.paramLength = 0;
        this.paramCount = 0;
        while (!done && !this.atEnd()) {
            if (this.next() == ')') {
                done = true;
                continue;
            }
            Type t = this.parseField(false);
            this.argV.addElement(t);
            this.paramLength += t.len;
            ++this.paramCount;
        }
        this.skip(')');
        this.returnType = this.parseField(true);
    }

    Type mkPrimitive(int arrayCount, int xKind) {
        Type t = new Type();
        t.arrayCount = arrayCount;
        t.nameBegin = xKind;
        t.nameEnd = xKind + 1;
        t.elementType = this.descriptor.charAt(xKind);
        if (arrayCount > 0) {
            t.len = 1;
        } else {
            switch (t.elementType) {
                case 'D': 
                case 'J': {
                    t.len = 2;
                    break;
                }
                default: {
                    t.len = 1;
                }
            }
        }
        return t;
    }

    Type mkClass(int arrayCount, int xBegin, int xEnd) {
        Type t = new Type();
        t.arrayCount = arrayCount;
        t.nameBegin = xBegin;
        t.nameEnd = xEnd;
        t.elementType = (char)76;
        t.len = 1;
        return t;
    }

    public static void main(String[] argv) {
        for (int x = 0; x < argv.length; ++x) {
            Descriptor d = new Descriptor(argv[x]);
            if (d.isMethod()) {
                System.out.println("Method: " + d);
                Type[] args = d.getArgs();
                for (int xArg = 0; xArg < args.length; ++xArg) {
                    System.out.println("  arg " + xArg + ": " + args[xArg] + ", length " + args[xArg].len);
                }
                System.out.println("  return " + d.getReturnType());
            } else {
                System.out.println("Field: " + d);
                System.out.println("  " + d.getFieldType() + ", length " + d.getFieldType().len);
            }
            if (!d.parseError()) continue;
            System.out.println("  ERROR");
        }
    }

    public class Type {
        int arrayCount;
        char elementType;
        int nameBegin;
        int nameEnd;
        int len;

        public char getElementCode() {
            return this.elementType;
        }

        public String name() {
            return Descriptor.this.descriptor.substring(this.nameBegin, this.nameEnd);
        }

        public boolean isClass() {
            return this.elementType == 'L';
        }

        public boolean isArray() {
            return this.arrayCount > 0;
        }

        public String toString() {
            String result = this.isArray() ? this.name() + "[" + this.arrayCount + "]" : this.name();
            return result;
        }
    }
}

