/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.util.classfile;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.Modifier;
import java.util.Hashtable;
import oracle.aurora.util.classfile.Raw;
import oracle.aurora.util.classfile.Type;
import oracle.aurora.util.classfile.TypeFactory;
import oracle.aurora.util.tools.ToolException;

public class Dig
implements Raw.JavaConstants {
    Raw.Class rawClass;
    ConstantPool constants;
    Class clazz;
    TypeFactory typeFactory;

    public Dig(Raw.Class rawClass) {
        if (rawClass == null) {
            throw new NullPointerException("Dig(null)");
        }
        this.rawClass = rawClass;
        this.constants = new ConstantPool();
        this.clazz = new Class();
    }

    public Class getClazz() {
        return this.clazz;
    }

    public Raw.Class getRaw() {
        return this.rawClass;
    }

    public String getName(Raw.Member member) {
        return this.constants.getString(member.nameIndex);
    }

    public String getName(Raw.Attribute attribute) {
        return this.constants.getString(attribute.nameIndex);
    }

    public Attribute getAttribute(String name) {
        return this.clazz.getAttributes().get(name);
    }

    public void output(PrintStream writer) {
        this.getClazz().output("Class", new Raw.FmtOutput(writer));
    }

    TypeFactory getFactory() {
        if (this.typeFactory == null) {
            this.typeFactory = new TypeFactory();
        }
        return this.typeFactory;
    }

    public static void dump(InputStream in, PrintStream out) {
        try {
            Raw.Class cl = new Raw.Class(in);
            Dig d = new Dig(cl);
            d.output(out);
        }
        catch (IOException ex) {
            ex.printStackTrace(out);
        }
        catch (ToolException ex) {
            ex.printStackTrace(out);
        }
    }

    public static void main(String[] argv) {
        try {
            File inArg = new File(argv[0]);
            FileInputStream fin = new FileInputStream(inArg);
            Dig.dump(fin, System.out);
            fin.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public class ExceptionHandler
    implements Raw.Fmt {
        Raw.ExceptionTableEntry rawHandler;

        public ExceptionHandler(Raw.ExceptionTableEntry rawHandler) {
            this.rawHandler = rawHandler;
        }

        public int getStartPc() {
            return this.rawHandler.startPc;
        }

        public int getEndPc() {
            return this.rawHandler.endPc;
        }

        public int getHandlerPc() {
            return this.rawHandler.handlerPc;
        }

        public String getExceptionClass() {
            return Dig.this.constants.getClass(this.rawHandler.catchType);
        }

        public Type getExceptionType() {
            return Dig.this.constants.getClassType(this.rawHandler.catchType);
        }

        public Raw.ExceptionTableEntry getRaw() {
            return this.rawHandler;
        }

        public void output(String name, Raw.FmtOutput fout) {
            fout.out(name);
            fout.push();
            fout.out("start pc", this.getStartPc());
            fout.out("end pc", this.getEndPc());
            fout.out("handler pc", this.getHandlerPc());
            String exceptionClass = this.getExceptionClass();
            if (exceptionClass == null) {
                exceptionClass = "finally block";
            }
            fout.out("exception class", exceptionClass);
            fout.pop();
        }
    }

    public class ExceptionHandlers
    implements Raw.Fmt {
        Raw.ExceptionTableEntry[] rawExceptionTable;

        public ExceptionHandlers(Raw.ExceptionTableEntry[] rawExceptionTable) {
            this.rawExceptionTable = rawExceptionTable;
        }

        public ExceptionHandler get(int x) {
            return new ExceptionHandler(this.rawExceptionTable[x]);
        }

        public int getSize() {
            return this.rawExceptionTable == null ? 0 : this.rawExceptionTable.length;
        }

        public Raw.ExceptionTableEntry[] getRaw() {
            return this.rawExceptionTable;
        }

        public void output(String name, Raw.FmtOutput fout) {
            fout.out(name);
            fout.push();
            for (int x = 0; x < this.getSize(); ++x) {
                fout.out("handler " + x, this.get(x));
            }
            fout.pop();
        }
    }

    public class Code
    implements Raw.Fmt {
        Raw.Code rawCode;

        public Code(Attribute att) {
            try {
                this.rawCode = new Raw.Code(new Raw.RawInput(att.getData()));
            }
            catch (IOException ex) {
                this.rawCode = new Raw.Code();
            }
            catch (ToolException ex) {
                this.rawCode = new Raw.Code();
            }
        }

        public byte[] getBytecodes() {
            return this.rawCode.code;
        }

        public int getMaxStack() {
            return this.rawCode.maxStack;
        }

        public int getMaxLocals() {
            return this.rawCode.maxLocals;
        }

        public ExceptionHandlers getExceptionHandlers() {
            return new ExceptionHandlers(this.rawCode.exceptionTable);
        }

        public Attributes getAttributes() {
            return new Attributes(this.rawCode.attributes);
        }

        public Raw.Code getRaw() {
            return this.rawCode;
        }

        public void output(String name, Raw.FmtOutput fout) {
            Raw.Code raw = this.getRaw();
            fout.out(name);
            fout.push();
            fout.out("max stack", this.getMaxStack());
            fout.out("max locals", this.getMaxLocals());
            fout.out("exception handlers", this.getExceptionHandlers());
            fout.out("attributes", this.getAttributes());
            fout.out("bytecodes", this.getBytecodes());
            fout.pop();
        }
    }

    public class Attribute
    implements Raw.Fmt {
        Raw.Attribute rawAttribute;

        public Attribute(Raw.Attribute rawAttribute) {
            this.rawAttribute = rawAttribute;
        }

        public String getName() {
            return Dig.this.constants.getString(this.rawAttribute.nameIndex);
        }

        public byte[] getData() {
            return this.rawAttribute.data;
        }

        public String toString() {
            return "attribute<" + this.getName() + ">";
        }

        public void output(String name, Raw.FmtOutput fout) {
            fout.out(name, this.getName());
            fout.push();
            fout.out("data", this.getData());
            fout.pop();
        }
    }

    public class Attributes
    implements Raw.Fmt {
        Raw.Attribute[] rawAttributes;

        public Attributes(Raw.Attribute[] rawAttributes) {
            this.rawAttributes = rawAttributes;
        }

        public int count() {
            return this.rawAttributes.length;
        }

        public Attribute get(int x) {
            return new Attribute(this.rawAttributes[x]);
        }

        public Attribute get(String name) {
            Attribute result = null;
            for (int x = 0; x < this.rawAttributes.length && result == null; ++x) {
                String attName = Dig.this.constants.getString(this.rawAttributes[x].nameIndex);
                if (!name.equals(attName)) continue;
                result = new Attribute(this.rawAttributes[x]);
            }
            return result;
        }

        public void output(String name, Raw.FmtOutput fout) {
            fout.out(name);
            fout.push();
            for (int x = 0; x < this.count(); ++x) {
                fout.out("attribute " + x, this.get(x));
            }
            fout.pop();
        }
    }

    public class Member
    implements Raw.Fmt {
        Raw.Member rawMember;

        public Member(Raw.Member rawMember) {
            this.rawMember = rawMember;
        }

        public int getModifiers() {
            return this.rawMember.accessFlags;
        }

        public boolean isAbstract() {
            return this.is(1024);
        }

        public boolean isFinal() {
            return this.is(16);
        }

        public boolean isNative() {
            return this.is(256);
        }

        public boolean isPrivate() {
            return this.is(2);
        }

        public boolean isProtected() {
            return this.is(4);
        }

        public boolean isPublic() {
            return this.is(1);
        }

        public boolean isStatic() {
            return this.is(8);
        }

        public boolean isVolatile() {
            return this.is(64);
        }

        public boolean isMethod() {
            String d = this.getDescriptor();
            return d != null && d.length() > 0 && d.charAt(0) == '(';
        }

        public boolean isField() {
            return !this.isMethod();
        }

        public boolean is(int category) {
            return (this.rawMember.accessFlags & category) != 0;
        }

        public boolean isConstructor() {
            return this.getName().equals("<init>");
        }

        public String getName() {
            return Dig.this.constants.getString(this.rawMember.nameIndex);
        }

        public String getDescriptor() {
            return Dig.this.constants.getString(this.rawMember.descriptorIndex);
        }

        public Type getType() {
            Type type = null;
            String descriptor = this.getDescriptor();
            if (descriptor != null) {
                try {
                    type = Dig.this.getFactory().construct(descriptor);
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
            return type;
        }

        public Attributes getAttributes() {
            return new Attributes(this.rawMember.attributes);
        }

        public Class containingClass() {
            return Dig.this.clazz;
        }

        public Raw.Member getRaw() {
            return this.rawMember;
        }

        public String toString() {
            return Modifier.toString(this.getModifiers()) + " " + this.getName() + "/" + this.getDescriptor();
        }

        public void output(String name, Raw.FmtOutput fout) {
            Attribute codeAttribute;
            fout.out(name, this.toString());
            Attributes a = this.getAttributes();
            if (a.count() > 0) {
                fout.out("attributes", a);
            }
            if (this.isMethod() && (codeAttribute = a.get("Code")) != null) {
                Code code = this.containingClass().makeCode(a.get("Code"));
                fout.out("Parsed Code attribute", code);
            }
        }
    }

    public class Methods
    implements Raw.Fmt {
        private Hashtable table;

        public int count() {
            return Dig.this.rawClass.methodCount;
        }

        public Member get(int x) {
            return new Member(Dig.this.rawClass.methods[x]);
        }

        private Hashtable getTable() {
            if (this.table == null) {
                this.table = new Hashtable(2 * Dig.this.rawClass.methodCount);
                for (int x = 0; x < Dig.this.rawClass.methodCount; ++x) {
                    Raw.Member rawMember = Dig.this.rawClass.methods[x];
                    String rawName = Dig.this.constants.getString(rawMember.nameIndex);
                    String rawDescriptor = Dig.this.constants.getString(rawMember.descriptorIndex);
                    this.table.put(new Entry(rawName, rawDescriptor), new Member(rawMember));
                }
            }
            return this.table;
        }

        public Member lookup(String name, String descriptor) {
            Member result = null;
            for (int x = 0; x < Dig.this.rawClass.methodCount && result == null; ++x) {
                String rawDescriptor;
                Raw.Member rawMember = Dig.this.rawClass.methods[x];
                String rawName = Dig.this.constants.getString(rawMember.nameIndex);
                if (!name.equals(rawName) || !descriptor.equals(rawDescriptor = Dig.this.constants.getString(rawMember.descriptorIndex))) continue;
                result = new Member(rawMember);
            }
            return result;
        }

        public void output(String name, Raw.FmtOutput fout) {
            fout.out(name);
            fout.push();
            for (int x = 0; x < this.count(); ++x) {
                fout.out("method " + x, this.get(x));
            }
            fout.pop();
        }

        class Entry {
            String name;
            String descriptor;

            Entry(String name, String descriptor) {
                this.name = name;
                this.descriptor = descriptor;
            }

            public boolean equals(Object other) {
                Entry oEntry = (Entry)other;
                return this.name.equals(oEntry.name) && this.descriptor.equals(oEntry.descriptor);
            }

            public int hashCode() {
                return this.name.hashCode() + this.descriptor.hashCode();
            }
        }
    }

    public class Fields
    implements Raw.Fmt {
        public int count() {
            return Dig.this.rawClass.fieldCount;
        }

        public Member get(int x) {
            return new Member(Dig.this.rawClass.fields[x]);
        }

        public Member lookup(String name, String descriptor) {
            Member result = null;
            for (int x = 0; x < Dig.this.rawClass.fieldCount && result == null; ++x) {
                Raw.Member rawMember = Dig.this.rawClass.fields[x];
                String fieldName = Dig.this.constants.getString(rawMember.nameIndex);
                String rawDescriptor = Dig.this.constants.getString(rawMember.descriptorIndex);
                if (!name.equals(fieldName) || descriptor != null && !descriptor.equals(rawDescriptor)) continue;
                result = new Member(rawMember);
            }
            return result;
        }

        public void output(String name, Raw.FmtOutput fout) {
            fout.out(name);
            fout.push();
            for (int x = 0; x < this.count(); ++x) {
                fout.out("field " + x, this.get(x));
            }
            fout.pop();
        }
    }

    public class ConstantPool
    implements Raw.Fmt {
        public int size() {
            return Dig.this.rawClass.poolCount;
        }

        public int getConstantType(int x) {
            if (x < 0 || x >= Dig.this.rawClass.constantPool.length) {
                return 0;
            }
            if (Dig.this.rawClass.constantPool[x] == null) {
                return 0;
            }
            return Dig.this.rawClass.constantPool[x].tag;
        }

        public Object get(int x) {
            if (x < 0 || x > Dig.this.rawClass.constantPool.length) {
                return null;
            }
            if (Dig.this.rawClass.constantPool[x] == null) {
                return null;
            }
            return Dig.this.rawClass.constantPool[x].info;
        }

        public String getString(int x) {
            String result = null;
            if (this.is(x, 1)) {
                result = (String)this.get(x);
            }
            return result;
        }

        public String getClass(int x) {
            String result = null;
            if (this.is(x, 7)) {
                int xString = this.getRawInt(x);
                result = this.getString(xString);
            }
            return result;
        }

        public String getDeclaringClass(int x) {
            return this.getClass(this.getFirst(x));
        }

        public String getNameOfRef(int x) {
            return this.getString(this.getFirst(this.getSecond(x)));
        }

        public String getDescriptorOfRef(int x) {
            return this.getString(this.getSecond(this.getSecond(x)));
        }

        public Type getClassType(int x) {
            String name = this.getClass(x);
            name = name.replace('/', '.');
            return Dig.this.getFactory().construct("L" + name + ";");
        }

        public Type getType(int x) {
            return this.getClassType(x);
        }

        public int getFirst(int x) {
            try {
                Raw.Pair pair = (Raw.Pair)this.get(x);
                return pair.first;
            }
            catch (ClassCastException ex) {
                return 0;
            }
            catch (NullPointerException ex) {
                return 0;
            }
        }

        public int getSecond(int x) {
            try {
                Raw.Pair pair = (Raw.Pair)this.get(x);
                return pair.second;
            }
            catch (ClassCastException ex) {
                return 0;
            }
            catch (NullPointerException ex) {
                return 0;
            }
        }

        public int getInteger(int x) {
            int result = 0;
            if (this.is(x, 3)) {
                result = ((Number)this.get(x)).intValue();
            }
            return result;
        }

        public long getLong(int x) {
            long result = 0L;
            if (this.is(x, 5) || this.is(x, 3)) {
                result = ((Number)this.get(x)).longValue();
            }
            return result;
        }

        public double getDouble(int x) {
            double result = 0.0;
            if (this.is(x, 4) || this.is(x, 6)) {
                result = ((Number)this.get(x)).doubleValue();
            }
            return result;
        }

        public int getRawInt(int x) {
            int result = 0;
            switch (this.getConstantType(x)) {
                case 7: 
                case 8: {
                    result = (Integer)this.get(x);
                    break;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    Raw.Pair p = (Raw.Pair)this.get(x);
                    result = p.first << 16 | p.second & 0xFFFF;
                }
            }
            return result;
        }

        public boolean isRef(int x) {
            if (x == 0 || x >= Dig.this.rawClass.constantPool.length || Dig.this.rawClass.constantPool[x] == null) {
                return false;
            }
            switch (Dig.this.rawClass.constantPool[x].tag) {
                case 9: 
                case 10: 
                case 11: {
                    return true;
                }
            }
            return false;
        }

        public boolean is(int x, int type) {
            if (x == 0 || x >= Dig.this.rawClass.constantPool.length || Dig.this.rawClass.constantPool[x] == null) {
                return false;
            }
            return Dig.this.rawClass.constantPool[x].tag == type;
        }

        public int find(String s) {
            int x = 0;
            boolean found = false;
            int xFound = 0;
            for (x = 1; x < Dig.this.rawClass.constantPool.length && !found; ++x) {
                Raw.Constant c = Dig.this.rawClass.constantPool[x];
                if (c == null || c.tag != 1 || !s.equals(c.info)) continue;
                found = true;
                xFound = x;
            }
            return found ? xFound : Dig.this.rawClass.constantPool.length;
        }

        String toString(int x) {
            String value;
            String what;
            switch (this.getConstantType(x)) {
                case 1: {
                    what = "UTF8";
                    break;
                }
                case 3: {
                    what = "INTEGER";
                    break;
                }
                case 4: {
                    what = "FLOAT";
                    break;
                }
                case 5: {
                    what = "LONG";
                    break;
                }
                case 6: {
                    what = "DOUBLE";
                    break;
                }
                case 7: {
                    what = "CLASS";
                    break;
                }
                case 8: {
                    what = "STRING";
                    break;
                }
                case 9: {
                    what = "FIELD";
                    break;
                }
                case 10: {
                    what = "METHOD";
                    break;
                }
                case 11: {
                    what = "INTERFACEMETHOD";
                    break;
                }
                case 12: {
                    what = "NAMEANDTYPE";
                    break;
                }
                default: {
                    what = "CONSTANT";
                }
            }
            switch (this.getConstantType(x)) {
                case 1: {
                    value = this.getString(x);
                    break;
                }
                case 7: {
                    value = this.getClass(x);
                    break;
                }
                case 8: {
                    value = this.getString(this.getRawInt(x));
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    value = this.getDeclaringClass(x) + "." + this.getNameOfRef(x) + ":" + this.getDescriptorOfRef(x);
                    break;
                }
                case 12: {
                    value = this.getString(this.getFirst(x)) + "," + this.getString(this.getSecond(x));
                    break;
                }
                default: {
                    Object c = this.get(x);
                    value = c == null ? "null" : c.toString();
                }
            }
            return what + "<" + value + ">";
        }

        public void output(String name, Raw.FmtOutput fout) {
            fout.out(name);
            fout.push();
            for (int x = 0; x < this.size(); ++x) {
                fout.out("constant " + x, this.toString(x));
            }
            fout.pop();
        }
    }

    public class Class
    implements Raw.Fmt {
        Type type;
        String name;

        public String getName() {
            if (this.name == null) {
                this.name = Dig.this.constants.getClass(Dig.this.rawClass.thisClass);
                if (this.name != null) {
                    this.name = this.name.replace('/', '.');
                }
            }
            return this.name;
        }

        public String getSlashName() {
            return Dig.this.constants.getClass(Dig.this.rawClass.thisClass);
        }

        public Type getType() {
            if (this.type == null) {
                this.type = Dig.this.getFactory().construct("L" + this.getName() + ";");
            }
            return this.type;
        }

        public int getModifiers() {
            return Dig.this.rawClass.accessFlags;
        }

        public String getSuperClass() {
            return Dig.this.constants.getClass(Dig.this.rawClass.superClass);
        }

        public String getSlashSuperClass() {
            return Dig.this.constants.getClass(Dig.this.rawClass.superClass);
        }

        public boolean isAbstract() {
            return this.is(1024);
        }

        public boolean isFinal() {
            return this.is(16);
        }

        public boolean isInterface() {
            return this.is(512);
        }

        public boolean isPrivate() {
            return this.is(2);
        }

        public boolean isPublic() {
            return this.is(1);
        }

        public boolean isProtected() {
            return this.is(4);
        }

        public boolean is(int flag) {
            return (Dig.this.rawClass.accessFlags & flag) != 0;
        }

        public ConstantPool getConstants() {
            return Dig.this.constants;
        }

        public int getInterfaceCount() {
            return Dig.this.rawClass.interfaceCount;
        }

        public String getInterface(int x) {
            return Dig.this.constants.getClass(Dig.this.rawClass.interfaces[x]);
        }

        public String getSlashInterface(int x) {
            return Dig.this.constants.getClass(Dig.this.rawClass.interfaces[x]);
        }

        public Fields getFields() {
            return new Fields();
        }

        public Methods getMethods() {
            return new Methods();
        }

        public Attributes getAttributes() {
            return new Attributes(Dig.this.rawClass.attributes);
        }

        public Code makeCode(Attribute codeAtt) {
            return new Code(codeAtt);
        }

        public Raw.Class getRaw() {
            return Dig.this.rawClass;
        }

        public Dig getDig() {
            return Dig.this;
        }

        public String toString() {
            return "class " + this.getName();
        }

        public void output(String name, Raw.FmtOutput fout) {
            fout.out("class " + this.getName());
            fout.outHex("magic", this.getRaw().magic);
            fout.out("minor version", this.getRaw().minorVersion);
            fout.out("major version", this.getRaw().majorVersion);
            fout.out("constants", this.getConstants());
            fout.out("accessFlags", Modifier.toString(this.getModifiers()));
            fout.out("this class", this.getSlashName());
            fout.out("super class", this.getSuperClass());
            fout.out("Interfaces");
            fout.push();
            for (int x = 0; x < this.getInterfaceCount(); ++x) {
                fout.out("interface " + x, this.getInterface(x));
            }
            fout.pop();
            fout.out("Fields", this.getFields());
            fout.out("Methods", this.getMethods());
            fout.out("Attributes", this.getAttributes());
        }
    }
}

