/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.util.tools;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.sql.SQLException;
import java.text.DecimalFormat;
import oracle.aurora.util.tools.ToolError;
import oracle.aurora.util.tools.ToolException;

public class ToolEnv {
    private PrintWriter writer;
    public static final int ALWAYS = 0;
    public static final int ERROR = 1;
    public static final int WARN = 2;
    public static final int INFO = 3;
    public static final int DEBUG = 4;
    public static final int MAX_LEVEL = 4;
    boolean connectionFailure = false;
    private int verbose = 2;
    private int[] count = new int[5];

    public ToolEnv(PrintWriter writer, int verbose) {
        this.writer = writer;
        this.verbose = verbose;
    }

    public ToolEnv(PrintWriter writer) {
        this(writer, 2);
    }

    public ToolEnv(Writer writer, int verbose) {
        this(new PrintWriter(writer), verbose);
    }

    public ToolEnv(Writer writer) {
        this(writer, 2);
    }

    public ToolEnv(OutputStream output, int verbose) {
        this(new PrintWriter(output), verbose);
    }

    public ToolEnv(OutputStream output) {
        this(output, 2);
    }

    public void out(String m, int level) {
        if (level <= this.verbose) {
            this.writer.println(m);
        }
    }

    public void countAs(int level) {
        int n = level;
        this.count[n] = this.count[n] + 1;
    }

    public void msg(String m) {
        this.out(m, 3);
    }

    public void err(String m) {
        this.out(m, 1);
        this.countAs(1);
    }

    public void warn(String m) {
        this.out(m, 2);
        this.countAs(2);
    }

    public void err(Exception ex, String what) {
        int level = 1;
        if (ex instanceof SQLException) {
            SQLException sex = (SQLException)ex;
            if (this.checkCode(sex, 1013)) {
                throw new ToolError("interrupted by user");
            }
            if (this.checkCode(sex, 3113) || this.checkCode(sex, 3114) || sex.getErrorCode() == 0) {
                this.connectionFailure = true;
            } else if (this.checkCode(sex, 29552)) {
                level = 2;
            }
        }
        String tag = level == 2 ? "Warning" : "Error";
        this.out(tag + " while " + what, level);
        if (ex instanceof SQLException && ((SQLException)ex).getErrorCode() != 0) {
            this.out("    " + ex.getMessage(), level);
        } else {
            this.out("    Exception " + ex.toString(), level);
        }
        this.countAs(level);
        if (this.verbose >= 4) {
            Exception exForTrace = ex;
            if (ex instanceof ToolException && ((ToolException)ex).getChain() != null) {
                exForTrace = ((ToolException)ex).getChain();
            }
            exForTrace.printStackTrace(this.writer);
        }
    }

    public void err(Exception ex) {
        this.err(ex, "unknown activity");
    }

    public boolean checkCode(SQLException ex, int code) {
        boolean result = false;
        boolean found = false;
        SQLException next = ex;
        while (next != null && !found) {
            found = ex.getErrorCode() == code || this.checkCode(ex.getMessage(), code);
            next = ex.getNextException();
        }
        return found;
    }

    public boolean checkCode(String msg, int code) {
        String pat = "ORA-" + new DecimalFormat("00000").format(code);
        boolean found = msg != null && msg.indexOf(pat) >= 0;
        return found;
    }

    public int getErrorCount() {
        return this.count[1];
    }

    public int getWarningCount() {
        return this.count[2];
    }
}

