/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.authentication;

import java.io.IOException;
import oracle.dbtools.auth.AuthenticationStatus;
import oracle.dbtools.auth.challenges.Challenges;
import oracle.dbtools.plugin.api.security.AuthenticationChallenge;
import oracle.dbtools.rt.entity.Entities;
import oracle.dbtools.rt.entity.Entity;
import oracle.dbtools.rt.entity.EntityHeadersBuilder;
import oracle.dbtools.rt.locale.LocalePreference;
import oracle.dbtools.rt.web.HttpHeader;
import oracle.dbtools.rt.web.HttpStatusCode;
import oracle.dbtools.rt.web.RequestEntity;
import oracle.dbtools.rt.web.WebException;

public class AuthenticationException
extends WebException {
    private final AuthenticationChallenge challenge;
    private static final long serialVersionUID = -1894767387759052228L;

    @Override
    public Entity response(RequestEntity request) throws IOException {
        Entity response = super.response(request);
        if (this.challenge != null && !Challenges.NO_CHALLENGE.equals(this.challenge)) {
            LocalePreference localePreference = LocalePreference.preference(request);
            EntityHeadersBuilder headers = Entities.headers();
            headers.header((CharSequence)HttpHeader.WWW_AUTHENTICATE, this.challenge.toString((Iterable)((Object)localePreference)));
            return Entities.merge(response, headers.build());
        }
        return response;
    }

    public AuthenticationChallenge challenge() {
        return this.challenge;
    }

    private AuthenticationException(WebException cause, AuthenticationChallenge challenge, AuthenticationStatus status) {
        super(AuthenticationStatus.NOT_AUTHORIZED == status ? HttpStatusCode.FORBIDDEN : cause.statusCode());
        this.cause(cause);
        this.challenge = challenge;
    }

    public static WebException authenticationException(WebException cause, AuthenticationChallenge challenge, AuthenticationStatus status) {
        if (challenge == null || Challenges.NO_CHALLENGE.equals(challenge)) {
            return cause;
        }
        return new AuthenticationException(cause, challenge, status);
    }
}

