/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.authentication;

import java.io.UnsupportedEncodingException;
import oracle.dbtools.common.util.Base64;
import oracle.dbtools.common.util.Pair;
import oracle.dbtools.common.util.Text;
import oracle.dbtools.rt.entity.EntityHeader;
import oracle.dbtools.rt.web.HttpHeader;
import oracle.dbtools.rt.web.Reason;
import oracle.dbtools.rt.web.RequestEntity;
import oracle.dbtools.rt.web.WebException;

abstract class HttpBasicAuthentication {
    private static final String BASIC = "Basic ";

    private HttpBasicAuthentication() {
    }

    static Pair<String, char[]> credentials(RequestEntity request) {
        String text;
        String username = null;
        char[] password = null;
        EntityHeader auth = request.headers().header(HttpHeader.AUTHORIZATION);
        if (auth != null && (text = auth.value()).startsWith(BASIC)) {
            String encoded = text.substring(BASIC.length()).trim();
            try {
                String decoded = new String(Base64.base64ToByteArray((String)encoded), Text.defaultEncoding());
                int colon = decoded.indexOf(58);
                if (colon != -1 && colon != decoded.length() - 1) {
                    username = decoded.substring(0, colon);
                    password = decoded.substring(colon + 1).toCharArray();
                }
            }
            catch (UnsupportedEncodingException e) {
                throw WebException.internalError(e, new Reason[0]);
            }
        }
        if (username == null || password == null) {
            return null;
        }
        return Pair.pair(username, password);
    }
}

