/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.authentication;

import java.util.logging.Level;
import javax.security.auth.callback.CallbackHandler;
import oracle.dbtools.auth.AuthenticationResult;
import oracle.dbtools.auth.Authenticator;
import oracle.dbtools.auth.AuthenticatorBase;
import oracle.dbtools.common.service.ServiceLocator;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.common.util.Log;

public abstract class LogonAuthenticatorBase
extends AuthenticatorBase {
    private final Log LOG = Log.get(LogonAuthenticatorBase.class);

    protected LogonAuthenticatorBase() {
    }

    public AuthenticationResult authenticate(CallbackHandler callbackHandler) {
        Iterable authenticators = ServiceLocator.acquireAll(Authenticator.class, (String[])new String[0]);
        if (this.LOG.isLoggable(Level.FINE)) {
            this.LOG.fine("Available authenticators: " + Iterables.join((Iterable)authenticators, (String)", "));
        }
        for (Authenticator auth : authenticators) {
            AuthenticationResult result = auth.authenticate(callbackHandler);
            switch (result.status()) {
                case INVALID: {
                    this.LOG.fine("Invalid credentials asserted by: " + auth);
                    return result;
                }
                case VALID: {
                    this.LOG.fine("valid credentials asserted by: " + auth);
                    if (this.LOG.isLoggable(Level.FINE)) {
                        this.LOG.fine("valid credentials asserted by: " + auth + " found: " + Iterables.join((Iterable)result, (String)", "));
                    }
                    return result;
                }
                case UNKNOWN: {
                    this.LOG.fine("unknown principal asserted by: " + auth);
                }
            }
        }
        this.LOG.fine("No authentication match found");
        return AuthenticationResult.invalid();
    }
}

