/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.home.tenants;

import java.security.Principal;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.common.util.Selector;
import oracle.dbtools.common.util.Selectors;
import oracle.dbtools.rt.home.tenants.TenantEntity;
import oracle.dbtools.rt.home.tenants.TenantIdentifier;
import oracle.dbtools.rt.tenants.TenantPrincipal;

public abstract class TenantIdentifiers {
    private TenantIdentifiers() {
    }

    public static boolean isInternal(TenantIdentifier id) {
        TenantIdentifier contract = id;
        return contract != null && contract.isInternal();
    }

    public static <T extends TenantEntity> Iterable<T> removeInternal(Iterable<T> items) {
        return Iterables.select(items, (Selector)Selectors.not(new InternalEntity()));
    }

    public static boolean sameParent(TenantEntity existing, TenantEntity instance) {
        if (existing == null || instance == null) {
            return false;
        }
        TenantIdentifier parentId = existing.parentId();
        if (parentId == null) {
            return instance.parentId() == null;
        }
        return parentId.equals(instance.parentId());
    }

    public static String string(CompoundPrincipal principal, TenantIdentifier id) {
        if (id == null) {
            return null;
        }
        TenantPrincipal tenant = TenantPrincipal.tenant((Principal)principal);
        return tenant.string(id);
    }

    private static final class InternalEntity<T extends TenantEntity>
    implements Selector<T> {
        private InternalEntity() {
        }

        public Boolean apply(T x) {
            return TenantIdentifiers.isInternal(x.id());
        }
    }
}

