/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.oauth.scope;

import java.io.InputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import oracle.dbtools.common.query.ResultRow;
import oracle.dbtools.common.query.ResultRows;
import oracle.dbtools.common.util.NullOrEmpty;
import oracle.dbtools.rt.home.tenants.TenantEntity;
import oracle.dbtools.rt.home.tenants.TenantEntityBase;
import oracle.dbtools.rt.home.tenants.TenantIdentifier;
import oracle.dbtools.rt.json.query.JSONQueryStream;

public class Scope
extends TenantEntityBase
implements TenantEntity {
    private String description;
    private final Set<String> modules = new HashSet<String>();
    private String name;
    private String title;
    private final Set<String> requiredRoles = new HashSet<String>();
    private static String[] FIELDS = new String[]{"name", "title", "description", "roles", "modules"};

    public InputStream content() {
        String[] modules = new String[this.modules.size()];
        String[] roles = new String[this.requiredRoles.size()];
        int i = 0;
        Iterator<String> i$ = this.modules.iterator();
        while (i$.hasNext()) {
            String moduleName;
            modules[i] = moduleName = i$.next();
            ++i;
        }
        i = 0;
        i$ = this.requiredRoles.iterator();
        while (i$.hasNext()) {
            String role;
            roles[i] = role = i$.next();
            ++i;
        }
        ResultRow row = ResultRows.row((String[])FIELDS, (Object[])new Object[]{this.name, this.title, this.description, roles, modules});
        return new JSONQueryStream(row);
    }

    public String description() {
        return this.description;
    }

    public Scope description(String description) {
        this.description = description;
        return this;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Scope other = (Scope)obj;
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + super.hashCode();
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public Scope module(String moduleName) {
        this.modules.add(moduleName);
        return this;
    }

    public Iterable<String> modules() {
        return this.modules;
    }

    public String name() {
        return this.name;
    }

    public Scope name(String name) {
        this.name = name;
        return this;
    }

    public Iterable<String> requiredRoles() {
        return this.requiredRoles;
    }

    public Scope requiredRole(String requiredRole) {
        if (!NullOrEmpty.nullOrEmpty((CharSequence)requiredRole)) {
            this.requiredRoles.add(requiredRole);
        }
        return this;
    }

    @Override
    public TenantIdentifier parentId() {
        return TenantIdentifier.NO_PARENT;
    }

    @Override
    public void parentId(TenantIdentifier templateId) {
    }

    public String title() {
        return this.title;
    }

    public Scope title(String title) {
        this.title = title;
        return this;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Scope [description=");
        builder.append(this.description);
        builder.append(", id=");
        builder.append(this.id());
        builder.append(", metadata=");
        builder.append(this.metadata());
        builder.append(", modules=");
        builder.append(this.modules);
        builder.append(", name=");
        builder.append(this.name);
        builder.append(", title=");
        builder.append(this.title);
        builder.append(", requiredRoles=");
        builder.append(this.requiredRoles);
        builder.append("]");
        return builder.toString();
    }
}

