/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.resource.templates.jdbc;

import java.io.IOException;
import java.io.Reader;
import java.security.Principal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import oracle.dbtools.common.jdbc.JDBCCallProvider;
import oracle.dbtools.common.jdbc.JDBCException;
import oracle.dbtools.common.jdbc.JDBCQuery;
import oracle.dbtools.common.jdbc.JDBCTransaction;
import oracle.dbtools.common.query.ResultRow;
import oracle.dbtools.common.query.ResultRowIterator;
import oracle.dbtools.common.stmt.ParameterAccess;
import oracle.dbtools.common.stmt.Statement;
import oracle.dbtools.common.stmt.StatementBuilder;
import oracle.dbtools.common.txn.Transaction;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.common.util.Log;
import oracle.dbtools.common.util.StreamCopy;
import oracle.dbtools.common.util.Text;
import oracle.dbtools.rt.home.tenants.TenantIdentifier;
import oracle.dbtools.rt.jdbc.entity.JDBCIdentifiers;
import oracle.dbtools.rt.resource.templates.jdbc.ApexListenerJDBCPrincipal;
import oracle.dbtools.rt.resource.templates.jdbc.JDBCResourceHandler;
import oracle.dbtools.rt.resource.templates.jdbc.JDBCResourceTemplateMatch;
import oracle.dbtools.rt.resource.templates.v2.ResourceHandler;
import oracle.dbtools.rt.resource.templates.v2.ResourceParameter;
import oracle.dbtools.rt.web.Reason;
import oracle.dbtools.rt.web.SecurityConstraint;
import oracle.dbtools.rt.web.WebException;

public class JDBCResourceHandlerLoader {
    private final JDBCCallProvider jdbc;
    private static final String GET_HANDLER_DATA = "select h.id, h.security_group_id, h.source_type, h.format, h.method, h.mimes_allowed, h.items_per_page, h.require_https , h.source, cursor(select p.name, p.bind_variable_name, p.source_type,p.access_method, p.param_type from wwv_flow_rt$parameters p where p.handler_id = h.id) parameters from wwv_flow_rt$handlers h where h.security_group_id  in (:tenant_id,10) and h.template_id = :id and h.method  = :method";
    private static final Statement GET_HANDLER_DATA_STMT = JDBCIdentifiers.keyParameter(StatementBuilder.query().append((CharSequence)"select h.id, h.security_group_id, h.source_type, h.format, h.method, h.mimes_allowed, h.items_per_page, h.require_https , h.source, cursor(select p.name, p.bind_variable_name, p.source_type,p.access_method, p.param_type from wwv_flow_rt$parameters p where p.handler_id = h.id) parameters from wwv_flow_rt$handlers h where h.security_group_id  in (:tenant_id,10) and h.template_id = :id and h.method  = :method")).parameter("method").build();
    private static final Log LOG = Log.get(JDBCResourceTemplateMatch.class);
    private static final String SUPPORTED_METHODS = "select handler_method from wwv_flow_rt$services where security_group_id  in (:tenant_id,10) and template_id = :id";
    private static final Statement SUPPORTED_METHODS_STMT = JDBCIdentifiers.keyParameter(StatementBuilder.query().append((CharSequence)"select handler_method from wwv_flow_rt$services where security_group_id  in (:tenant_id,10) and template_id = :id")).build();

    public JDBCResourceHandlerLoader(JDBCCallProvider jdbc) {
        this.jdbc = jdbc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ResourceHandler load(CompoundPrincipal principal, TenantIdentifier templateId, String method) {
        JDBCQuery call;
        JDBCTransaction txn;
        TenantIdentifier handlerId;
        Iterator rows;
        JDBCResourceHandler.Builder b;
        block12: {
            CompoundPrincipal apexListener = ApexListenerJDBCPrincipal.apexListener(principal);
            b = JDBCResourceHandler.jdbcBuilder();
            rows = null;
            handlerId = null;
            txn = null;
            call = null;
            txn = this.jdbc.transaction((Principal)apexListener);
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            JDBCIdentifiers.bind(parameters, principal, templateId);
            parameters.put("method", method.toUpperCase());
            call = this.jdbc.query((Transaction)txn, GET_HANDLER_DATA_STMT, false);
            call.setFetchSize(20);
            call.bind(parameters);
            rows = call.execute();
            if (rows.hasNext()) break block12;
            ResourceHandler resourceHandler = this.allowableMethods((Transaction)txn, principal, templateId);
            Closeables.close((Object[])new Object[]{rows, call, txn});
            return resourceHandler;
        }
        try {
            String[] mimesAllowed;
            ResultRow row = (ResultRow)rows.next();
            handlerId = JDBCIdentifiers.valueOf(row, "security_group_id", "id");
            b.id(handlerId);
            b.contentType(JDBCResourceHandlerLoader.contentType((String)row.get("source_type", String.class), (String)row.get("format", String.class)));
            b.method((String)row.get("method", String.class));
            for (String mime : mimesAllowed = Text.commaDelimited((String)((String)row.get("mimes_allowed", String.class)))) {
                b.acceptable(mime);
            }
            Integer itemsPerPage = (Integer)row.get("items_per_page", Integer.class);
            if (itemsPerPage != null) {
                b.itemsPerPage(itemsPerPage);
            }
            SecurityConstraint securityConstraint = SecurityConstraint.fromString((String)row.get("require_https", String.class));
            b.securityConstraint(securityConstraint);
            Reader source = null;
            try {
                source = (Reader)row.get("source", Reader.class);
                String content = StreamCopy.string((Readable)source);
                b.content(content);
            }
            catch (Throwable throwable) {
                Closeables.close(source);
                throw throwable;
            }
            Closeables.close((Object)source);
            ResultRowIterator params = null;
            try {}
            catch (Throwable throwable) {
                Closeables.close(params);
                throw throwable;
            }
            {
                params = (ResultRowIterator)row.get("parameters", ResultRowIterator.class);
                this.parameters(b, params);
            }
            Closeables.close((Object)params);
        }
        catch (IOException e) {
            try {
                LOG.severe((Throwable)e);
                throw WebException.internalError(e, new Reason[0]);
                catch (SQLException e2) {
                    throw WebException.internalError(e2, new Reason[0]);
                }
            }
            catch (Throwable throwable) {
                Closeables.close((Object[])new Object[]{rows, call, txn});
                throw throwable;
            }
        }
        Closeables.close((Object[])new Object[]{rows, call, txn});
        return b.build();
    }

    private ResourceHandler allowableMethods(Transaction txn, CompoundPrincipal principal, TenantIdentifier templateId) {
        Iterator rows = null;
        JDBCQuery call = null;
        try {
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            JDBCIdentifiers.bind(parameters, principal, templateId);
            call = this.jdbc.query(txn, SUPPORTED_METHODS_STMT, false);
            call.bind(parameters);
            rows = call.execute();
            if (rows.hasNext()) {
                ArrayList<String> supportedMethods = new ArrayList<String>();
                while (rows.hasNext()) {
                    ResultRow row = (ResultRow)rows.next();
                    String supportedMethod = (String)row.get(1, String.class);
                    supportedMethods.add(supportedMethod);
                }
                throw WebException.methodNotAllowed(supportedMethods);
            }
        }
        catch (SQLException e) {
            try {
                throw JDBCException.wrap((SQLException)e);
            }
            catch (Throwable throwable) {
                Closeables.close((Object[])new Object[]{rows, call});
                throw throwable;
            }
        }
        Closeables.close((Object[])new Object[]{rows, call});
        return null;
    }

    private void parameters(JDBCResourceHandler.Builder b, ResultRowIterator rows) {
        while (rows.hasNext()) {
            ResultRow row = (ResultRow)rows.next();
            String originalName = (String)row.get("name", String.class);
            String bindName = (String)row.get("bind_variable_name", String.class);
            ResourceParameter.Kind kind = ResourceParameter.Kind.HEADER;
            String source = (String)row.get("source_type", String.class);
            if ("URI".equals(source) || "RESPONSE".equals(source)) {
                kind = ResourceParameter.Kind.URI;
            }
            ParameterAccess access = ParameterAccess.value((String)((String)row.get("access_method", String.class)));
            Class<?> type = this.type((String)row.get("param_type", String.class));
            b.parameter(kind, bindName, originalName, type, access);
        }
    }

    private Class<?> type(String paramType) {
        if ("STRING".equals(paramType)) {
            return String.class;
        }
        if ("INT".equals(paramType)) {
            return Integer.class;
        }
        if ("DOUBLE".equals(paramType)) {
            return Double.class;
        }
        if ("BOOLEAN".equals(paramType)) {
            return Boolean.class;
        }
        if ("LONG".equals(paramType)) {
            return Long.class;
        }
        if ("TIMESTAMP".equals(paramType)) {
            return Timestamp.class;
        }
        return String.class;
    }

    static String contentType(String type, String format) {
        String contentType = "oracle.dbtools.rt.web.ResourceGenerator";
        if ("QUERY".equals(type)) {
            contentType = "CSV".equals(format) ? "csv/query" : "json/query";
        } else if ("QUERY_1_ROW".equals(type)) {
            contentType = "json/query;type=single";
        } else if ("PLSQL".equals(type)) {
            contentType = "plsql/block";
        } else if ("FEED".equals(type)) {
            contentType = "json/query;type=feed";
        } else if ("MEDIA".equals(type)) {
            contentType = "resource/lob";
        }
        return contentType;
    }
}

