/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.resource.templates.jdbc;

import java.io.IOException;
import oracle.dbtools.cache.CacheConfiguration;
import oracle.dbtools.common.jdbc.ConnectionPoolException;
import oracle.dbtools.common.jdbc.JDBCCallProvider;
import oracle.dbtools.common.query.UsesQuery;
import oracle.dbtools.common.service.NotAvailableException;
import oracle.dbtools.common.service.ServiceLocator;
import oracle.dbtools.common.service.ServiceProperties;
import oracle.dbtools.common.service.model.Reference;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.rt.home.tenants.TenantIdentifier;
import oracle.dbtools.rt.oauth.OAuthScopeProvider;
import oracle.dbtools.rt.resource.templates.cache.CachedResourceTemplateDispatcher;
import oracle.dbtools.rt.resource.templates.cache.MetadataCacheConfigurations;
import oracle.dbtools.rt.resource.templates.jdbc.JDBCResourceTemplates;
import oracle.dbtools.rt.resource.templates.v2.ProtectedResourceTemplateMatch;
import oracle.dbtools.rt.resource.templates.v2.ResourceTemplatesDispatcher;
import oracle.dbtools.rt.web.HttpResource;
import oracle.dbtools.rt.web.RequestEntity;
import oracle.dbtools.rt.web.ResourceDispatcher;

@Service(priority=1)
public class JDBCResourceTemplateDispatcher
extends UsesQuery
implements ResourceDispatcher,
OAuthScopeProvider {
    @Reference
    private ResourceTemplatesDispatcher dispatcher;
    @Reference
    private JDBCCallProvider jdbc;
    private JDBCResourceTemplates resourceTemplates;

    @Override
    public ResourceDispatcher.Score canDispatch(RequestEntity request) {
        return this.dispatcher.canDispatch(this.resourceTemplates, request);
    }

    @Override
    public HttpResource dispatch(ResourceDispatcher.Score score, RequestEntity request) throws IOException {
        return this.dispatcher.dispatch(this.resourceTemplates, score, request);
    }

    @Override
    public TenantIdentifier scopeForPath(CompoundPrincipal principal, String path) {
        try {
            ProtectedResourceTemplateMatch match = this.resourceTemplates.resourceTemplate(principal, path);
            if (match != null) {
                return match.privilegeId();
            }
            return null;
        }
        catch (ConnectionPoolException e) {
            return null;
        }
    }

    protected void activate(ServiceProperties properties) {
        MetadataCacheConfigurations confs = (MetadataCacheConfigurations)ServiceLocator.acquire(MetadataCacheConfigurations.class);
        CacheConfiguration cacheConfig = confs.resourceModules();
        if (cacheConfig.enabled()) {
            throw new NotAvailableException(CachedResourceTemplateDispatcher.class);
        }
        this.resourceTemplates = new JDBCResourceTemplates(this.jdbc);
    }
}

