/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.resource.templates.v2;

import java.io.IOException;
import java.io.InputStream;
import oracle.dbtools.common.txn.Transaction;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.common.util.NullOrEmpty;
import oracle.dbtools.common.util.PrimitiveTypes;
import oracle.dbtools.common.x3p.X3PBuilder;
import oracle.dbtools.common.x3p.X3PFactory;
import oracle.dbtools.common.x3p.X3PReader;
import oracle.dbtools.common.x3p.X3PWriterOptions;
import oracle.dbtools.rt.csv.CommaSeparatedValues;
import oracle.dbtools.rt.home.NestedEntityStorage;
import oracle.dbtools.rt.resource.templates.v2.ResourceHandler;
import oracle.dbtools.rt.resource.templates.v2.ResourceModule;
import oracle.dbtools.rt.resource.templates.v2.ResourceParameter;
import oracle.dbtools.rt.resource.templates.v2.ResourceTemplate;
import oracle.dbtools.rt.resource.templates.v2.ResourceTemplatesProfile;
import oracle.dbtools.rt.uri.URITemplate;
import oracle.dbtools.rt.web.HttpMethod;
import oracle.dbtools.rt.web.SecurityConstraint;

class ResourceModuleWriter {
    private final NestedEntityStorage<ResourceModule, ResourceTemplate> modules;
    private final NestedEntityStorage<ResourceTemplate, ResourceHandler> templates;

    ResourceModuleWriter(NestedEntityStorage<ResourceModule, ResourceTemplate> modules, NestedEntityStorage<ResourceTemplate, ResourceHandler> templates) {
        this.modules = modules;
        this.templates = templates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream content(CompoundPrincipal principal, ResourceModule module) throws IOException {
        InputStream inputStream;
        Transaction txn = null;
        Iterable<ResourceTemplate> templates = null;
        try {
            txn = this.modules.newTransaction(principal);
            X3PBuilder xml = X3PBuilder.builder((boolean)true);
            xml.startDocument();
            X3PBuilder.AttributeBuilder attrs = X3PBuilder.attributes();
            if (!ResourceModule.isDefaultModule(module)) {
                attrs.attribute("name", module.name());
            }
            if (module.published()) {
                attrs.attribute("published", "true");
            }
            if (!NullOrEmpty.nullOrEmpty((CharSequence)module.uriPrefix())) {
                attrs.attribute("uri-prefix", module.uriPrefix());
            }
            if (module.itemsPerPage() > 0) {
                attrs.attribute("page-size", PrimitiveTypes.string((Object)module.itemsPerPage()));
            }
            if (!NullOrEmpty.nullOrEmpty(module.originsAllowed())) {
                attrs.attribute("origins-allowed", Iterables.join(module.originsAllowed(), (String)", "));
            }
            xml.startElement(ResourceTemplatesProfile.MODULE, attrs.build());
            templates = this.modules.children(txn, principal, module.id());
            for (ResourceTemplate template : templates) {
                this.render(txn, principal, xml, template);
            }
            xml.endElement(ResourceTemplatesProfile.MODULE);
            xml.endDocument();
            inputStream = X3PFactory.newStream((X3PReader)xml.build(), (X3PWriterOptions)ResourceTemplatesProfile.DEFAULT_SERIALIZATION);
        }
        catch (Throwable throwable) {
            Closeables.close((Object[])new Object[]{templates, txn});
            throw throwable;
        }
        Closeables.close((Object[])new Object[]{templates, txn});
        return inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void render(Transaction txn, CompoundPrincipal principal, X3PBuilder xml, ResourceTemplate template) {
        URITemplate pattern = template.uriTemplate();
        X3PBuilder.AttributeBuilder attrs = X3PBuilder.attributes();
        attrs.attribute("pattern", pattern.toString());
        if (pattern.priority() > 0) {
            attrs.attribute("priority", (String)PrimitiveTypes.valueOf((Number)pattern.priority(), String.class));
        }
        xml.startElement(ResourceTemplatesProfile.TEMPLATE, attrs.build());
        ResourceHandler etag = template.etag();
        if (etag != null) {
            if (NullOrEmpty.nullOrEmpty((CharSequence)etag.content())) {
                xml.element(ResourceTemplatesProfile.ETAG);
            } else {
                xml.element(ResourceTemplatesProfile.ETAG, null, etag.content());
            }
        }
        Iterable<ResourceHandler> handlers = null;
        try {
            handlers = this.templates.children(txn, principal, template.id());
            for (ResourceHandler handler : handlers) {
                this.render(txn, principal, xml, handler);
            }
        }
        finally {
            Closeables.close(handlers);
        }
        xml.endElement(ResourceTemplatesProfile.TEMPLATE);
    }

    private void render(Transaction txn, CompoundPrincipal principal, X3PBuilder xml, ResourceHandler handler) {
        SecurityConstraint securityConstraint;
        Object[] accept;
        String type;
        X3PBuilder.AttributeBuilder attrs = X3PBuilder.attributes();
        String method = handler.method();
        if (null != method && !HttpMethod.GET.equals(method)) {
            attrs.attribute("method", method);
        }
        if (!"json/query".equals(type = handler.contentType())) {
            attrs.attribute("type", type);
        }
        if (!NullOrEmpty.nullOrEmpty((Object[])(accept = handler.acceptableTypes()))) {
            attrs.attribute("accept", CommaSeparatedValues.string((String[])accept));
        }
        if (SecurityConstraint.NONE == (securityConstraint = handler.securityConstraint())) {
            attrs.attribute("security-constraint", SecurityConstraint.NONE.toString());
        } else {
            attrs.attribute("security-constraint", SecurityConstraint.SECURE.toString());
        }
        int pageSize = handler.itemsPerPage();
        if (pageSize >= 0) {
            attrs.attribute("page-size", (String)PrimitiveTypes.valueOf((Number)pageSize, String.class));
        }
        xml.startElement(ResourceTemplatesProfile.HANDLER, attrs.build());
        Object[] parameters = handler.parameters();
        if (!NullOrEmpty.nullOrEmpty((Object[])parameters)) {
            for (Object parameter : parameters) {
                this.render(txn, principal, xml, (ResourceParameter)parameter);
            }
        }
        xml.element(ResourceTemplatesProfile.CONTENT, null, handler.content());
        xml.endElement(ResourceTemplatesProfile.HANDLER);
    }

    private void render(Transaction txn, CompoundPrincipal principal, X3PBuilder xml, ResourceParameter parameter) {
        X3PBuilder.AttributeBuilder attrs = X3PBuilder.attributes();
        attrs.attribute("name", parameter.bindName());
        attrs.attribute("aliasing", parameter.originalName());
        attrs.attribute("source", parameter.kind().toString().toLowerCase());
        attrs.attribute("access", parameter.access().toString());
        Class<?> type = parameter.primitiveType();
        if (String.class != type) {
            attrs.attribute("type", type.getSimpleName());
        }
        xml.element(ResourceTemplatesProfile.PARAMETER, attrs.build());
    }
}

