/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.web;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import oracle.dbtools.http.servlet.UriRequest;
import oracle.dbtools.rt.web.HttpHeader;

class AbsoluteLocationHeader
extends HttpServletResponseWrapper {
    private final HttpServletRequest request;

    protected AbsoluteLocationHeader(HttpServletRequest request, HttpServletResponse response) {
        super(response);
        this.request = request;
    }

    public void addHeader(String name, String value) {
        value = this.resolve(name, value);
        super.addHeader(name, value);
    }

    public void sendRedirect(String location) throws IOException {
        location = this.resolve(location);
        super.sendRedirect(location);
    }

    public void setHeader(String name, String value) {
        value = this.resolve(name, value);
        super.setHeader(name, value);
    }

    public String toString() {
        return this.getResponse().toString();
    }

    private final String resolve(String location) {
        UriRequest uri = UriRequest.uriRequest((HttpServletRequest)this.request);
        String resolved = uri.resolveLocation(location);
        return resolved;
    }

    private String resolve(String name, String value) {
        if (HttpHeader.LOCATION.matches(name)) {
            value = this.resolve(value);
        }
        return value;
    }

    public static HttpServletResponse apply(HttpServletRequest request, HttpServletResponse response) {
        return new AbsoluteLocationHeader(request, response);
    }
}

